/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.margin.PledgeSecurityQuery;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.margin.models.PledgeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PledgeSecurityQueryPart
extends MxPart {
    @FXML
    private TableView<PledgeSecurityQuery> tablePledgeSecurity;
    @FXML
    private TableColumn<PledgeSecurityQuery, String> colMarket;
    @FXML
    private TableColumn<PledgeSecurityQuery, String> colSecuritiesCode;
    @FXML
    private TableColumn<PledgeSecurityQuery, String> colSecuritiesName;
    @FXML
    private TableColumn<PledgeSecurityQuery, Number> colConversionRate;
    @FXML
    protected TextField searchText;
    @Inject
    protected PledgeModel model;
    @Inject
    private MxAlert alert;
    protected MxList<PledgeSecurityQuery> mxList = new MxList();
    private static final Logger logger = LogManager.getLogger(PledgeSecurityQueryPart.class);
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected Predicate<PledgeSecurityQuery> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((PledgeSecurityQuery)en)) {
            return true;
        }
        if (en.getSecurityId().contains(text)) {
            return true;
        }
        if (this.extend((PledgeSecurityQuery)en)) {
            return false;
        }
        return false;
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<PledgeSecurityQuery> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
        Platform.runLater(() -> {
            this.sort(this.mxList);
            this.tablePledgeSecurity.sort();
        });
    };

    public boolean premise(PledgeSecurityQuery sofp) {
        return true;
    }

    public boolean extend(PledgeSecurityQuery sofp) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<PledgeSecurityQuery> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<PledgeSecurityQuery> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<PledgeSecurityQuery>)this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.sort(this.mxList);
            this.tablePledgeSecurity.sort();
            this.lstnSearch.invalidated(null);
        });
    }

    @FXML
    private void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void beforeClose() {
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePledgeSecurity);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePledgeSecurity, (String)"\u6298\u7b97\u7387\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colConversionRate.setCellValueFactory(data -> new SimpleDoubleProperty(((PledgeSecurityQuery)data.getValue()).getPledgeRate()));
        this.colConversionRate.setCellFactory(data -> new DoubleTableCell());
        this.colMarket.setCellValueFactory(data -> new SimpleStringProperty(((PledgeSecurityQuery)data.getValue()).getMarket()));
        this.colSecuritiesCode.setCellValueFactory(data -> new SimpleStringProperty(((PledgeSecurityQuery)data.getValue()).getSecurityId()));
        this.colSecuritiesName.setCellValueFactory(data -> new SimpleStringProperty(((PledgeSecurityQuery)data.getValue()).getSecurityName()));
        this.tablePledgeSecurity.setItems(this.mxList.getList());
        this.tablePledgeSecurity.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tablePledgeSecurity);
    }

    public void sort(MxList<PledgeSecurityQuery> mxList) {
        mxList.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
    }
}

