/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.http.api.strategy.dto.EntrustInfo;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.query.current.models.MarginAlgoDetailModel;
import cms.tmx.query.margin.views.MarginOrderPart;
import java.io.IOException;
import java.util.List;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NewMarginAlgoDetailOrderPart
extends MarginOrderPart {
    private static final Logger logger = LogManager.getLogger(NewMarginAlgoDetailOrderPart.class);
    AlgoBaseOrder order = new AlgoBaseOrder();
    @Inject
    private MarginAlgoDetailModel algoModel;

    @FXML
    public void initialize() {
        super.initialize();
        this.algoModel.SetBaseOrder(this.order);
        this.algoModel.query();
        this.initValue();
    }

    private void initValue() {
        if (this.getList().isEmpty() && !this.algoModel.getList().isEmpty()) {
            this.algoModel.getList().forEach(data -> {
                SingleOrder order = new SingleOrder();
                order.update(data);
                this.getList().add(order);
            });
        }
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException e) {
            System.err.println("\u4e24\u878d\u7b97\u6cd5\u67e5\u8be2\u59d4\u6258\u9762\u677f\u52a0\u8f7d\u5931\u8d25   " + e.getMessage());
        }
    }

    @Override
    protected boolean predicate(SingleOrder t) {
        String text = this.searchText.getText().trim();
        if (!(t.getSecurityId().contains(text) || t.getSecurityName().contains(text) || t.getInvestorId().contains(text))) {
            return false;
        }
        if (t.getExecMode() == null) {
            return false;
        }
        if (!this.order.getAlgoOrderId().equals(t.getExecMode().getEmName().split(":")[0])) {
            return false;
        }
        if (!this.order.getSideStr().equals(t.getSide().name().toString())) {
            return false;
        }
        for (EntrustInfo info : this.getOrdList()) {
            if (!t.getSide().getValue().equals(info.getSide())) continue;
            t.setSecurityName(info.getSymbol());
            t.setReference(info.getAlgoOrderId());
        }
        return true;
    }

    private List<EntrustInfo> getOrdList() {
        return this.algoModel.getList();
    }

    public void SetBaseOrder(AlgoBaseOrder base) {
        this.order = base;
    }

    @PreDestroy
    public void close() {
        this.searchText.textProperty().removeListener(this.listenerSearch);
        this.getModel().changedProperty().removeListener(this.lstnModel);
    }
}

