/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.CcsCancelFactory;
import cms.tmx.query.current.views.CcsCancelConfirmDialog;
import cms.tmx.query.current.views.CcsReplaceConfirmDialog;
import cms.tmx.query.margin.models.MarginUnfinishedOrderModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarginUnfinishedOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(MarginUnfinishedOrderPart.class);
    @FXML
    protected TableView<ObSingleOrderMargin> tableUnOrder;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Boolean> selected;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colAccId;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colSecAcc;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colSecId;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colSecName;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colMarket;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colExtOrderId;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colPrice;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colOrdType;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colMarketIndicator;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colOrdStatus;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colOrdTime;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colOrderQty;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colCumQty;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colAvgPx;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colInfo;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colUnit;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colUser;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colUserName;
    @FXML
    private TableColumn<ObSingleOrderMargin, String> colReference;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colOrderAmt;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colFrozenMargin;
    @FXML
    private TableColumn<ObSingleOrderMargin, Number> colPercent;
    @FXML
    protected TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbPriceTp;
    @FXML
    protected Spinner<Double> spnPriceFlP;
    @FXML
    protected Spinner<Double> spnPriceFlU;
    @FXML
    protected Label labFloatU;
    @FXML
    protected Button btnCancelAndOrder;
    @FXML
    protected Button btnOrderCancel;
    @Inject
    protected MarginUnfinishedOrderModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IUiRightService rightsModel;
    public static final String PRICE_ADJUST_UNIT = "price_adjust_unit";
    public static final String PRICE_ADJUST_UNIT_PERCENT = "1";
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";
    protected MxList<ObSingleOrderMargin> mxList = new MxList();
    private MxGroup group = new MxGroup();
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(now.booleanValue()));
        }
    };
    protected Predicate<ObSingleOrderMargin> pd = en -> {
        String text = this.searchText.getText().trim();
        if (en.getInstrument().getSecurityId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        if (en.getOrderId().contains(text)) {
            return true;
        }
        if (en.getInvestorId().contains(text)) {
            return true;
        }
        return this.extend((ObSingleOrderMargin)en);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<ObSingleOrderMargin> newList = Collections.synchronizedList(new ArrayList());
        List<ObSingleOrderMargin> list = this.model.getObList();
        synchronized (list) {
            newList.addAll(this.model.getObList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            Collections.sort(this.mxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableUnOrder.sort();
        });
    };
    protected InvalidationListener lstnSearch = ob -> this.mxList.filter(this.model.getObList(), this.pd);
    @Inject
    protected CcsCancelFactory ccf;
    @Inject
    protected DialogFactory df;

    @FXML
    public void initialize() {
        this.listener();
        this.initValues();
        this.createTableView();
        this.refresh();
        this.bind();
        this.checkRights();
        this.isPop();
    }

    private void listener() {
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    private void checkRights() {
    }

    protected void bind() {
        this.cmbPriceTp.setItems(this.model.getPriceType().getNodes());
        this.model.priceFloatProperty().bindBidirectional((Property)this.spnPriceFlP.getEditor().textProperty());
        this.model.floatUnitProperty().bindBidirectional((Property)this.labFloatU.textProperty());
        this.cmbPriceTp.valueProperty().bindBidirectional(this.model.priceTypeProperty());
    }

    protected void initValues() {
        MxNode node = MxNodeFactory.create((String)PRICE_ADJUST_UNIT, (String)PRICE_ADJUST_UNIT_PERCENT);
        this.labFloatU.textProperty().setValue(node.getValue());
        this.labFloatU.setOnMouseClicked(event -> this.changePriceUnit());
        this.labFloatU.getStyleClass().add((Object)"lbPercentYuan");
        this.group.add(new Control[]{this.spnPriceFlU, this.spnPriceFlP}).setVisible(new Control[]{this.spnPriceFlP});
        this.spnPriceFlU.getEditor().setText("0.000");
        this.spnPriceFlP.getEditor().setText("0.00");
        SpinnerUtils.arrowsStyle(this.spnPriceFlP);
        SpinnerUtils.arrowsStyle(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 3, 3, 1000.0).ctrl(this.spnPriceFlU);
        new DoubleSpinnerCtrl(false, 2, 2, 100.0).ctrl(this.spnPriceFlP);
    }

    protected void changePriceUnit() {
        if ("%".equals(this.labFloatU.getText())) {
            this.labFloatU.setText("\u5143");
            this.group.setVisible(new Control[]{this.spnPriceFlU});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlP.getEditor().textProperty(), (Property)this.spnPriceFlU.getEditor().textProperty());
        } else {
            this.labFloatU.setText("%");
            this.group.setVisible(new Control[]{this.spnPriceFlP});
            MxBindings.bindBidirectional((Property)this.model.priceFloatProperty(), (Property)this.spnPriceFlU.getEditor().textProperty(), (Property)this.spnPriceFlP.getEditor().textProperty());
        }
    }

    protected void createTableView() {
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.colAccId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).investorSecIdProperty());
        this.colSecId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).securityIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).securityNameProperty());
        this.colMarket.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).marketProperty());
        this.colUnit.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).unitProperty());
        this.colUser.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).userIdProperty());
        this.colUserName.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).userNameProperty());
        this.colReference.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).referenceProperty());
        this.colExtOrderId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).extOrderIdProperty());
        this.colOrdType.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).ordTypeDescProperty());
        this.colMarketIndicator.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).marketIndicatorProperty());
        this.colOrdStatus.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).statusProperty());
        this.colOrdTime.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).ordTimeProperty());
        this.colInfo.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).errInfoProperty());
        this.colInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderMargin, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderMargin)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colOrderQty.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).orderQtyProperty());
        this.colOrderQty.setCellFactory(data -> new NumberTableCell());
        this.colCumQty.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).cumQtyProperty());
        this.colCumQty.setCellFactory(data -> new NumberTableCell());
        this.colPrice.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new PriceCell());
        this.colAvgPx.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(data -> new AvgPriceCell());
        this.colOrderAmt.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).orderAmountProperty());
        this.colOrderAmt.setCellFactory(data -> new PriceCell());
        this.colFrozenMargin.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).frozenMarginProperty());
        this.colFrozenMargin.setCellFactory(data -> new PriceCell());
        this.colPercent.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).donePercentProperty());
        this.colPercent.setCellFactory(data -> new DoubleTableCell());
        this.tableUnOrder.setItems(this.mxList.getList());
        this.tableUnOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableUnOrder);
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableUnOrder, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableUnOrder, (String)"\u878d\u8d44\u878d\u5238\u672a\u5b8c\u6210\u59d4\u6258\u67e5\u8be2", (int)1, (int)(this.tableUnOrder.getColumns().size() - 1));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void refresh() {
        this.model.query();
    }

    @FXML
    protected void orderCancel() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        this.ordersCancel((List<ObSingleOrderMargin>)list, "\u64a4\u5355\u786e\u8ba4", false);
    }

    protected void ordersCancel(List<ObSingleOrderMargin> list, String dialogName, boolean isDiskless) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, TIP)) {
            return;
        }
        if (this.model.isPopBeforeCancel() && this.createDialog(list, dialogName, isDiskless)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        int success = this.model.cancel(list);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + success + "\u7b14\n\u5931\u8d25\uff1a" + (list.size() - success) + "\u7b14");
    }

    private boolean createDialog(List<ObSingleOrderMargin> list, String dialogName, boolean isDiskless) {
        CcsCancelConfirmDialog obj = (CcsCancelConfirmDialog)((Object)this.of.create(CcsCancelConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        for (ObSingleOrderMargin or : list) {
            CcsCancelEntrust en = this.ccf.createCcsSingle(or.getExtCashAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecurityId());
            en.setOrderId(or.getOrderId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInvestorSecId());
            en.setSecType(or.getInstrument().getSecurityType());
            en.setMarket(or.getInstrument().getMarket());
            en.setOrderType(Integer.parseInt(or.getOrdType().getValue()));
            MxNode side = MxNodeFactory.create((String)"side", (String)or.getSide().getValue());
            en.setSide(side);
            en.setMarketIndicator(or.getMarketIndicator());
            en.setTip("".equals(or.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getExtOrderId());
            en.setQuantity(or.getOrderQty() - or.getCumQty());
            en.setPrice(or.getPrice());
            if ("XSHG".equals(or.getInstrument().getMarket()) && "BOND".equals(or.getInstrument().getSecurityType())) {
                en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
            } else {
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            enList.add(en);
        }
        obj.setMargin(true);
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        obj.setIsDiskless(isDiskless);
        MxDialog dialog = this.df.create((DialogObj)obj, dialogName);
        return dialog.launch() != ButtonType.OK;
    }

    protected void orderCancelOne(ObSingleOrderMargin order) {
    }

    @FXML
    private void cancelAndOrder() {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.INFORMATION, TIP)) {
            return;
        }
        CcsReplaceConfirmDialog obj = (CcsReplaceConfirmDialog)((Object)this.of.create(CcsReplaceConfirmDialog.class));
        LinkedList<CcsCancelEntrust> enList = new LinkedList<CcsCancelEntrust>();
        this.model.queryMarketItem((List<ObSingleOrderMargin>)list);
        boolean isMarginPayOff = false;
        int payOffNum = 0;
        int totalNum = list.size();
        for (ObSingleOrderMargin or2 : list) {
            if ("\u73b0\u5238\u8fd8\u5238".equals(or2.getInstrument().getMarketIndicator()) || "\u76f4\u63a5\u8fd8\u6b3e".equals(or2.getInstrument().getMarketIndicator())) {
                isMarginPayOff = true;
                ++payOffNum;
                continue;
            }
            CcsCancelEntrust en = this.ccf.createCcsSingle(or2.getExtCashAccntId(), or2.getExtSecAccntId());
            en.setSec(or2.getInstrument().getSecurityId());
            en.setSecName(or2.getInstrument().getSymbol());
            en.setAcc(or2.getInvestorId());
            en.setSecAcc(or2.getInvestorSecId());
            en.setSecType(or2.getInstrument().getSecurityType());
            en.setMarket(or2.getInstrument().getMarket());
            if ("80".equals(or2.getOrdType().getValue())) {
                en.setOrderTypeStr("\u76d8\u540e\u56fa\u5b9a\u4ef7");
            }
            en.setOrderType(Integer.parseInt(or2.getOrdType().getValue()));
            en.setOrderId(or2.getExtOrderId());
            en.setQuantity(or2.getOrderQty() - or2.getCumQty());
            MxNode side = MxNodeFactory.create((String)"side", (String)or2.getSide().getValue());
            en.setSide(side);
            en.setMarketIndicator(or2.getMarketIndicator());
            en.setPrice(this.model.getNewPrice(or2, StringUtils.parseInt((String)this.model.getPriceType().getRaw()), this.model.getFloatUnit(), this.model.getPriceFloat()));
            or2.setNewPrice(en.getPrice());
            if ("XSHG".equals(or2.getInstrument().getMarket()) && "BOND".equals(or2.getInstrument().getSecurityType())) {
                en.setAmt((double)en.getQuantity() * en.getPrice() * 10.0);
            } else {
                en.setAmt((double)en.getQuantity() * en.getPrice());
            }
            if (OrdType.ORD_TYPE_LIMIT.equals((Object)or2.getOrdType()) && Double.doubleToLongBits(or2.getNewPrice()) == Double.doubleToLongBits(or2.getPrice())) {
                en.setTip("".equals(or2.getExtOrderId()) ? null : "\u4e0e\u539f\u59d4\u6258\u4ef7\u683c\u76f8\u540c\uff0c\u65e0\u9700\u64a4\u5355\u91cd\u4e0b\u3002\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getExtOrderId());
                or2.setCanCancelReplace(false);
                en.setIsModified(true);
            } else {
                or2.setCanCancelReplace(true);
                en.setTip("".equals(or2.getExtOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or2.getExtOrderId());
            }
            enList.add(en);
        }
        if (totalNum == payOffNum) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8be5\u4e1a\u52a1\u7c7b\u578b\u4e0d\u652f\u6301\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        this.sort(enList);
        obj.setMargin(true);
        obj.setList(enList);
        obj.setMarginPayOff(isMarginPayOff);
        obj.setDialogType("\u64a4\u5355\u91cd\u4e0b");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u91cd\u4e0b\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\u91cd\u4e0b\uff01");
            return;
        }
        FilteredList filteredList = list.filtered(or -> or.isCanCancelReplace());
        if (filteredList.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u4e0d\u7b26\u5408\u64a4\u5355\u91cd\u4e0b\u6761\u4ef6\u3002");
            return;
        }
        int success = this.model.cancelAndOrder((List<ObSingleOrderMargin>)filteredList);
        this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u6210\u529f\uff1a" + success + "\u7b14\n\u5931\u8d25\uff1a" + (list.size() - success) + "\u7b14");
    }

    private void sort(List<CcsCancelEntrust> enList) {
        Collections.sort(enList, new Comparator<CcsCancelEntrust>(){

            @Override
            public int compare(CcsCancelEntrust o1, CcsCancelEntrust o2) {
                if (o2.isIsModified() && !o1.isIsModified()) {
                    return 1;
                }
                if (o1.isIsModified() && !o2.isIsModified()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public boolean extend(ObSingleOrderMargin en) {
        return false;
    }

    protected void isPop() {
        String parentId;
        switch (parentId = this.p.getParent().getParent().getId().toUpperCase()) {
            case "CMS-TMX-STOCK-PART-UNFINISHEDORDER": {
                this.model.setType(PRICE_ADJUST_UNIT_PERCENT, "200001");
                break;
            }
        }
        this.model.doSet();
    }

    private class AvgPriceCell
    extends DoubleTableCell<ObSingleOrderMargin> {
        int scale = 3;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderMargin order = (ObSingleOrderMargin)ObSingleOrderMargin.class.cast(this.getTableRow().getItem());
                if (order.getInstrument().getSecurityId() != null && order.getInstrument().getSecurityType() != null && (refItem = MarginUnfinishedOrderPart.this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<ObSingleOrderMargin> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderMargin order = (ObSingleOrderMargin)ObSingleOrderMargin.class.cast(this.getTableRow().getItem());
                if (order.getInstrument().getSecurityId() != null && order.getInstrument().getSecurityType() != null && (refItem = MarginUnfinishedOrderPart.this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObSingleOrderMargin, Side> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Side value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value.toString());
            switch (value) {
                case SIDE_BUY: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

