/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.margin.models.MarginPositionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class MarginPositionPart
extends MxPart {
    @FXML
    private TableView<ObPositionMargin> tablePosition;
    @FXML
    private TableColumn<ObPositionMargin, String> colAccId;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecAcc;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecId;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecName;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, Number> colMarketValue;
    @FXML
    private TableColumn<ObPositionMargin, Number> colSecBalance;
    @FXML
    private TableColumn<ObPositionMargin, Number> colSecAvail;
    @FXML
    protected TableColumn<ObPositionMargin, String> colUnit;
    @FXML
    private TextField searchText;
    @Inject
    private MarginPositionModel model;
    private static final Logger logger = LogManager.getLogger(MarginPositionPart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObPositionMargin> mxList = new MxList();
    private Predicate<ObPositionMargin> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObPositionMargin)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObPositionMargin)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<ObPositionMargin> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObPositionMargin obj) {
        return true;
    }

    public boolean extend(ObPositionMargin obj) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObPositionMargin> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObPositionMargin> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObPositionMargin>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tablePosition.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u878d\u8d44\u878d\u5238\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colAccId.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colSecId.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colMarketValue.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getPosStatistic().marketValueProperty());
        this.colMarketValue.setCellFactory(data -> new DoubleTableCell());
        this.colSecBalance.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secBalanceProperty());
        this.colSecBalance.setCellFactory(data -> new DoubleTableCell());
        this.colSecAvail.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secAvailProperty());
        this.colSecAvail.setCellFactory(data -> new DoubleTableCell());
        this.colUnit.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).unitProperty());
        this.tablePosition.setItems(this.mxList.getList());
        this.tablePosition.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }
}

