/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.margin.models.MarginOrderModel;
import cms.tmx.query.margin.views.LoadPartModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarginOrderPart
extends MxPagePart<SingleOrder, ObSingleOrderMargin> {
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> price;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> errInfo;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> ordTypeDesc;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> reference;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> orderQty;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> cumQty;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> avgPx;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> orderAmount;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> frozenMargin;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> donePercent;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> algoId;
    @FXML
    protected TextField searchText;
    @Inject
    protected MarginOrderModel model;
    @Inject
    protected IRefDataMng refMng;
    protected static final Logger logger = LogManager.getLogger(MarginOrderPart.class);
    @Inject
    protected MxAlert alert;
    @Inject
    private LoadPartModel load;

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listExec, (String)"\u878d\u8d44\u878d\u5238\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderMargin, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderMargin)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.cumQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new PriceCell());
        this.avgPx.setCellFactory(data -> new AvgPriceCell());
        this.orderAmount.setCellFactory(data -> new PriceCell());
        this.frozenMargin.setCellFactory(data -> new PriceCell());
        this.donePercent.setCellFactory(data -> new DoubleTableCell());
        this.algoId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).algoIdProperty());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth((TableView)this.tableView);
    }

    protected boolean predicate(SingleOrder en) {
        String text = this.searchText.getText().trim();
        return en.getSecurityId().contains(text) || en.getSecurityName().contains(text) || en.getExtOrderId().contains(text) || en.getInvestorId().contains(text);
    }

    protected List<SingleOrder> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> {
            if (o2.getOrdTime().compareTo(o1.getOrdTime()) == 0) {
                return o2.getOrderId().compareTo(o1.getOrderId());
            }
            return o2.getOrdTime().compareTo(o1.getOrdTime());
        });
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected class AvgPriceCell
    extends DoubleTableCell<ObSingleOrderMargin> {
        int scale = 3;

        protected AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderMargin order = (ObSingleOrderMargin)ObSingleOrderMargin.class.cast(this.getTableRow().getItem());
                if (order.getSecurityId() != null && order.getInstrument().getSecurityType() != null && (refItem = MarginOrderPart.this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class PriceCell
    extends DoubleTableCell<ObSingleOrderMargin> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderMargin order = (ObSingleOrderMargin)ObSingleOrderMargin.class.cast(this.getTableRow().getItem());
                if (order.getSecurityId() != null && order.getInstrument().getSecurityType() != null && (refItem = MarginOrderPart.this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    protected class SideCell
    extends TableCell<ObSingleOrderMargin, Side> {
        protected Label label = new Label();

        protected SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Side value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value.toString());
            switch (value) {
                case SIDE_BUY: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

