/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecutionMargin;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.margin.models.MarginDealModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarginDealPart
extends MxPagePart<Execution, ObExecutionMargin> {
    @FXML
    private TableView<ObExecutionMargin> tableView;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastAmount;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastPx;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastQty;
    @Inject
    private MarginDealModel model;
    @Inject
    private IRefDataMng refMng;
    private static final Logger logger = LogManager.getLogger(MarginDealPart.class);
    @Inject
    private MxAlert alert;

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listExec, (String)"\u878d\u8d44\u878d\u5238\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.lastAmount.setCellFactory(data -> new PriceCell());
        this.lastPx.setCellFactory(data -> new PriceCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableView);
    }

    protected boolean predicate(Execution t) {
        String text = this.searchText.getText().trim();
        return t.getSecurityId().contains(text) || t.getSecurityName().contains(text) || t.getInvestorId().contains(text);
    }

    protected List<Execution> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void defaultSort() {
    }

    private class PriceCell
    extends DoubleTableCell<ObExecutionMargin> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObExecutionMargin exec = (ObExecutionMargin)ObExecutionMargin.class.cast(this.getTableRow().getItem());
                if (exec.getInstrument().getSecurityId() != null && exec.getInstrument().getSecurityType() != null && (refItem = MarginDealPart.this.refMng.getItem(exec.getInstrument().getSecurityType(), exec.getInstrument().getMarket(), exec.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class SideCell
    extends TableCell<ObExecutionMargin, Side> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Side value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value.toString());
            switch (value) {
                case SIDE_BUY: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

