/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.margin.models.MarginAlgoQueryModel;
import cms.tmx.query.margin.views.MarginAlgoDetailDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginAlgoQueryPart
extends MxPagePart<AlgoBaseOrder, AlgoBaseOrder> {
    private static final Logger logger = LogManager.getLogger(MarginAlgoQueryPart.class);
    public static List<String> CAN_CANCEL = Arrays.asList("0", "6", "7", "8", "1");
    @FXML
    protected TableView<AlgoBaseOrder> tableView;
    @FXML
    protected TableColumn<AlgoBaseOrder, Boolean> selected;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> algoOrderId;
    @FXML
    protected TableColumn<AlgoBaseOrder, MxNode> type;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> algoStatus;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> security;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> name;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> side;
    @FXML
    protected TableColumn<AlgoBaseOrder, Number> targetVol;
    @FXML
    protected TableColumn<AlgoBaseOrder, Number> executedQty;
    @FXML
    protected TableColumn<AlgoBaseOrder, Number> tradeAmt;
    @FXML
    protected TableColumn<AlgoBaseOrder, Number> tradeAvgPx;
    @FXML
    protected TableColumn<AlgoBaseOrder, Object> operation;
    @FXML
    protected TableColumn<AlgoBaseOrder, Number> executedPercent;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> entrustDate;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> startTime;
    @FXML
    protected TableColumn<AlgoBaseOrder, String> remark;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private MEventService es;
    @Inject
    protected MarginAlgoQueryModel tradeModel;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private UserPreOrderTips setTips;
    protected CheckBox checkBox = new CheckBox();
    protected ChangeListener<Boolean> lstnCheckBox = (obv, old, now) -> {
        ObservableList observableList = this.mxList.getPageList();
        synchronized (observableList) {
            this.mxList.getPageList().forEach(e -> {
                if (CAN_CANCEL.contains(e.getAlgoStatusStr())) {
                    e.setSelected(now.booleanValue());
                }
            });
        }
    };
    public static final String TIP = "\u8bf7\u9009\u62e9\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u8bb0\u5f55";

    public MarginAlgoQueryPart() {
        this.path = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".fxml";
    }

    protected boolean predicate(AlgoBaseOrder order) {
        String text = this.searchText.getText().trim();
        return order.getSecurity().contains(text) || order.getAlgoOrderId().contains(text) || order.getSecName().contains(text);
    }

    @FXML
    public void initialize() {
        super.initialize();
        this.listener();
        this.refresh();
        this.createTableView();
    }

    private void listener() {
        this.checkBox.selectedProperty().addListener(this.lstnCheckBox);
        this.tradeModel.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.listenerSearch);
    }

    @PreDestroy
    private void destroy() {
        this.checkBox.selectedProperty().removeListener(this.lstnCheckBox);
        this.tradeModel.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.listenerSearch);
    }

    protected List getList() {
        return this.tradeModel.getList();
    }

    protected void createTableView() {
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.selected.getTableView().setEditable(true);
        this.selected.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).selectedProperty());
        this.selected.setCellFactory(data -> new MxCheckBoxTableCellOrd());
        this.algoOrderId.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).algoOrderIdProperty());
        this.type.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).tradeTypeProperty());
        this.algoStatus.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).algoStatusProperty());
        this.security.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).securityProperty());
        this.name.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).secNameProperty());
        this.side.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).sideProperty());
        this.targetVol.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).targetVolProperty());
        this.executedQty.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).executedQtyProperty());
        this.tradeAmt.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).tradeAmtProperty());
        this.tradeAmt.setCellFactory(p -> new PriceCell());
        this.tradeAvgPx.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).tradeAvgPxProperty());
        this.tradeAvgPx.setCellFactory(p -> new PriceCell());
        this.executedPercent.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).executedPercentProperty());
        this.executedPercent.setCellFactory(p -> new DoubleTableCell());
        this.entrustDate.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).entrustDateProperty());
        this.startTime.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).entrustTimeProperty());
        this.remark.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).remarkProperty());
        this.operation.setCellValueFactory(data -> this.setOperate((AlgoBaseOrder)data.getValue()));
        this.tableView.setItems(this.mxList.getPageList());
        this.algoOrderId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.algoOrderId);
    }

    @FXML
    protected void refresh() {
        try {
            this.tradeModel.fullQuery();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportExcel() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    @FXML
    public void cancel() {
        FilteredList list = this.mxList.getPageList().filtered(p -> p.isSelected());
        this.ordersCancel((List<AlgoBaseOrder>)list, "\u64a4\u5355\u786e\u8ba4", false, TIP);
    }

    protected void ordersCancel(List<AlgoBaseOrder> list, String dialogName, boolean isDiskless, String tip) {
        if (!this.alert.check(!list.isEmpty(), Alert.AlertType.ERROR, tip)) {
            return;
        }
        if (list.size() < 1) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u5b9a\u64a4\u5355?", "\u786e\u5b9a", "\u53d6\u6d88")) {
            return;
        }
        String msg = this.getModel().cancel(list);
        this.alert.check(false, Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + msg);
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getAlgoOrderId().compareTo(o1.getAlgoOrderId()));
    }

    protected MarginAlgoQueryModel getModel() {
        return this.tradeModel;
    }

    protected void algoDetail(AlgoBaseOrder order) {
        this.tableView.getSelectionModel().select((Object)order);
        MarginAlgoDetailDialog.setBase(order);
        MarginAlgoDetailDialog query = (MarginAlgoDetailDialog)((Object)this.of.create(MarginAlgoDetailDialog.class));
        MxDialog dialog = this.df.create((DialogObj)query, "\u7b97\u6cd5\u8be6\u60c5");
        dialog.launch();
    }

    private void lookOver(AlgoBaseOrder order) {
        MEvent event = new MEvent();
        event.put((Object)"MarginDialog", (Object)order);
        this.es.sendEvent("MarginDialog", event);
    }

    private ReadOnlyObjectWrapper<Object> setOperate(AlgoBaseOrder order) {
        HBox box = new HBox();
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button param = new Button("\u7b97\u6cd5\u53c2\u6570");
        Button detail = new Button("\u7b97\u6cd5\u8be6\u60c5");
        param.getStyleClass().add((Object)"btnOperation");
        detail.getStyleClass().add((Object)"btnOperation");
        param.setOnAction(event -> this.lookOver(order));
        detail.setOnAction(event -> this.algoDetail(order));
        box.getChildren().addAll((Object[])new Node[]{param, detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    public class MxCheckBoxTableCellOrd
    extends CheckBoxTableCell<AlgoBaseOrder, Boolean> {
        private final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");
        private CheckBox checkbox;

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, now.booleanValue()));
                    if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        return;
                    }
                    AlgoBaseOrder ord = (AlgoBaseOrder)AlgoBaseOrder.class.cast(this.getTableRow().getItem());
                    this.checkbox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                        if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                            return;
                        }
                        AlgoBaseOrder ords = (AlgoBaseOrder)AlgoBaseOrder.class.cast(this.getTableRow().getItem());
                        if (ords != null) {
                            ords.getLock().lock();
                            try {
                                if (ords.isSelected()) {
                                    MarginAlgoQueryPart.this.mxList.getPageList().forEach(data -> {
                                        if (data.getAlgoOrderId().equals(ords.getAlgoOrderId()) && !data.getSideStr().equals(ords.getSideStr()) && !data.isSelected()) {
                                            data.setSelected(true);
                                        }
                                    });
                                } else if (!ords.isSelected()) {
                                    MarginAlgoQueryPart.this.mxList.getPageList().forEach(data -> {
                                        if (data.getAlgoOrderId().equals(ords.getAlgoOrderId()) && !data.getSideStr().equals(ords.getSideStr()) && data.isSelected()) {
                                            data.setSelected(false);
                                        }
                                    });
                                }
                            }
                            finally {
                                ords.getLock().unlock();
                            }
                        }
                    });
                    this.getTableRow().pseudoClassStateChanged(this.MXSELECTED, this.checkbox.isSelected());
                    if (!CAN_CANCEL.contains(ord.getAlgoStatusStr())) {
                        this.setDisable(true);
                    } else {
                        this.setDisable(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<AlgoBaseOrder> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.scale = 2;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

