/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.api.strategy.dto.EntrustInfo;
import cms.tmx.http.api.strategy.dto.ObEntrustInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.current.models.MarginAlgoDetailModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginAlgoDetailOrderPart
extends MxPagePart<EntrustInfo, ObEntrustInfo> {
    private static final Logger logger = LogManager.getLogger(MarginAlgoDetailOrderPart.class);
    @FXML
    protected TableView<ObEntrustInfo> tableView;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colSecurity;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colSymbol;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colSide;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colPrice;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colType;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colQty;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colUnit;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colOrderAmt;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colFrozenAmt;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colTradeQty;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colPercent;
    @FXML
    protected TableColumn<ObEntrustInfo, Number> colAvgPrice;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colEntrustTime;
    @FXML
    protected TableColumn<ObEntrustInfo, MxNode> colEntrustStatus;
    @FXML
    protected TableColumn<ObEntrustInfo, MxNode> colMarket;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colEntrustNo;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colFundAccnt;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colContractNo;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colAlgoOrderId;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colUser;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colUserName;
    @FXML
    protected TableColumn<ObEntrustInfo, String> colRemark;
    @Inject
    private MarginAlgoDetailModel model;
    protected InvalidationListener lstnSearch = ob -> {
        List<EntrustInfo> list = this.getModel().getList();
        synchronized (list) {
            this.mxList.filter(this.getModel().getList(), this.pd);
        }
    };
    protected InvalidationListener lstnModel = ob -> {
        ArrayList<EntrustInfo> newList = new ArrayList<EntrustInfo>();
        List<EntrustInfo> list = this.getModel().getList();
        synchronized (list) {
            newList.addAll(this.getModel().getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList);
            this.mxList.updatePageList();
            this.lstnSearch.invalidated(null);
        });
    };

    @FXML
    protected void initialize() {
        this.listener();
        this.createTableView();
        this.refresh();
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    private void listener() {
        this.getModel().changedProperty().addListener(this.lstnModel);
    }

    protected boolean predicate(EntrustInfo data) {
        return false;
    }

    protected List<EntrustInfo> getList() {
        return this.model.getList();
    }

    protected MarginAlgoDetailModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        this.colSecurity.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).securityProperty());
        this.colSymbol.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).symbolProperty());
        this.colSide.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).sideProperty());
        this.colPrice.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).priceProperty());
        this.colType.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).typeProperty());
        this.colQty.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).qtyProperty());
        this.colUnit.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).unitProperty());
        this.colOrderAmt.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).orderAmtProperty());
        this.colFrozenAmt.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).frozenAmtProperty());
        this.colTradeQty.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).tradeQtyProperty());
        this.colPercent.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).percentProperty());
        this.colAvgPrice.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).avgPriceProperty());
        this.colEntrustTime.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).entrustTimeProperty());
        this.colEntrustStatus.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).entrustStatusProperty());
        this.colMarket.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).marketProperty());
        this.colEntrustNo.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).entrustNoProperty());
        this.colFundAccnt.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).fundAccntProperty());
        this.colContractNo.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).contractNoProperty());
        this.colAlgoOrderId.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).algoOrderIdProperty());
        this.colUser.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).userProperty());
        this.colUserName.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).userNameProperty());
        this.colRemark.setCellValueFactory(data -> ((ObEntrustInfo)data.getValue()).remarkProperty());
        this.tableView.setItems(this.mxList.getPageList());
        this.colAlgoOrderId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.colAlgoOrderId);
    }

    @FXML
    protected void refresh() {
        this.model.query();
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u59d4\u6258\u67e5\u8be2");
        }
        catch (Exception exception) {
            logger.info("\u59d4\u6258\u67e5\u8be2\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getEntrustTime().compareTo(o1.getEntrustTime()));
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }
}

