/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.ObOrderRecord;
import cms.tmx.http.query.OrderRecord;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.margin.models.ContractModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContractPart
extends MxPagePart<OrderRecord, ObOrderRecord> {
    @FXML
    private TableView<ObOrderRecord> tableView;
    @FXML
    private TableColumn<ObOrderRecord, Number> orderQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> lastQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> orderAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> tradeAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> exFee;
    @FXML
    private TableColumn<ObOrderRecord, Number> annualInterestRate;
    @FXML
    private TableColumn<ObOrderRecord, Number> marginRate;
    @FXML
    private TableColumn<ObOrderRecord, Number> repayAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> fundRemain;
    @FXML
    private TableColumn<ObOrderRecord, Number> repayQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> stkRemain;
    @FXML
    private TableColumn<ObOrderRecord, Number> feeRepay;
    @FXML
    private TableColumn<ObOrderRecord, Number> overdueFee;
    @FXML
    private TableColumn<ObOrderRecord, Number> puniFeeRepay;
    @Inject
    private ContractModel model;
    private static final Logger logger = LogManager.getLogger(ContractPart.class);
    @Inject
    private MxAlert alert;

    protected boolean predicate(OrderRecord t) {
        String text = this.searchText.getText().trim();
        return t.getSecId().contains(text) || t.getSecName().contains(text);
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listExec, (String)"\u5408\u7ea6\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.tradeAmount.setCellFactory(data -> new DoubleTableCell());
        this.exFee.setCellFactory(data -> new DoubleTableCell());
        this.annualInterestRate.setCellFactory(data -> new PriceCell());
        this.marginRate.setCellFactory(data -> new DoubleTableCell());
        this.repayAmount.setCellFactory(data -> new DoubleTableCell());
        this.fundRemain.setCellFactory(data -> new DoubleTableCell());
        this.repayQty.setCellFactory(data -> new NumberTableCell());
        this.stkRemain.setCellFactory(data -> new NumberTableCell());
        this.feeRepay.setCellFactory(data -> new DoubleTableCell());
        this.puniFeeRepay.setCellFactory(data -> new DoubleTableCell());
        this.overdueFee.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableView);
    }

    protected List<OrderRecord> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void defaultSort() {
    }

    private class PriceCell
    extends DoubleTableCell<ObOrderRecord> {
        int scale = 4;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

