/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.http.query.marginxt.XtUnderlyingSecurity;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.mng.xt.UnderlyingSecurityMng;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UnderlyingModel
extends MxModel {
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    @Inject
    private UnderlyingSecurityMng api;
    private static final int FULL_QUERY_INTERVAL = 5000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private MxList<XtUnderlyingSecurity> list = new MxList();
    private Map<String, XtUnderlyingSecurity> mapUnderlying = new ConcurrentHashMap<String, XtUnderlyingSecurity>();
    private volatile boolean working = false;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(5000);
        this.sdSpecQuery.setInterval(1000);
    }

    public void query() {
        if (this.working) {
            return;
        }
        try {
            try {
                this.working = true;
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("\u8baf\u6295\u878d\u8d44\u878d\u5238\u6807\u7684\u5238 underlying query failed: ", e);
                this.working = false;
            }
        }
        finally {
            this.working = false;
        }
    }

    private void fullQuery() throws MException {
        List<String> fundList = this.faccService.getMarginFundAccountList().stream().map(item -> item.getParentId()).collect(Collectors.toList());
        List<XtUnderlyingSecurity> list = this.api.queryList(fundList);
        this.update(list);
    }

    private void update(List<XtUnderlyingSecurity> listQuery) {
        this.list.setAll(listQuery);
        this.mapUnderlying = this.list.getList().stream().collect(Collectors.toMap(XtUnderlyingSecurity::unique, u -> u));
        this.changed();
    }

    public List<XtUnderlyingSecurity> getList() {
        return this.list.getList();
    }

    public Boolean isUnderlying(String codeMarket) {
        if (this.mapUnderlying.isEmpty()) {
            return false;
        }
        return this.mapUnderlying.containsKey(codeMarket);
    }

    public XtUnderlyingSecurity getUnderlying(String codeMarket) {
        if (this.mapUnderlying.isEmpty()) {
            return null;
        }
        return this.mapUnderlying.get(codeMarket);
    }
}

