/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.query.marginxt.XtPledgeSecurity;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.mng.xt.PledgeSecurityMng;
import cms.tmx.utils.MarketUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PledgeModel
extends MxModel {
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MObjFactory of;
    @Inject
    private IFundAccountService faccService;
    private Map<FundAccount, PledgeSecurityMng> mapQuery = new ConcurrentHashMap<FundAccount, PledgeSecurityMng>();
    private Map<String, XtPledgeSecurity> mapPledge = new ConcurrentHashMap<String, XtPledgeSecurity>();
    private MxList<XtPledgeSecurity> mxList = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private volatile boolean working = false;
    @Inject
    private PledgeSecurityMng api;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    public synchronized PledgeSecurityMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals("CCS")) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        PledgeSecurityMng query = (PledgeSecurityMng)((Object)this.of.create(PledgeSecurityMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        if (this.working) {
            return;
        }
        try {
            try {
                this.working = true;
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("\u8baf\u6295\u878d\u8d44\u878d\u5238\u62c5\u4fdd\u54c1 pledge query failed", e);
                this.working = false;
            }
        }
        finally {
            this.working = false;
        }
    }

    private void fullQuery() throws MException {
        List<String> fundList = this.faccService.getMarginFundAccountList().stream().map(item -> item.getParentId()).collect(Collectors.toList());
        List<XtPledgeSecurity> list = this.api.query(fundList);
        this.update(list);
    }

    private void update(List<XtPledgeSecurity> listQuery) {
        for (XtPledgeSecurity pledgeSecurityQuery : listQuery) {
            pledgeSecurityQuery.setMarket(MarketUtils.getMarketNameById((String)pledgeSecurityQuery.getMarket()));
        }
        this.mxList.setAll(listQuery);
        this.mapPledge = this.mxList.getList().stream().collect(Collectors.toMap(XtPledgeSecurity::unique, u -> u));
        this.changed();
    }

    public List<XtPledgeSecurity> getList() {
        return this.mxList.getList();
    }

    public Boolean isPledgeSecurity(String codeMarket) {
        if (this.mapPledge.isEmpty()) {
            return false;
        }
        return this.mapPledge.containsKey(codeMarket);
    }

    public XtPledgeSecurity getPledgeSecurity(String codeMarket) {
        if (this.mapPledge.isEmpty()) {
            return null;
        }
        return this.mapPledge.get(codeMarket);
    }
}

