/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CcsTradeSettings;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.api.strategy.dto.OrderCancelReplaceRequest;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.query.marginxt.api.XtOrderCancelServiceApi;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.models.xt.MarginOrderModel;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginUnfinishedOrderModel
extends MarginOrderModel {
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    private boolean popBeforeCancel = true;
    private MxNode nodeHandicap;
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private MarginAccountMap marginAccMap;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private static final Logger logger = LogManager.getLogger(MarginUnfinishedOrderModel.class);
    @Inject
    private XtOrderCancelServiceApi orderApi;

    @Override
    @PostConstruct
    public void init() {
        this.isUnfinishedOrder = true;
        super.init();
        this.nodeHandicap = MxNodeFactory.createNew((String)"handicap", (String)"0");
        this.initPriceType(this.nodeHandicap);
        this.setPriceType(this.nodeHandicap);
        this.es.subscribe("settingsRefresh", event -> this.doSet());
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.doSet());
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void doSet() {
        try {
            if (this.funcPanelType == null || this.menuId == null) {
                return;
            }
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CcsTradeSettings) {
                this.setPopBeforeCancel(((CcsTradeSettings)CcsTradeSettings.class.cast(settings)).getPopBeforeCancel().equals("1"));
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "100");
        node.addNode("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
        node.addNode("-100");
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public synchronized int cancel(List<ObSingleOrderMargin> list) {
        int countSuc = 0;
        for (ObSingleOrderMargin order : list) {
            try {
                OrderCancelRequest req = new OrderCancelRequest();
                Instrument inst = new Instrument();
                inst.setApplId("760");
                inst.setMarketGroup("CCS");
                inst.setMarket(order.getInstrument().getMarket());
                inst.setSecurityId(order.getSecurityId());
                inst.setSymbol(order.getSecurityName());
                req.setInstrument(inst);
                req.setOrderId(order.getOrderId());
                req.setCashAccntId(order.getExtCashAccntId());
                req.setParty(null);
                CcsFundAccount fundAcc = this.marginAccMap.getFundAcc(order.getInvestorId());
                String counterId = "";
                if (fundAcc != null) {
                    counterId = fundAcc.getCounterId();
                }
                req.setPlatformId(counterId);
                this.orderApi.orderCancel(req);
                ++countSuc;
            }
            catch (MException e) {
                logger.error("\u8baf\u6295\u64a4\u5355\u63d0\u4ea4\u5931\u8d25" + order.getOrderId() + (Object)((Object)e));
            }
        }
        return countSuc;
    }

    public synchronized int cancelAndOrder(List<ObSingleOrderMargin> list) {
        int countSuc = 0;
        for (ObSingleOrderMargin order : list) {
            if ("\u73b0\u5238\u8fd8\u5238".equals(order.getInstrument().getMarketIndicator()) || "\u76f4\u63a5\u8fd8\u6b3e".equals(order.getInstrument().getMarketIndicator())) continue;
            try {
                OrderCancelReplaceRequest req = new OrderCancelReplaceRequest();
                Instrument inst = new Instrument();
                inst.setApplId("760");
                inst.setMarketGroup("CCS");
                inst.setMarket(order.getInstrument().getMarket());
                inst.setSecurityId(order.getSecurityId());
                inst.setSymbol(order.getSecurityName());
                req.setInstrument(inst);
                req.setOrderId(order.getOrderId());
                req.setCashAccntId(order.getExtCashAccntId());
                req.setPrice(order.getNewPrice());
                CcsFundAccount fundAcc = this.marginAccMap.getFundAcc(order.getInvestorId());
                String counterId = "";
                if (fundAcc != null) {
                    counterId = fundAcc.getCounterId();
                }
                req.setPlatformId(counterId);
                if ("80".equals(order.getOrdType().getValue())) {
                    req.setOrderType("80");
                } else {
                    req.setOrderType("50");
                }
                this.orderApi.orderCancelReplace(req);
                ++countSuc;
            }
            catch (MException e) {
                logger.error("\u8baf\u6295\u64a4\u5355\u91cd\u4e0b\u63d0\u4ea4\u5931\u8d25" + order.getOrderId() + (Object)((Object)e));
            }
        }
        return countSuc;
    }

    public void queryMarketItem(List<ObSingleOrderMargin> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (ObSingleOrderMargin order : list) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        gears.setSell(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    private MarketItem getMktItemByOrder(ObSingleOrderMargin order) {
        RefItem refItem = this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId());
        if (refItem == null) {
            return null;
        }
        MarketItem mktItem = this.marketMng.getInfo((IRefItem)refItem);
        return mktItem;
    }

    public double getNewPrice(ObSingleOrderMargin order, int priceType, String floatUnit, String priceFloat) {
        double price = 0.0;
        MarketItem mktItem = this.getMktItemByOrder(order);
        if (mktItem == null) {
            return 0.0;
        }
        price = this.getPrice(priceType, mktItem);
        int scale = mktItem.getRefItem().getScale();
        BigDecimal bg = new BigDecimal(String.valueOf(price));
        price = bg.setScale(scale, 4).doubleValue();
        if (floatUnit.equals("\u5143")) {
            price += Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat);
        } else if (floatUnit.equals("%")) {
            BigDecimal floatP = new BigDecimal(1).add(new BigDecimal(Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat)).multiply(new BigDecimal(0.01)));
            price = new BigDecimal(price).multiply(floatP).doubleValue();
        }
        if (!"BOND".equals(order.getInstrument().getSecurityType()) && !"REPO".equals(order.getInstrument().getSecurityType()) && !"PLEDGE".equals(order.getInstrument().getSecurityType()) && mktItem.getUpLimitPrice() > 0.0 && price > mktItem.getUpLimitPrice()) {
            price = mktItem.getUpLimitPrice();
        } else if (!"BOND".equals(order.getInstrument().getSecurityType()) && !"REPO".equals(order.getInstrument().getSecurityType()) && !"PLEDGE".equals(order.getInstrument().getSecurityType()) && mktItem.getDownLimitPrice() > 0.0 && price < mktItem.getDownLimitPrice()) {
            price = mktItem.getDownLimitPrice();
        }
        bg = new BigDecimal(String.valueOf((double)Math.round(price * 10000.0) / 10000.0));
        if ("49".equals(order.getSide().getValue())) {
            price = bg.setScale(scale, 1).doubleValue();
        } else if ("50".equals(order.getSide().getValue())) {
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    private double getPrice(int i, MarketItem mktItem) {
        double price = 0.0;
        if (i == 0) {
            price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
        } else if (i == 100) {
            price = mktItem.getUpLimitPrice() > 0.0 ? mktItem.getUpLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i == -100) {
            price = mktItem.getDownLimitPrice() > 0.0 ? mktItem.getDownLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i > 0) {
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListBuyHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListBuyHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        } else if (i < 0) {
            i = Math.abs(i);
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListSellHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListSellHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        }
        return price;
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    @Override
    public List<ObSingleOrderMargin> getObList() {
        return this.obList.getList();
    }
}

