/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.query.marginxt.XtOrdEvent;
import cms.tmx.http.query.marginxt.XtSingleOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.mng.xt.MarginOrderMng;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginOrderModel
extends MxModel {
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    @Inject
    private IUserService userService;
    private String marketGroup = "CCS";
    protected Gson gson = new Gson();
    private MxList<XtSingleOrder> list = new MxList();
    protected MxList<ObSingleOrderMargin> obList = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Map<FundAccount, MarginOrderMng> mapQuery = new ConcurrentHashMap<FundAccount, MarginOrderMng>();
    protected boolean isUnfinishedOrder = false;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", e -> this.onPush(e));
    }

    protected boolean careReport(String type) {
        return "48".equals(type) || "52".equals(type) || "56".equals(type) || "70".equals(type) || "65".equals(type);
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        XtOrdEvent ordEvent = (XtOrdEvent)this.gson.fromJson((JsonElement)obj, XtOrdEvent.class);
        for (XtSingleOrder or : ordEvent.getOrder()) {
            if (!"760".equals(or.getInstrument().getApplId()) || !"CCS".equals(or.getInstrument().getMarketGroup())) {
                return;
            }
            or.setOrdEvent();
            or.setErrInfo(or.transferErrInfo());
            or.setExtraFields();
            or.setUnit(QueryUtils.getUnit(or.getInstrument().getSecurityType(), or.getInstrument().getMarket()));
            or.setUserName((String)this.userService.getUserName(or.getUserId()).get());
            ObSingleOrderMargin single = new ObSingleOrderMargin();
            single.update((Object)or);
            if (this.isUnfinishedOrder) {
                if (or.isCanCancel()) {
                    this.list.updatePart((MxObject)or);
                    this.obList.updatePart((MxObject)single);
                    continue;
                }
                if (this.list.getListMap().get(or) == null) continue;
                this.list.remove((MxObject)or);
                this.obList.remove((MxObject)single);
                continue;
            }
            this.list.updatePart((MxObject)or);
            this.obList.updatePart((MxObject)single);
        }
        this.changed();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("order query failed", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullQuery() throws MException {
        List<XtSingleOrder> list = this.getList();
        synchronized (list) {
            this.list.clear();
            this.obList.clear();
        }
        List fundList = this.faccService.getMarginFundAccountList();
        for (FundAccount fund : fundList) {
            MarginOrderMng mng = this.getQuery(fund);
            ArrayList<XtSingleOrder> listQuery = new ArrayList<XtSingleOrder>();
            ArrayList<ObSingleOrderMargin> obListQuery = new ArrayList<ObSingleOrderMargin>();
            Set<XtSingleOrder> setQuery = null;
            try {
                setQuery = mng.query(this.isUnfinishedOrder);
            }
            catch (MException e) {
                this.logger.error("query fund account order failed: ", (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
            for (XtSingleOrder o : listQuery) {
                o.setErrInfo(o.transferErrInfo());
                if (o.getOrdStatus() != null && XtSingleOrder.CAN_CANCEL_STATUS.contains(o.getOrdStatus().getValue())) {
                    o.setCanCancel(true);
                }
                o.setExtraFields();
                if (o.getInstrument() != null) {
                    o.setUnit(QueryUtils.getUnit(o.getInstrument().getSecurityType(), o.getInstrument().getMarket()));
                }
                o.setUserName((String)this.userService.getUserName(o.getUserId()).get());
                ObSingleOrderMargin ob = new ObSingleOrderMargin();
                ob.update((Object)o);
                obListQuery.add(ob);
            }
            this.update(listQuery, obListQuery);
        }
    }

    public synchronized MarginOrderMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        MarginOrderMng query = (MarginOrderMng)((Object)this.of.create(MarginOrderMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(List<XtSingleOrder> listQuery, List<ObSingleOrderMargin> newList) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            listQuery.addAll((Collection<XtSingleOrder>)this.list.getList());
        }
        this.list.update(listQuery);
        observableList = this.obList.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSingleOrderMargin>)this.obList.getList());
        }
        this.obList.update(newList);
        this.changed();
    }

    public List<XtSingleOrder> getList() {
        return this.list.getList();
    }

    public List<ObSingleOrderMargin> getObList() {
        return this.obList.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    public Set<String> getInvestorSecIds() {
        return this.accountMap.getInvestorSecIds();
    }
}

