/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.query.marginxt.XtExecEvent;
import cms.tmx.http.query.marginxt.XtExecution;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.mng.xt.MarginDealMng;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginDealModel
extends MxModel {
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private MxList<XtExecution> list = new MxList();
    private Map<FundAccount, MarginDealMng> mapQuery = new ConcurrentHashMap<FundAccount, MarginDealMng>();
    private String marketGroup = "CCS";
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.ExecEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        XtExecEvent execEvent = (XtExecEvent)this.gson.fromJson((JsonElement)obj, XtExecEvent.class);
        for (XtExecution exec : execEvent.getExecution()) {
            if (!"760".equals(exec.getInstrument().getApplId()) || !"CCS".equals(exec.getInstrument().getMarketGroup())) continue;
            exec.setExecEvent();
            exec.setExtraFieldsMargin();
            exec.setUnit(QueryUtils.getUnit(exec.getInstrument().getSecurityType(), exec.getInstrument().getMarket()));
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    public synchronized MarginDealMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        MarginDealMng query = (MarginDealMng)((Object)this.of.create(MarginDealMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("execution query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        List fundList = this.faccService.getMarginFundAccountList();
        ArrayList<XtExecution> listQuery = new ArrayList<XtExecution>();
        for (FundAccount fund : fundList) {
            MarginDealMng mng = this.getQuery(fund);
            Set<XtExecution> setQuery = null;
            try {
                setQuery = mng.query();
            }
            catch (MException e) {
                this.logger.error("\u8baf\u6295\u878d\u8d44\u878d\u5238\u6210\u4ea4query fund account deal failed: " + fund + "\u8d26\u53f7" + fund.getNewCashAccntId(), (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
        }
        for (XtExecution o : listQuery) {
            o.setExtraFieldsMargin();
            o.setUnit(QueryUtils.getUnit(o.getInstrument().getSecurityType(), o.getInstrument().getMarket()));
        }
        this.update(listQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(List<XtExecution> listQuery) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(listQuery);
        }
        this.changed();
    }

    public ObservableList<XtExecution> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    public Set<String> getInvestorSecIds() {
        return this.accountMap.getInvestorSecIds();
    }
}

