/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models.xt;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.query.marginxt.XtGetOrdersReq;
import cms.tmx.http.query.marginxt.XtGetOrdersResp;
import cms.tmx.http.query.marginxt.XtSingleOrder;
import cms.tmx.http.query.marginxt.api.XtOrderServiceApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionMarginOrderModel
extends MxModel {
    @Inject
    private XtOrderServiceApi orderApi;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    private CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<ObSingleOrderMargin> list = new MxList();
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    private MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    private ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    private ObSimpleInstruction instruction;

    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent cfr_ignored_0 = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        this.changed();
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    private Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query(ObSimpleInstruction instr) throws IOException, MException {
        ArrayList listOrder = new ArrayList();
        try {
            XtGetOrdersReq req = new XtGetOrdersReq();
            Page httpDefPage = this.httpBase.getXtHttpDefPage();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String date = LocalDate.now().format(formatter);
            req.setBeginDate(date);
            req.setEndDate(date);
            AccountId accountId = ((AccntSecInfo)instr.getOrderDetail().getAccntSecInfo().get(0)).getAccountId();
            req.setCapitalAccountIds(Arrays.asList(accountId.getCashAccntId()));
            req.setInstructionId(instr.getId());
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(1);
            XtGetOrdersResp resp = this.orderApi.getOrderList(req);
            this.list.clear();
            Page pageResp = resp.getPage();
            listOrder.addAll(resp.getOrder());
            int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            int total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            while (--queryTimes > 0) {
                req.setPageSize(httpDefPage.getPageSize());
                req.setPageNum(total - queryTimes + 1);
                XtGetOrdersResp res = this.orderApi.getOrderList(req);
                listOrder.addAll(res.getOrder());
            }
        }
        catch (MException e) {
            this.logger.error("\u8baf\u6295\u878d\u8d44\u878d\u5238\u6307\u4ee4\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        for (XtSingleOrder or : listOrder) {
            or.setErrInfo(or.transferErrInfo());
            if (XtSingleOrder.CAN_CANCEL_STATUS.contains(or.getOrdStatus().getValue())) {
                or.setCanCancel(true);
            }
            or.setExtraFields();
            or.setUnit(QueryUtils.getUnit(or.getInstrument().getSecurityType(), or.getInstrument().getMarket()));
            or.setUserName((String)this.userService.getUserName(or.getUserId()).get());
            ObSingleOrderMargin ob = new ObSingleOrderMargin();
            ob.update((Object)or);
            this.list.add((MxObject)ob);
        }
        this.changed();
    }

    public List<ObSingleOrderMargin> getList() {
        return this.list.getList();
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }
}

