/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.query.margin.UnderlyingSecurityQuery;
import cms.tmx.http.statement.api.UnderlyingSecurityApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UnderlyingModel
extends MxModel {
    @Inject
    private UnderlyingSecurityApi underlyingApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    private MxList<UnderlyingSecurityQuery> underlyingList = new MxList();
    private Map<String, UnderlyingSecurityQuery> mapUnderlying = new ConcurrentHashMap<String, UnderlyingSecurityQuery>();

    @PostConstruct
    private void init() {
    }

    public synchronized void query() throws MException {
        List underlyingSecurityList = this.underlyingApi.getUnderlyingSecurityList("");
        this.underlyingList.clear();
        this.mapUnderlying.clear();
        this.underlyingList.addAll(underlyingSecurityList);
        this.mapUnderlying = this.underlyingList.getList().stream().collect(Collectors.toMap(UnderlyingSecurityQuery::unique, u -> u));
        this.changed();
    }

    public List<UnderlyingSecurityQuery> getList() {
        return this.underlyingList.getList();
    }

    public Boolean isUnderlying(String codeMarket) {
        if (this.mapUnderlying.isEmpty()) {
            return false;
        }
        return this.mapUnderlying.containsKey(codeMarket);
    }

    public UnderlyingSecurityQuery getUnderlying(String codeMarket) {
        if (this.mapUnderlying.isEmpty()) {
            return null;
        }
        return this.mapUnderlying.get(codeMarket);
    }
}

