/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.query.ObSofp;
import cms.tmx.http.query.Sofp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.mng.RateMng;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class RateModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(RateModel.class);
    private String marketGroup;
    private Map<FundAccount, RateMng> mapQuery = new ConcurrentHashMap<FundAccount, RateMng>();
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MObjFactory of;
    private MxList<ObSofp> list = new MxList();
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
    }

    public synchronized RateMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        RateMng query = (RateMng)((Object)this.of.create(RateMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("rate query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        List fundList = this.faccService.getMarginFundAccountList();
        ArrayList<Sofp> listQuery = new ArrayList<Sofp>();
        ArrayList<ObSofp> listOb = new ArrayList<ObSofp>();
        for (FundAccount fund : fundList) {
            RateMng rateMng = this.getQuery(fund);
            Sofp setQuery = null;
            try {
                setQuery = rateMng.query();
            }
            catch (MException e) {
                logger.error("query fund account rate failed: ", (Throwable)e);
            }
            if (setQuery == null) continue;
            listQuery.add(setQuery);
        }
        for (Sofp each : listQuery) {
            ObSofp o = new ObSofp();
            o.update((Object)each);
            listOb.add(o);
        }
        this.update(listOb);
    }

    private synchronized void update(List<ObSofp> listSofp) {
        this.list.update(listSofp);
        this.changed();
    }

    public ObservableList<ObSofp> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

