/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.http.query.margin.PledgeSecurityQuery;
import cms.tmx.http.statement.api.PledgeSecurityApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.MarketUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PledgeModel
extends MxModel {
    @Inject
    private static PledgeSecurityApi pledgeApi;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 5000;
    private MxList<PledgeSecurityQuery> pledgeList = new MxList();
    private Map<String, PledgeSecurityQuery> mapPledge = new ConcurrentHashMap<String, PledgeSecurityQuery>();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(5000);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                System.err.println("Pledge query failed");
                this.logger.error("Pledge query failed", e);
            }
        });
    }

    public ObservableList<PledgeSecurityQuery> getList() {
        return this.pledgeList.getList();
    }

    private void getMapPledge() {
        if (this.pledgeList.getList().isEmpty()) {
            this.query();
        }
        for (PledgeSecurityQuery pledgeSecurityQuery : this.pledgeList.getList()) {
            String codeMarket = String.valueOf(pledgeSecurityQuery.getSecurityId()) + pledgeSecurityQuery.getMarket();
            this.mapPledge.put(codeMarket, pledgeSecurityQuery);
        }
    }

    public Boolean isPledgeSecurity(String codeMarket) {
        if (this.mapPledge.isEmpty()) {
            this.getMapPledge();
        }
        return this.mapPledge.containsKey(codeMarket);
    }

    public PledgeSecurityQuery getPledgeSecurity(String codeMarket) {
        if (this.mapPledge.isEmpty()) {
            this.getMapPledge();
        }
        return this.mapPledge.get(codeMarket);
    }

    public void fullQuery() throws MException {
        List pledges = pledgeApi.getPledgeList("");
        this.pledgeList.clear();
        this.mapPledge.clear();
        for (PledgeSecurityQuery pledgeSecurityQuery : pledges) {
            pledgeSecurityQuery.setMarket(MarketUtils.getMarketNameById((String)pledgeSecurityQuery.getMarket()));
        }
        this.pledgeList.addAll(pledges);
        this.changed();
    }
}

