/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.http.api.strategy.dto.PosEvent;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.mng.MarginPositionMng;
import cms.tmx.query.utils.QueryUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginPositionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(MarginPositionModel.class);
    private String marketGroup;
    private Map<FundAccount, MarginPositionMng> mapQuery = new ConcurrentHashMap<FundAccount, MarginPositionMng>();
    private Map<String, Position> mapList = new ConcurrentHashMap<String, Position>();
    @Inject
    private ISecAccountService secService;
    @Inject
    private MObjFactory of;
    private MxListDirty<ObPositionMargin> list = new MxListDirty();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.PosEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PosEvent posEvent = (PosEvent)this.gson.fromJson((JsonElement)obj, PosEvent.class);
        for (Positions posi : posEvent.getPosition()) {
            if (AccntType.ACCNT_TYPE_SEC != posi.getAccntType() || !"750".equals(posi.getInstrument().getApplId()) || !"CCS".equals(posi.getInstrument().getMarketGroup())) continue;
            List posStatistic = posi.getPosStatistic();
            Position po = new Position();
            if (posStatistic != null) {
                po.setPosStatistic((PosStatistic)posStatistic.get(0));
            }
            po.update((Object)posi);
            po.setInvestorId(this.fundMng.getCcsAccntIdToInvestorId(po.getPosAccnt().getAccntId()));
            po.setInverstorSecId(this.accountMap.getMarginInvestorSec(po.getPosAccnt().getSecAccntId()));
            po.transformQty();
            String key = String.join((CharSequence)",", po.getPosAccnt().getSecAccntId(), po.getInstrument().getSecurityId());
            ObPositionMargin o = new ObPositionMargin();
            o.update((Object)po);
            String type = o.getInstrument().getSecType();
            String market = o.getInstrument().getMarket().getRaw();
            String unit = QueryUtils.getUnit(type, market);
            o.setUnit(unit);
            RefItem refItem = this.refMng.getItem(type, market, o.getInstrument().getSecId());
            double nowPrice = 0.0;
            if (refItem == null) {
                logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u63a8\u9001\u878d\u8d44\u878d\u5238\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                if ("STD_BOND".equals(type)) {
                    nowPrice = 100.0;
                }
            } else {
                MarketItem marketItem;
                LinkedList<RefItem> listItem = new LinkedList<RefItem>();
                listItem.add(refItem);
                Gears gears = new Gears();
                if (!listItem.isEmpty()) {
                    this.marketMng.query(listItem, gears);
                }
                if ((marketItem = this.marketMng.getInfo((IRefItem)refItem)) != null) {
                    nowPrice = marketItem.getClosePrice();
                    if (marketItem.getNowPrice() != 0.0) {
                        nowPrice = marketItem.getNowPrice();
                    }
                } else {
                    logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u63a8\u9001\u878d\u8d44\u878d\u5238\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            if (refItem != null && nowPrice != 0.0) {
                double marketValue = QueryUtils.calAmountByMarketAndSecType(market, type, (long)o.getSecBalance(), nowPrice);
                o.getPosStatistic().setMarketValue((double)Math.round(marketValue * 100.0) / 100.0);
            }
            if (this.list.getListMap().get(o) == null) {
                this.list.add((MxDirtyObj)o);
            } else {
                ((ObPositionMargin)this.list.getListMap().get(o)).update((Object)o);
            }
            this.mapList.put(key, po);
            this.changed();
        }
    }

    public synchronized MarginPositionMng getQuery(FundAccount fund, List<SecAccount> list) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        MarginPositionMng query = (MarginPositionMng)((Object)this.of.create(MarginPositionMng.class));
        query.setFund(fund);
        ArrayList<String> sec = new ArrayList<String>();
        list.forEach(each -> sec.add(each.getExtSecAccntId()));
        query.setSecList(sec);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("rate query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        Map map = this.secService.getMarginSecAccountMap();
        ArrayList<Position> listQuery = new ArrayList<Position>();
        ArrayList<ObPositionMargin> listOb = new ArrayList<ObPositionMargin>();
        for (FundAccount fund : map.keySet()) {
            MarginPositionMng mng = this.getQuery(fund, (List)map.get(fund));
            Set<Position> setQuery = null;
            try {
                setQuery = mng.query();
            }
            catch (MException e) {
                logger.error("query fund account position failed: ", (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
        }
        this.queryMarketItem(listQuery);
        for (Position po : listQuery) {
            double marketValue;
            po.setInvestorId(this.fundMng.getCcsAccntIdToInvestorId(po.getPosAccnt().getAccntId()));
            po.setInverstorSecId(this.accountMap.getMarginInvestorSec(po.getPosAccnt().getSecAccntId()));
            po.transformQty();
            String key = String.join((CharSequence)",", po.getPosAccnt().getSecAccntId(), po.getInstrument().getSecurityId());
            this.mapList.put(key, po);
            ObPositionMargin o = new ObPositionMargin();
            o.update((Object)po);
            String type = o.getInstrument().getSecType();
            String market = o.getInstrument().getMarket().getRaw();
            String unit = QueryUtils.getUnit(type, market);
            o.setUnit(unit);
            RefItem refItem = this.refMng.getItem(type, market, o.getInstrument().getSecId());
            double nowPrice = 0.0;
            if (refItem == null) {
                logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u67e5\u8be2\u878d\u8d44\u878d\u5238\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                if ("STD_BOND".equals(type)) {
                    nowPrice = 100.0;
                    marketValue = QueryUtils.calAmountByMarketAndSecType(market, type, (long)o.getSecBalance(), nowPrice);
                    o.getPosStatistic().setMarketValue((double)Math.round(marketValue * 100.0) / 100.0);
                }
            } else {
                MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    nowPrice = marketItem.getClosePrice();
                    if (marketItem.getNowPrice() != 0.0) {
                        nowPrice = marketItem.getNowPrice();
                    }
                } else {
                    logger.error(String.valueOf(o.getInstrument().getSecId()) + "\u67e5\u8be2\u878d\u8d44\u878d\u5238\u6301\u4ed3\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            if (refItem != null && nowPrice != 0.0) {
                marketValue = QueryUtils.calAmountByMarketAndSecType(market, type, (long)o.getSecBalance(), nowPrice);
                o.getPosStatistic().setMarketValue((double)Math.round(marketValue * 100.0) / 100.0);
            }
            listOb.add(o);
        }
        this.update(listOb);
    }

    private synchronized void queryMarketItem(List<Position> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (Position o : posList) {
            RefItem item = this.refMng.getItem(o.getInstrument().getSecurityType(), o.getInstrument().getMarket(), o.getInstrument().getSecurityId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    private synchronized void update(List<ObPositionMargin> listQuery) {
        this.list.update(listQuery);
        this.changed();
    }

    public ObservableList<ObPositionMargin> getList() {
        return this.list.getList();
    }

    public Map<String, Position> getMapList() {
        return this.mapList;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

