/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.mng.MarginOrderMng;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginOrderModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(MarginOrderModel.class);
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MObjFactory of;
    private MxList<SingleOrder> list = new MxList();
    protected MxList<ObSingleOrderMargin> obList = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    @Inject
    private IUserService userService;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    private String marketGroup;
    protected Gson gson = new Gson();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Map<FundAccount, MarginOrderMng> mapQuery = new ConcurrentHashMap<FundAccount, MarginOrderMng>();
    protected boolean isUnfinishedOrder = false;

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder or : ordEvent.getOrder()) {
            if (!"750".equals(or.getInstrument().getApplId()) || !"CCS".equals(or.getInstrument().getMarketGroup())) continue;
            or.setClOrdId(or.getClOrdId().substring(or.getClOrdId().lastIndexOf("|") + 1));
            or.setParentId(or.getParentId().substring(or.getParentId().lastIndexOf("|") + 1));
            or.setErrInfo(or.transferErrInfo());
            or.setExtraFields();
            or.setUnit(QueryUtils.getUnit(or.getInstrument().getSecurityType(), or.getInstrument().getMarket()));
            or.setUserName((String)this.userService.getUserName(or.getUserId()).get());
            if (or.getExecMode() != null && or.getExecMode().getEmName() != null && or.getExecMode().getEmName().contains(":")) {
                or.setAlgoId(or.getExecMode().getEmName().substring(0, or.getExecMode().getEmName().indexOf(":")));
            } else {
                or.setAlgoId("");
            }
            ObSingleOrderMargin single = new ObSingleOrderMargin();
            single.update((Object)or);
            if (this.isUnfinishedOrder) {
                if (or.isCanCancel()) {
                    this.list.updatePart((MxObject)or);
                    this.obList.updatePart((MxObject)single);
                    continue;
                }
                if (this.list.getListMap().get(or) == null) continue;
                this.list.remove((MxObject)or);
                this.obList.remove((MxObject)single);
                continue;
            }
            this.list.updatePart((MxObject)or);
            this.obList.updatePart((MxObject)single);
        }
        this.changed();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("order query failed", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullQuery() throws MException {
        List<SingleOrder> list = this.getList();
        synchronized (list) {
            this.list.clear();
            this.obList.clear();
        }
        List fundList = this.faccService.getMarginFundAccountList();
        for (FundAccount fund : fundList) {
            MarginOrderMng mng = this.getQuery(fund);
            ArrayList<SingleOrder> listQuery = new ArrayList<SingleOrder>();
            ArrayList<ObSingleOrderMargin> obListQuery = new ArrayList<ObSingleOrderMargin>();
            List<SingleOrder> setQuery = null;
            try {
                setQuery = mng.query(this.isUnfinishedOrder);
            }
            catch (MException e) {
                logger.error("query fund account order failed: ", (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
            for (SingleOrder o : listQuery) {
                o.setClOrdId(o.getClOrdId().substring(o.getClOrdId().lastIndexOf("|") + 1));
                o.setParentId(o.getParentId().substring(o.getParentId().lastIndexOf("|") + 1));
                o.setErrInfo(o.transferErrInfo());
                if (SingleOrder.CAN_CANCEL_STATUS.contains(o.getOrdStatus().getValue())) {
                    o.setCanCancel(true);
                }
                o.setExtraFields();
                o.setUnit(QueryUtils.getUnit(o.getInstrument().getSecurityType(), o.getInstrument().getMarket()));
                o.setUserName((String)this.userService.getUserName(o.getUserId()).get());
                if (o.getExecMode() != null && o.getExecMode().getEmName() != null && o.getExecMode().getEmName().contains(":")) {
                    o.setAlgoId(o.getExecMode().getEmName().substring(0, o.getExecMode().getEmName().indexOf(":")));
                } else {
                    o.setAlgoId("");
                }
                ObSingleOrderMargin ob = new ObSingleOrderMargin();
                ob.update((Object)o);
                obListQuery.add(ob);
            }
            this.update(listQuery, obListQuery);
        }
    }

    public synchronized MarginOrderMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        MarginOrderMng query = (MarginOrderMng)((Object)this.of.create(MarginOrderMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(List<SingleOrder> listQuery, List<ObSingleOrderMargin> newList) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            listQuery.addAll((Collection<SingleOrder>)this.list.getList());
        }
        this.list.update(listQuery);
        observableList = this.obList.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSingleOrderMargin>)this.obList.getList());
        }
        this.obList.update(newList);
        this.changed();
    }

    public List<SingleOrder> getList() {
        return this.list.getList();
    }

    public List<ObSingleOrderMargin> getObList() {
        return this.obList.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

