/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.margin.mng.MarginDealMng;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginDealModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(MarginDealModel.class);
    private String marketGroup;
    private Map<FundAccount, MarginDealMng> mapQuery = new ConcurrentHashMap<FundAccount, MarginDealMng>();
    @Inject
    private IFundAccountService faccService;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MObjFactory of;
    private MxList<Execution> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.ExecEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)this.gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution exec : execEvent.getExecution()) {
            if (!"750".equals(exec.getInstrument().getApplId()) || !"CCS".equals(exec.getInstrument().getMarketGroup())) continue;
            exec.setExtraFieldsMargin();
            exec.setUnit(QueryUtils.getUnit(exec.getInstrument().getSecurityType(), exec.getInstrument().getMarket()));
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    public synchronized MarginDealMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        MarginDealMng query = (MarginDealMng)((Object)this.of.create(MarginDealMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("execution query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        List fundList = this.faccService.getMarginFundAccountList();
        ArrayList<Execution> listQuery = new ArrayList<Execution>();
        for (FundAccount fund : fundList) {
            MarginDealMng mng = this.getQuery(fund);
            Set<Execution> setQuery = null;
            try {
                setQuery = mng.query();
            }
            catch (MException e) {
                logger.error("query fund account deal failed: ", (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
        }
        for (Execution o : listQuery) {
            o.setExtraFieldsMargin();
            o.setUnit(QueryUtils.getUnit(o.getInstrument().getSecurityType(), o.getInstrument().getMarket()));
        }
        this.update(listQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(List<Execution> listQuery) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(listQuery);
        }
        this.changed();
    }

    public ObservableList<Execution> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

