/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.api.AlgoOrderServiceApi;
import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.http.api.strategy.dto.AlgoDetail;
import cms.tmx.http.api.strategy.dto.BasketInfo;
import cms.tmx.http.api.strategy.dto.CancelBaseAlgoRep;
import cms.tmx.http.api.strategy.dto.CancelBaseAlgoReq;
import cms.tmx.http.api.strategy.dto.CancelReqInfo;
import cms.tmx.http.api.strategy.dto.QueryBaseAlgoReq;
import cms.tmx.http.api.strategy.dto.QueryReqInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.MarginAccountMap;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class MarginAlgoQueryModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(MarginAlgoQueryModel.class);
    @Inject
    private AlgoOrderServiceApi algoApi;
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    protected MarginAccountMap accMng;
    protected Map<AlgoBaseOrder, List<AlgoBaseOrder>> map = new ConcurrentHashMap<AlgoBaseOrder, List<AlgoBaseOrder>>();
    protected Map<String, RefItem> secNameMap = new HashMap<String, RefItem>();
    List<AlgoBaseOrder> algoList = new ArrayList<AlgoBaseOrder>();
    private DateFormat format = new SimpleDateFormat("yyyyMMdd");
    protected boolean firstUpdate = true;
    @Inject
    private MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 5000;
    @Inject
    protected IRefDataMng refMng;
    protected MEventHandler autoQuery = event -> this.fullQuery();

    @PostConstruct
    public void init() {
        this.getRefItems();
        this.sdFullQuery.setInterval(5000);
        if (this.algoList.size() == 0) {
            this.query();
        }
        this.es.sendEvent("isMargin", new MEvent());
        this.es.subscribe("marginAlgoQuery", this.autoQuery);
    }

    public void fullQuery() {
        this.sdFullQuery.schedule(event -> this.query());
    }

    private void query() {
        try {
            this.queryBaseOrder();
        }
        catch (MException | Exception e) {
            logger.info("\u7b97\u6cd5\u67e5\u8be2\u51fa\u9519" + e.getMessage());
        }
    }

    private synchronized void queryBaseOrder() throws MException {
        int today = Integer.valueOf(this.format.format(new Date()));
        this.algoList.clear();
        List<String> listFund = this.accMng.getParentId();
        ArrayList data = new ArrayList();
        try {
            QueryBaseAlgoReq request = new QueryBaseAlgoReq();
            request.setReqInfo(new QueryReqInfo());
            request.getReqInfo().setStartDate(today - 1);
            request.getReqInfo().setEndDate(today);
            request.getReqInfo().setIsSummary(0);
            for (String fund : listFund) {
                request.getReqInfo().setAccount(fund);
                request.getReqInfo().setAlgoOrderIdIndex("");
                data.addAll(this.algoApi.algoQuery(request));
            }
        }
        catch (IOException e) {
            logger.info("\u7b97\u6cd5\u67e5\u8be2\u51fa\u9519" + e.getMessage());
        }
        for (AlgoDetail algoDetail : data) {
            ArrayList<AlgoBaseOrder> list = new ArrayList<AlgoBaseOrder>();
            AlgoBaseOrder keyOrder = new AlgoBaseOrder();
            keyOrder.update((Object)algoDetail);
            algoDetail.getStockMargin().getBasket();
            for (BasketInfo info : algoDetail.getStockMargin().getBasket()) {
                AlgoBaseOrder order = new AlgoBaseOrder();
                order.update((Object)algoDetail);
                order.update((Object)info);
                this.afterUpdate(order, algoDetail);
                list.add(order);
            }
            this.map.put(keyOrder, list);
            this.algoList.addAll(list);
        }
        this.changed();
    }

    private void afterUpdate(AlgoBaseOrder order, AlgoDetail algoDetail) {
        List basket;
        MxNode node = MxNodeFactory.createNew((String)"algo_status");
        if ("SIDE_BUY".equals(order.getSideStr())) {
            basket = algoDetail.getStockMargin().getBasket();
            for (BasketInfo basketInfo : basket) {
                if ("SIDE_BUY".equals(basketInfo.getSide())) {
                    order.setExecutedQty((int)basketInfo.getTradeQty());
                    order.setAvgPrice(basketInfo.getTradeAvgPx());
                    order.setExecutedPercent(basketInfo.getExeTag() * 100.0);
                    continue;
                }
                order.setOtherType(basketInfo.getTradeType());
            }
            order.setSide("\u4e70\u5165");
            node.setRaw(order.getAlgoStatus());
            order.setAlgoStatus(node.getValue());
        } else if ("SIDE_SELL".equals(order.getSideStr())) {
            basket = algoDetail.getStockMargin().getBasket();
            for (BasketInfo basketInfo : basket) {
                if ("SIDE_SELL".equals(basketInfo.getSide())) {
                    order.setExecutedPercent(basketInfo.getExeTag() * 100.0);
                    order.setExecutedQty((int)basketInfo.getTradeQty());
                    order.setAvgPrice(basketInfo.getTradeAvgPx());
                    continue;
                }
                order.setOtherType(basketInfo.getTradeType());
            }
            order.setSide("\u5356\u51fa");
            node.setRaw(order.getAlgoStatus());
            order.setAlgoStatus(node.getValue());
        }
        RefItem refItem = this.secNameMap.get(order.getSecurity());
        if (refItem != null) {
            order.setSecName(refItem.getName());
        } else {
            order.setSecName(((BasketInfo)algoDetail.getStockMargin().getBasket().get(0)).getReserved1().split("#")[2]);
        }
    }

    public Map<AlgoBaseOrder, List<AlgoBaseOrder>> getMap() {
        return this.map;
    }

    public List<AlgoBaseOrder> getList() {
        return this.algoList;
    }

    protected void getRefItems() {
        Collection refItems = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
        refItems.forEach(date -> this.secNameMap.put(date.getCode(), (RefItem)date));
    }

    public String cancel(List<AlgoBaseOrder> list) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        int n = 0;
        HashMap map = new HashMap();
        list.forEach(data -> map.put(data.getAlgoOrderId(), data));
        try {
            CancelBaseAlgoReq cancelReq = new CancelBaseAlgoReq();
            cancelReq.setReqInfo(new CancelReqInfo());
            CancelReqInfo reqInfo = cancelReq.getReqInfo();
            for (String key : map.keySet()) {
                AlgoBaseOrder ord = (AlgoBaseOrder)map.get(key);
                reqInfo.setAlgoName(ord.getAlgoName());
                reqInfo.setAccount(ord.getBizAcct());
                reqInfo.setUserId(ord.getUserId());
                cancelReq.setAlgoOrderId(ord.getAlgoOrderId());
                CancelBaseAlgoRep rep = this.algoApi.algoModify(cancelReq);
                if (rep.getRetCode() != 0) {
                    ++m;
                    logger.error("\u878d\u8d44\u878d\u5238\u7b97\u6cd5\u64a4\u5355\u5931\u8d25" + rep.getRetMsg());
                    continue;
                }
                ++n;
            }
        }
        catch (MException | IOException e) {
            logger.error("\u878d\u8d44\u878d\u5238\u7b97\u6cd5\u64a4\u5355\u5931\u8d25" + e);
            ++m;
        }
        sb.append(String.valueOf(m) + "\u7b14\u64a4\u5355\u5931\u8d25, " + n + "\u7b14\u64a4\u5355\u6210\u529f");
        return sb.toString();
    }
}

