/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.strategy.dto.SOFPEvent;
import cms.tmx.http.api.strategy.dto.TransPosReport;
import cms.tmx.http.query.ObSofp;
import cms.tmx.http.query.Sofp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.margin.mng.RateMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginAccountModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(MarginAccountModel.class);
    private String marketGroup;
    private Map<FundAccount, RateMng> mapQuery = new ConcurrentHashMap<FundAccount, RateMng>();
    private Map<String, Sofp> mapSofp = new ConcurrentHashMap<String, Sofp>();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MObjFactory of;
    private MxList<ObSofp> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.SOFPEvent", e -> this.onSofpPush(e));
        this.es.subscribe("uap.push.TransPosReport", e -> this.onTransPosPush(e));
    }

    private void onSofpPush(MEvent event) {
        if (!(event.getObj() instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        SOFPEvent sofps = (SOFPEvent)this.gson.fromJson(obj.getAsString(), SOFPEvent.class);
        LinkedList<ObSofp> listOb = new LinkedList<ObSofp>();
        for (Sofp each : sofps.getSofps()) {
            ObSofp o = new ObSofp();
            each.setInvestorId(this.fundMng.getCcsInvestorId(each.getCashAccntId()));
            o.update((Object)each);
            listOb.add(o);
        }
        this.update(listOb);
    }

    private void onTransPosPush(MEvent event) {
        JsonElement cast = (JsonElement)JsonElement.class.cast(event.getObj());
        TransPosReport report = (TransPosReport)this.gson.fromJson(cast.toString(), TransPosReport.class);
        String type = report.getExecType().getValue();
        if (!this.careReport(type)) {
            return;
        }
        this.updateFundAccount(report.getSrc().getExtCashAccntId(), "CCS");
    }

    private boolean careReport(String type) {
        return type.equals("48") || type.equals("52") || type.equals("56") || type.equals("70");
    }

    private void updateFundAccount(String extAccntId, String marketGrp) {
        FundAccount fundAcc = this.fundMng.getFundAccountNew(extAccntId, marketGrp);
        RateMng query = null;
        if (fundAcc != null) {
            query = this.mapQuery.get(fundAcc);
        }
        if (query != null) {
            query.addQuery(extAccntId);
            this.scheduleSpecQuery();
        }
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("spec query sofp failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<Sofp> listSrc = new LinkedList<Sofp>();
        LinkedList<ObSofp> listOb = new LinkedList<ObSofp>();
        List fundList = this.fundMng.getMarginFundAccountList();
        for (FundAccount fund : fundList) {
            RateMng query = this.getQuery(fund);
            Sofp sofp = query.queryDirty();
            if (sofp == null) continue;
            listSrc.add(sofp);
            this.mapSofp.put(fund.getNewCashAccntId(), sofp);
        }
        for (Sofp each : listSrc) {
            ObSofp o = new ObSofp();
            o.update((Object)each);
            listOb.add(o);
        }
        this.update(listOb);
    }

    public synchronized RateMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        RateMng query = (RateMng)((Object)this.of.create(RateMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("account query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        List fundList = this.fundMng.getMarginFundAccountList();
        ArrayList<Sofp> listQuery = new ArrayList<Sofp>();
        ArrayList<ObSofp> listOb = new ArrayList<ObSofp>();
        for (FundAccount fund : fundList) {
            RateMng rateMng = this.getQuery(fund);
            Sofp sofp = null;
            try {
                sofp = rateMng.query();
            }
            catch (MException e) {
                logger.error("query fund account failed: ", (Throwable)e);
            }
            if (sofp == null) continue;
            this.mapSofp.put(fund.getNewCashAccntId(), sofp);
            listQuery.add(sofp);
        }
        for (Sofp each : listQuery) {
            ObSofp o = new ObSofp();
            o.update((Object)each);
            listOb.add(o);
        }
        this.update(listOb);
    }

    private synchronized void update(List<ObSofp> listQuery) {
        this.list.updatePart(listQuery);
        this.changed();
    }

    public ObservableList<ObSofp> getList() {
        return this.list.getList();
    }

    public Map<String, Sofp> getMapSofp() {
        return this.mapSofp;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

