/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.strategy.dto.ContractEvent;
import cms.tmx.http.api.strategy.dto.ExecutionReport;
import cms.tmx.http.api.strategy.dto.TransPosReport;
import cms.tmx.http.query.OrderExtra;
import cms.tmx.http.query.OrderRecord;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.mng.ContractMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ContractModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(ContractModel.class);
    private String marketGroup;
    private Map<FundAccount, ContractMng> mapQuery = new ConcurrentHashMap<FundAccount, ContractMng>();
    private Map<String, List<OrderRecord>> mapList = new ConcurrentHashMap<String, List<OrderRecord>>();
    private Map<String, Double> mapAmount = new ConcurrentHashMap<String, Double>();
    private Map<String, Integer> mapQty = new ConcurrentHashMap<String, Integer>();
    @Inject
    private IFundAccountService faccService;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private MObjFactory of;
    private MxList<OrderRecord> list = new MxList();
    @Inject
    private MEventService es;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.marketGroup = "CCS";
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.ExecutionReport", e -> this.onPush(e));
        this.es.subscribe("uap.push.TransPosReport", e -> this.onTransPosPush(e));
        this.es.subscribe("uap.push.ContractEvent", e -> this.onContractPush(e));
    }

    private void onContractPush(MEvent event) {
        if (!(event.getObj() instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive ob = (JsonPrimitive)event.getObj();
        ContractEvent contract = (ContractEvent)this.gson.fromJson(ob.getAsString(), ContractEvent.class);
        LinkedList<OrderRecord> listO = new LinkedList<OrderRecord>();
        for (OrderRecord order : contract.getOrderRecords()) {
            if (!"750".equals(order.getInstrument().getApplId()) || !"CCS".equals(order.getInstrument().getMarketGroup())) continue;
            OrderExtra obj = order.getObject();
            obj.setExtraFee(obj);
            order.setInvestorId(this.fundMng.getCcsInvestorId(order.getExtCashAccntId()));
            order.setInverstorSecId(this.accountMap.getMarginInvestorSec(order.getExtSecAccntId()));
            order.setExtraFields();
            String key = String.join((CharSequence)",", order.getExtCashAccntId(), order.getInstrument().getSecurityId());
            if (this.mapList.containsKey(key)) {
                ArrayList<OrderRecord> newList = new ArrayList<OrderRecord>();
                newList.addAll((Collection)this.mapList.get(key));
                if (newList.contains(order)) {
                    newList.set(newList.indexOf(order), order);
                } else {
                    newList.add(order);
                }
                this.updateMap(newList);
            } else {
                this.updateMap(Arrays.asList(order));
            }
            listO.add(order);
        }
        this.update(listO);
    }

    private void onTransPosPush(MEvent event) {
        if (event.getObj() instanceof JsonElement) {
            JsonElement json = (JsonElement)JsonElement.class.cast(event.getObj());
            TransPosReport report = (TransPosReport)this.gson.fromJson(json.toString(), TransPosReport.class);
            String type = report.getExecType().getValue();
            if (!this.careReport(type)) {
                return;
            }
            this.updateRecord(report.getInstrument().getSecurityId(), report.getInstrument().getMarket(), report.getSrc().getExtCashAccntId(), report.getInstrument().getMarketGroup());
        }
    }

    private void onPush(MEvent event) {
        if (event.getObj() instanceof JsonElement) {
            JsonElement json = (JsonElement)JsonElement.class.cast(event.getObj());
            ExecutionReport report = (ExecutionReport)this.gson.fromJson(json.toString(), ExecutionReport.class);
            if (!"750".equals(report.getInstrument().getApplId()) || !"CCS".equals(report.getInstrument().getMarketGroup())) {
                return;
            }
            if (report.getExecType() == null) {
                return;
            }
            String type = report.getExecType().getValue();
            if (!this.careReport(type)) {
                return;
            }
            this.updateRecord(report.getInstrument().getSecurityId(), report.getInstrument().getMarket(), report.getExtCashAccntId(), report.getInstrument().getMarketGroup());
        }
    }

    private void updateRecord(String securityId, String market, String extCashId, String marketGrp) {
        OrderRecord order = new OrderRecord();
        order.setSecId(securityId);
        order.setMarket(market);
        order.setExtCashAccntId(extCashId);
        order.setMarketGrp(marketGrp);
        this.updateOrderRecord(order);
    }

    private boolean careReport(String type) {
        return type.equals("48") || type.equals("52") || type.equals("70");
    }

    public synchronized ContractMng getQuery(FundAccount fund) {
        if (fund == null) {
            return null;
        }
        if (!fund.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        if (this.mapQuery.containsKey(fund)) {
            return this.mapQuery.get(fund);
        }
        ContractMng query = (ContractMng)((Object)this.of.create(ContractMng.class));
        query.setFund(fund);
        this.mapQuery.put(fund, query);
        return query;
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("rate query failed", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullQuery() throws MException {
        List<OrderRecord> list = this.getList();
        synchronized (list) {
            this.list.clear();
        }
        this.mapList.clear();
        this.mapAmount.clear();
        this.mapQty.clear();
        List fundList = this.faccService.getMarginFundAccountList();
        ArrayList<OrderRecord> listQuery = new ArrayList<OrderRecord>();
        for (FundAccount fund : fundList) {
            ContractMng mng = this.getQuery(fund);
            Set<OrderRecord> setQuery = null;
            try {
                setQuery = mng.query();
            }
            catch (MException e) {
                logger.error("query fund account contract failed: ", (Throwable)e);
            }
            if (setQuery == null || setQuery.size() == 0) continue;
            listQuery.addAll(setQuery);
        }
        this.updateMap(listQuery);
        this.update(listQuery);
    }

    private synchronized void updateMap(List<OrderRecord> listQuery) {
        ConcurrentHashMap<String, Integer> mapQt = new ConcurrentHashMap<String, Integer>();
        ConcurrentHashMap<String, List<Object>> mapOrders = new ConcurrentHashMap<String, List<Object>>();
        for (OrderRecord or : listQuery) {
            String keyQty = String.join((CharSequence)",", or.getExtCashAccntId(), or.getInstrument().getSecurityId());
            or.getExtCashAccntId();
            if (mapOrders.containsKey(keyQty)) {
                ArrayList<OrderRecord> newList = new ArrayList<OrderRecord>();
                newList.addAll((Collection)mapOrders.get(keyQty));
                newList.add(or);
                mapOrders.replace(keyQty, newList);
            } else {
                mapOrders.put(keyQty, Arrays.asList(or));
            }
            if (mapQt.containsKey(keyQty)) {
                mapQt.replace(keyQty, (Integer)mapQt.get(keyQty) + or.getObject().getStkRemain());
                continue;
            }
            mapQt.put(keyQty, or.getObject().getStkRemain());
        }
        for (String key : mapOrders.keySet()) {
            this.mapList.put(key, (List)mapOrders.get(key));
        }
        for (String key : mapQt.keySet()) {
            this.mapQty.put(key, (Integer)mapQt.get(key));
        }
    }

    private synchronized void update(List<OrderRecord> listQuery) {
        this.list.updatePart(listQuery);
        this.changed();
    }

    private void updateOrderRecord(OrderRecord order) {
        FundAccount fundAcc = this.faccService.getFundAccountNew(order.getExtCashAccntId(), order.getMarketGrp());
        ContractMng query = null;
        if (fundAcc != null) {
            query = this.mapQuery.get(fundAcc);
        }
        if (query != null) {
            query.addQuery(order);
            this.scheduleSpecQuery();
        }
    }

    private void scheduleSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("spec query position failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        LinkedList<OrderRecord> listSrc = new LinkedList<OrderRecord>();
        List fundList = this.faccService.getMarginFundAccountList();
        for (FundAccount fund : fundList) {
            ContractMng query = this.getQuery(fund);
            listSrc.addAll(query.queryDirty());
        }
        this.updateMap(listSrc);
        this.update(listSrc);
    }

    public List<OrderRecord> getList() {
        return this.list.getList();
    }

    public Map<String, List<OrderRecord>> getMapList() {
        return this.mapList;
    }

    public Map<String, Double> getMapAmount() {
        return this.mapAmount;
    }

    public Map<String, Integer> getMapQty() {
        return this.mapQty;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }
}

