/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.marginxt.XtGetBalanceReq;
import cms.tmx.http.query.marginxt.XtGetBalanceResp;
import cms.tmx.http.query.marginxt.XtSofp;
import cms.tmx.http.query.marginxt.api.XtRateServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class RateMng
extends MxModel {
    @Inject
    private XtRateServiceApi rateApi;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private HttpBaseApi httpBase;
    private Set<String> setQuery = new HashSet<String>();
    private ReentrantLock lock = new ReentrantLock();

    public void addQuery(String extAccntId) {
        this.lock.lock();
        try {
            this.setQuery.add(extAccntId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<XtSofp> queryDirty() {
        this.lock.lock();
        LinkedList<String> listSrc = new LinkedList<String>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        Set<XtSofp> sofp = null;
        for (String extAccntId : listSrc) {
            try {
                sofp = this.queryByPage(extAccntId);
            }
            catch (MException e) {
                this.logger.error("query spec sofp failed", (Throwable)e);
            }
        }
        return sofp;
    }

    public Set<XtSofp> query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId());
    }

    private Set<XtSofp> queryByPage(String extAccntId) throws MException {
        Set<XtSofp> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        XtGetBalanceReq req = new XtGetBalanceReq();
        Page httpDefPage = this.httpBase.getHttpDefPage();
        req.setAccntLevel(Integer.valueOf(AccntLevel.ACCNT_LEVEL_EXT.getValue()));
        req.setCashAccntId(Arrays.asList(extAccntId));
        req.setPageSize(httpDefPage.getPageSize());
        req.setPageNum(1);
        XtGetBalanceResp resp = this.rateApi.getBalanceSheetReq(req);
        list.clear();
        list.addAll(resp.getSofps());
        Page pageResp = resp.getPage();
        int queryTimes = 0;
        int total = 0;
        if (pageResp != null) {
            queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
        }
        while (--queryTimes > 0) {
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(total - queryTimes + 1);
            XtGetBalanceResp res = this.rateApi.getBalanceSheetReq(req);
            list.addAll(res.getSofps());
        }
        for (XtSofp sofp : list) {
            sofp.setInvestorId(this.fundMng.getCcsInvestorId(sofp.getCashAccntId()));
            set.add(sofp);
        }
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

