/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.marginxt.XtGetPledgeSecuritysReq;
import cms.tmx.http.query.marginxt.XtGetPledgeSecuritysResp;
import cms.tmx.http.query.marginxt.XtPledgeSecurity;
import cms.tmx.http.query.marginxt.api.XtPledgeServiceApi;
import cms.tmx.javafx.MxModel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PledgeSecurityMng
extends MxModel {
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private XtPledgeServiceApi pledgeApi;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    private Set<String> setQuery = new HashSet<String>();
    private ReentrantLock lock = new ReentrantLock();

    public void addQuery(String accntId) {
        this.lock.lock();
        try {
            this.setQuery.add(accntId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<XtPledgeSecurity> query(List<String> accntId) throws MException {
        return this.queryByPage(accntId);
    }

    private List<XtPledgeSecurity> queryByPage(List<String> accntId) throws MException {
        LinkedList<XtPledgeSecurity> list = new LinkedList<XtPledgeSecurity>();
        list.addAll(this.queryByPage(accntId, "XSHG"));
        list.addAll(this.queryByPage(accntId, "XSHE"));
        return list;
    }

    private List<XtPledgeSecurity> queryByPage(List<String> accntId, String market) throws MException {
        LinkedList<XtPledgeSecurity> list = new LinkedList<XtPledgeSecurity>();
        try {
            XtGetPledgeSecuritysReq req = new XtGetPledgeSecuritysReq();
            Page httpDefPage = this.httpBase.getHttpDefPage();
            httpDefPage.setPageSize(10000);
            req.setMarket(market);
            req.setAccntId(accntId);
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(1);
            XtGetPledgeSecuritysResp resp = this.pledgeApi.getPledgeList(req);
            list.clear();
            Page pageResp = resp.getPage();
            list.addAll(resp.getPledgeSecurities());
            int queryTimes = 0;
            int total = 0;
            if (pageResp != null) {
                queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
                total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            }
            while (--queryTimes > 0) {
                req.setPageSize(httpDefPage.getPageSize());
                req.setPageNum(total - queryTimes + 1);
                XtGetPledgeSecuritysResp res = this.pledgeApi.getPledgeList(req);
                list.addAll(res.getPledgeSecurities());
            }
        }
        catch (MException e) {
            this.logger.error("\u62c5\u4fdd\u8bc1\u5238\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        return list;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }
}

