/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.marginxt.XtGetPositionsReq;
import cms.tmx.http.query.marginxt.XtGetPositionsResp;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.marginxt.api.XtPositionServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginPositionMng
extends MxModel {
    @Inject
    private XtPositionServiceApi positionApi;
    private FundAccount fund;
    private List<String> secList;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private HttpBaseApi baseApi;

    public Set<XtPosition> query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.secList);
    }

    private Set<XtPosition> queryByPage(List<String> secList) throws MException {
        Set<XtPosition> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        if (secList.isEmpty()) {
            return set;
        }
        XtGetPositionsReq req = new XtGetPositionsReq();
        req.setAccntType(1);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
        req.setMarketGroup("");
        req.setAccntId(secList);
        req.setEndDate("");
        req.setBeginDate("");
        req.setIncludeZero(Boolean.valueOf(true));
        req.setAccntId(secList);
        Page httpDefPage = this.baseApi.getHttpDefPage();
        req.setPageSize(httpDefPage.getPageSize());
        req.setPageNum(1);
        XtGetPositionsResp resp = this.positionApi.getXtPositionList(req);
        list.clear();
        Page pageResp = resp.getPage();
        list.addAll(resp.getPosData());
        int queryTimes = 0;
        int total = 0;
        if (pageResp != null) {
            queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
        }
        while (--queryTimes > 0) {
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(total - queryTimes + 1);
            XtGetPositionsResp res = this.positionApi.getXtPositionList(req);
            list.addAll(res.getPosData());
        }
        set.addAll(list);
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public List<String> getSecList() {
        return this.secList;
    }

    public void setSecList(List<String> secList) {
        this.secList = secList;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

