/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.marginxt.XtGetOrdersReq;
import cms.tmx.http.query.marginxt.XtGetOrdersResp;
import cms.tmx.http.query.marginxt.XtSingleOrder;
import cms.tmx.http.query.marginxt.api.XtOrderServiceApi;
import cms.tmx.javafx.MxModel;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginOrderMng
extends MxModel {
    @Inject
    private XtOrderServiceApi orderApi;
    @Inject
    private HttpBaseApi httpBase;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();

    public Set<XtSingleOrder> query(boolean isUnfinished) throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId(), isUnfinished);
    }

    private Set<XtSingleOrder> queryByPage(String extAccntId, boolean isUnfinished) throws MException {
        Set<XtSingleOrder> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        try {
            XtGetOrdersReq req = new XtGetOrdersReq();
            Page httpDefPage = this.httpBase.getXtHttpDefPage();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String date = LocalDate.now().format(formatter);
            req.setBeginDate(date);
            req.setEndDate(date);
            req.setCanCancelFlag(isUnfinished ? 1 : 0);
            req.setCapitalAccountIds(Arrays.asList(extAccntId));
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(1);
            XtGetOrdersResp resp = this.orderApi.getOrderList(req);
            list.clear();
            Page pageResp = resp.getPage();
            list.addAll(resp.getOrder());
            int queryTimes = 0;
            int total = 0;
            if (pageResp != null) {
                queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
                total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            }
            while (--queryTimes > 0) {
                req.setPageSize(httpDefPage.getPageSize());
                req.setPageNum(total - queryTimes + 1);
                XtGetOrdersResp res = this.orderApi.getOrderList(req);
                list.addAll(res.getOrder());
            }
        }
        catch (MException e) {
            this.logger.error("\u8baf\u6295\u878d\u8d44\u878d\u5238\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        set.addAll(list);
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

