/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.marginxt.XtExecution;
import cms.tmx.http.query.marginxt.XtGetExecutionsReq;
import cms.tmx.http.query.marginxt.XtGetExecutionsResp;
import cms.tmx.http.query.marginxt.api.XtExecutionServiceApi;
import cms.tmx.javafx.MxModel;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginDealMng
extends MxModel {
    @Inject
    private XtExecutionServiceApi dealApi;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private HttpBaseApi httpBase;

    public Set<XtExecution> query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId());
    }

    private Set<XtExecution> queryByPage(String extAccntId) throws MException {
        Set<XtExecution> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        XtGetExecutionsReq req = new XtGetExecutionsReq();
        Page httpDefPage = this.httpBase.getXtHttpDefPage();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = LocalDate.now().format(formatter);
        req.setBeginDate(date);
        req.setEndDate(date);
        req.setCapitalAccountIds(Arrays.asList(extAccntId));
        req.setPageSize(httpDefPage.getPageSize());
        req.setPageNum(1);
        XtGetExecutionsResp resp = this.dealApi.getDeals(req);
        list.clear();
        Page pageResp = resp.getPage();
        list.addAll(resp.getExecution());
        int queryTimes = 0;
        int total = 0;
        if (pageResp != null) {
            queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
        }
        while (--queryTimes > 0) {
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(total - queryTimes + 1);
            XtGetExecutionsResp res = this.dealApi.getDeals(req);
            list.addAll(res.getExecution());
        }
        set.addAll(list);
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

