/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.CreditDirect;
import cms.tmx.http.query.LifeStatus;
import cms.tmx.http.query.marginxt.XtGetCreditContractReq;
import cms.tmx.http.query.marginxt.XtGetCreditContractResp;
import cms.tmx.http.query.marginxt.XtOrderRecord;
import cms.tmx.http.query.marginxt.api.XtContractServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ContractMng
extends MxModel {
    @Inject
    private XtContractServiceApi contractApi;
    private FundAccount fund;
    private List<String> secList;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private HttpBaseApi httpBase;
    private Set<XtOrderRecord> setQuery = new HashSet<XtOrderRecord>();
    private ReentrantLock lock = new ReentrantLock();

    public void addQuery(XtOrderRecord order) {
        this.lock.lock();
        try {
            this.setQuery.add(order);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<XtOrderRecord> queryDirty() {
        this.lock.lock();
        LinkedList<XtOrderRecord> listSrc = new LinkedList<XtOrderRecord>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        LinkedList<XtOrderRecord> listResults = new LinkedList<XtOrderRecord>();
        for (XtOrderRecord or : listSrc) {
            try {
                Set<XtOrderRecord> set = this.queryByPage(or.getExtCashAccntId(), Arrays.asList(or.getExtSecAccntId()), or.getSecId(), or.getMarket());
                if (set == null) continue;
                listResults.addAll(set);
            }
            catch (MException e) {
                this.logger.error("query spec orderRecord failed", (Throwable)e);
            }
        }
        return listResults;
    }

    public Set<XtOrderRecord> query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId(), this.secList, "", "");
    }

    private Set<XtOrderRecord> queryByPage(String extAccntId, List<String> secAccntId, String secId, String market) throws MException {
        Set<XtOrderRecord> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        XtGetCreditContractReq req = new XtGetCreditContractReq();
        Page httpDefPage = this.httpBase.getHttpDefPage();
        if (StringUtils.isEmpty((String)extAccntId)) {
            return set;
        }
        req.setCashAccntId(Arrays.asList(extAccntId));
        req.setSecAccntId(secAccntId);
        req.setMarket(market);
        req.setSecurityId(secId);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
        req.setPageSize(httpDefPage.getPageSize());
        req.setPageNum(1);
        XtGetCreditContractResp resp = this.contractApi.getContractList(req);
        list.clear();
        Page pageResp = resp.getPage();
        list.addAll(resp.getCreditContracts());
        int queryTimes = 0;
        int total = 0;
        if (pageResp != null) {
            queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
            total = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)req.getPageSize());
        }
        while (--queryTimes > 0) {
            req.setPageSize(httpDefPage.getPageSize());
            req.setPageNum(total - queryTimes + 1);
            XtGetCreditContractResp res = this.contractApi.getContractList(req);
            list.addAll(res.getCreditContracts());
        }
        for (XtOrderRecord or : list) {
            if (CreditDirect.CREDIT_DIRECT_STK.getCode().equals(or.getCreditDirect())) {
                or.setFundRepayAmount(0.0);
                or.setFundRemainAmount(0.0);
            } else if (CreditDirect.CREDIT_DIRECT_CASH.getCode().equals(or.getCreditDirect())) {
                or.setStockRepayQty(0.0);
                or.setStockRemainQty(0.0);
            }
            or.setCreditDirect(CreditDirect.getDesc((String)or.getCreditDirect()));
            or.setLifeStatus(LifeStatus.getDesc((String)or.getLifeStatus()));
            or.setExtraFields();
            set.add(or);
        }
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public List<String> getSecList() {
        return this.secList;
    }

    public void setSecList(List<String> secList) {
        this.secList = secList;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

