/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.query.Sofp;
import cms.tmx.http.statement.api.StatementServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class RateMng
extends MxModel {
    @Inject
    private StatementServiceApi balanceSheetApi;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    private Set<String> setQuery = new HashSet<String>();
    private ReentrantLock lock = new ReentrantLock();

    public void addQuery(String extAccntId) {
        this.lock.lock();
        try {
            this.setQuery.add(extAccntId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Sofp queryDirty() {
        this.lock.lock();
        LinkedList<String> listSrc = new LinkedList<String>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        Sofp sofp = null;
        for (String extAccntId : listSrc) {
            try {
                sofp = this.queryByPage(extAccntId);
            }
            catch (MException e) {
                this.logger.error("query spec sofp failed", (Throwable)e);
            }
        }
        return sofp;
    }

    public Sofp query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId());
    }

    private Sofp queryByPage(String extAccntId) throws MException {
        Sofp sofp = this.balanceSheetApi.GetBalanceSheetReq(extAccntId, "CCS");
        if (sofp != null) {
            sofp.setInvestorId(this.fundMng.getCcsInvestorId(sofp.getCashAccntId()));
        }
        return sofp;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

