/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginPositionMng
extends MxModel {
    @Inject
    private PositionServiceApi positionApi;
    private FundAccount fund;
    private List<String> secList;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private HttpBaseApi baseApi;

    public Set<Position> query() throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.secList);
    }

    private Set<Position> queryByPage(List<String> secList) throws MException {
        Set<Position> set = Collections.synchronizedSet(new HashSet());
        LinkedList list = new LinkedList();
        if (secList.isEmpty()) {
            return set;
        }
        GetPositionsReq req = new GetPositionsReq();
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
        Page httpDefPage = this.baseApi.getHttpDefPage();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("CCS");
        req.setAccntId(secList);
        boolean flag = false;
        do {
            req.setPage(httpDefPage);
            GetExtPositionsResp resp = this.positionApi.getExtPositionList(req);
            list.addAll(resp.getRealPosition());
            flag = resp.getPage().isLast();
            if (flag) continue;
            httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
        } while (!flag);
        set.addAll(list);
        return set;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public List<String> getSecList() {
        return this.secList;
    }

    public void setSecList(List<String> secList) {
        this.secList = secList;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

