/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.mng;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.query.GetOrdersReq;
import cms.tmx.http.query.GetOrdersResp;
import cms.tmx.javafx.MxModel;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginOrderMng
extends MxModel {
    @Inject
    private OrderServiceApi orderApi;
    @Inject
    private HttpBaseApi httpBase;
    private FundAccount fund;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();

    public List<SingleOrder> query(boolean isUnfinished) throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.fund.getNewCashAccntId(), isUnfinished);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SingleOrder> queryByPage(String extAccntId, boolean isUnfinished) throws MException {
        LinkedList<SingleOrder> list = new LinkedList<SingleOrder>();
        try {
            GetOrdersReq req = new GetOrdersReq();
            Page httpDefPage = this.httpBase.getHttpDefPage();
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarketGrp("CCS");
            req.setApplId("750");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String date = LocalDate.now().format(formatter);
            req.setBeginDate(date);
            req.setEndDate(date);
            req.setCanCancelFlag(isUnfinished ? 1 : 0);
            req.setExtCashAccntId(Arrays.asList(extAccntId));
            boolean flag = false;
            do {
                req.setPage(httpDefPage);
                GetOrdersResp resp = this.orderApi.getOrderList(req);
                if (resp == null || resp.getOrder() == null) return list;
                list.addAll(resp.getOrder());
                boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
                if (!flag) continue;
                httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
            } while (flag);
            return list;
        }
        catch (MException e) {
            this.logger.error("\u878d\u8d44\u878d\u5238\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
        }
        return list;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

