/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.TradeRecord;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ITradeRecordHisService;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class TradeRecordHisQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private CheckComboBox<MxNode> ccmbType;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbType;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    private IAccountService accntService;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private IBaseApi iba;
    @Inject
    private MxAlert alert;
    private HisQueryPage<TradeRecord> pageCcs = new HisQueryPage();
    @FXML
    private TableView<TradeRecord> tableTradeRecord;
    @FXML
    private TableColumn<TradeRecord, String> colRecordId;
    @FXML
    private TableColumn<TradeRecord, String> colRecordDate;
    @FXML
    private TableColumn<TradeRecord, String> colRecordTime;
    @FXML
    private TableColumn<TradeRecord, String> colExtAccntId;
    @FXML
    private TableColumn<TradeRecord, String> colExtSecAccntId;
    @FXML
    private TableColumn<TradeRecord, MxNode> colTradeType;
    @FXML
    private TableColumn<TradeRecord, String> colSecId;
    @FXML
    private TableColumn<TradeRecord, String> colSecName;
    @FXML
    private TableColumn<TradeRecord, String> colComments;
    @FXML
    private TableColumn<TradeRecord, String> colBeginSecQty;
    @FXML
    private TableColumn<TradeRecord, String> colSecOccurQty;
    @FXML
    private TableColumn<TradeRecord, String> colSecBalance;
    @FXML
    private TableColumn<TradeRecord, String> colBeginAmt;
    @FXML
    private TableColumn<TradeRecord, String> colOccurAmt;
    @FXML
    private TableColumn<TradeRecord, String> colBalance;
    @FXML
    private TableColumn<TradeRecord, String> colAvail;
    @FXML
    private TableColumn<TradeRecord, String> colAdvisable;
    @FXML
    private TableColumn<TradeRecord, Number> colPrice;
    @FXML
    private TableColumn<TradeRecord, Number> colQty;
    @FXML
    private TableColumn<TradeRecord, Number> colAmount;
    @FXML
    private TableColumn<TradeRecord, String> colExecId;
    @FXML
    private TableColumn<TradeRecord, String> colIndex;
    private final String ALL_SELECT_RAW = "0";
    @Inject
    private ITradeRecordHisService tradeRecordService;
    private static final Logger logger = LogManager.getLogger(TradeRecordHisQueryPart.class);
    private boolean changeExtAcc = false;
    private StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };
    boolean flag;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @FXML
    private void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.query();
        this.focusRefresh(this.tableTradeRecord);
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxType();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)listAcc);
            for (Account acc : listAcc) {
                if (acc.isExternalAsset()) continue;
                this.ccmbAccnt.getItems().add((Object)acc);
            }
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                logger.error("\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u8d26\u6237", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAcc.add(account.getInvestorId());
            }
            String accStr = listAcc.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxType() {
        MxNode tradeNode = MxNodeFactory.create((String)"trade_type", (String)"1");
        List collect = tradeNode.getNodes().stream().sorted((o1, o2) -> {
            if (Integer.parseInt(o1.getRaw()) > Integer.parseInt(o2.getRaw())) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList());
        this.ccmbType.getItems().setAll(collect);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbType);
        checkComboBoxModel.init();
        this.ccmbType.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbType.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (MxNode account : checkedItems) {
                if ("0".equals(account.getRaw())) continue;
                listAcc.add(account.getValue());
            }
            String accStr = listAcc.toString();
            this.lbType.setText(accStr.substring(1, accStr.length() - 1));
            this.lbType.setTooltip(new Tooltip(this.lbType.getText()));
        });
        this.ccmbType.getCheckModel().checkAll();
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        this.changeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    private void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.createNew((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.parseInt(o1.getRaw()) - Integer.parseInt(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        if (this.changeExtAcc) {
            this.changeExtAcc = false;
            ObservableList listAcc = FxUtils.newList();
            LinkedList<Integer> tradeTypeList = new LinkedList<Integer>();
            ObservableList accList = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList typeList = this.ccmbType.getCheckModel().getCheckedItems();
            if (accList.size() > 0) {
                this.fundAccntService.getAllFundAccountList().forEach(arg_0 -> this.lambda$11(orderPage, (List)listAcc, arg_0));
            }
            orderPage.setExtAccntIdList((List)listAcc);
            for (MxNode type : typeList) {
                if ("0".equals(type.getRaw())) continue;
                tradeTypeList.add(Integer.parseInt(type.getRaw()));
            }
            orderPage.setTradeTypeList(tradeTypeList);
            if (listAcc.isEmpty()) {
                return false;
            }
        }
        return !orderPage.getExtAccntIdList().isEmpty();
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> table) {
        table.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> table.refresh());
            }
        });
    }

    private void ccsQuery() {
        if (!this.rebuildPagi(this.pageCcs)) {
            this.ccsReset();
            return;
        }
        try {
            this.tradeRecordService.query(this.pageCcs);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u67e5\u8be2\u8d44\u5238\u6d41\u6c34", e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.flag = true;
            this.tableTradeRecord.scrollToColumnIndex(0);
        } else if (this.flag) {
            this.tableTradeRecord.scrollToColumnIndex(0);
            this.flag = false;
        }
        this.tableTradeRecord.scrollTo(0);
    }

    private void createTable() {
        this.colRecordId.setCellValueFactory(data -> ((TradeRecord)data.getValue()).recordIdProperty());
        this.reactMap.put(this.colRecordId.getId(), "RecordId");
        this.colRecordDate.setCellValueFactory(data -> ((TradeRecord)data.getValue()).recordDateProperty());
        this.reactMap.put(this.colRecordDate.getId(), "RecordDate");
        this.colRecordTime.setCellValueFactory(data -> ((TradeRecord)data.getValue()).recordTimeProperty());
        this.reactMap.put(this.colRecordTime.getId(), "RecordTime");
        this.colExtAccntId.setCellValueFactory(data -> ((TradeRecord)data.getValue()).investorIdProperty());
        this.reactMap.put(this.colExtAccntId.getId(), "InvestorId");
        this.colExtSecAccntId.setCellValueFactory(data -> ((TradeRecord)data.getValue()).inverstorSecIdProperty());
        this.reactMap.put(this.colExtSecAccntId.getId(), "InverstorSecId");
        this.colTradeType.setCellValueFactory(data -> ((TradeRecord)data.getValue()).tradeTypeProperty());
        this.reactMap.put(this.colTradeType.getId(), "ExTradeType");
        this.colSecId.setCellValueFactory(data -> ((TradeRecord)data.getValue()).getInstrument().secIdProperty());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.colSecName.setCellValueFactory(data -> ((TradeRecord)data.getValue()).getInstrument().symbolProperty());
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.colComments.setCellValueFactory(data -> ((TradeRecord)data.getValue()).commentsProperty());
        this.reactMap.put(this.colComments.getId(), "Comments");
        this.colBeginSecQty.setCellValueFactory(data -> ((TradeRecord)data.getValue()).beginSecQtyProperty());
        this.reactMap.put(this.colBeginSecQty.getId(), "BeginSecQty");
        this.colSecOccurQty.setCellValueFactory(data -> ((TradeRecord)data.getValue()).secOccurQtyProperty());
        this.reactMap.put(this.colSecOccurQty.getId(), "SecOccurQty");
        this.colSecBalance.setCellValueFactory(data -> ((TradeRecord)data.getValue()).secBalanceProperty());
        this.reactMap.put(this.colSecBalance.getId(), "SecBalance");
        this.colBeginAmt.setCellValueFactory(data -> ((TradeRecord)data.getValue()).beginAmtProperty());
        this.reactMap.put(this.colBeginAmt.getId(), "BeginAmt");
        this.colOccurAmt.setCellValueFactory(data -> ((TradeRecord)data.getValue()).occurAmtProperty());
        this.reactMap.put(this.colOccurAmt.getId(), "OccurAmt");
        this.colBalance.setCellValueFactory(data -> ((TradeRecord)data.getValue()).balanceProperty());
        this.reactMap.put(this.colBalance.getId(), "Balance");
        this.colAvail.setCellValueFactory(data -> ((TradeRecord)data.getValue()).availProperty());
        this.reactMap.put(this.colAvail.getId(), "Avail");
        this.colAdvisable.setCellValueFactory(data -> ((TradeRecord)data.getValue()).advisableProperty());
        this.reactMap.put(this.colAdvisable.getId(), "Advisable");
        this.colPrice.setCellValueFactory(data -> ((TradeRecord)data.getValue()).priceProperty());
        this.reactMap.put(this.colPrice.getId(), "Price");
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colQty.setCellValueFactory(data -> ((TradeRecord)data.getValue()).qtyProperty());
        this.reactMap.put(this.colQty.getId(), "Qty");
        this.colAmount.setCellValueFactory(data -> ((TradeRecord)data.getValue()).amountProperty());
        this.reactMap.put(this.colAmount.getId(), "Amount");
        this.colAmount.setCellFactory(p -> new PriceCell());
        this.colExecId.setCellValueFactory(data -> ((TradeRecord)data.getValue()).execIdProperty());
        this.reactMap.put(this.colExecId.getId(), "ExecId");
        TableUtils.isAuto(this.colIndex);
        this.colIndex.setSortable(false);
        this.tableTradeRecord.setItems(this.pageCcs.getDataList());
        this.tableTradeRecord.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableTradeRecord);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithTwoHead(this.tableTradeRecord, (int)0, (int)0);
    }

    @FXML
    private void refresh() {
        this.ccsQuery();
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u8d44\u5238\u6d41\u6c34\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<TradeRecord> page = this.tradeRecordService.getAllCcsData(this.pageCcs);
                    ExcelUtils.writeHisTwoHeadExcel(this.tableTradeRecord, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$11(HisQueryPage hisQueryPage, List list, FundAccount item) {
        String marketGrp = hisQueryPage.getMarketGrp();
        if (this.lbAccnt.getText().contains(item.getInvestId()) && marketGrp.equals(item.getMarketGrp())) {
            list.add(item.getExtAccntId());
        }
    }

    private class PriceCell
    extends DoubleTableCell<TradeRecord> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

