/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.Product;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.SecuritySummary;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ISecuritySummaryHisService;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecuritySummaryHisQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private IBaseApi iba;
    @Inject
    private MxAlert alert;
    private HisQueryPage<SecuritySummary> pageCcs = new HisQueryPage();
    @FXML
    private TableView<SecuritySummary> tableSecuritySummary;
    @FXML
    private TableColumn<SecuritySummary, String> colIndex;
    @FXML
    private TableColumn<SecuritySummary, String> colSecId;
    @FXML
    private TableColumn<SecuritySummary, String> colSecName;
    @FXML
    private TableColumn<SecuritySummary, String> colExtAccntId;
    @FXML
    private TableColumn<SecuritySummary, String> colPortfolio;
    @FXML
    private TableColumn<SecuritySummary, Number> colDividendVolume;
    @FXML
    private TableColumn<SecuritySummary, Number> colBuyVolume;
    @FXML
    private TableColumn<SecuritySummary, Number> colBuyAmt;
    @FXML
    private TableColumn<SecuritySummary, Number> colSellVolume;
    @FXML
    private TableColumn<SecuritySummary, Number> colSellAmt;
    @FXML
    private TableColumn<SecuritySummary, Number> colDividendAmt;
    @FXML
    private TableColumn<SecuritySummary, Number> colProfit;
    @Inject
    private ISecuritySummaryHisService securitySummaryService;
    private static final Logger logger = LogManager.getLogger(SecuritySummaryHisQueryPart.class);
    private boolean changeExtAcc = false;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @Inject
    private ProductMngServiceImpl productMng;
    private List<Product> productList;
    private List<Portfolio> portfList;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.query();
        this.focusRefresh(this.tableSecuritySummary);
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldEnd = LocalDate.now().minusDays(1L);
        this.endDateText.setValue((Object)ldEnd);
        LocalDate ldBegin = ldEnd.minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        MxNode node = MxNodeFactory.create((String)"query_dimension_clearrecord", (String)"2");
        this.btnDimension.setItems(node.getNodes());
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxProduct();
        this.initCheckBoxPort();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
    }

    private void initCheckBoxProduct() {
        try {
            this.productList = this.productMng.getProducts(this.iba.getPartyId());
        }
        catch (MException e) {
            Platform.runLater(() -> {
                logger.error("\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u4ea7\u54c1", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
    }

    private void initCheckBoxPort() {
        this.portfList = this.subAccMng.getPortfolios();
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.changeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.createNew((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.parseInt(o1.getRaw()) - Integer.parseInt(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (this.changeExtAcc) {
            this.changeExtAcc = false;
            if ("3".equals(dimension)) {
                ObservableList productIdList = FxUtils.newList();
                for (Product product : this.productList) {
                    if (product.getId().isEmpty()) continue;
                    productIdList.add(product.getId());
                }
                orderPage.setProductIdList((List)productIdList);
                if (productIdList.isEmpty()) {
                    return false;
                }
            } else {
                ObservableList portfolioIdList = FxUtils.newList();
                for (Portfolio portfolio : this.portfList) {
                    if (portfolio.getId().isEmpty()) continue;
                    portfolioIdList.add(portfolio.getId());
                }
                orderPage.setPortfolioIdList((List)portfolioIdList);
                if (portfolioIdList.isEmpty()) {
                    return false;
                }
            }
        }
        return !("3".equals(dimension) ? orderPage.getProductIdList().isEmpty() : orderPage.getPortfolioIdList().isEmpty());
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> table) {
        table.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> table.refresh());
            }
        });
    }

    private void ccsQuery() {
        if (!this.rebuildPagi(this.pageCcs)) {
            this.ccsReset();
            return;
        }
        try {
            this.securitySummaryService.query(this.pageCcs);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u67e5\u8be2\u80a1\u7968\u660e\u7ec6\u62a5\u8868", e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        if (this.tableSecuritySummary.getItems() != null && this.tableSecuritySummary.getItems().size() == 0) {
            this.tableSecuritySummary.scrollToColumnIndex(0);
        }
        this.tableSecuritySummary.scrollTo(0);
    }

    private void createTable() {
        this.colSecId.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).getInstrument().symbolProperty());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.colExtAccntId.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).investorIdProperty());
        this.colPortfolio.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).portfolioProperty());
        this.colDividendVolume.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).dividendVolumeProperty());
        this.colDividendVolume.setCellFactory(p -> new NumberTableCell());
        this.colDividendAmt.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).dividendAmtProperty());
        this.colDividendAmt.setCellFactory(p -> new DoubleTableCell());
        this.colBuyVolume.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).buyVolumeProperty());
        this.colBuyVolume.setCellFactory(p -> new NumberTableCell());
        this.colBuyAmt.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).buyAmtProperty());
        this.colBuyAmt.setCellFactory(p -> new DoubleTableCell());
        this.colSellVolume.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).sellVolumeProperty());
        this.colSellVolume.setCellFactory(p -> new NumberTableCell());
        this.colSellAmt.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).sellAmtProperty());
        this.colSellAmt.setCellFactory(p -> new DoubleTableCell());
        this.colProfit.setCellValueFactory(data -> ((SecuritySummary)data.getValue()).profitProperty());
        this.colProfit.setCellFactory(p -> new DoubleTableCell());
        this.reactMap.put(this.colExtAccntId.getId(), "InvestorId");
        this.reactMap.put(this.colPortfolio.getId(), "Portfolio");
        this.reactMap.put(this.colDividendVolume.getId(), "DividendVolume");
        this.reactMap.put(this.colDividendAmt.getId(), "DividendAmt");
        this.reactMap.put(this.colBuyVolume.getId(), "BuyVolume");
        this.reactMap.put(this.colBuyAmt.getId(), "BuyAmt");
        this.reactMap.put(this.colSellVolume.getId(), "SellVolume");
        this.reactMap.put(this.colSellAmt.getId(), "SellAmt");
        this.reactMap.put(this.colProfit.getId(), "Profit");
        TableUtils.isAuto(this.colIndex);
        this.colIndex.setSortable(false);
        this.tableSecuritySummary.setItems(this.pageCcs.getDataList());
        this.tableSecuritySummary.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableSecuritySummary);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableSecuritySummary);
    }

    @FXML
    private void refresh() {
        this.ccsQuery();
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u80a1\u7968\u660e\u7ec6\u62a5\u8868");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<SecuritySummary> page = this.securitySummaryService.getAllCcsData(this.pageCcs);
                    ExcelUtils.writeExcel(this.tableSecuritySummary, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }
}

