/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.history.ICcsPositionHisService;
import cms.tmx.query.history.ICtpPositionHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PositionHisQueryPart
extends HisQueryPart<CcsPosition, CtpPosition, Object> {
    private static final Logger logger = LogManager.getLogger(PositionHisQueryPart.class);
    @FXML
    private TableView<CcsPosition> ccsTablePosition;
    @FXML
    private TableColumn<CcsPosition, String> ccsColSecId;
    @FXML
    private TableColumn<CcsPosition, String> ccsColSecName;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColTotalVol;
    @FXML
    private TableColumn<CcsPosition, String> ccsColTotalStock;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCanVol;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColFrozenVol;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColImpawnIn;
    @FXML
    private TableColumn<CcsPosition, String> ccsColUnit;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCost;
    @FXML
    private TableColumn<CcsPosition, Number> colCostAmt;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColTotalProfit;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColProfit;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColNowPrice;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColPercent;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColBuyCost;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColTodayRealizedPl;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColYield;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCarryYield;
    @FXML
    private TableColumn<CcsPosition, MxNode> ccsColMarket;
    @FXML
    private TableColumn<CcsPosition, String> ccsColAcc;
    @FXML
    private TableColumn<CcsPosition, String> counter;
    @FXML
    private TableColumn<CcsPosition, String> ccsColAccName;
    @FXML
    private TableColumn<CcsPosition, String> ccsColSecAcc;
    @FXML
    private TableColumn<CcsPosition, String> ccsColDate;
    @FXML
    private TableColumn<CcsPosition, String> ccsColPort;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCapital;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColNet;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColPreCapital;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColBuyInQty;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColSellOutQty;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColBuyInAmt;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColSellOutAmt;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColPreTotalQty;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCurDividend;
    @FXML
    private TableColumn<CcsPosition, String> ccsColAccntGrpName;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCarryBuyCostAmt;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCarryBuyCost;
    @FXML
    private TableColumn<CcsPosition, Number> ccsColCarryRealizedPl;
    @FXML
    private TableColumn<CcsPosition, String> ccsColPosisGrpName;
    @FXML
    private TableView<CtpPosition> ctpTablePosition;
    @FXML
    private TableColumn<CtpPosition, String> ctpColSecId;
    @FXML
    private TableColumn<CtpPosition, String> ctpColSecName;
    @FXML
    private TableColumn<CtpPosition, MxNode> colCtpMarket;
    @FXML
    private TableColumn<CtpPosition, MxNode> ctpColPosiDire;
    @FXML
    private TableColumn<CtpPosition, MxNode> ctpColHedgeFlag;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColTdPosi;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColYdPosi;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColPosi;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColPosiProfit;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColCloseProfit;
    @FXML
    private TableColumn<CtpPosition, Number> ctpColUseMargin;
    @FXML
    private TableColumn<CtpPosition, String> ctpColAcc;
    @FXML
    private TableColumn<CtpPosition, String> ctpColAccName;
    @FXML
    private TableColumn<CtpPosition, String> ctpColAccSec;
    @FXML
    private TableColumn<CtpPosition, String> ctpColDate;
    @FXML
    private TableColumn<CcsPosition, String> ccsIndex;
    @FXML
    private TableColumn<CtpPosition, String> ctpIndex;
    @FXML
    private Label labelTotal;
    @FXML
    private Label labelAvail;
    @FXML
    private Label labelCapital;
    @FXML
    private Label labelPreCatital;
    @FXML
    private CheckBox checkBoxClose;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsPositionHisService ccsPositionHisService;
    @Inject
    private ICtpPositionHisService ctpPositionHisService;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;
    private static final int DEFAULT_SECONDS = 5;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ctpExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @Inject
    private IMarketDataMng mktMng;
    private boolean firstQuery;
    private String dateString = "";

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableCtp();
        this.query();
        this.focusRefresh(this.ccsTablePosition);
        this.focusRefresh(this.ctpTablePosition);
        this.scheduledFuture = this.executorService.scheduleWithFixedDelay(() -> this.ccsPositionHisService.queryNewMarketItem((List<CcsPosition>)this.pageCcs.getDataList()), 5L, 5L, TimeUnit.SECONDS);
    }

    @PreDestroy
    private void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    protected <E> void checkPortfolio(TableView<E> tableBase, TableColumn<E, ?> portfolio) {
        String dimension = this.pageCcs.getDimension();
        ObservableList columns = tableBase.getColumns();
        if ("1".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
            if (columns.contains(this.ccsColAccntGrpName)) {
                columns.remove(this.ccsColAccntGrpName);
            }
            if (!columns.contains(this.ccsColAcc)) {
                columns.add(this.ccsColAcc);
            }
            if (!columns.contains(this.ccsColNet)) {
                columns.add(10, this.ccsColNet);
            }
            if (columns.contains(this.ccsColPosisGrpName)) {
                columns.remove(this.ccsColPosisGrpName);
            }
        } else if ("6".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
            if (columns.contains(this.ccsColAcc)) {
                columns.remove(this.ccsColAcc);
            }
            if (columns.contains(this.ccsColSecAcc)) {
                columns.remove(this.ccsColSecAcc);
            }
            if (columns.contains(this.ccsColNet)) {
                columns.remove(this.ccsColNet);
            }
            if (columns.contains(this.ccsColPosisGrpName)) {
                columns.remove(this.ccsColPosisGrpName);
            }
            if (!columns.contains(this.ccsColAccntGrpName)) {
                columns.add(this.ccsColAccntGrpName);
            }
        } else if ("7".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
            if (columns.contains(this.ccsColAcc)) {
                columns.remove(this.ccsColAcc);
            }
            if (columns.contains(this.ccsColSecAcc)) {
                columns.remove(this.ccsColSecAcc);
            }
            if (columns.contains(this.ccsColNet)) {
                columns.remove(this.ccsColNet);
            }
            if (columns.contains(this.ccsColAccntGrpName)) {
                columns.remove(this.ccsColAccntGrpName);
            }
            if (!columns.contains(this.ccsColPosisGrpName)) {
                columns.add(this.ccsColPosisGrpName);
            }
        } else {
            if (columns.contains(this.ccsColAccntGrpName)) {
                columns.remove(this.ccsColAccntGrpName);
            }
            if (columns.contains(this.ccsColPosisGrpName)) {
                columns.remove(this.ccsColPosisGrpName);
            }
            if (!columns.contains(this.ccsColAcc)) {
                columns.add(this.ccsColAcc);
            }
            if (!columns.contains(portfolio)) {
                columns.add(portfolio);
            }
            if (!columns.contains(this.ccsColNet)) {
                columns.add(10, this.ccsColNet);
            }
        }
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTablePosition, this.ccsColPort);
        this.pageCcs.setContainsClose(this.checkBoxClose.isSelected());
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            this.labelTotal.setText(StringUtils.toThousands((Number)0, (int)3));
            this.labelAvail.setText(StringUtils.toThousands((Number)0, (int)3));
            this.labelCapital.setText(StringUtils.toThousands((Number)0, (int)3));
            this.labelPreCatital.setText(StringUtils.toThousands((Number)0, (int)3));
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.ccsPositionHisService.query((HisQueryPage<CcsPosition>)this.pageCcs);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        if (this.ccsPositionHisService.getCollect() != null) {
            BigDecimal total = BigDecimal.valueOf(this.ccsPositionHisService.getCollect().getSumTotal()).setScale(3, 4);
            BigDecimal avail = BigDecimal.valueOf(this.ccsPositionHisService.getCollect().getSumAvail()).setScale(3, 4);
            BigDecimal capital = BigDecimal.valueOf(this.ccsPositionHisService.getCollect().getSumCapitalization()).setScale(3, 4);
            BigDecimal preCapital = BigDecimal.valueOf(this.ccsPositionHisService.getCollect().getSumPreCapitalization()).setScale(3, 4);
            this.labelTotal.setText(StringUtils.toThousands((Number)total, (int)3));
            this.labelAvail.setText(StringUtils.toThousands((Number)avail, (int)3));
            this.labelCapital.setText(StringUtils.toThousands((Number)capital, (int)3));
            this.labelPreCatital.setText(StringUtils.toThousands((Number)preCapital, (int)3));
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTablePosition.scrollToColumnIndex(0);
        }
        this.ccsTablePosition.scrollTo(0);
        this.ccsTablePosition.sort();
    }

    @Override
    protected void ctpQuery() {
        if (this.isPortDimension() || this.isAssetGrpDimension() || !this.rebuildPagi(this.pageCtp, this.ctpChangeExtAcc) || this.pageCtp.getExtAccntIdList().isEmpty()) {
            this.ctpReset();
            return;
        }
        try {
            this.ctpChangeExtAcc = false;
            this.ctpPositionHisService.query((HisQueryPage<CtpPosition>)this.pageCtp);
        }
        catch (MException e) {
            logger.error("\u671f\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        if (this.pageCtp.getDataList().size() == 0) {
            this.ctpTablePosition.scrollToColumnIndex(0);
        }
        this.ctpTablePosition.scrollTo(0);
        this.ctpTablePosition.sort();
    }

    private void creatTableCcs() {
        this.ccsTablePosition.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secIdProperty());
        this.reactMap.put(this.ccsColSecId.getId(), "SecId");
        this.ccsColSecName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).secNameProperty());
        this.reactMap.put(this.ccsColSecName.getId(), "SecName");
        this.ccsColTotalVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalVolProperty());
        this.reactMap.put(this.ccsColTotalVol.getId(), "TotalVol");
        this.ccsColTotalVol.setCellFactory(cell -> new NumberTableCell());
        this.ccsColTotalStock.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalStockPercentProperty());
        this.reactMap.put(this.ccsColTotalStock.getId(), "TotalStockPercent");
        this.ccsColCanVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).canVolProperty());
        this.reactMap.put(this.ccsColCanVol.getId(), "CanVol");
        this.ccsColCanVol.setCellFactory(cell -> new NumberTableCell());
        this.ccsColFrozenVol.setCellValueFactory(data -> ((CcsPosition)data.getValue()).frozenVolProperty());
        this.reactMap.put(this.ccsColFrozenVol.getId(), "FrozenVol");
        this.ccsColFrozenVol.setCellFactory(cell -> new NumberTableCell());
        this.ccsColImpawnIn.setCellValueFactory(data -> ((CcsPosition)data.getValue()).impawnInProperty());
        this.reactMap.put(this.ccsColImpawnIn.getId(), "ImpawnIn");
        this.ccsColImpawnIn.setCellFactory(cell -> new NumberTableCell());
        this.ccsColUnit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).unitProperty());
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.ccsColCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).costProperty());
        this.reactMap.put(this.ccsColCost.getId(), "Cost");
        this.ccsColCost.setCellFactory(p -> new CostPriceCell());
        this.colCostAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).costAmtProperty());
        this.reactMap.put(this.colCostAmt.getId(), "CostAmt");
        this.colCostAmt.setCellFactory(p -> new CostPriceCell());
        this.ccsColNowPrice.setCellValueFactory(data -> ((CcsPosition)data.getValue()).nowPriceProperty());
        this.reactMap.put(this.ccsColNowPrice.getId(), "NowPrice");
        this.ccsColNowPrice.setCellFactory(p -> new PriceCell());
        this.ccsColPercent.setCellValueFactory(data -> ((CcsPosition)data.getValue()).percentProperty());
        this.ccsColPercent.setCellFactory(data -> new DoubleTableCell());
        this.reactMap.put(this.ccsColPercent.getId(), "Percent");
        this.ccsColBuyCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).buyCostProperty());
        this.reactMap.put(this.ccsColBuyCost.getId(), "BuyCost");
        this.ccsColBuyCost.setCellFactory(data -> new BuyCostCell());
        this.ccsColProfit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).profitProperty());
        this.reactMap.put(this.ccsColProfit.getId(), "Profit");
        this.ccsColProfit.setCellFactory(p -> new PriceCell());
        this.ccsColTotalProfit.setCellValueFactory(data -> ((CcsPosition)data.getValue()).totalProfitProperty());
        this.reactMap.put(this.ccsColTotalProfit.getId(), "TotalProfit");
        this.ccsColTotalProfit.setCellFactory(p -> new PriceCell());
        this.ccsColRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).realizedPlProperty());
        this.reactMap.put(this.ccsColRealizedPl.getId(), "RealizedPl");
        this.ccsColRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.ccsColTodayRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).todayRealizedPlProperty());
        this.reactMap.put(this.ccsColTodayRealizedPl.getId(), "TodayRealizedPl");
        this.ccsColTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.ccsColYield.setCellValueFactory(data -> ((CcsPosition)data.getValue()).yieldProperty());
        this.ccsColYield.setCellFactory(data -> new DoubleTableCell());
        this.reactMap.put(this.ccsColYield.getId(), "Yield");
        this.ccsColNet.setCellValueFactory(data -> ((CcsPosition)data.getValue()).netProperty());
        this.ccsColNet.setCellFactory(data -> new NetCell());
        this.reactMap.put(this.ccsColNet.getId(), "Net");
        this.ccsColCarryYield.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryYieldProperty());
        this.ccsColCarryYield.setCellFactory(data -> new DoubleTableCell());
        this.reactMap.put(this.ccsColCarryYield.getId(), "CarryYield");
        this.ccsColCapital.setCellValueFactory(data -> ((CcsPosition)data.getValue()).capitalizationProperty());
        this.reactMap.put(this.ccsColCapital.getId(), "Capitalization");
        this.ccsColCapital.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColPreCapital.setCellValueFactory(data -> ((CcsPosition)data.getValue()).preCapitalizationProperty());
        this.reactMap.put(this.ccsColPreCapital.getId(), "PreCapitalization");
        this.ccsColPreCapital.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColBuyInQty.setCellValueFactory(data -> ((CcsPosition)data.getValue()).buyInProperty());
        this.reactMap.put(this.ccsColBuyInQty.getId(), "BuyIn");
        this.ccsColBuyInQty.setCellFactory(cell -> new NumberTableCell());
        this.ccsColSellOutQty.setCellValueFactory(data -> ((CcsPosition)data.getValue()).sellOutProperty());
        this.reactMap.put(this.ccsColSellOutQty.getId(), "SellOut");
        this.ccsColSellOutQty.setCellFactory(cell -> new NumberTableCell());
        this.ccsColBuyInAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).buyInAmountProperty());
        this.reactMap.put(this.ccsColBuyInAmt.getId(), "BuyInAmount");
        this.ccsColBuyInAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColSellOutAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).sellOutAmountProperty());
        this.reactMap.put(this.ccsColSellOutAmt.getId(), "SellOutAmount");
        this.ccsColSellOutAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColPreTotalQty.setCellValueFactory(data -> ((CcsPosition)data.getValue()).preTotalQtyProperty());
        this.reactMap.put(this.ccsColPreTotalQty.getId(), "PreTotalQty");
        this.ccsColPreTotalQty.setCellFactory(cell -> new NumberTableCell());
        this.ccsColCurDividend.setCellValueFactory(data -> ((CcsPosition)data.getValue()).curDividendProperty());
        this.reactMap.put(this.ccsColCurDividend.getId(), "CurDividend");
        this.ccsColCurDividend.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCarryBuyCostAmt.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostAmtProperty());
        this.reactMap.put(this.ccsColCarryBuyCostAmt.getId(), "CarryBuyCostAmt");
        this.ccsColCarryBuyCostAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCarryBuyCost.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryBuyCostProperty());
        this.reactMap.put(this.ccsColCarryBuyCost.getId(), "CarryBuyCost");
        this.ccsColCarryBuyCost.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCarryRealizedPl.setCellValueFactory(data -> ((CcsPosition)data.getValue()).carryRealizedPlProperty());
        this.reactMap.put(this.ccsColCarryRealizedPl.getId(), "CarryRealizedPl");
        this.ccsColCarryRealizedPl.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColMarket.setCellValueFactory(data -> ((CcsPosition)data.getValue()).marketProperty());
        this.reactMap.put(this.ccsColMarket.getId(), "ExMarket");
        this.ccsColAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorIdProperty());
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.counter.setCellValueFactory(data -> ((CcsPosition)data.getValue()).counterNameProperty());
        this.reactMap.put(this.counter.getId(), "CounterName");
        this.ccsColAccName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).investorNameProperty());
        this.reactMap.put(this.ccsColAccName.getId(), "InvestorName");
        this.ccsColSecAcc.setCellValueFactory(data -> ((CcsPosition)data.getValue()).inverstorSecIdProperty());
        this.reactMap.put(this.ccsColSecAcc.getId(), "InverstorSecId");
        this.ccsColAccntGrpName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).accntGrpNameProperty());
        this.reactMap.put(this.ccsColAccntGrpName.getId(), "AccntGrpName");
        this.ccsColPosisGrpName.setCellValueFactory(data -> ((CcsPosition)data.getValue()).accntGrpNameProperty());
        this.reactMap.put(this.ccsColPosisGrpName.getId(), "AccntGrpName");
        this.ccsColDate.setCellValueFactory(data -> ((CcsPosition)data.getValue()).tradingDayProperty());
        this.reactMap.put(this.ccsColDate.getId(), "TradingDay");
        this.ccsColPort.setCellValueFactory(data -> {
            SimpleStringProperty portName = new SimpleStringProperty("");
            CcsPosition posi = (CcsPosition)data.getValue();
            if (posi instanceof CcsPortfPosition) {
                CcsPortfPosition port = (CcsPortfPosition)CcsPortfPosition.class.cast(posi);
                portName.set((Object)port.getPortfolioName());
            }
            return portName;
        });
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
        this.ccsTablePosition.setItems(this.pageCcs.getDataList());
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTablePosition);
    }

    @FXML
    public void ctpRefresh() {
        this.ctpQuery();
    }

    @FXML
    public void ctpCopy() {
        TableUtils.copyContentWithHead(this.ctpTablePosition);
    }

    private void creatTableCtp() {
        this.ctpTablePosition.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ctpIndex);
        this.ctpIndex.setSortable(false);
        this.ctpColSecId.setCellValueFactory(data -> ((CtpPosition)data.getValue()).secIdProperty());
        this.reactMap.put(this.ctpColSecId.getId(), "SecId");
        this.ctpColSecName.setCellValueFactory(data -> ((CtpPosition)data.getValue()).secNameProperty());
        this.reactMap.put(this.ctpColSecName.getId(), "SecName");
        this.colCtpMarket.setCellValueFactory(data -> ((CtpPosition)data.getValue()).marketProperty());
        this.reactMap.put(this.colCtpMarket.getId(), "ExMarket");
        this.ctpColPosiDire.setCellValueFactory(data -> ((CtpPosition)data.getValue()).posiDirectionProperty());
        this.reactMap.put(this.ctpColPosiDire.getId(), "ExPosiDirection");
        this.ctpColHedgeFlag.setCellValueFactory(data -> ((CtpPosition)data.getValue()).hedgeFlagProperty());
        this.reactMap.put(this.ctpColHedgeFlag.getId(), "ExHedgeFlag");
        this.ctpColTdPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).tdPositionProperty());
        this.reactMap.put(this.ctpColTdPosi.getId(), "TdPosition");
        this.ctpColYdPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).ydPositionProperty());
        this.reactMap.put(this.ctpColYdPosi.getId(), "YdPosition");
        this.ctpColPosi.setCellValueFactory(data -> ((CtpPosition)data.getValue()).positionProperty());
        this.reactMap.put(this.ctpColPosi.getId(), "Position");
        this.ctpColPosiProfit.setCellValueFactory(data -> ((CtpPosition)data.getValue()).positionProfitProperty());
        this.reactMap.put(this.ctpColPosiProfit.getId(), "PositionProfit");
        this.ctpColCloseProfit.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpPosition)data.getValue()).getCloseProfit()));
        this.reactMap.put(this.ctpColCloseProfit.getId(), "CloseProfit");
        this.ctpColUseMargin.setCellValueFactory(data -> ((CtpPosition)data.getValue()).useMarginProperty());
        this.reactMap.put(this.ctpColUseMargin.getId(), "UseMargin");
        this.ctpColPosiProfit.setCellFactory(cell -> new DoubleTableCell());
        this.ctpColCloseProfit.setCellFactory(cell -> new DoubleTableCell());
        this.ctpColUseMargin.setCellFactory(cell -> new DoubleTableCell());
        this.ctpColDate.setCellValueFactory(data -> ((CtpPosition)data.getValue()).tradingDayProperty());
        this.reactMap.put(this.ctpColDate.getId(), "TradingDay");
        this.ctpColAcc.setCellValueFactory(data -> ((CtpPosition)data.getValue()).investorIdProperty());
        this.reactMap.put(this.ctpColAcc.getId(), "InvestorId");
        this.ctpColAccName.setCellValueFactory(data -> ((CtpPosition)data.getValue()).investorNameProperty());
        this.reactMap.put(this.ctpColAccName.getId(), "InvestorName");
        this.ctpColAccSec.setCellValueFactory(data -> ((CtpPosition)data.getValue()).inverstorSecIdProperty());
        this.reactMap.put(this.ctpColAccSec.getId(), "InverstorSecId");
        this.ctpTablePosition.setItems(this.pageCtp.getDataList());
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6301\u4ed3\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            Date date = new Date();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
            this.dateString = simpleFormat.format(date);
            this.exe.execute(() -> {
                try {
                    LinkedList positions = new LinkedList();
                    HisQueryPage<CcsPosition> page = this.ccsPositionHisService.getAllCcsData((HisQueryPage<CcsPosition>)this.pageCcs);
                    positions.addAll(page.getDataList());
                    if (positions.isEmpty()) {
                        return;
                    }
                    if (!this.firstQuery) {
                        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
                        for (CcsPosition t : positions) {
                            if (!this.dateString.equals(t.getTradingDay())) continue;
                            RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId());
                            if ("SHSC".equals(t.getMarket().getRaw()) || "SZSC".equals(t.getMarket().getRaw())) {
                                item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecId());
                            }
                            if (item == null) continue;
                            listItem.add(item);
                        }
                        Gears gears = new Gears();
                        gears.setBuy(new int[]{0});
                        if (!listItem.isEmpty()) {
                            this.mktMng.queryNewPriceIn5Seconds(listItem, gears);
                        }
                    }
                    for (CcsPosition posi : positions) {
                        if (!this.firstQuery && this.dateString.equals(posi.getTradingDay())) {
                            RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                            if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                                refItem = this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId());
                            }
                            if (refItem == null) {
                                if ("STD_BOND".equals(posi.getSecType())) {
                                    posi.setNowPrice(100.0);
                                    posi.setClosePrice(100.0);
                                }
                            } else {
                                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                                if (marketItem != null) {
                                    if (marketItem.getNowPrice() == 0.0) {
                                        posi.setNowPrice(marketItem.getClosePrice());
                                    } else {
                                        posi.setNowPrice(marketItem.getNowPrice());
                                    }
                                }
                            }
                        }
                        BigDecimal b = new BigDecimal(posi.getCost());
                        double cost = b.setScale(4, 4).doubleValue();
                        if (posi.getNowPrice() == 0.0 || cost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                            posi.setPercent(0.0);
                        } else {
                            double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                            posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
                        }
                        BigDecimal buy = new BigDecimal(posi.getBuyCost());
                        double buyCost = buy.setScale(4, 4).doubleValue();
                        if (posi.getNowPrice() == 0.0 || buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                            posi.setYield(0.0);
                        } else {
                            double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
                            posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
                        }
                        posi.setCarryBuyCost((double)Math.round(posi.getCarryBuyCost() * 100.0) / 100.0);
                    }
                    this.firstQuery = true;
                    ExcelUtils.writeExcel(this.ccsTablePosition, positions, this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                        this.ccsExcel.setDisable(false);
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ctpExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6301\u4ed3\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CtpPosition> page = this.ctpPositionHisService.getAllCtpData((HisQueryPage<CtpPosition>)this.pageCtp);
                    ExcelUtils.writeExcel(this.ctpTablePosition, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private class BuyCostCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 3;

        private BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class CostPriceCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 3;

        private CostPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsPosition posi = (CcsPosition)CcsPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = PositionHisQueryPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                    refItem = PositionHisQueryPart.this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId());
                }
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class NetCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 2;

        private NetCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if ("7".equals(PositionHisQueryPart.this.pageCcs.getDimension()) || "6".equals(PositionHisQueryPart.this.pageCcs.getDimension())) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<CcsPosition> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsPosition posi = (CcsPosition)CcsPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = PositionHisQueryPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                    refItem = PositionHisQueryPart.this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecId());
                    this.scale = refItem != null ? (refItem.getScale() == 0 ? 3 : refItem.getScale()) : 3;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

