/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.Gears;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ICcsPositionNewHisService;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.INewRefMng;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class PositionHisNewQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    protected CheckComboBox<AssetGrp> ccmbPorts;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbPort;
    @FXML
    protected Label lbAccnts;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private GridPane gridPorts;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    private MObjFactory of;
    @Inject
    private IAccountService accntService;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    private ISecAccountService secAccService;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private MxAlert alert;
    @Inject
    private DialogFactory df;
    private HisQueryPage<ObPosition> pageCcs = new HisQueryPage();
    @FXML
    private TableView<ObPosition> ccsTablePosition;
    @FXML
    private TableColumn<ObPosition, String> ccsIndex;
    @FXML
    private TableColumn<ObPosition, String> ccsColSecId;
    @FXML
    private TableColumn<ObPosition, String> ccsColSecName;
    @FXML
    private TableColumn<ObPosition, Number> ccsColTotalVol;
    @FXML
    private TableColumn<ObPosition, String> ccsColTotalStock;
    @FXML
    private TableColumn<ObPosition, Number> ccsColRate;
    @FXML
    private TableColumn<ObPosition, Number> ccsColCanVol;
    @FXML
    private TableColumn<ObPosition, Number> ccsColFrozenVol;
    @FXML
    private TableColumn<ObPosition, String> ccsColUnit;
    @FXML
    private TableColumn<ObPosition, Number> ccsColCost;
    @FXML
    private TableColumn<ObPosition, Number> colCostAmt;
    @FXML
    private TableColumn<ObPosition, Number> ccsColTotalProfit;
    @FXML
    private TableColumn<ObPosition, Number> ccsColProfit;
    @FXML
    private TableColumn<ObPosition, Number> ccsColNowPrice;
    @FXML
    private TableColumn<ObPosition, Number> ccsColPercent;
    @FXML
    private TableColumn<ObPosition, Number> ccsColBuyCost;
    @FXML
    private TableColumn<ObPosition, Number> colBuyCostAmt;
    @FXML
    private TableColumn<ObPosition, Number> ccsColRealizedPl;
    @FXML
    private TableColumn<ObPosition, Number> ccsColTodayRealizedPl;
    @FXML
    private TableColumn<ObPosition, Number> ccsColYield;
    @FXML
    private TableColumn<ObPosition, MxNode> ccsColMarket;
    @FXML
    private TableColumn<ObPosition, String> ccsColType;
    @FXML
    private TableColumn<ObPosition, String> ccsColAcc;
    @FXML
    private TableColumn<ObPosition, String> ccsColSecAcc;
    @FXML
    private TableColumn<ObPosition, String> ccsColDate;
    @FXML
    private TableColumn<ObPosition, String> ccsColPort;
    @FXML
    private TableColumn<ObPosition, Number> ccsColCapital;
    @FXML
    private TableColumn<ObPosition, Number> colCapitalCNY;
    @FXML
    private TableColumn<ObPosition, Number> ccsColNet;
    @FXML
    private TableColumn<ObPosition, Number> ccsColPreTotalQty;
    @FXML
    private TableColumn<ObPosition, Number> ccsColCurDividend;
    @FXML
    private TableColumn<ObPosition, String> ccsColPortGrpName;
    @FXML
    private Label labelTotal;
    @FXML
    private Label labelAvail;
    private double sumSecBalance;
    private double sumCapitalCNY;
    @FXML
    private Label labelCapital;
    @FXML
    private Label labelPreCatital;
    @FXML
    private CheckBox checkBoxClose;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private INewRefMng newRefMng;
    private static final Logger logger = LogManager.getLogger(PositionHisNewQueryPart.class);
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private boolean ccsChangeExtAcc = false;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private MarketDataModel newMktMng;
    private String dateString = "";
    @Inject
    private ICcsPositionNewHisService positionHisService;
    private Map<String, String> reactMap = new HashMap<String, String>();
    private ScheduledFuture<?> scheduledFuture;
    private static final int DEFAULT_SECONDS = 5;
    private List<AssetGrp> listAssets;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    protected StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };

    @FXML
    private void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.query();
        this.focusRefresh(this.ccsTablePosition);
        this.scheduledFuture = this.executorService.scheduleWithFixedDelay(() -> this.positionHisService.queryNewMarketItem((List<ObPosition>)this.pageCcs.getDataList()), 5L, 5L, TimeUnit.SECONDS);
    }

    @PreDestroy
    private void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now();
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        MxNode node = MxNodeFactory.createNew((String)"query_dimension_assetgrp", (String)"1");
        node.removeNode("6");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("1")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else if (now.getRaw().equals("2")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            } else if ("7".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPorts});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        this.initCheckBoxPorts();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)listAcc);
            this.ccmbAccnt.getItems().addAll((Collection)listAcc);
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u8d44\u91d1\u8d26\u53f7" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccId = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccId.add(account.getInvestorId());
            }
            String accStr = listAccId.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfoliosAll();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void initCheckBoxPorts() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            this.ccmbPorts.getItems().add((Object)asset);
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            this.portfolioMng.getPortfoliosByParty(this.iba.getPartyId());
            this.listAssets = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "3".equals(item.getType().getRaw())) {
                    String[] ids = item.getAssetUnitId().split(",");
                    HashSet<String> set = new HashSet<String>();
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String portId = stringArray[n2];
                        set.add(portId);
                        ++n2;
                    }
                    this.positionHisService.getAssetIdMap().put(item.getId(), set);
                    this.listAssets.add((AssetGrp)item);
                }
            });
            this.ccmbPorts.getItems().addAll(this.listAssets);
        }
        catch (MException | Exception e) {
            logger.error("\u521d\u59cb\u5316\u6295\u7ec4\u7ec4" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPorts);
        checkComboBoxModel.init();
        this.ccmbPorts.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPorts.getCheckModel().getCheckedItems();
            ObservableList listAssetId = FxUtils.newList();
            for (AssetGrp item : checkedItems) {
                if (item.getId().isEmpty()) continue;
                listAssetId.add(item.getName());
            }
            String assetStr = listAssetId.toString();
            this.lbAccnts.setText(assetStr.substring(1, assetStr.length() - 1));
            this.lbAccnts.setTooltip(new Tooltip(this.lbAccnts.getText()));
        });
        this.ccmbPorts.getCheckModel().checkAll();
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.ccsChangeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage) throws MException {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (this.ccsChangeExtAcc) {
            this.ccsChangeExtAcc = false;
            HashSet<String> listSecAcc = new HashSet<String>();
            LinkedList<String> listPort = new LinkedList<String>();
            LinkedList<String> list = new LinkedList<String>();
            HashSet<String> portfolioIdSet = new HashSet<String>();
            if (dimension.equals("1")) {
                this.fundApi.getExtAssetFundAccs().forEach(item -> {
                    try {
                        String marketGrp = orderPage.getMarketGrp();
                        if (this.secAccService.getAllSecAccountMap().get(item) != null && this.lbAccnt.getText().contains(item.getInvestId()) && marketGrp.equals(item.getMarketGrp())) {
                            ((List)this.secAccService.getAllSecAccountMap().get(item)).forEach(secAcc -> {
                                if (!StringUtils.isEmpty((String)secAcc.getNewSecAccntId())) {
                                    listSecAcc.add(secAcc.getNewSecAccntId());
                                }
                            });
                        }
                    }
                    catch (MException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                });
                orderPage.setAccountIdList(new LinkedList(listSecAcc));
                if (listSecAcc.isEmpty()) {
                    return false;
                }
            } else if ("2".equals(dimension)) {
                for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                    if (portfolio.getId().isEmpty() || this.subAccMng.getMap(portfolio) == null) continue;
                    for (List<SecAccount> listSec : this.subAccMng.getMap(portfolio).values()) {
                        for (SecAccount secAccount : listSec) {
                            if (!(secAccount instanceof CcsSubSecAccount)) continue;
                            CcsSubSecAccount subSecAccnt = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                            listSecAcc.add(subSecAccnt.getSubSecAccntId());
                        }
                    }
                }
                orderPage.setSubAccntIdList(new ArrayList(listSecAcc));
                if (listSecAcc.isEmpty()) {
                    return false;
                }
            } else if ("7".equals(dimension)) {
                for (AssetGrp asset : this.ccmbPorts.getCheckModel().getCheckedItems()) {
                    if (asset.getId().isEmpty()) continue;
                    list.add(asset.getId());
                    String[] ids = asset.getAssetUnitId().split(",");
                    portfolioIdSet.addAll(Arrays.asList(ids));
                }
                for (String portId : portfolioIdSet) {
                    if (this.subAccMng.getMap(portId) == null) continue;
                    for (List<SecAccount> listSec : this.subAccMng.getMap(portId).values()) {
                        for (SecAccount secAccount : listSec) {
                            if (!(secAccount instanceof CcsSubSecAccount)) continue;
                            CcsSubSecAccount subSecAccnt = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                            listSecAcc.add(subSecAccnt.getSubSecAccntId());
                        }
                    }
                    listPort.add(portId);
                }
                orderPage.setSubAccntIdList(new LinkedList(listSecAcc));
                orderPage.setPortfolioIdList(listPort);
                orderPage.setAssetsGrpIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            }
        }
        return !("1".equals(dimension) ? orderPage.getAccountIdList().isEmpty() : ("2".equals(dimension) ? orderPage.getSubAccntIdList().isEmpty() : "7".equals(dimension) && (orderPage.getAssetsGrpIdList().isEmpty() || orderPage.getSubAccntIdList().isEmpty())));
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTablePosition, this.ccsColPort);
        this.pageCcs.setContainsClose(this.checkBoxClose.isSelected());
        try {
            if (!this.rebuildPagi(this.pageCcs)) {
                this.ccsReset();
                this.labelTotal.setText(StringUtils.toThousands((Number)0, (int)3));
                this.labelCapital.setText(StringUtils.toThousands((Number)0, (int)3));
                return;
            }
            this.ccsChangeExtAcc = false;
            this.positionHisService.query(this.pageCcs);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), e);
                this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage());
            });
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTablePosition.scrollToColumnIndex(0);
        }
        this.ccsTablePosition.scrollTo(0);
        this.ccsTablePosition.sort();
        this.querySum();
    }

    protected <E> void checkPortfolio(TableView<E> tableBase, TableColumn<E, ?> portfolio) {
        String dimension = this.pageCcs.getDimension();
        ObservableList columns = tableBase.getColumns();
        if ("1".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
            if (columns.contains(this.ccsColPortGrpName)) {
                columns.remove(this.ccsColPortGrpName);
            }
            if (!columns.contains(this.ccsColAcc)) {
                columns.add(this.ccsColAcc);
            }
        } else if ("6".equals(dimension)) {
            if (columns.contains(this.ccsColAcc)) {
                columns.remove(this.ccsColAcc);
            }
            if (columns.contains(this.ccsColSecAcc)) {
                columns.remove(this.ccsColSecAcc);
            }
        } else if ("7".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
            if (columns.contains(this.ccsColAcc)) {
                columns.remove(this.ccsColAcc);
            }
            if (columns.contains(this.ccsColSecAcc)) {
                columns.remove(this.ccsColSecAcc);
            }
            if (!columns.contains(this.ccsColPortGrpName)) {
                columns.add(this.ccsColPortGrpName);
            }
        } else {
            if (columns.contains(this.ccsColPortGrpName)) {
                columns.remove(this.ccsColPortGrpName);
            }
            if (!columns.contains(this.ccsColAcc)) {
                columns.add(this.ccsColAcc);
            }
            if (!columns.contains(portfolio)) {
                columns.add(portfolio);
            }
        }
    }

    private void createTable() {
        this.ccsTablePosition.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityIdProperty());
        this.reactMap.put(this.ccsColSecId.getId(), "SecurityId");
        this.ccsColSecName.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityNameProperty());
        this.reactMap.put(this.ccsColSecName.getId(), "SecurityName");
        this.ccsColTotalVol.setCellValueFactory(data -> ((ObPosition)data.getValue()).secBalanceProperty());
        this.reactMap.put(this.ccsColTotalVol.getId(), "SecBalance");
        this.ccsColTotalVol.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColTotalStock.setCellValueFactory(data -> ((ObPosition)data.getValue()).totalStockPercentProperty());
        this.reactMap.put(this.ccsColTotalStock.getId(), "TotalStockPercent");
        this.ccsColRate.setCellValueFactory(data -> ((ObPosition)data.getValue()).rateProperty());
        this.ccsColRate.setCellFactory(d -> new RateTableCell());
        this.reactMap.put(this.ccsColRate.getId(), "Rate");
        this.ccsColCanVol.setCellValueFactory(data -> ((ObPosition)data.getValue()).secAvailProperty());
        this.reactMap.put(this.ccsColCanVol.getId(), "SecAvail");
        this.ccsColCanVol.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColFrozenVol.setCellValueFactory(data -> ((ObPosition)data.getValue()).frozenQtyProperty());
        this.reactMap.put(this.ccsColFrozenVol.getId(), "FrozenQty");
        this.ccsColFrozenVol.setCellFactory(cell -> new NumberTableCell());
        this.ccsColUnit.setCellValueFactory(data -> ((ObPosition)data.getValue()).unitProperty());
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.ccsColCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).costProperty());
        this.reactMap.put(this.ccsColCost.getId(), "Cost");
        this.ccsColCost.setCellFactory(p -> new BuyCostCell());
        this.colCostAmt.setCellValueFactory(data -> ((ObPosition)data.getValue()).holdCostAmtProperty());
        this.reactMap.put(this.colCostAmt.getId(), "HoldCostAmt");
        this.colCostAmt.setCellFactory(p -> new CostPriceCell());
        this.ccsColNowPrice.setCellValueFactory(data -> ((ObPosition)data.getValue()).nowPriceProperty());
        this.reactMap.put(this.ccsColNowPrice.getId(), "NowPrice");
        this.ccsColNowPrice.setCellFactory(p -> new PriceCell());
        this.ccsColPercent.setCellValueFactory(data -> ((ObPosition)data.getValue()).percentProperty());
        this.ccsColPercent.setCellFactory(data -> new DoubleTableCell());
        this.reactMap.put(this.ccsColPercent.getId(), "Percent");
        this.ccsColBuyCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostProperty());
        this.reactMap.put(this.ccsColBuyCost.getId(), "BuyCost");
        this.ccsColBuyCost.setCellFactory(p -> new BuyCostCell());
        this.colBuyCostAmt.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostAmtProperty());
        this.reactMap.put(this.colBuyCostAmt.getId(), "BuyCostAmt");
        this.colBuyCostAmt.setCellFactory(p -> new PriceCell());
        this.ccsColProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).floatPnlProperty());
        this.reactMap.put(this.ccsColProfit.getId(), "FloatPnl");
        this.ccsColProfit.setCellFactory(p -> new PriceCell());
        this.ccsColTotalProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).totalProfitProperty());
        this.reactMap.put(this.ccsColTotalProfit.getId(), "TotalProfit");
        this.ccsColTotalProfit.setCellFactory(p -> new PriceCell());
        this.ccsColRealizedPl.setCellValueFactory(data -> ((ObPosition)data.getValue()).realPnlProperty());
        this.reactMap.put(this.ccsColRealizedPl.getId(), "RealPnl");
        this.ccsColRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.ccsColTodayRealizedPl.setCellValueFactory(data -> ((ObPosition)data.getValue()).todayRealizedPlProperty());
        this.reactMap.put(this.ccsColTodayRealizedPl.getId(), "TodayRealizedPl");
        this.ccsColTodayRealizedPl.setCellFactory(data -> new DoubleTableCell());
        this.ccsColYield.setCellValueFactory(data -> ((ObPosition)data.getValue()).yieldProperty());
        this.ccsColYield.setCellFactory(data -> new DoubleTableCell());
        this.reactMap.put(this.ccsColYield.getId(), "Yield");
        this.ccsColNet.setCellValueFactory(data -> ((ObPosition)data.getValue()).netProperty());
        this.ccsColNet.setCellFactory(data -> new NetCell());
        this.reactMap.put(this.ccsColNet.getId(), "Net");
        this.ccsColCapital.setCellValueFactory(data -> ((ObPosition)data.getValue()).marketValueProperty());
        this.reactMap.put(this.ccsColCapital.getId(), "MarketValue");
        this.ccsColCapital.setCellFactory(cell -> new DoubleTableCell());
        this.colCapitalCNY.setCellValueFactory(data -> ((ObPosition)data.getValue()).capitalCNYProperty());
        this.reactMap.put(this.colCapitalCNY.getId(), "CapitalCNY");
        this.colCapitalCNY.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColPreTotalQty.setCellValueFactory(data -> ((ObPosition)data.getValue()).sodQtyProperty());
        this.reactMap.put(this.ccsColPreTotalQty.getId(), "SodQty");
        this.ccsColPreTotalQty.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCurDividend.setCellValueFactory(data -> ((ObPosition)data.getValue()).cashDividendProperty());
        this.reactMap.put(this.ccsColCurDividend.getId(), "CashDividend");
        this.ccsColCurDividend.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColType.setCellValueFactory(data -> ((ObPosition)data.getValue()).typeProperty());
        this.reactMap.put(this.ccsColType.getId(), "Type");
        this.ccsColMarket.setCellValueFactory(data -> ((ObPosition)data.getValue()).marketProperty());
        this.reactMap.put(this.ccsColMarket.getId(), "ExMarket");
        this.ccsColAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorIdProperty());
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.ccsColSecAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorSecIdProperty());
        this.reactMap.put(this.ccsColSecAcc.getId(), "InvestorSecId");
        this.ccsColPortGrpName.setCellValueFactory(data -> ((ObPosition)data.getValue()).portGrpNameProperty());
        this.reactMap.put(this.ccsColPortGrpName.getId(), "PortGrpName");
        this.ccsColDate.setCellValueFactory(data -> ((ObPosition)data.getValue()).trdDateProperty());
        this.reactMap.put(this.ccsColDate.getId(), "TrdDate");
        this.ccsColPort.setCellValueFactory(data -> ((ObPosition)data.getValue()).portfolioNameProperty());
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
        this.ccsTablePosition.setItems(this.pageCcs.getDataList());
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTablePosition);
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6301\u4ed3\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            Date date = new Date();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
            this.dateString = simpleFormat.format(date);
            this.exe.execute(() -> {
                try {
                    LinkedList positions = new LinkedList();
                    HisQueryPage<ObPosition> page = this.positionHisService.getAllCcsData(this.pageCcs);
                    positions.addAll(page.getDataList());
                    if (positions.isEmpty()) {
                        return;
                    }
                    LinkedList<RefItem> listItem = new LinkedList<RefItem>();
                    LinkedList<RefItem> listItemNew = new LinkedList<RefItem>();
                    for (ObPosition t : positions) {
                        if (this.dateString.compareTo(t.getTrdDate()) > 0) continue;
                        RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId());
                        if ("SHSC".equals(t.getMarket().getRaw()) || "SZSC".equals(t.getMarket().getRaw())) {
                            item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecurityId());
                        } else if ("NEEQ".equals(t.getMarket().getRaw()) && (item = this.newRefMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId())) != null) {
                            listItemNew.add(item);
                            continue;
                        }
                        if (item == null) continue;
                        listItem.add(item);
                    }
                    Gears gears = new Gears();
                    gears.setBuy(new int[]{0});
                    if (!listItem.isEmpty()) {
                        this.mktMng.queryNewPriceIn5Seconds(listItem, gears);
                    }
                    if (!listItemNew.isEmpty()) {
                        this.newMktMng.query(listItemNew);
                    }
                    for (ObPosition po : positions) {
                        if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                            po.setNowPrice(100.0);
                            po.setClosePrice(100.0);
                        }
                        if (this.dateString.compareTo(po.getTrdDate()) <= 0) {
                            double precent;
                            String key;
                            RefItem refItem = this.refMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                            if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                refItem = this.refMng.getItem(String.valueOf(po.getSecType()) + po.getMarket().getRaw(), po.getMarket().getRaw(), po.getSecurityId());
                            } else if ("NEEQ".equals(po.getMarket().getRaw())) {
                                refItem = this.newRefMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                            }
                            if (refItem != null) {
                                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                                if ("NEEQ".equals(po.getMarket().getRaw())) {
                                    marketItem = this.newMktMng.getItem(refItem);
                                }
                                if (marketItem != null) {
                                    if (marketItem.getClosePrice() == 0.0) {
                                        po.setOpenPrice(marketItem.getOpenPrice());
                                    } else {
                                        po.setOpenPrice(marketItem.getClosePrice());
                                    }
                                    if (marketItem.getNowPrice() == 0.0) {
                                        po.setNowPrice(marketItem.getClosePrice());
                                        po.setClosePrice(marketItem.getClosePrice());
                                    } else {
                                        po.setNowPrice(marketItem.getNowPrice());
                                        po.setClosePrice(marketItem.getNowPrice());
                                    }
                                }
                            }
                            double capitalization = QueryUtils.calAmountByMarketAndSecType(po.getMarket().getRaw(), po.getSecType(), po.getSecBalance(), po.getNowPrice());
                            if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                                capitalization = po.getSecBalance() * (double)("XSHG".equals(po.getMarket().getRaw()) ? 1000 : 100);
                            }
                            po.setMarketValue((double)Math.round(capitalization * 1000.0) / 1000.0);
                            po.setCapitalCNY((double)Math.round(po.getMarketValue() * 100.0) / 100.0);
                            if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                po.setCapitalCNY((double)Math.round(po.getMarketValue() * po.getHkRate() * 100.0) / 100.0);
                            }
                            po.updateProfit();
                            if ("1".equals(this.pageCcs.getDimension())) {
                                key = String.valueOf(po.getInvestorId()) + "," + po.getTrdDate();
                                if (this.positionHisService.getAccntMap().get(key) != null && 0.0 != this.positionHisService.getAccntMap().get(key).getNetAsset()) {
                                    precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.positionHisService.getAccntMap().get(key).getNetAsset()) / 100.0;
                                    if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                        precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.positionHisService.getAccntMap().get(key).getNetAsset()) / 100.0;
                                    }
                                    po.setNet(precent);
                                }
                            } else if ("2".equals(this.pageCcs.getDimension())) {
                                key = String.valueOf(po.getPortfolioId()) + "," + po.getTrdDate();
                                if (!StringUtils.isEmpty((String)po.getPortfolioId()) && this.positionHisService.getPortMap().get(key) != null && 0.0 != this.positionHisService.getPortMap().get(key).getNetAsset()) {
                                    precent = (double)Math.round(po.getMarketValue() * 10000.0 / this.positionHisService.getPortMap().get(key).getNetAsset()) / 100.0;
                                    if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                        precent = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / this.positionHisService.getPortMap().get(key).getNetAsset()) / 100.0;
                                    }
                                    po.setNet(precent);
                                }
                            } else if ("7".equals(this.pageCcs.getDimension())) {
                                Set<String> portSet = this.positionHisService.getAssetIdMap().get(po.getAssetGroupId());
                                double netAsset = 0.0;
                                StringBuilder key2 = new StringBuilder();
                                for (String portId : portSet) {
                                    key2 = new StringBuilder(portId).append(",").append(po.getTrdDate());
                                    netAsset += this.positionHisService.getPortMap().get(key2.toString()).getNetAsset().doubleValue();
                                }
                                if (!StringUtils.isEmpty((String)po.getAssetGroupId()) && this.positionHisService.getAssetIdMap().get(po.getAssetGroupId()) != null && this.positionHisService.getAssetIdMap().get(po.getAssetGroupId()).size() > 0 && 0.0 != netAsset) {
                                    double precent2 = (double)Math.round(po.getMarketValue() * 10000.0 / netAsset) / 100.0;
                                    if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                        precent2 = (double)Math.round(po.getMarketValue() * 10000.0 * po.getHkRate() / netAsset) / 100.0;
                                    }
                                    po.setNet(precent2);
                                }
                            }
                        }
                        BigDecimal b = new BigDecimal(po.getCost());
                        double cost = b.setScale(4, 4).doubleValue();
                        if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || cost == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                            po.setPercent(0.0);
                        } else {
                            double percent = (po.getNowPrice() - cost) * 100.0 / cost;
                            po.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
                        }
                        BigDecimal buy = new BigDecimal(po.getBuyCost());
                        double buyCost = buy.setScale(4, 4).doubleValue();
                        if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || buyCost == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                            po.setYield(0.0);
                        } else {
                            double yield = (po.getNowPrice() - buyCost) * 100.0 / buyCost;
                            po.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
                        }
                        BigDecimal open = new BigDecimal(po.getOpenPrice());
                        double openPrice = open.setScale(4, 4).doubleValue();
                        if (po.getSecType().equals("STD_BOND") || po.getNowPrice() == 0.0 || openPrice == 0.0 || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) continue;
                        double rate = (double)Math.round((po.getNowPrice() - openPrice) * 10000.0 / openPrice) / 100.0;
                        po.setRate(rate);
                    }
                    ExcelUtils.writeExcel(this.ccsTablePosition, positions, this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.alert.alert(Alert.AlertType.ERROR, "\u5bfc\u51faEXCEL\u5f02\u5e38" + e.getMessage());
                        this.ccsExcel.setDisable(false);
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private void querySum() {
        try {
            Date date = new Date();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
            this.dateString = simpleFormat.format(date);
            this.exe.execute(() -> {
                try {
                    LinkedList positions = new LinkedList();
                    HisQueryPage<ObPosition> page = this.positionHisService.getAllCcsData(this.pageCcs);
                    positions.addAll(page.getDataList());
                    if (positions.isEmpty()) {
                        Platform.runLater(() -> {
                            this.labelCapital.setText(StringUtils.toThousands((Number)0, (int)3));
                            this.labelTotal.setText(StringUtils.toThousands((Number)0, (int)3));
                        });
                        return;
                    }
                    LinkedList<RefItem> listItem = new LinkedList<RefItem>();
                    LinkedList<RefItem> listItemNew = new LinkedList<RefItem>();
                    for (ObPosition t : positions) {
                        if (this.dateString.compareTo(t.getTrdDate()) > 0) continue;
                        RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId());
                        if ("SHSC".equals(t.getMarket().getRaw()) || "SZSC".equals(t.getMarket().getRaw())) {
                            item = this.refMng.getItem(String.valueOf(t.getSecType()) + t.getMarket().getRaw(), t.getMarket().getRaw(), t.getSecurityId());
                        } else if ("NEEQ".equals(t.getMarket().getRaw()) && (item = this.newRefMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecurityId())) != null) {
                            listItemNew.add(item);
                            continue;
                        }
                        if (item == null) continue;
                        listItem.add(item);
                    }
                    Gears gears = new Gears();
                    gears.setBuy(new int[]{0});
                    if (!listItem.isEmpty()) {
                        this.mktMng.queryNewPriceIn5Seconds(listItem, gears);
                    }
                    if (!listItemNew.isEmpty()) {
                        this.newMktMng.query(listItemNew);
                    }
                    double sumSec = 0.0;
                    double sumCapital = 0.0;
                    for (ObPosition po : positions) {
                        if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                            po.setNowPrice(100.0);
                            po.setClosePrice(100.0);
                        }
                        if (this.dateString.compareTo(po.getTrdDate()) <= 0) {
                            RefItem refItem = this.refMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                            if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                refItem = this.refMng.getItem(String.valueOf(po.getSecType()) + po.getMarket().getRaw(), po.getMarket().getRaw(), po.getSecurityId());
                            } else if ("NEEQ".equals(po.getMarket().getRaw())) {
                                refItem = this.newRefMng.getItem(po.getSecType(), po.getMarket().getRaw(), po.getSecurityId());
                            }
                            if (refItem != null) {
                                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                                if ("NEEQ".equals(po.getMarket().getRaw())) {
                                    marketItem = this.newMktMng.getItem(refItem);
                                }
                                if (marketItem != null) {
                                    if (marketItem.getNowPrice() == 0.0) {
                                        po.setNowPrice(marketItem.getClosePrice());
                                        po.setClosePrice(marketItem.getClosePrice());
                                    } else {
                                        po.setNowPrice(marketItem.getNowPrice());
                                        po.setClosePrice(marketItem.getNowPrice());
                                    }
                                }
                            }
                            double capitalization = QueryUtils.calAmountByMarketAndSecType(po.getMarket().getRaw(), po.getSecType(), po.getSecBalance(), po.getNowPrice());
                            if (po.getSecType().equals("STD_BOND") || po.getSecurityId().equals("888880") || po.getSecurityId().equals("131990")) {
                                capitalization = po.getSecBalance() * (double)("XSHG".equals(po.getMarket().getRaw()) ? 1000 : 100);
                            }
                            po.setMarketValue((double)Math.round(capitalization * 1000.0) / 1000.0);
                            po.setCapitalCNY((double)Math.round(po.getMarketValue() * 100.0) / 100.0);
                            if ("SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw())) {
                                po.setCapitalCNY((double)Math.round(po.getMarketValue() * po.getHkRate() * 100.0) / 100.0);
                            }
                        }
                        sumCapital += po.getCapitalCNY();
                        sumSec += po.getSecBalance();
                    }
                    this.sumCapitalCNY = sumCapital;
                    this.sumSecBalance = sumSec;
                }
                catch (MException | Exception e) {
                    logger.error("\u6c47\u603b\u6301\u4ed3\u6570\u91cf\u548c\u4eba\u6c11\u5e01\u5e02\u503c\u5f02\u5e38" + e.getMessage(), e);
                }
                Platform.runLater(() -> {
                    if (this.sumCapitalCNY > 0.0) {
                        this.labelCapital.setText(StringUtils.toThousands((Number)((double)Math.round(this.sumCapitalCNY * 1000.0) / 1000.0), (int)3));
                    } else {
                        this.labelCapital.setText(StringUtils.toThousands((Number)0, (int)3));
                    }
                    if (this.sumSecBalance > 0.0) {
                        this.labelTotal.setText(StringUtils.toThousands((Number)((double)Math.round(this.sumSecBalance * 1000.0) / 1000.0), (int)3));
                    } else {
                        this.labelTotal.setText(StringUtils.toThousands((Number)0, (int)3));
                    }
                });
            });
        }
        catch (Exception e) {
            logger.error("\u6c47\u603b\u6301\u4ed3\u6570\u91cf\u548c\u4eba\u6c11\u5e01\u5e02\u503c\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
    }

    private class BuyCostCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        private BuyCostCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObPosition posi = (ObPosition)ObPosition.class.cast(this.getTableRow().getItem());
                if ("STOCK".equals(posi.getSecType())) {
                    this.scale = 3;
                } else if ("FUND".equals(posi.getSecType()) && !"XOTC".equals(posi.getMarket().getRaw()) || "BOND".equals(posi.getSecType())) {
                    this.scale = 4;
                } else if ("XOTC".equals(posi.getMarket().getRaw())) {
                    this.scale = 5;
                }
                if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                    this.scale = 4;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class CostPriceCell
    extends DoubleTableCell<ObPosition> {
        int scale = 4;

        private CostPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObPosition posi = (ObPosition)ObPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = PositionHisNewQueryPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
                if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                    refItem = PositionHisNewQueryPart.this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecurityId());
                }
                if (refItem != null) {
                    this.scale = refItem.getScale() + 1;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class NetCell
    extends DoubleTableCell<ObPosition> {
        int scale = 2;

        private NetCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if ("6".equals(PositionHisNewQueryPart.this.pageCcs.getDimension())) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class PriceCell
    extends DoubleTableCell<ObPosition> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObPosition posi = (ObPosition)ObPosition.class.cast(this.getTableRow().getItem());
                RefItem refItem = PositionHisNewQueryPart.this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if ("SHSC".equals(posi.getMarket().getRaw()) || "SZSC".equals(posi.getMarket().getRaw())) {
                    refItem = PositionHisNewQueryPart.this.refMng.getItem(String.valueOf(posi.getSecType()) + posi.getMarket().getRaw(), posi.getMarket().getRaw(), posi.getSecurityId());
                    this.scale = refItem != null ? (refItem.getScale() == 0 ? 3 : refItem.getScale()) : 3;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    public class RateTableCell<S>
    extends DoubleTableCell<S> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");
        private Label label = new Label();

        private RateTableCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                double value = item.doubleValue();
                this.label.setText(this.sDFPrice.format(value));
                if (value > 0.0) {
                    CssUtils.makeRise((Control)this.label);
                } else if (value < 0.0) {
                    CssUtils.makeFall((Control)this.label);
                } else if (value == 0.0) {
                    CssUtils.makeEven((Control)this.label);
                }
            } else {
                this.label.setText("");
                this.setGraphic(null);
                this.setText(null);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

