/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.TransRecord;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.models.OtcTransferQueryModel;
import cms.tmx.query.history.models.PageModel;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class OtcTransferQueryPart
extends MxPart {
    @FXML
    private DatePicker dpBegin;
    @FXML
    private DatePicker dpEnd;
    @FXML
    private TabPane tabPane;
    @FXML
    private TableView<TransRecord> tablePosi;
    @FXML
    private TableColumn<TransRecord, Number> countDouble;
    @FXML
    private TableColumn<TransRecord, Number> price;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbTotalPosi;
    @FXML
    private TextField txtJumpPosi;
    @FXML
    private ComboBox<MxNode> cmbSizePosi;
    @FXML
    private Pagination pagePosi;
    @FXML
    protected Label lbPort;
    @Inject
    private OtcTransferQueryModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private IBaseApi iba;
    @Inject
    protected PortfolioAccountModel portfolioAccountModel;
    private PageModel<TransRecord> modelPosi;
    private String format = "yyyy-MM-dd";
    protected InvalidationListener lstnInit = ob -> this.query();
    private Map<String, String> reactMap = new HashMap<String, String>();
    @FXML
    private MenuItem posiExcel;

    @FXML
    public void initialize() {
        this.queryAccountInfo();
        this.initCheckBoxPort();
        this.modelPosi = this.model.initPagePosi();
        this.initControls();
        this.createTable();
        if (this.model.isDone()) {
            this.lstnInit.invalidated(null);
        } else {
            this.query();
        }
        this.model.doneProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnInit));
    }

    private void queryAccountInfo() {
        ArrayList list = new ArrayList();
        String partyId = this.iba.getPartyId();
        if (StringUtils.isEmpty((String)partyId)) {
            return;
        }
        try {
            list.addAll(this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll(this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tablePosi);
        this.countDouble.setCellFactory(cell -> new EditTableCell(2));
        this.countDouble.setEditable(false);
        this.tablePosi.setPlaceholder((Node)new Label());
        this.tablePosi.setItems(this.modelPosi.getData());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.initReactMap(this.tablePosi);
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.portfolioAccountModel.getPortfoliosAll();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listPortId = FxUtils.newList();
            for (Portfolio port : checkedItems) {
                if (port.getId().isEmpty()) continue;
                listPortId.add(port.getName());
            }
            String portStr = listPortId.toString();
            this.lbPort.setText(portStr.substring(1, portStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void initReactMap(TableView<TransRecord> table) {
        for (TableColumn column : table.getColumns()) {
            String s = column.getId();
            if ("index".equals(s)) continue;
            String columnId = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.reactMap.put(s, columnId);
        }
    }

    private void initControls() {
        DatePickerUtils.setDateLimit((DatePicker)this.dpBegin, (DatePicker)this.dpEnd, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.dpBegin, (String)this.format);
        DatePickerUtils.setFormat((DatePicker)this.dpEnd, (String)this.format);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.dpBegin.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.dpEnd.setValue((Object)ldEnd);
        this.initPage(this.pagePosi, this.lbTotalPosi, this.txtJumpPosi, this.cmbSizePosi, this.modelPosi);
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, PageModel<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw()));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(txtJump.getText()) - 1);
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && "".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(txtJump.getText()) - 1);
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, PageModel<?> pageModel) {
        int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
        pageModel.setPageSize(pageSize);
    }

    @FXML
    private void query() {
        String begin = ((LocalDate)this.dpBegin.getValue()).toString().replaceAll("-", "");
        String end = ((LocalDate)this.dpEnd.getValue()).toString().replaceAll("-", "");
        List portfolioId = this.ccmbPort.getCheckModel().getCheckedItems().stream().map(p -> p.getId()).collect(Collectors.toList());
        this.exe.execute(() -> {
            try {
                this.model.query(false, begin, end, portfolioId);
                this.tablePosi.sort();
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getDesc()));
            }
        });
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosi);
    }

    @FXML
    private void posiExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u8bc1\u5238\u5212\u8f6c\u67e5\u8be2.xls");
            if (file == null) {
                return;
            }
            this.posiExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeExcel(this.tablePosi, this.modelPosi.getList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.posiExcel.setDisable(false));
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                    Platform.runLater(() -> {
                        this.posiExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }
}

