/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ObOrder;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.history.ICtpOrderHisService;
import cms.tmx.query.history.models.CcsNewOrderHisServiceImpl;
import cms.tmx.query.history.views.HisNewQueryPart;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderNewHisQueryPart
extends HisNewQueryPart<ObOrder> {
    private static final Logger logger = LogManager.getLogger(OrderNewHisQueryPart.class);
    @FXML
    private TableView<ObOrder> ccsTableOrder;
    @FXML
    private TableColumn<ObOrder, String> index;
    @FXML
    private TableColumn<ObOrder, String> colCcsCode;
    @FXML
    private TableColumn<ObOrder, String> colCcsName;
    @FXML
    private TableColumn<ObOrder, String> colCcsMarket;
    @FXML
    private TableColumn<ObOrder, Number> colCcsPrice;
    @FXML
    private TableColumn<ObOrder, Number> colCcsAmt;
    @FXML
    private TableColumn<ObOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<ObOrder, Number> colCcsOrderQty;
    @FXML
    private TableColumn<ObOrder, Number> colCcsCumQty;
    @FXML
    private TableColumn<ObOrder, Number> colCcsPercent;
    @FXML
    private TableColumn<ObOrder, Number> colAvgPx;
    @FXML
    private TableColumn<ObOrder, String> colReference;
    @FXML
    private TableColumn<ObOrder, String> unit;
    @FXML
    private TableColumn<ObOrder, String> portfolioName;
    @FXML
    private TableColumn<ObOrder, Number> colCcsRealFee;
    @FXML
    private TableColumn<ObOrder, Number> colCcsCommission;
    @FXML
    private TableColumn<ObOrder, Side> side;
    @FXML
    private TableColumn<ObOrder, String> ordStatus;
    @FXML
    private TableColumn<ObOrder, Number> colCcsChgFee;
    @FXML
    private TableColumn<ObOrder, Number> colCcsStampTax;
    @FXML
    private TableColumn<ObOrder, Number> colCcsHandleFee;
    @FXML
    private TableColumn<ObOrder, Number> colCcsSecAdminFee;
    @FXML
    private TableColumn<ObOrder, Number> colCcsOtherFee;
    @FXML
    private TableColumn<ObOrder, String> colInfo;
    @FXML
    private TableColumn<ObOrder, String> ccsColUserName;
    @FXML
    private TableColumn<ObOrder, String> colCcsType;
    @FXML
    private TableColumn<ObOrder, String> orderId;
    @FXML
    private TableColumn<ObOrder, String> investorId;
    @FXML
    private TableColumn<ObOrder, String> inverstorSecId;
    @FXML
    private TableColumn<ObOrder, String> ordDate;
    @FXML
    private TableColumn<ObOrder, String> ordTime;
    @FXML
    private TableView<ObOrder> tableOrderOtc;
    @FXML
    private TableColumn<ObOrder, String> indexOtc;
    @FXML
    private TableColumn<ObOrder, String> codeOtc;
    @FXML
    private TableColumn<ObOrder, String> nameOtc;
    @FXML
    private TableColumn<ObOrder, String> marketOtc;
    @FXML
    private TableColumn<ObOrder, SecSubType> secSubType;
    @FXML
    private TableColumn<ObOrder, Number> priceOtc;
    @FXML
    private TableColumn<ObOrder, Number> amtOtc;
    @FXML
    private TableColumn<ObOrder, Number> frozenAmtOtc;
    @FXML
    private TableColumn<ObOrder, Number> orderQtyOtc;
    @FXML
    private TableColumn<ObOrder, String> referenceOtc;
    @FXML
    private TableColumn<ObOrder, String> unitOtc;
    @FXML
    private TableColumn<ObOrder, String> ordStatusOtc;
    @FXML
    private TableColumn<ObOrder, String> portfolioNameOtc;
    @FXML
    private TableColumn<ObOrder, Side> sideOtc;
    @FXML
    private TableColumn<ObOrder, String> infoOtc;
    @FXML
    private TableColumn<ObOrder, String> userNameOtc;
    @FXML
    private TableColumn<ObOrder, String> orderIdOtc;
    @FXML
    private TableColumn<ObOrder, String> investorIdOtc;
    @FXML
    private TableColumn<ObOrder, String> investorSecIdOtc;
    @FXML
    private TableColumn<ObOrder, String> ordDateOtc;
    @FXML
    private TableColumn<ObOrder, String> ordTimeOtc;
    @Inject
    private MxAlert alert;
    @Inject
    private CcsNewOrderHisServiceImpl ccsOrderHisService;
    @Inject
    private ICtpOrderHisService ctpOrderHisService;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ccsExcelOtc;

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableOtc();
        this.query();
        this.focusRefresh(this.ccsTableOrder);
    }

    @Override
    protected void initValue() {
        super.initValue();
    }

    @Override
    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    private void creatTableCcs() {
        TableUtils.initValueFactory(this.ccsTableOrder);
        this.colCcsCode.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInstrument().getSecurityId()));
        this.colCcsName.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInstrument().getSymbol()));
        this.colCcsMarket.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getMarket()));
        this.colCcsPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getPrice()));
        this.colCcsPrice.setCellFactory(p -> new HisNewQueryPart.PriceCell());
        this.colCcsOrderQty.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getOrderQty()));
        this.colCcsOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colCcsCumQty.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getCumQty()));
        this.colCcsCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colCcsAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getOrderAmount()));
        this.colCcsAmt.setCellFactory(p -> new HisNewQueryPart.PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new HisNewQueryPart.PriceCell());
        this.colCcsPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getDonePercent()));
        this.colCcsPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getAvgPx()));
        this.colAvgPx.setCellFactory(p -> new HisNewQueryPart.AvgPriceCell());
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getReference()));
        this.portfolioName.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getPortfolioName()));
        this.colCcsCommission.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getCommission()));
        this.colCcsCommission.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsChgFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getChgOwnerFee()));
        this.colCcsChgFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsStampTax.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getStampTax()));
        this.colCcsStampTax.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsHandleFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getHandleFee()));
        this.colCcsHandleFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsSecAdminFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getSecAdminFee()));
        this.colCcsSecAdminFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsOtherFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getOtherFee()));
        this.colCcsOtherFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsRealFee.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getRealFee()));
        this.colCcsRealFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColUserName.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getUserName()));
        this.colCcsType.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getOrdTypeDesc()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<ObOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.side.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObOrder)data.getValue()).getSide()));
        this.side.setCellFactory(data -> new SideCell());
        this.unit.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getUnit()));
        this.ordStatus.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getStatus()));
        this.orderId.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getExtOrderId()));
        this.investorId.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInvestorId()));
        this.inverstorSecId.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInvestorSecId()));
        this.ordDate.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getOrdDate()));
        this.ordTime.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getOrdTime()));
        this.ordTime.setCellValueFactory(data -> ((ObOrder)data.getValue()).ordTimeProperty());
        this.ccsTableOrder.setItems(this.pageCcs.getDataList());
        this.ccsTableOrder.setPlaceholder((Node)new Label());
        this.reactMap.put(this.colCcsCode.getId(), "SecurityId");
        this.reactMap.put(this.side.getId(), "SideString");
        this.reactMap.put(this.ordDate.getId(), "OrdDate");
        this.reactMap.put(this.ordTime.getId(), "OrdTime");
        this.reactMap.put(this.unit.getId(), "Unit");
        this.reactMap.put(this.orderId.getId(), "ExtOrderId");
        this.reactMap.put(this.investorId.getId(), "InvestorId");
        this.reactMap.put(this.inverstorSecId.getId(), "InvestorSecId");
        this.reactMap.put(this.ordStatus.getId(), "Status");
        this.reactMap.put(this.colCcsName.getId(), "Symbol");
        this.reactMap.put(this.colCcsMarket.getId(), "Market");
        this.reactMap.put(this.colCcsPrice.getId(), "Price");
        this.reactMap.put(this.colCcsOrderQty.getId(), "OrderQty");
        this.reactMap.put(this.colCcsCumQty.getId(), "CumQty");
        this.reactMap.put(this.colCcsAmt.getId(), "OrderAmount");
        this.reactMap.put(this.colFrozenAmt.getId(), "FrozenMargin");
        this.reactMap.put(this.colCcsPercent.getId(), "DonePercent");
        this.reactMap.put(this.colAvgPx.getId(), "AvgPx");
        this.reactMap.put(this.colReference.getId(), "Reference");
        this.reactMap.put(this.portfolioName.getId(), "PortfolioName");
        this.reactMap.put(this.colCcsCommission.getId(), "Commission");
        this.reactMap.put(this.colCcsChgFee.getId(), "ChgOwnerFee");
        this.reactMap.put(this.colCcsStampTax.getId(), "StampTax");
        this.reactMap.put(this.colCcsHandleFee.getId(), "HandleFee");
        this.reactMap.put(this.colCcsSecAdminFee.getId(), "SecAdminFee");
        this.reactMap.put(this.colCcsOtherFee.getId(), "OtherFee");
        this.reactMap.put(this.colCcsRealFee.getId(), "RealFee");
        this.reactMap.put(this.colInfo.getId(), "ErrInfo");
        this.reactMap.put(this.ccsColUserName.getId(), "UserName");
        this.reactMap.put(this.colCcsType.getId(), "OrdTypeDesc");
    }

    private void creatTableOtc() {
        TableUtils.isAuto(this.indexOtc);
        this.codeOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInstrument().getSecurityId()));
        this.nameOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInstrument().getSymbol()));
        this.marketOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getMarket()));
        this.secSubType.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObOrder)data.getValue()).getSecSubType()));
        this.priceOtc.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getPrice()));
        this.priceOtc.setCellFactory(data -> new DoubleTableCell(4));
        this.orderQtyOtc.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getOrderQty()));
        this.orderQtyOtc.setCellFactory(cell -> new DoubleTableCell());
        this.amtOtc.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getOrderAmount()));
        this.amtOtc.setCellFactory(p -> new HisNewQueryPart.PriceCell());
        this.frozenAmtOtc.setCellValueFactory(data -> new SimpleDoubleProperty(((ObOrder)data.getValue()).getFrozenMargin()));
        this.frozenAmtOtc.setCellFactory(p -> new HisNewQueryPart.PriceCell());
        this.referenceOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getReference()));
        this.portfolioNameOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getPortfolioName()));
        this.userNameOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getUserName()));
        this.infoOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getErrInfo()));
        this.infoOtc.setCellFactory(data -> new TooltipTableCell<ObOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.sideOtc.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObOrder)data.getValue()).getSide()));
        this.sideOtc.setCellFactory(data -> new SideCell());
        this.unitOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getUnit()));
        this.ordStatusOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getStatus()));
        this.orderIdOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getExtOrderId()));
        this.investorIdOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInvestorId()));
        this.investorSecIdOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getInvestorSecId()));
        this.ordDateOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getOrdDate()));
        this.ordTimeOtc.setCellValueFactory(data -> new SimpleStringProperty(((ObOrder)data.getValue()).getOrdTime()));
        this.tableOrderOtc.setItems(this.pageOtc.getDataList());
        this.tableOrderOtc.setPlaceholder((Node)new Label());
        this.reactMap.put(this.codeOtc.getId(), "SecurityId");
        this.reactMap.put(this.sideOtc.getId(), "SideString");
        this.reactMap.put(this.ordDateOtc.getId(), "OrdDate");
        this.reactMap.put(this.ordTimeOtc.getId(), "OrdTime");
        this.reactMap.put(this.ordStatusOtc.getId(), "Status");
        this.reactMap.put(this.unitOtc.getId(), "Unit");
        this.reactMap.put(this.orderIdOtc.getId(), "ExtOrderId");
        this.reactMap.put(this.investorIdOtc.getId(), "InvestorId");
        this.reactMap.put(this.investorSecIdOtc.getId(), "InvestorSecId");
        this.reactMap.put(this.nameOtc.getId(), "Symbol");
        this.reactMap.put(this.marketOtc.getId(), "Market");
        this.reactMap.put(this.secSubType.getId(), "SecSubType");
        this.reactMap.put(this.priceOtc.getId(), "Price");
        this.reactMap.put(this.orderQtyOtc.getId(), "OrderQty");
        this.reactMap.put(this.amtOtc.getId(), "OrderAmount");
        this.reactMap.put(this.frozenAmtOtc.getId(), "FrozenMargin");
        this.reactMap.put(this.referenceOtc.getId(), "Reference");
        this.reactMap.put(this.portfolioNameOtc.getId(), "PortfolioName");
        this.reactMap.put(this.infoOtc.getId(), "ErrInfo");
        this.reactMap.put(this.userNameOtc.getId(), "UserName");
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTableOrder, this.portfolioName);
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.pageCcs.setMarketGrp("CCS");
            this.ccsOrderHisService.query((HisQueryPage<ObOrder>)this.pageCcs);
        }
        catch (MException | IOException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTableOrder.scrollToColumnIndex(0);
        }
        this.ccsTableOrder.scrollTo(0);
        this.ccsTableOrder.sort();
        this.ccsTableOrder.refresh();
    }

    @Override
    protected void otcQuery() {
        this.checkPortfolio(this.tableOrderOtc, this.portfolioNameOtc);
        if (!this.rebuildPagi(this.pageOtc, this.otcChangeExtAcc)) {
            this.otcReset();
            return;
        }
        try {
            this.otcChangeExtAcc = false;
            this.pageOtc.setMarketGrp("OTC");
            this.ccsOrderHisService.queryOtc((HisQueryPage<ObOrder>)this.pageOtc);
        }
        catch (MException | IOException e) {
            logger.error("\u573a\u5916\u57fa\u91d1" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u573a\u5916\u57fa\u91d1" + e.getMessage()));
        }
        if (this.pageOtc.getDataList().size() == 0) {
            this.tableOrderOtc.scrollToColumnIndex(0);
        }
        this.tableOrderOtc.scrollTo(0);
        this.tableOrderOtc.sort();
        this.tableOrderOtc.refresh();
    }

    @Override
    protected void queryAll() {
        super.queryAll();
        this.blockChangeExtAcc = false;
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableOrder);
    }

    @FXML
    public void ccsRefreshOtc() {
        this.otcQuery();
    }

    @FXML
    public void ccsCopyOtc() {
        TableUtils.copyContentWithHead(this.tableOrderOtc);
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u59d4\u6258\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.pageCcs.setMarketGrp("CCS");
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObOrder> page = this.ccsOrderHisService.getAllCcsData((HisQueryPage<ObOrder>)this.pageCcs);
                    ExcelUtils.writeExcel(this.ccsTableOrder, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ccsExportExcelOtc() {
        try {
            File file = ExcelUtils.saveFile((String)"\u59d4\u6258\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcelOtc.setDisable(true);
            this.pageOtc.setMarketGrp("OTC");
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObOrder> page = this.ccsOrderHisService.getAllCcsData((HisQueryPage<ObOrder>)this.pageOtc);
                    ExcelUtils.writeExcel(this.tableOrderOtc, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcelOtc.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcelOtc.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    public class SideCell<T>
    extends TableCell<T, Side> {
        private Label label = new Label();
        Side side;

        public SideCell() {
            this.label.setText("");
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Side sid, boolean empty) {
            try {
                if (sid == null) {
                    return;
                }
                if ("".equals(sid)) {
                    return;
                }
                if ("".equals(sid.getValue())) {
                    return;
                }
                int side = StringUtils.parseInt((String)sid.getValue());
                this.label.setText(sid.toString());
                switch (side) {
                    case 49: 
                    case 71: 
                    case 80: 
                    case 83: 
                    case 201: {
                        CssUtils.makeRise((Control)this.label);
                        break;
                    }
                    default: {
                        CssUtils.makeFall((Control)this.label);
                    }
                }
                this.setGraphic((Node)this.label);
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }
}

