/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.block.BlockOrderModel;
import cms.tmx.query.history.ICcsOrderHisService;
import cms.tmx.query.history.ICtpOrderHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderHisCreaterQueryPart
extends HisQueryPart<CcsOrder, CtpOrder, BlockOrder> {
    private static final Logger logger = LogManager.getLogger(OrderHisCreaterQueryPart.class);
    @FXML
    private TableView<CcsOrder> ccsTableOrder;
    @FXML
    private TableColumn<CcsOrder, String> colCcsCode;
    @FXML
    private TableColumn<CcsOrder, String> colCcsName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colCcsMarket;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colFrozenAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsCumQty;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPx;
    @FXML
    private TableColumn<CcsOrder, String> colReference;
    @FXML
    private TableColumn<CcsOrder, String> unit;
    @FXML
    private TableColumn<CcsOrder, String> portfolioName;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsRealFee;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsCommision;
    @FXML
    private TableColumn<CcsOrder, MxNode> side;
    @FXML
    private TableColumn<CcsOrder, MxNode> ordStatus;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsChgFee;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsStampTax;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsHandleFee;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsSecAdminFee;
    @FXML
    private TableColumn<CcsOrder, Number> colCcsOtherFee;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> ccsColUserName;
    @FXML
    private TableColumn<CcsOrder, String> colCcsType;
    @FXML
    private TableColumn<CcsOrder, String> orderId;
    @FXML
    private TableColumn<CcsOrder, String> investorId;
    @FXML
    private TableColumn<CcsOrder, String> accName;
    @FXML
    private TableColumn<CcsOrder, String> inverstorSecId;
    @FXML
    private TableColumn<CcsOrder, String> ordDate;
    @FXML
    private TableColumn<CcsOrder, String> ordTime;
    @FXML
    private TableView<CtpOrder> ctpTableOrder;
    @FXML
    private TableColumn<Order, String> colCtpCode;
    @FXML
    private TableColumn<CtpOrder, String> colCtpName;
    @FXML
    private TableColumn<CtpOrder, MxNode> colCtpMarket;
    @FXML
    private TableColumn<CtpOrder, Number> colCtpPrice;
    @FXML
    private TableColumn<CtpOrder, Number> colCtpOrderQty;
    @FXML
    private TableColumn<CtpOrder, Number> colCtpCumQty;
    @FXML
    private TableColumn<CtpOrder, MxNode> sideCtp;
    @FXML
    private TableColumn<CtpOrder, Number> colCtpPercent;
    @FXML
    private TableColumn<CtpOrder, Number> colCtpAvg;
    @FXML
    private TableColumn<CtpOrder, Number> colFroMargin;
    @FXML
    private TableColumn<CtpOrder, String> ctpColAcc;
    @FXML
    private TableColumn<CtpOrder, String> ctpColAccName;
    @FXML
    private TableColumn<CtpOrder, String> ctpColAccSec;
    @FXML
    private TableColumn<CtpOrder, String> ctpColReference;
    @FXML
    private TableColumn<CtpOrder, String> ctpColUser;
    @FXML
    private TableColumn<CtpOrder, String> ctpColTime;
    @FXML
    private TableColumn<CtpOrder, String> colCtpInfo;
    @FXML
    private TableColumn<CtpOrder, String> ctpColUserName;
    @FXML
    private TableColumn<CtpOrder, String> colCtpType;
    @FXML
    private TableColumn<CtpOrder, String> colCtpOrdDate;
    @FXML
    private TableColumn<CtpOrder, MxNode> colCtpOrdStatus;
    @FXML
    private TableColumn<CtpOrder, MxNode> ocFlag;
    @FXML
    private TableColumn<CtpOrder, MxNode> shFlag;
    @FXML
    private TableColumn<CtpOrder, String> colCtpOrderId;
    @FXML
    private TableView<BlockOrder> blockTableOrder;
    @FXML
    private TableColumn<BlockOrder, String> colSecId;
    @FXML
    private TableColumn<BlockOrder, String> colSecName;
    @FXML
    private TableColumn<BlockOrder, MxNode> colSide;
    @FXML
    private TableColumn<BlockOrder, MxNode> colType;
    @FXML
    private TableColumn<BlockOrder, Number> colPrice;
    @FXML
    private TableColumn<BlockOrder, Number> colOrderQty;
    @FXML
    private TableColumn<BlockOrder, String> colUnit;
    @FXML
    private TableColumn<BlockOrder, Number> colDoneVol;
    @FXML
    private TableColumn<BlockOrder, MxNode> colOrdStatus;
    @FXML
    private TableColumn<BlockOrder, String> colOrderId;
    @FXML
    private TableColumn<BlockOrder, String> colOrdTime;
    @FXML
    private TableColumn<BlockOrder, MxNode> colMarket;
    @FXML
    private TableColumn<BlockOrder, String> colAccId;
    @FXML
    private TableColumn<BlockOrder, String> colAccName;
    @FXML
    private TableColumn<BlockOrder, String> colSecAcc;
    @FXML
    private TableColumn<BlockOrder, String> colSysTrader;
    @FXML
    private TableColumn<BlockOrder, String> colOurTrader;
    @FXML
    private TableColumn<BlockOrder, String> colContractNo;
    @FXML
    private TableColumn<BlockOrder, String> colOppositeTradingUnit;
    @FXML
    private TableColumn<BlockOrder, String> colOppositeTrader;
    @FXML
    private TableColumn<BlockOrder, String> colContact;
    @FXML
    private TableColumn<BlockOrder, String> colRemark;
    @FXML
    private TableColumn<BlockOrder, String> colDate;
    @FXML
    private TableColumn<BlockDeal, String> blockIndex;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsOrderHisService ccsOrderHisService;
    @Inject
    private ICtpOrderHisService ctpOrderHisService;
    @Inject
    protected BlockOrderModel blockModel;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @FXML
    private Tab blockTab;
    @FXML
    private ComboBox<MxNode> blockPageSize;
    @FXML
    private Pagination blockPagination;
    @FXML
    private Label blockTotalCount;
    @FXML
    private TextField blockJumpPage;
    @FXML
    protected CheckBox cbSH;
    @FXML
    protected CheckBox cbSZ;
    @FXML
    protected CheckBox cbBuy;
    @FXML
    protected CheckBox cbSell;
    @FXML
    protected Label lbBuyCumAmt;
    @FXML
    protected Label lbSellCumAmt;
    @FXML
    protected Label lbBuyOrdAmt;
    @FXML
    protected Label lbSellOrdAmt;
    @FXML
    protected Label lbCcsBuyCumAmt;
    @FXML
    protected Label lbCcsSellCumAmt;
    @FXML
    protected Label lbCcsBuyOrdAmt;
    @FXML
    protected Label lbCcsSellOrdAmt;
    @FXML
    protected Label lbCtpBuyCumAmt;
    @FXML
    protected Label lbCtpSellCumAmt;
    @FXML
    protected Label lbCtpBuyOrdAmt;
    @FXML
    protected Label lbCtpSellOrdAmt;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ctpExcel;
    @FXML
    private MenuItem blockExcel;

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableCtp();
        this.createTableBlock();
        this.query();
        this.focusRefresh(this.ccsTableOrder);
        this.focusRefresh(this.ctpTableOrder);
        this.focusRefresh(this.blockTableOrder);
    }

    @Override
    protected void initValue() {
        super.initValue();
        this.initPage(this.blockPagination, this.blockTotalCount, this.blockJumpPage, this.blockPageSize, this.pageBlock);
    }

    @Override
    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
            this.tabPane.getTabs().remove((Object)this.blockTab);
        }
        if (!marketGrpList.contains("FUTURES")) {
            this.tabPane.getTabs().remove((Object)this.ctpTab);
        }
    }

    protected void blockReset() {
        this.blockPagination.setPageCount(1);
        this.blockTotalCount.setText("0");
    }

    private void creatTableCcs() {
        TableUtils.initValueFactory(this.ccsTableOrder);
        this.colCcsCode.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colCcsName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colCcsMarket.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().marketProperty());
        this.colCcsPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colCcsPrice.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colCcsOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colCcsOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colCcsCumQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colCcsCumQty.setCellFactory(cell -> new NumberTableCell());
        this.colCcsAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colCcsAmt.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colFrozenAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getFrozenMargin()));
        this.colFrozenAmt.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colCcsPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colCcsPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPx.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPx.setCellFactory(p -> new HisQueryPart.AvgPriceCell());
        this.colReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getReference()));
        this.portfolioName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getPortfolioName()));
        this.colCcsCommision.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getCommision()));
        this.colCcsCommision.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsChgFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getChgOwnerFee()));
        this.colCcsChgFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsStampTax.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getStampTax()));
        this.colCcsStampTax.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsHandleFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getHandleFee()));
        this.colCcsHandleFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsSecAdminFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getSecAdminFee()));
        this.colCcsSecAdminFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsOtherFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOtherFee()));
        this.colCcsOtherFee.setCellFactory(cell -> new DoubleTableCell());
        this.colCcsRealFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getRealFee()));
        this.colCcsRealFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColUserName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserName()));
        this.colCcsType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colInfo.setCellFactory(data -> new TooltipTableCell<CcsOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CcsOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.side.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.side.setCellFactory(data -> new SideCell());
        this.unit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.ordStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getOrdStatus()));
        this.orderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.investorId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.accName.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getAccName()));
        this.inverstorSecId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.ordDate.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdDate()));
        this.ordTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.ccsTableOrder.setItems(this.pageCcs.getDataList());
        this.ccsTableOrder.setPlaceholder((Node)new Label());
        this.reactMap.put(this.colCcsCode.getId(), "SecId");
        this.reactMap.put(this.side.getId(), "ExSide");
        this.reactMap.put(this.ordDate.getId(), "OrdDate");
        this.reactMap.put(this.ordTime.getId(), "OrdTime");
        this.reactMap.put(this.unit.getId(), "Unit");
        this.reactMap.put(this.orderId.getId(), "OrderId");
        this.reactMap.put(this.investorId.getId(), "InvestorId");
        this.reactMap.put(this.accName.getId(), "InvestorName");
        this.reactMap.put(this.inverstorSecId.getId(), "InverstorSecId");
        this.reactMap.put(this.ordStatus.getId(), "ExOrdStatus");
        this.reactMap.put(this.colCcsName.getId(), "SecName");
        this.reactMap.put(this.colCcsMarket.getId(), "Market");
        this.reactMap.put(this.colCcsPrice.getId(), "Price");
        this.reactMap.put(this.colCcsOrderQty.getId(), "OrderQty");
        this.reactMap.put(this.colCcsCumQty.getId(), "CumQty");
        this.reactMap.put(this.colCcsAmt.getId(), "OrderAmt");
        this.reactMap.put(this.colFrozenAmt.getId(), "FrozenMargin");
        this.reactMap.put(this.colCcsPercent.getId(), "DonePercent");
        this.reactMap.put(this.colAvgPx.getId(), "AvgPx");
        this.reactMap.put(this.colReference.getId(), "Reference");
        this.reactMap.put(this.portfolioName.getId(), "PortfolioName");
        this.reactMap.put(this.colCcsCommision.getId(), "Commision");
        this.reactMap.put(this.colCcsChgFee.getId(), "ChgOwnerFee");
        this.reactMap.put(this.colCcsStampTax.getId(), "StampTax");
        this.reactMap.put(this.colCcsHandleFee.getId(), "HandleFee");
        this.reactMap.put(this.colCcsSecAdminFee.getId(), "SecAdminFee");
        this.reactMap.put(this.colCcsOtherFee.getId(), "OtherFee");
        this.reactMap.put(this.colCcsRealFee.getId(), "RealFee");
        this.reactMap.put(this.colInfo.getId(), "ErrInfo");
        this.reactMap.put(this.ccsColUserName.getId(), "UserName");
        this.reactMap.put(this.colCcsType.getId(), "OrdTypeDesc");
    }

    private void createTableBlock() {
        this.blockTableOrder.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.blockIndex);
        this.blockIndex.setSortable(false);
        this.colSecId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSide.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sideProperty());
        this.colSide.setCellFactory(data -> new SideCell());
        this.colType.setCellValueFactory(data -> ((BlockOrder)data.getValue()).typeProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockOrder)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new HisQueryPart.PriceCell());
        this.colOrderQty.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderQtyProperty());
        this.colOrderQty.setCellFactory(data -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).unitProperty());
        this.colDoneVol.setCellValueFactory(data -> ((BlockOrder)data.getValue()).dealQtyProperty());
        this.colDoneVol.setCellFactory(data -> new NumberTableCell());
        this.colOrdStatus.setCellValueFactory(data -> ((BlockOrder)data.getValue()).statusProperty());
        this.colOrderId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).orderIdProperty());
        this.colOrdTime.setCellValueFactory(data -> ((BlockOrder)data.getValue()).timeProperty());
        this.colMarket.setCellValueFactory(data -> ((BlockOrder)data.getValue()).getInstrument().marketProperty());
        this.colAccId.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorIdProperty());
        this.colAccName.setCellValueFactory(data -> ((BlockOrder)data.getValue()).investorNameProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockOrder)data.getValue()).inverstorSecIdProperty());
        this.colSysTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).sysTraderProperty());
        this.colContractNo.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contractNoProperty());
        this.colOppositeTradingUnit.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTradingUnitProperty());
        this.colOppositeTrader.setCellValueFactory(data -> ((BlockOrder)data.getValue()).oppositeTraderProperty());
        this.colContact.setCellValueFactory(data -> ((BlockOrder)data.getValue()).contactProperty());
        this.colRemark.setCellValueFactory(data -> ((BlockOrder)data.getValue()).remarkProperty());
        this.colDate.setCellValueFactory(data -> ((BlockOrder)data.getValue()).dateProperty());
        this.colRemark.setCellFactory(data -> new TooltipTableCell<BlockOrder, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((BlockOrder)this.getValue()).getRemark();
            }
        });
        this.blockTableOrder.setItems(this.pageBlock.getDataList());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.reactMap.put(this.colSide.getId(), "ExSide");
        this.reactMap.put(this.colOrdStatus.getId(), "ExOrdStatus");
        this.reactMap.put(this.colMarket.getId(), "Market");
        this.reactMap.put(this.colType.getId(), "Type");
        this.reactMap.put(this.colPrice.getId(), "Price");
        this.reactMap.put(this.colOrderQty.getId(), "OrderQty");
        this.reactMap.put(this.colUnit.getId(), "Unit");
        this.reactMap.put(this.colDoneVol.getId(), "DealQty");
        this.reactMap.put(this.colOrderId.getId(), "OrderId");
        this.reactMap.put(this.colOrdTime.getId(), "Time");
        this.reactMap.put(this.colAccId.getId(), "InvestorId");
        this.reactMap.put(this.colAccName.getId(), "InvestorName");
        this.reactMap.put(this.colSecAcc.getId(), "InverstorSecId");
        this.reactMap.put(this.colSysTrader.getId(), "SysTrader");
        this.reactMap.put(this.colContractNo.getId(), "ContractNo");
        this.reactMap.put(this.colOppositeTradingUnit.getId(), "OppositeTradingUnit");
        this.reactMap.put(this.colOppositeTrader.getId(), "OppositeTrader");
        this.reactMap.put(this.colContact.getId(), "Contact");
        this.reactMap.put(this.colDate.getId(), "Date");
    }

    private void creatTableCtp() {
        TableUtils.initValueFactory(this.ctpTableOrder);
        this.colCtpCode.setCellValueFactory(data -> ((Order)data.getValue()).getInstrument().secIdProperty());
        this.colCtpName.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().symbolProperty());
        this.colCtpMarket.setCellValueFactory(data -> ((CtpOrder)data.getValue()).getInstrument().marketProperty());
        this.colFroMargin.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getFrozenMargin()));
        this.colFroMargin.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colCtpPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getPrice()));
        this.colCtpPrice.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colCtpPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getDonePercent()));
        this.colCtpPercent.setCellFactory(column -> new DoubleTableCell());
        this.colCtpAvg.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpOrder)data.getValue()).getAvgPx()));
        this.colCtpAvg.setCellFactory(p -> new HisQueryPart.PriceCell());
        this.colCtpOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getOrderQty()));
        this.colCtpOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colCtpCumQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CtpOrder)data.getValue()).getCumQty()));
        this.colCtpCumQty.setCellFactory(cell -> new NumberTableCell());
        this.sideCtp.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getSide()));
        this.sideCtp.setCellFactory(data -> new SideCell());
        this.ctpColAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInvestorId()));
        this.ctpColAccName.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getAccName()));
        this.ctpColAccSec.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getInverstorSecId()));
        this.ctpColReference.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getReference()));
        this.ctpColUser.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getUserId()));
        this.ctpColUserName.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getUserName()));
        this.ctpColTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrdTime()));
        this.colCcsType.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTypeDesc()));
        this.ocFlag.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOcFlag()));
        this.shFlag.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getShFlag()));
        this.colCtpInfo.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getErrInfo()));
        this.colCtpInfo.setCellFactory(data -> new TooltipTableCell<CtpOrder, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((CtpOrder)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.colCtpOrdDate.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrdDate()));
        this.colCtpOrdStatus.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpOrder)data.getValue()).getOrdStatus()));
        this.colCtpOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrderId()));
        this.colCtpType.setCellValueFactory(data -> new SimpleStringProperty(((CtpOrder)data.getValue()).getOrdTypeDesc()));
        this.ctpTableOrder.setItems(this.pageCtp.getDataList());
        this.ctpTableOrder.setPlaceholder((Node)new Label());
        this.reactMap.put(this.colCtpCode.getId(), "SecId");
        this.reactMap.put(this.colCtpName.getId(), "SecName");
        this.reactMap.put(this.colCtpMarket.getId(), "Market");
        this.reactMap.put(this.colFroMargin.getId(), "FrozenMargin");
        this.reactMap.put(this.colCtpPrice.getId(), "Price");
        this.reactMap.put(this.colCtpPercent.getId(), "DonePercent");
        this.reactMap.put(this.colCtpAvg.getId(), "AvgPx");
        this.reactMap.put(this.colCtpOrderQty.getId(), "OrderQty");
        this.reactMap.put(this.colCtpCumQty.getId(), "CumQty");
        this.reactMap.put(this.sideCtp.getId(), "ExSide");
        this.reactMap.put(this.ctpColAcc.getId(), "InvestorId");
        this.reactMap.put(this.ctpColAccName.getId(), "InvestorName");
        this.reactMap.put(this.ctpColAccSec.getId(), "InverstorSecId");
        this.reactMap.put(this.ctpColReference.getId(), "Reference");
        this.reactMap.put(this.ctpColUser.getId(), "UserId");
        this.reactMap.put(this.ocFlag.getId(), "ExOcFlag");
        this.reactMap.put(this.shFlag.getId(), "ExShFlag");
        this.reactMap.put(this.ctpColTime.getId(), "OrdTime");
        this.reactMap.put(this.colCtpInfo.getId(), "ErrInfo");
        this.reactMap.put(this.colCtpOrdDate.getId(), "OrdDate");
        this.reactMap.put(this.colCtpOrdStatus.getId(), "OrdStatus");
        this.reactMap.put(this.colCtpOrderId.getId(), "OrderId");
        this.reactMap.put(this.ctpColUserName.getId(), "UserName");
        this.reactMap.put(this.colCtpType.getId(), "OrdTypeDesc");
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTableOrder, this.portfolioName);
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.ccsOrderHisService.query((HisQueryPage<CcsOrder>)this.pageCcs);
            this.cbCcsFiltrate((HisQueryPage<CcsOrder>)this.pageCcs);
        }
        catch (MException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        catch (IOException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.ccsTableOrder.scrollTo(0);
        this.ccsTableOrder.sort();
    }

    private void cbCcsFiltrate(HisQueryPage<CcsOrder> pageCcsOrder) {
        MxList dataList = new MxList();
        dataList.addAll((List)pageCcsOrder.getDataList());
        this.pageCcs.getDataList().clear();
        for (CcsOrder deal : dataList.getList()) {
            if (!"XSHG".equals(deal.getInstrument().getMarket().getRaw()) ? "XSHE".equals(deal.getInstrument().getMarket().getRaw()) && !this.cbSZ.isSelected() : !this.cbSH.isSelected()) continue;
            if ("49".equals(deal.getSide().getRaw()) ? !this.cbBuy.isSelected() : "50".equals(deal.getSide().getRaw()) && !this.cbSell.isSelected()) continue;
            this.pageCcs.getDataList().add((Object)deal);
        }
        this.sumNum((ObservableList<CcsOrder>)this.pageCcs.getDataList());
    }

    @Override
    protected void ctpQuery() {
        if (this.isPortDimension() || this.isAssetGrpDimension() || !this.rebuildPagi(this.pageCtp, this.ctpChangeExtAcc) || this.pageCtp.getExtAccntIdList().isEmpty()) {
            this.ctpReset();
            return;
        }
        try {
            this.ctpChangeExtAcc = false;
            this.ctpOrderHisService.query((HisQueryPage<CtpOrder>)this.pageCtp);
            this.cbCtpFiltrate((HisQueryPage<CtpOrder>)this.pageCtp);
        }
        catch (MException e) {
            logger.error("\u671f\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u671f\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.ctpTableOrder.scrollTo(0);
        this.ctpTableOrder.sort();
    }

    private void cbCtpFiltrate(HisQueryPage<CtpOrder> pageCtpOrder) {
        MxList dataList = new MxList();
        dataList.addAll((List)pageCtpOrder.getDataList());
        this.pageCtp.getDataList().clear();
        for (CtpOrder deal : dataList.getList()) {
            if (!"XSHG".equals(deal.getInstrument().getMarket().getRaw()) ? "XSHE".equals(deal.getInstrument().getMarket().getRaw()) && !this.cbSZ.isSelected() : !this.cbSH.isSelected()) continue;
            if ("49".equals(deal.getSide().getRaw()) ? !this.cbBuy.isSelected() : "50".equals(deal.getSide().getRaw()) && !this.cbSell.isSelected()) continue;
            this.pageCtp.getDataList().add((Object)deal);
        }
        this.sumCtpNum((ObservableList<CtpOrder>)this.pageCtp.getDataList());
    }

    @Override
    @FXML
    protected void queryAll() {
        super.queryAll();
        this.blockQuery();
        this.blockChangeExtAcc = false;
        this.sumNum((ObservableList<CcsOrder>)this.pageCcs.getDataList());
        this.sumCtpNum((ObservableList<CtpOrder>)this.pageCtp.getDataList());
    }

    protected void blockQuery() {
        if (!this.rebuildPagi(this.pageBlock, this.blockChangeExtAcc)) {
            this.blockReset();
            return;
        }
        try {
            this.blockChangeExtAcc = false;
            this.blockModel.query((HisQueryPage<BlockOrder>)this.pageBlock);
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u5927\u5b97\u59d4\u6258\u5931\u8d25" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u5927\u5b97\u59d4\u6258\u5931\u8d25" + e.getMessage()));
        }
        this.blockTableOrder.scrollTo(0);
        this.blockTableOrder.sort();
    }

    @FXML
    private void blockCopy() {
        TableUtils.copyContentWithHead(this.blockTableOrder);
    }

    @FXML
    private void blockRefresh() {
        this.blockQuery();
    }

    @FXML
    public void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    public void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableOrder);
    }

    @FXML
    public void ctpRefresh() {
        this.ctpQuery();
    }

    @FXML
    public void ctpCopy() {
        TableUtils.copyContentWithHead(this.ctpTableOrder);
    }

    @FXML
    private void blockExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u5927\u5b97\u59d4\u6258\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.blockExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<BlockOrder> page = this.blockModel.getAllBlockData((HisQueryPage<BlockOrder>)this.pageBlock);
                    ExcelUtils.writeExcel(this.blockTableOrder, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.blockExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.blockExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u59d4\u6258\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CcsOrder> page = this.ccsOrderHisService.getAllCcsData((HisQueryPage<CcsOrder>)this.pageCcs);
                    ExcelUtils.writeExcel(this.ccsTableOrder, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ctpExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u59d4\u6258\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ctpExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CtpOrder> page = this.ctpOrderHisService.getAllCcsData((HisQueryPage<CtpOrder>)this.pageCtp);
                    ExcelUtils.writeExcel(this.ctpTableOrder, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ctpExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ctpExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private void sumNum(ObservableList<CcsOrder> dataList) {
        Platform.runLater(() -> {
            double orderSellAmt = 0.0;
            double orderBuyAmt = 0.0;
            double cumSellAmt = 0.0;
            double cumBuyAmt = 0.0;
            for (CcsOrder order : dataList) {
                if ("49".equals(order.getSide().getRaw()) || "71".equals(order.getSide().getRaw())) {
                    cumBuyAmt += order.getTotalValue();
                    orderBuyAmt += order.getOrderAmt();
                }
                if (!"50".equals(order.getSide().getRaw())) continue;
                cumSellAmt += order.getTotalValue();
                orderSellAmt += order.getOrderAmt();
            }
            this.lbCcsBuyCumAmt.setText(StringUtils.toThousands((Number)cumBuyAmt, (int)2));
            this.lbCcsSellCumAmt.setText(StringUtils.toThousands((Number)cumSellAmt, (int)2));
            this.lbCcsBuyOrdAmt.setText(StringUtils.toThousands((Number)orderBuyAmt, (int)2));
            this.lbCcsSellOrdAmt.setText(StringUtils.toThousands((Number)orderSellAmt, (int)2));
        });
    }

    private void sumCtpNum(ObservableList<CtpOrder> dataList) {
        Platform.runLater(() -> {
            double orderSellAmt = 0.0;
            double orderBuyAmt = 0.0;
            double cumSellAmt = 0.0;
            double cumBuyAmt = 0.0;
            for (CtpOrder order : dataList) {
                if ("49".equals(order.getSide().getRaw()) || "71".equals(order.getSide().getRaw())) {
                    cumBuyAmt += order.getTotalValue();
                    orderBuyAmt += order.getOrderAmt();
                }
                if (!"50".equals(order.getSide().getRaw())) continue;
                cumSellAmt += order.getTotalValue();
                orderSellAmt += order.getOrderAmt();
            }
            this.lbCtpBuyCumAmt.setText(StringUtils.toThousands((Number)cumBuyAmt, (int)2));
            this.lbCtpSellCumAmt.setText(StringUtils.toThousands((Number)cumSellAmt, (int)2));
            this.lbCtpBuyOrdAmt.setText(StringUtils.toThousands((Number)orderBuyAmt, (int)2));
            this.lbCtpSellOrdAmt.setText(StringUtils.toThousands((Number)orderSellAmt, (int)2));
        });
    }
}

