/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ObExecution;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.history.ICcsNewDealHisService;
import cms.tmx.query.history.views.HisNewQueryPart;
import cms.tmx.query.utils.ObSideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewDealHisQueryPart
extends HisNewQueryPart<ObExecution> {
    private static final Logger logger = LogManager.getLogger(NewDealHisQueryPart.class);
    @FXML
    private TableView<ObExecution> ccsTableDeal;
    @FXML
    private TableColumn<ObExecution, String> ccsColSecId;
    @FXML
    private TableColumn<ObExecution, String> ccsColSecName;
    @FXML
    private TableColumn<ObExecution, Side> ccsColDir;
    @FXML
    private TableColumn<ObExecution, Number> ccsColVol;
    @FXML
    private TableColumn<ObExecution, String> ccsColUnit;
    @FXML
    private TableColumn<ObExecution, Number> ccsColPrice;
    @FXML
    private TableColumn<ObExecution, String> ccsColTime;
    @FXML
    private TableColumn<ObExecution, String> ccsColDate;
    @FXML
    private TableColumn<ObExecution, String> ccsColMkt;
    @FXML
    private TableColumn<ObExecution, String> ccsColENo;
    @FXML
    private TableColumn<ObExecution, String> ccsColDealNo;
    @FXML
    private TableColumn<ObExecution, String> ccsColAcc;
    @FXML
    private TableColumn<ObExecution, String> ccsColSecAcc;
    @FXML
    private TableColumn<ObExecution, Number> ccsColAmt;
    @FXML
    private TableColumn<ObExecution, String> ccsColReference;
    @FXML
    private TableColumn<ObExecution, String> ccsColPort;
    @FXML
    private TableColumn<ObExecution, String> ccsIndex;
    @FXML
    private TableView<ObExecution> tableDealOtc;
    @FXML
    private TableColumn<ObExecution, String> secIdOtc;
    @FXML
    private TableColumn<ObExecution, String> secNameOtc;
    @FXML
    private TableColumn<ObExecution, Side> dirOtc;
    @FXML
    private TableColumn<ObExecution, Number> volOtc;
    @FXML
    private TableColumn<ObExecution, String> unitOtc;
    @FXML
    private TableColumn<ObExecution, Number> priceOtc;
    @FXML
    private TableColumn<ObExecution, String> timeOtc;
    @FXML
    private TableColumn<ObExecution, String> dateOtc;
    @FXML
    private TableColumn<ObExecution, String> mktOtc;
    @FXML
    private TableColumn<ObExecution, String> eNoOtc;
    @FXML
    private TableColumn<ObExecution, String> dealNoOtc;
    @FXML
    private TableColumn<ObExecution, String> accOtc;
    @FXML
    private TableColumn<ObExecution, String> secAccOtc;
    @FXML
    private TableColumn<ObExecution, Number> amtOtc;
    @FXML
    private TableColumn<ObExecution, String> referenceOtc;
    @FXML
    private TableColumn<ObExecution, String> portOtc;
    @FXML
    private TableColumn<ObExecution, String> indexOtc;
    @FXML
    private TableColumn<ObExecution, SecSubType> secSubType;
    @FXML
    private TableColumn<ObExecution, Number> fee;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsNewDealHisService ccsDealHisService;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @FXML
    private Tab blockTab;
    @FXML
    private ComboBox<MxNode> blockPageSize;
    @FXML
    private Pagination blockPagination;
    @FXML
    private Label blockTotalCount;
    @FXML
    private TextField blockJumpPage;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ccsExcelOtc;

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableOtc();
        this.query();
        this.focusRefresh(this.ccsTableDeal);
    }

    @Override
    protected void initValue() {
        super.initValue();
    }

    @Override
    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
            this.tabPane.getTabs().remove((Object)this.blockTab);
        }
    }

    protected void blockReset() {
        this.blockPagination.setPageCount(1);
        this.blockTotalCount.setText("0");
    }

    protected void ctpQuery() {
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTableDeal, this.ccsColPort);
        this.pageCcs.setMarketGrp("CCS");
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.ccsDealHisService.query((HisQueryPage<ObExecution>)this.pageCcs);
        }
        catch (MException | IOException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTableDeal.scrollToColumnIndex(0);
        }
        this.ccsTableDeal.scrollTo(0);
        this.ccsTableDeal.sort();
        Platform.runLater(() -> this.ccsTableDeal.refresh());
    }

    @Override
    protected void otcQuery() {
        this.checkPortfolio(this.tableDealOtc, this.portOtc);
        this.pageOtc.setMarketGrp("OTC");
        if (!this.rebuildPagi(this.pageOtc, this.otcChangeExtAcc)) {
            this.otcReset();
            return;
        }
        try {
            this.otcChangeExtAcc = false;
            this.ccsDealHisService.query((HisQueryPage<ObExecution>)this.pageOtc);
        }
        catch (MException | IOException e) {
            logger.error("\u573a\u5916\u57fa\u91d1" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u573a\u5916\u57fa\u91d1" + e.getMessage()));
        }
        if (this.pageOtc.getDataList().size() == 0) {
            this.tableDealOtc.scrollToColumnIndex(0);
        }
        this.tableDealOtc.scrollTo(0);
        this.tableDealOtc.sort();
        Platform.runLater(() -> this.tableDealOtc.refresh());
    }

    @Override
    protected void queryAll() {
        super.queryAll();
        this.blockChangeExtAcc = false;
    }

    protected void blockQuery() {
    }

    private void creatTableCcs() {
        this.ccsTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObExecution)data.getValue()).getInstrument().getSecurityId()));
        this.ccsColSecName.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityNameProperty());
        this.ccsColDir.setCellValueFactory(data -> ((ObExecution)data.getValue()).sideProperty());
        this.ccsColDir.setCellFactory(data -> new ObSideCell());
        this.ccsColVol.setCellFactory(column -> new NumberTableCell());
        this.ccsColVol.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastQtyProperty());
        this.ccsColUnit.setCellValueFactory(data -> ((ObExecution)data.getValue()).unitProperty());
        this.ccsColPrice.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastPxProperty());
        this.ccsColPrice.setCellFactory(data -> new HisNewQueryPart.PriceCell());
        this.ccsColAmt.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastAmountProperty());
        this.ccsColAmt.setCellFactory(data -> new HisNewQueryPart.PriceCell());
        this.ccsColMkt.setCellValueFactory(data -> ((ObExecution)data.getValue()).marketProperty());
        this.ccsColPort.setCellValueFactory(data -> ((ObExecution)data.getValue()).portfolioNameProperty());
        this.ccsColPort.setCellFactory(data -> new TooltipTableCell<ObExecution, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((ObExecution)this.getValue()).getPortfolioName();
            }
        });
        this.ccsColTime.setCellValueFactory(data -> ((ObExecution)data.getValue()).execTimeProperty());
        this.ccsColDate.setCellValueFactory(data -> ((ObExecution)data.getValue()).execDateProperty());
        this.ccsColENo.setCellValueFactory(data -> ((ObExecution)data.getValue()).extOrderIdProperty());
        this.ccsColDealNo.setCellValueFactory(data -> ((ObExecution)data.getValue()).execIdProperty());
        this.ccsColAcc.setCellValueFactory(data -> ((ObExecution)data.getValue()).investorIdProperty());
        this.ccsColSecAcc.setCellValueFactory(data -> ((ObExecution)data.getValue()).investorSecIdProperty());
        this.ccsColReference.setCellValueFactory(data -> ((ObExecution)data.getValue()).instructionIdProperty());
        this.ccsTableDeal.setItems(this.pageCcs.getDataList());
        this.reactMap.put(this.ccsColSecId.getId(), "SecurityId");
        this.reactMap.put(this.ccsColSecName.getId(), "SecurityName");
        this.reactMap.put(this.ccsColDir.getId(), "Side");
        this.reactMap.put(this.ccsColVol.getId(), "LastQty");
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.reactMap.put(this.ccsColPrice.getId(), "LastPx");
        this.reactMap.put(this.ccsColAmt.getId(), "LastAmount");
        this.reactMap.put(this.ccsColTime.getId(), "ExecTime");
        this.reactMap.put(this.ccsColDate.getId(), "ExecDate");
        this.reactMap.put(this.ccsColMkt.getId(), "Market");
        this.reactMap.put(this.ccsColENo.getId(), "ExtOrderId");
        this.reactMap.put(this.ccsColDealNo.getId(), "ExecId");
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.reactMap.put(this.ccsColSecAcc.getId(), "InvestorSecId");
        this.reactMap.put(this.ccsColReference.getId(), "InstructionId");
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
    }

    private void creatTableOtc() {
        this.tableDealOtc.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.indexOtc);
        this.indexOtc.setSortable(false);
        this.secIdOtc.setCellValueFactory(data -> new SimpleObjectProperty((Object)((ObExecution)data.getValue()).getInstrument().getSecurityId()));
        this.secNameOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).securityNameProperty());
        this.secSubType.setCellValueFactory(data -> ((ObExecution)data.getValue()).secSubTypeProperty());
        this.dirOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).sideProperty());
        this.dirOtc.setCellFactory(data -> new ObSideCell());
        this.volOtc.setCellFactory(column -> new DoubleTableCell());
        this.volOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastQtyProperty());
        this.unitOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).unitProperty());
        this.priceOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastPxProperty());
        this.priceOtc.setCellFactory(data -> new DoubleTableCell(4));
        this.fee.setCellValueFactory(data -> ((ObExecution)data.getValue()).execFeeProperty());
        this.fee.setCellFactory(data -> new HisNewQueryPart.PriceCell());
        this.amtOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).lastAmountProperty());
        this.amtOtc.setCellFactory(data -> new HisNewQueryPart.PriceCell());
        this.mktOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).marketProperty());
        this.portOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).portfolioNameProperty());
        this.portOtc.setCellFactory(data -> new TooltipTableCell<ObExecution, String>(){

            public String tooltip() {
                return this.getValue() == null ? "" : ((ObExecution)this.getValue()).getPortfolioName();
            }
        });
        this.timeOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).execTimeProperty());
        this.dateOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).execDateProperty());
        this.eNoOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).extOrderIdProperty());
        this.dealNoOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).execIdProperty());
        this.accOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).investorIdProperty());
        this.secAccOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).investorSecIdProperty());
        this.referenceOtc.setCellValueFactory(data -> ((ObExecution)data.getValue()).instructionIdProperty());
        this.tableDealOtc.setItems(this.pageOtc.getDataList());
        this.reactMap.put(this.secIdOtc.getId(), "SecurityId");
        this.reactMap.put(this.secNameOtc.getId(), "SecurityName");
        this.reactMap.put(this.dirOtc.getId(), "Side");
        this.reactMap.put(this.volOtc.getId(), "LastQty");
        this.reactMap.put(this.unitOtc.getId(), "Unit");
        this.reactMap.put(this.priceOtc.getId(), "LastPx");
        this.reactMap.put(this.amtOtc.getId(), "LastAmount");
        this.reactMap.put(this.timeOtc.getId(), "ExecTime");
        this.reactMap.put(this.dateOtc.getId(), "ExecDate");
        this.reactMap.put(this.mktOtc.getId(), "Market");
        this.reactMap.put(this.eNoOtc.getId(), "ExtOrderId");
        this.reactMap.put(this.dealNoOtc.getId(), "ExecId");
        this.reactMap.put(this.accOtc.getId(), "InvestorId");
        this.reactMap.put(this.secAccOtc.getId(), "InvestorSecId");
        this.reactMap.put(this.referenceOtc.getId(), "InstructionId");
        this.reactMap.put(this.portOtc.getId(), "PortfolioName");
        this.reactMap.put(this.secSubType.getId(), "SecSubType");
        this.reactMap.put(this.fee.getId(), "ExecFee");
    }

    @FXML
    private void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableDeal);
    }

    @FXML
    private void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    private void ccsCopyOtc() {
        TableUtils.copyContentWithHead(this.tableDealOtc);
    }

    @FXML
    private void ccsRefreshOtc() {
        this.otcQuery();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.pageCcs.setMarketGrp("CCS");
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObExecution> page = this.ccsDealHisService.getAllCcsData((HisQueryPage<ObExecution>)this.pageCcs);
                    ExcelUtils.writeExcel(this.ccsTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ccsExportExcelOtc() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcelOtc.setDisable(true);
            this.pageOtc.setMarketGrp("OTC");
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObExecution> page = this.ccsDealHisService.getAllCcsData((HisQueryPage<ObExecution>)this.pageOtc);
                    ExcelUtils.writeExcel(this.tableDealOtc, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcelOtc.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcelOtc.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private class FeeCell
    extends DoubleTableCell<CtpDeal> {
        int scale = 3;

        private FeeCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

