/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.ZeroDoubleTableCell;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.InstructionHisNewDialog;
import cms.tmx.query.history.models.InstructionHisNewServiceImpl;
import cms.tmx.query.history.views.InstructionSideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class InstructionHisNewQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbPort;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField referenceIdSearch;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    private MObjFactory of;
    @Inject
    private IAccountService accntService;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private MxAlert alert;
    @Inject
    private DialogFactory df;
    private HisQueryPage<ObInstruction> pageCcs = new HisQueryPage();
    @FXML
    private TableView<ObInstruction> tableInstruction;
    @FXML
    private TableColumn<ObInstruction, String> colInsId;
    @FXML
    private TableColumn<ObInstruction, String> colBelongTo;
    @FXML
    private TableColumn<ObInstruction, String> colInsType;
    @FXML
    private TableColumn<ObInstruction, String> colInsStatus;
    @FXML
    private TableColumn<ObInstruction, Number> colInsProgress;
    @FXML
    private TableColumn<ObInstruction, Number> colInsOrderProgress;
    @FXML
    private TableColumn<ObInstruction, Object> colInsDetail;
    @FXML
    private TableColumn<ObInstruction, String> colInsBeginTime;
    @FXML
    private TableColumn<ObInstruction, String> colInsEndTime;
    @FXML
    private TableColumn<ObInstruction, String> colIndex;
    @FXML
    private TableColumn<ObInstruction, Number> colQty;
    @FXML
    private TableColumn<ObInstruction, Number> colCumAmount;
    @FXML
    private TableColumn<ObInstruction, Number> colAvgPx;
    @FXML
    private TableColumn<ObInstruction, String> colSide;
    @FXML
    private TableColumn<ObInstruction, String> colSecId;
    @FXML
    private TableColumn<ObInstruction, String> colSecName;
    @FXML
    private TableColumn<ObInstruction, String> colInsPrice;
    @FXML
    private TableColumn<ObInstruction, Number> colOrderAmount;
    @FXML
    private TableColumn<ObInstruction, String> colExpiredDate;
    @Inject
    private InstructionHisNewServiceImpl instrMng;
    private static final Logger logger = LogManager.getLogger(InstructionHisNewQueryPart.class);
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private boolean changeExtAcc = false;
    private StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @FXML
    private void initialize() {
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.query();
        this.focusRefresh(this.tableInstruction);
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldEnd = LocalDate.now();
        this.beginDateText.setValue((Object)ldEnd);
        this.endDateText.setValue((Object)ldEnd);
        MxNode node = MxNodeFactory.create((String)"query_dimension", (String)"1");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("1")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.referenceIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 18));
        this.referenceIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)listAcc);
            for (Account acc : listAcc) {
                if (acc.isExternalAsset()) continue;
                this.ccmbAccnt.getItems().add((Object)acc);
            }
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAcc.add(account.getInvestorId());
            }
            String accStr = listAcc.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.changeExtAcc = true;
        this.pageCcs.setReferenceId(this.referenceIdSearch.getText());
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    private void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (this.changeExtAcc) {
            this.changeExtAcc = false;
            LinkedList<String> list = new LinkedList<String>();
            HashSet setExtAcc = new HashSet();
            if (dimension.equals("1")) {
                this.fundAccntService.getExtAssetFundAccs().forEach(item -> {
                    if (this.lbAccnt.getText().contains(item.getInvestId()) && !StringUtils.isEmpty((String)item.getNewCashAccntId())) {
                        setExtAcc.add(item.getNewCashAccntId());
                    }
                });
                orderPage.setAccountIdList(new LinkedList(setExtAcc));
                if (setExtAcc.isEmpty()) {
                    return false;
                }
            } else {
                for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                    if (portfolio.getId().isEmpty()) continue;
                    list.add(portfolio.getId());
                }
                orderPage.setPortfolioIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            }
        }
        return !("1".equals(dimension) ? orderPage.getAccountIdList().isEmpty() : orderPage.getPortfolioIdList().isEmpty());
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    private void ccsQuery() {
        if (!this.rebuildPagi(this.pageCcs)) {
            this.ccsReset();
            return;
        }
        try {
            this.instrMng.query(this.pageCcs);
        }
        catch (MException | Exception e) {
            logger.error("\u6307\u4ee4\u67e5\u8be2\u5931\u8d25" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u67e5\u8be2\u5931\u8d25" + e.getMessage()));
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.tableInstruction.scrollToColumnIndex(0);
        }
        this.tableInstruction.scrollTo(0);
        this.tableInstruction.sort();
    }

    private void createTable() {
        this.colInsId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).idProperty());
        this.reactMap.put(this.colInsId.getId(), "Id");
        this.colBelongTo.setCellValueFactory(data -> ((ObInstruction)data.getValue()).belongToProperty());
        this.reactMap.put(this.colBelongTo.getId(), "BelongTo");
        this.colInsType.setCellValueFactory(data -> ((ObInstruction)data.getValue()).typeNameProperty());
        this.reactMap.put(this.colInsType.getId(), "TypeName");
        this.colInsProgress.setCellValueFactory(data -> ((ObInstruction)data.getValue()).ratioProperty());
        this.reactMap.put(this.colInsProgress.getId(), "Ratio");
        this.colInsProgress.setCellFactory(data -> new DoubleTableCell());
        this.colInsOrderProgress.setCellValueFactory(data -> ((ObInstruction)data.getValue()).orderRatioProperty());
        this.reactMap.put(this.colInsOrderProgress.getId(), "OrderRatio");
        this.colInsOrderProgress.setCellFactory(data -> new DoubleTableCell());
        this.colInsStatus.setCellValueFactory(data -> ((ObInstruction)data.getValue()).statusNameProperty());
        this.reactMap.put(this.colInsStatus.getId(), "StatusName");
        this.colInsDetail.setCellValueFactory(data -> this.setDetail((ObInstruction)data.getValue()));
        this.reactMap.put(this.colInsDetail.getId(), "colInsDetail");
        this.colInsBeginTime.setCellValueFactory(data -> ((ObInstruction)data.getValue()).beginTimeProperty());
        this.reactMap.put(this.colInsBeginTime.getId(), "BeginTime");
        this.colInsEndTime.setCellValueFactory(data -> ((ObInstruction)data.getValue()).endTimeProperty());
        this.reactMap.put(this.colInsEndTime.getId(), "EndTime");
        this.colCumAmount.setCellValueFactory(data -> ((ObInstruction)data.getValue()).cumAmountProperty());
        this.colCumAmount.setCellFactory(cell -> new ZeroDoubleTableCell(4));
        this.reactMap.put(this.colCumAmount.getId(), "CumAmount");
        this.colOrderAmount.setCellValueFactory(data -> ((ObInstruction)data.getValue()).orderAmountProperty());
        this.colOrderAmount.setCellFactory(cell -> new DoubleTableCell(4));
        this.reactMap.put(this.colOrderAmount.getId(), "OrderAmount");
        this.colAvgPx.setCellValueFactory(data -> ((ObInstruction)data.getValue()).avgPxProperty());
        this.colAvgPx.setCellFactory(cell -> new AvgPriceCell());
        this.reactMap.put(this.colAvgPx.getId(), "AvgPx");
        this.colQty.setCellValueFactory(data -> ((ObInstruction)data.getValue()).totalExpectationQtyProperty());
        this.colQty.setCellFactory(cell -> new DoubleTableCell());
        this.reactMap.put(this.colQty.getId(), "TotalExpectationQty");
        this.colSide.setCellValueFactory(data -> ((ObInstruction)data.getValue()).sideNameProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
        this.reactMap.put(this.colSide.getId(), "SideName");
        this.colSecId.setCellValueFactory(data -> ((ObInstruction)data.getValue()).securityCodeProperty());
        this.reactMap.put(this.colSecId.getId(), "SecurityCode");
        this.colSecName.setCellValueFactory(data -> ((ObInstruction)data.getValue()).securityNameProperty());
        this.reactMap.put(this.colSecName.getId(), "SecurityName");
        this.colExpiredDate.setCellValueFactory(data -> ((ObInstruction)data.getValue()).expireDateProperty());
        this.reactMap.put(this.colExpiredDate.getId(), "ExpireDate");
        this.colInsPrice.setCellValueFactory(data -> ((ObInstruction)data.getValue()).insPriceStrProperty());
        this.reactMap.put(this.colInsPrice.getId(), "InsPriceStr");
        this.colInsId.setSortType(TableColumn.SortType.DESCENDING);
        TableUtils.isAuto(this.colIndex);
        this.tableInstruction.setItems(this.pageCcs.getDataList());
        this.tableInstruction.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableInstruction);
    }

    private ReadOnlyObjectWrapper<Object> setDetail(ObInstruction instruction) {
        HBox box = new HBox(){

            public String toString() {
                return "\u8be6\u60c5";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button detail = new Button("\u8be6\u60c5");
        detail.getStyleClass().add((Object)"btnOperation");
        detail.setOnAction(event -> this.showDetail(instruction));
        box.getChildren().addAll((Object[])new Node[]{detail});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showDetail(ObInstruction instruction) {
        this.tableInstruction.getSelectionModel().select((Object)instruction);
        logger.info("instruction showDetail\u5386\u53f2\u6307\u4ee4\u8be6\u60c5" + instruction.getId() + "|" + instruction.getStatusName() + "|" + instruction.getEntryId());
        InstructionHisNewDialog obj = (InstructionHisNewDialog)((Object)this.of.create(InstructionHisNewDialog.class));
        ObSimpleInstruction ins = new ObSimpleInstruction();
        ins.setId(instruction.getId());
        ins.setStatus(instruction.getStatus());
        ins.setMarket(instruction.getMarket());
        ins.setMarketGrp(instruction.getMarketGrp());
        ins.setEntryId(instruction.getEntryId());
        if (instruction.getBeginTime().length() > 7) {
            ins.setBeginDate(instruction.getBeginTime().substring(0, 8));
        }
        ins.setExpireDate(instruction.getExpireDate());
        obj.setInstruction(ins);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableInstruction);
    }

    @FXML
    private void refresh() {
        this.ccsQuery();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6307\u4ee4\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    ExcelUtils.writeExcel(this.tableInstruction, this.instrMng.exportIns(this.pageCcs), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private class AvgPriceCell
    extends DoubleTableCell<ObInstruction> {
        int scale = 4;

        private AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            }
        }
    }
}

