/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.combobox.ComboBoxCheckModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javax.inject.Inject;

public class HisQueryPart<S, T, X>
extends MxPart {
    protected static final String FORMAT = "yyyy-MM-dd";
    private int scale = 3;
    @FXML
    protected Tab ccsTab;
    @FXML
    protected Tab ctpTab;
    @FXML
    protected TabPane tabPane;
    @FXML
    protected DatePicker beginDateText;
    @FXML
    protected DatePicker endDateText;
    @FXML
    protected ComboBox<MxNode> btnDimension;
    @FXML
    protected ComboBox<Account> ccmbAccnt;
    @FXML
    protected ComboBox<Portfolio> ccmbPort;
    @FXML
    protected ComboBox<AssetGrp> ccmbAsset;
    @FXML
    protected ComboBox<AssetGrp> ccmbPorts;
    @FXML
    protected Label lbPort;
    @FXML
    protected Label lbAsset;
    @FXML
    protected Label lbAccnts;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private GridPane gridPorts;
    @FXML
    private GridPane gridAsset;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private ComboBox<MxNode> ctpPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Pagination ctpPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private Label ctpTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField ctpJumpPage;
    @FXML
    protected TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IAccountService accntService;
    @Inject
    private IBaseApi iba;
    @Inject
    protected PortfolioAccountModel subAccMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    private List<AssetGrp> listAsset;
    private List<AssetGrp> listAssets;
    @Inject
    protected MxAlert alert;
    protected HisQueryPage<S> pageCcs = new HisQueryPage();
    protected HisQueryPage<T> pageCtp = new HisQueryPage();
    protected HisQueryPage<X> pageBlock = new HisQueryPage();
    protected boolean ccsChangeExtAcc = false;
    protected boolean ctpChangeExtAcc = false;
    protected boolean blockChangeExtAcc = false;
    protected boolean assetGrp = false;
    private Set<String> accSet = new HashSet<String>();
    private Set<String> portfSet = new HashSet<String>();
    protected ComboBoxCheckModel<Account> accountModel;
    protected ComboBoxCheckModel<Portfolio> portfolioModel;
    protected ComboBoxCheckModel<AssetGrp> assetGrpModel;
    protected ComboBoxCheckModel<AssetGrp> assetGrpPortModel;
    protected Predicate<Account> accountPd = inst -> {
        String idName = this.ccmbAccnt.getEditor().getText().trim();
        return inst.getName().contains(idName) || inst.getInvestorId().contains(idName);
    };
    protected Comparator<Account> accountCp = (u, o) -> {
        if (u == o) {
            return 0;
        }
        if (u.getId().isEmpty() && !o.getId().isEmpty()) {
            return -1;
        }
        if (!u.getId().isEmpty() && o.getId().isEmpty()) {
            return 1;
        }
        return 1;
    };
    protected Predicate<Portfolio> portfolioPd = inst -> {
        String idName = this.ccmbPort.getEditor().getText().trim();
        return inst.getName().contains(idName);
    };
    protected Comparator<Portfolio> portfolioCp = (u, o) -> {
        if (u == o) {
            return 0;
        }
        if (u.getId().isEmpty() && !o.getId().isEmpty()) {
            return -1;
        }
        if (!u.getId().isEmpty() && o.getId().isEmpty()) {
            return 1;
        }
        return 1;
    };
    protected Predicate<AssetGrp> assetGrpPd = inst -> {
        String idName = this.ccmbAsset.getEditor().getText().trim();
        return inst.getName().contains(idName);
    };
    protected Predicate<AssetGrp> assetGrpPortPd = inst -> {
        String idName = this.ccmbPorts.getEditor().getText().trim();
        return inst.getName().contains(idName);
    };
    protected Comparator<AssetGrp> assetGrpCp = (u, o) -> {
        if (u == o) {
            return 0;
        }
        if (u.getId().isEmpty() && !o.getId().isEmpty()) {
            return -1;
        }
        if (!u.getId().isEmpty() && o.getId().isEmpty()) {
            return 1;
        }
        return 1;
    };

    @FXML
    protected void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.pageCtp.setMarketGrp("FUTURES");
        this.pageBlock.setMarketGrp("CCS");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.pageCtp.changedProperty().addListener(ob -> this.queryAll());
        this.pageBlock.changedProperty().addListener(ob -> this.queryAll());
    }

    protected void initValue() {
        this.setDate();
        MxNode node = this.assetGrp ? MxNodeFactory.create((String)"query_dimension_assetgrp", (String)"1") : MxNodeFactory.create((String)"query_dimension", (String)"1");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if ("1".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else if ("2".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            } else if (this.assetGrp && "6".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAsset});
            } else if (this.assetGrp && "7".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPorts});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        if (this.assetGrp) {
            this.initCheckBoxAsset();
            this.initCheckBoxPorts();
        }
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
        this.initPage(this.ctpPagination, this.ctpTotalCount, this.ctpJumpPage, this.ctpPageSize, this.pageCtp);
    }

    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            listAcc.add(0, (Object)account);
            List collect = listAcc.stream().filter(item -> !Account.isNewFrame((Account)item) && !item.isExternalAsset()).collect(Collectors.toList());
            this.accountModel = new ComboBoxCheckModel(this.ccmbAccnt);
            this.accountModel.initCellFactroy();
            this.accountModel.initData(collect, this.accountPd, this.accountCp);
            this.tabHide((ObservableList<Account>)listAcc);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfolios();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        listPort.add(0, portfolio);
        this.portfolioModel = new ComboBoxCheckModel(this.ccmbPort);
        this.portfolioModel.initCellFactroy();
        this.portfolioModel.initData(listPort, this.portfolioPd, this.portfolioCp);
    }

    private void initCheckBoxAsset() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            ArrayList list = new ArrayList();
            list.addAll(this.accntService.getAccountListByParty(this.iba.getPartyId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll(this.accntService.getAccountListByParty(this.iba.getPartyId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            for (Account acc : list) {
                if (!acc.isExternalAsset()) continue;
                this.accSet.add(acc.getId());
            }
            this.listAsset = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "1".equals(item.getType().getRaw())) {
                    String[] ids = item.getAssetUnitId().split(",");
                    boolean flag = true;
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String accId = stringArray[n2];
                        if (this.accSet.contains(accId)) {
                            flag = false;
                            break;
                        }
                        ++n2;
                    }
                    if (flag) {
                        this.listAsset.add((AssetGrp)item);
                    }
                }
            });
            this.listAsset.add(0, asset);
            this.assetGrpModel = new ComboBoxCheckModel(this.ccmbAsset);
            this.assetGrpModel.initCellFactroy();
            this.assetGrpModel.initData(this.listAsset, this.assetGrpPd, this.assetGrpCp);
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
    }

    private void initCheckBoxPorts() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            List listPortfolio = this.portfolioMng.getPortfoliosByParty(this.iba.getPartyId());
            for (Portfolio port : listPortfolio) {
                if (!port.isExternalAsset()) continue;
                this.portfSet.add(port.getId());
            }
            this.listAssets = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "3".equals(item.getType().getRaw())) {
                    String[] ids = item.getAssetUnitId().split(",");
                    boolean flag = true;
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String portId = stringArray[n2];
                        if (this.portfSet.contains(portId)) {
                            flag = false;
                            break;
                        }
                        ++n2;
                    }
                    if (flag) {
                        this.listAssets.add((AssetGrp)item);
                    }
                }
            });
            this.listAssets.add(0, asset);
            this.assetGrpPortModel = new ComboBoxCheckModel(this.ccmbPorts);
            this.assetGrpPortModel.initCellFactroy();
            this.assetGrpPortModel.initData(this.listAssets, this.assetGrpPortPd, this.assetGrpCp);
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
    }

    @FXML
    protected void query() {
        this.pageCcs.clear();
        this.pageCtp.clear();
        this.pageBlock.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.pageCtp.setDimension(raw);
        this.pageBlock.setDimension(raw);
        this.ccsChangeExtAcc = true;
        this.ctpChangeExtAcc = true;
        this.blockChangeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.pageCtp.setSecurityId(this.secIdSearch.getText());
        this.pageBlock.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
        this.layout();
    }

    @FXML
    protected void queryAll() {
        this.ccsQuery();
        this.ctpQuery();
        this.ccsChangeExtAcc = false;
        this.ctpChangeExtAcc = false;
    }

    @FXML
    protected void ccsQuery() {
    }

    @FXML
    protected void ctpQuery() {
    }

    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
        if (!marketGrpList.contains("FUTURES")) {
            this.tabPane.getTabs().remove((Object)this.ctpTab);
        }
    }

    protected <E> void checkPortfolio(TableView<E> tableBase, TableColumn<E, ?> portfolio) {
        String dimension = this.pageCcs.getDimension();
        ObservableList columns = tableBase.getColumns();
        if ("1".equals(dimension) || "6".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
        } else if (!columns.contains(portfolio)) {
            columns.add(portfolio);
        }
    }

    protected void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    protected void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    protected boolean rebuildPagi(HisQueryPage<?> orderPage, boolean queryAll) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (queryAll) {
            ObservableList listAcc = FxUtils.newList();
            LinkedList<String> list = new LinkedList<String>();
            List checkItems = this.accountModel.getCheckItems();
            List checkIds = checkItems.stream().map(Account::getId).collect(Collectors.toList());
            if (dimension.equals("1")) {
                this.fundAccntService.getAllFundAccountList().forEach(arg_0 -> HisQueryPart.lambda$23(orderPage, checkIds, (List)listAcc, arg_0));
                orderPage.setExtAccntIdList((List)listAcc);
                if (listAcc.isEmpty()) {
                    return false;
                }
            } else if ("2".equals(dimension)) {
                for (Portfolio portfolio : this.portfolioModel.getCheckItems()) {
                    if (portfolio.getId().isEmpty()) continue;
                    for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                        if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                        CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                        list.add(subFundAccnt.getSubAccntId());
                    }
                }
                orderPage.setSubAccntIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            } else if (this.assetGrp && "6".equals(dimension)) {
                for (AssetGrp asset : this.assetGrpModel.getCheckItems()) {
                    if (asset.getId().isEmpty()) continue;
                    list.add(asset.getId());
                }
                orderPage.setAssetGrpIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            } else if ("7".equals(dimension)) {
                for (AssetGrp asset : this.assetGrpPortModel.getCheckItems()) {
                    if (asset.getId().isEmpty()) continue;
                    list.add(asset.getId());
                }
                orderPage.setAssetsGrpIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            }
        }
        return !("1".equals(dimension) ? orderPage.getExtAccntIdList().isEmpty() : ("2".equals(dimension) ? orderPage.getSubAccntIdList().isEmpty() : ("6".equals(dimension) ? orderPage.getAssetGrpIdList().isEmpty() : "7".equals(dimension) && orderPage.getAssetsGrpIdList().isEmpty())));
    }

    protected void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    protected void ctpReset() {
        this.ctpPagination.setPageCount(1);
        this.ctpTotalCount.setText("0");
    }

    protected boolean isPortDimension() {
        return ((MxNode)this.btnDimension.getValue()).getRaw().equals("2");
    }

    protected boolean isAssetGrpDimension() {
        return ((MxNode)this.btnDimension.getValue()).getRaw().equals("6") || ((MxNode)this.btnDimension.getValue()).getRaw().equals("7");
    }

    private RefItem getScale(Object obj) {
        RefItem item = null;
        if (obj instanceof CcsOrder) {
            CcsOrder order = (CcsOrder)CcsOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        } else if (obj instanceof CtpOrder) {
            CtpOrder order = (CtpOrder)CtpOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        } else if (obj instanceof BlockDeal) {
            BlockDeal deal = (BlockDeal)BlockDeal.class.cast(obj);
            item = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
        } else if (obj instanceof BlockOrder) {
            BlockOrder order = (BlockOrder)BlockOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        }
        return item;
    }

    protected void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    private static /* synthetic */ void lambda$23(HisQueryPage hisQueryPage, List list, List list2, FundAccount item) {
        String marketGrp = hisQueryPage.getMarketGrp();
        if (list.contains(item.getParentId()) && marketGrp.equals(item.getMarketGrp())) {
            list2.add(item.getExtAccntId());
        }
    }

    protected class AvgPriceCell<E>
    extends DoubleTableCell<E> {
        protected AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                Object obj = this.getTableRow().getItem();
                if (obj == null) {
                    return;
                }
                RefItem ref = HisQueryPart.this.getScale(obj);
                int sca = ref == null ? HisQueryPart.this.scale : ref.getScale() + 1;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)sca));
            }
        }
    }

    protected class PriceCell<E>
    extends DoubleTableCell<E> {
        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                Object obj = this.getTableRow().getItem();
                if (obj == null) {
                    return;
                }
                RefItem ref = HisQueryPart.this.getScale(obj);
                int sca = ref == null ? HisQueryPart.this.scale : ref.getScale() + 1;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)sca));
            }
        }
    }
}

