/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class HisNewQueryPart<S>
extends MxPart {
    protected static final String FORMAT = "yyyy-MM-dd";
    private int scale = 3;
    @FXML
    protected Tab ccsTab;
    @FXML
    protected TabPane tabPane;
    @FXML
    protected DatePicker beginDateText;
    @FXML
    protected DatePicker endDateText;
    @FXML
    protected ComboBox<MxNode> btnDimension;
    @FXML
    protected CheckComboBox<Account> ccmbAccnt;
    @FXML
    protected CheckComboBox<Portfolio> ccmbPort;
    @FXML
    protected CheckComboBox<AssetGrp> ccmbPorts;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected Label lbPort;
    @FXML
    protected Label lbAccnts;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private GridPane gridPorts;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private ComboBox<MxNode> ccsPageSizeOtc;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Pagination ccsPaginationOtc;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private Label ccsTotalCountOtc;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField ccsJumpPageOtc;
    @FXML
    protected TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IAccountService accntService;
    @Inject
    private IBaseApi iba;
    @Inject
    protected PortfolioAccountModel subAccMng;
    @Inject
    protected OtcPortfolioAccountModel otcAccMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    private List<AssetGrp> listAsset;
    private List<AssetGrp> listAssets;
    @Inject
    protected MxAlert alert;
    @Inject
    protected IFundAccountService fundApi;
    protected HisQueryPage<S> pageCcs = new HisQueryPage();
    protected HisQueryPage<S> pageOtc = new HisQueryPage();
    protected boolean ccsChangeExtAcc = false;
    protected boolean otcChangeExtAcc = false;
    protected boolean ctpChangeExtAcc = false;
    protected boolean blockChangeExtAcc = false;
    protected boolean assetGrp = false;
    protected StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };

    @FXML
    protected void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.pageOtc.setMarketGrp("OTC");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.pageOtc.changedProperty().addListener(ob -> this.queryAll());
    }

    protected void initValue() {
        MxNode node;
        this.setDate();
        if (this.assetGrp) {
            node = MxNodeFactory.createNew((String)"query_dimension_assetgrp", (String)"1");
            node.removeNode("6");
        } else {
            node = MxNodeFactory.create((String)"query_dimension", (String)"1");
        }
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if ("1".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else if ("2".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            } else if (this.assetGrp && "7".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPorts});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        this.initCheckBoxPorts();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
        this.initPage(this.ccsPaginationOtc, this.ccsTotalCountOtc, this.ccsJumpPageOtc, this.ccsPageSizeOtc, this.pageOtc);
    }

    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now();
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
    }

    private void initCheckBoxAcc() {
        try {
            LinkedList ids = new LinkedList();
            List fundAccountList1 = this.fundApi.getFundAccountList("CCS");
            this.fundApi.getNeeqFundAccountList();
            fundAccountList1.forEach(fundAccount -> {
                boolean bl = ids.add(fundAccount.getNewCashAccntId());
            });
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)listAcc);
            this.ccmbAccnt.getItems().addAll((Collection)listAcc);
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAcc.add(account.getInvestorId());
            }
            String accStr = listAcc.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfoliosAll();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void initCheckBoxAsset() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            this.listAsset = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && !"3".equals(item.getType().getRaw())) {
                    this.listAsset.add((AssetGrp)item);
                }
            });
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
    }

    private void initCheckBoxPorts() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            this.ccmbPorts.getItems().add((Object)asset);
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            this.listAssets = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "3".equals(item.getType().getRaw())) {
                    this.listAssets.add((AssetGrp)item);
                }
            });
            this.ccmbPorts.getItems().addAll(this.listAssets);
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPorts);
        checkComboBoxModel.init();
        this.ccmbPorts.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPorts.getCheckModel().getCheckedItems();
            ObservableList listAssetId = FxUtils.newList();
            for (AssetGrp item : checkedItems) {
                if (item.getId().isEmpty()) continue;
                listAssetId.add(item.getName());
            }
            String assetStr = listAssetId.toString();
            this.lbAccnts.setText(assetStr.substring(1, assetStr.length() - 1));
            this.lbAccnts.setTooltip(new Tooltip(this.lbAccnts.getText()));
        });
        this.ccmbPorts.getCheckModel().checkAll();
    }

    @FXML
    protected void query() {
        this.pageCcs.clear();
        this.pageOtc.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.pageOtc.setDimension(raw);
        this.ccsChangeExtAcc = true;
        this.otcChangeExtAcc = true;
        this.ctpChangeExtAcc = true;
        this.blockChangeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.pageOtc.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
        this.layout();
    }

    @FXML
    protected void queryAll() {
        this.otcQuery();
        this.ccsQuery();
        this.ccsChangeExtAcc = false;
        this.otcChangeExtAcc = false;
        this.ctpChangeExtAcc = false;
    }

    @FXML
    protected void ccsQuery() {
    }

    @FXML
    protected void otcQuery() {
    }

    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    protected <E> void checkPortfolio(TableView<E> tableBase, TableColumn<E, ?> portfolio) {
        String dimension = this.pageCcs.getDimension();
        ObservableList columns = tableBase.getColumns();
        if ("1".equals(dimension) || "6".equals(dimension)) {
            if (columns.contains(portfolio)) {
                columns.remove(portfolio);
            }
        } else if (!columns.contains(portfolio)) {
            columns.add(portfolio);
        }
    }

    protected void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    protected void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    protected boolean rebuildPagi(HisQueryPage<?> orderPage, boolean queryAll) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (queryAll) {
            ObservableList listNewAcc = FxUtils.newList();
            LinkedList<String> list = new LinkedList<String>();
            LinkedList<String> listPortfolio = new LinkedList<String>();
            HashSet<String> setExtAcc = new HashSet<String>();
            HashSet<String> portfolioIdSet = new HashSet<String>();
            if (dimension.equals("1")) {
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    this.fundAccntService.getExtAssetFundAccs().forEach(arg_0 -> this.lambda$17(orderPage, (List)listNewAcc, arg_0));
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (CcsFundAccount ccsFundAccount : this.otcAccMng.getFundAccounts()) {
                        if (!(ccsFundAccount instanceof CcsSubFundAccount) || !this.lbAccnt.getText().contains(ccsFundAccount.getInvestId())) continue;
                        CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                        listNewAcc.add(subFundAccnt.getNewCashAccntId());
                    }
                }
                orderPage.setNewAccntIdList((List)listNewAcc);
                if (listNewAcc.isEmpty()) {
                    return false;
                }
            } else if ("2".equals(dimension)) {
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                        if (portfolio.getId().isEmpty() || this.subAccMng.getMap(portfolio) == null) continue;
                        listPortfolio.add(portfolio.getId());
                        for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            list.add(subFundAccnt.getNewCashAccntId());
                        }
                    }
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                        if (portfolio.getId().isEmpty() || this.otcAccMng.getMap(portfolio) == null) continue;
                        listPortfolio.add(portfolio.getId());
                        for (CcsFundAccount fundAccnt : this.otcAccMng.getMap(portfolio).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            list.add(subFundAccnt.getNewCashAccntId());
                        }
                    }
                }
                orderPage.setPortfolioIdList(listPortfolio);
                orderPage.setNewAccntIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            } else if ("7".equals(dimension)) {
                for (AssetGrp assetGrp : this.ccmbPorts.getCheckModel().getCheckedItems()) {
                    if (assetGrp.getId().isEmpty()) continue;
                    list.add(assetGrp.getId());
                    String[] ids = assetGrp.getAssetUnitId().split(",");
                    portfolioIdSet.addAll(Arrays.asList(ids));
                }
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    for (String string : portfolioIdSet) {
                        if (this.subAccMng.getMap(string) == null) continue;
                        for (CcsFundAccount fundAccnt : this.subAccMng.getMap(string).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPortfolio.add(string);
                    }
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (String string : portfolioIdSet) {
                        if (this.otcAccMng.getMap(string) == null) continue;
                        for (CcsFundAccount fundAccnt : this.otcAccMng.getMap(string).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPortfolio.add(string);
                    }
                }
                orderPage.setNewAccntIdList(new LinkedList(setExtAcc));
                orderPage.setPortfolioIdList(listPortfolio);
                if (list.isEmpty()) {
                    return false;
                }
            }
        }
        return !("1".equals(dimension) ? orderPage.getNewAccntIdList().isEmpty() : ("2".equals(dimension) ? orderPage.getNewAccntIdList().isEmpty() : "7".equals(dimension) && orderPage.getNewAccntIdList().isEmpty()));
    }

    protected void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    protected void otcReset() {
        this.ccsPaginationOtc.setPageCount(1);
        this.ccsTotalCountOtc.setText("0");
    }

    protected boolean isPortDimension() {
        return ((MxNode)this.btnDimension.getValue()).getRaw().equals("2");
    }

    protected boolean isAssetGrpDimension() {
        return ((MxNode)this.btnDimension.getValue()).getRaw().equals("6") || ((MxNode)this.btnDimension.getValue()).getRaw().equals("7");
    }

    private RefItem getScale(Object obj) {
        RefItem item = null;
        if (obj instanceof CcsOrder) {
            CcsOrder order = (CcsOrder)CcsOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        } else if (obj instanceof CtpOrder) {
            CtpOrder order = (CtpOrder)CtpOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        } else if (obj instanceof BlockDeal) {
            BlockDeal deal = (BlockDeal)BlockDeal.class.cast(obj);
            item = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
        } else if (obj instanceof BlockOrder) {
            BlockOrder order = (BlockOrder)BlockOrder.class.cast(obj);
            item = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        }
        return item;
    }

    protected void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    private /* synthetic */ void lambda$17(HisQueryPage hisQueryPage, List list, FundAccount item) {
        String marketGrp = hisQueryPage.getMarketGrp();
        if (this.lbAccnt.getText().contains(item.getInvestId()) && marketGrp.equals(item.getMarketGrp())) {
            list.add(item.getNewCashAccntId());
        }
    }

    protected class AvgPriceCell<E>
    extends DoubleTableCell<E> {
        protected AvgPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                Object obj = this.getTableRow().getItem();
                if (obj == null) {
                    return;
                }
                RefItem ref = HisNewQueryPart.this.getScale(obj);
                int sca = ref == null ? HisNewQueryPart.this.scale : ref.getScale() + 1;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)sca));
            }
        }
    }

    protected class PriceCell<E>
    extends DoubleTableCell<E> {
        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                Object obj = this.getTableRow().getItem();
                if (obj == null) {
                    return;
                }
                RefItem ref = HisNewQueryPart.this.getScale(obj);
                int sca = ref == null ? HisNewQueryPart.this.scale : ref.getScale() + 1;
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)sca));
            }
        }
    }
}

