/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.FutureCrossOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.EtfRefreshModel;
import cms.tmx.query.history.models.FutureCrossOrderHisServiceImpl;
import java.io.File;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class FutureCrossOrderHisQueryPart
extends MxPart {
    @FXML
    private TableView<FutureCrossOrder> tableCross;
    @FXML
    private TableColumn<FutureCrossOrder, String> index;
    @FXML
    private TableColumn<FutureCrossOrder, String> id;
    @FXML
    private TableColumn<FutureCrossOrder, String> code;
    @FXML
    private TableColumn<FutureCrossOrder, String> name;
    @FXML
    private TableColumn<FutureCrossOrder, MxNode> market;
    @FXML
    private TableColumn<FutureCrossOrder, Number> buyPrice;
    @FXML
    private TableColumn<FutureCrossOrder, Number> sellPrice;
    @FXML
    private TableColumn<FutureCrossOrder, Number> spread;
    @FXML
    private TableColumn<FutureCrossOrder, Number> buyQty;
    @FXML
    private TableColumn<FutureCrossOrder, Number> sellQty;
    @FXML
    private TableColumn<FutureCrossOrder, Number> buyDealQty;
    @FXML
    private TableColumn<FutureCrossOrder, Number> sellDealQty;
    @FXML
    private TableColumn<FutureCrossOrder, String> date;
    @FXML
    private TableColumn<FutureCrossOrder, String> time;
    @FXML
    private TableColumn<FutureCrossOrder, String> accntId;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private TextField secIdSearch;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<String> cmbDetailSum;
    @FXML
    private ComboBox<MxNode> pageSize;
    @FXML
    private Pagination pagination;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label totalCount;
    @FXML
    private TextField jumpPage;
    @FXML
    private Button btnSearch;
    @FXML
    private Tab etfTab;
    @FXML
    private TabPane tabPane;
    @Inject
    private MxAlert alert;
    @Inject
    private IFundAccountService fundAccntService;
    @Inject
    private IAccountService accntService;
    @Inject
    private MObjFactory of;
    @Inject
    private IBaseApi iba;
    @Inject
    private ExecutorService exe;
    @Inject
    private FutureCrossOrderHisServiceImpl crossOrderHisService;
    private HisQueryPage<FutureCrossOrder> orderPage;
    protected ObservableList<FutureCrossOrder> list = FxUtils.newList();
    private ObservableList<String> obList = FxUtils.newList();
    private Boolean reBuildCcsPagiCount = true;
    @Inject
    private EtfRefreshModel refreshMng;
    private Map<String, String> reactMap = new HashMap<String, String>();
    private static final Logger logger = LogManager.getLogger(FutureCrossOrderHisQueryPart.class);
    protected static final String FORMAT = "yyyy-MM-dd";
    protected ObservableList<CcsOrder> orderList = FxUtils.newList();
    @Inject
    private CtpAccountMap accountMap;
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.initValue();
        this.initPage();
        this.bind();
        this.createTable();
        this.query();
        this.cmbDetailSum.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            boolean visible = !now.equals("\u6c47\u603b");
            this.id.setVisible(visible);
            this.buyPrice.setVisible(visible);
            this.sellPrice.setVisible(visible);
            this.spread.setVisible(visible);
            this.date.setVisible(visible);
            this.time.setVisible(visible);
            this.query();
        });
    }

    @PreDestroy
    private void close() {
        this.id.setVisible(true);
        this.buyPrice.setVisible(true);
        this.sellPrice.setVisible(true);
        this.spread.setVisible(true);
        this.date.setVisible(true);
        this.time.setVisible(true);
    }

    private void etfReset() {
        this.list.clear();
        this.pagination.setPageCount(1);
        this.totalCount.setText("0");
    }

    @FXML
    private void query() {
        if (!this.checkDate().booleanValue()) {
            return;
        }
        this.list.clear();
        this.rebuildPagi(this.orderPage, this.pagination, this.pageSize, "FUTURES");
        if (this.orderPage.getExtAccntIdList().isEmpty()) {
            this.etfReset();
            return;
        }
        try {
            this.crossOrderHisService.query(this.orderPage);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.list.addAll((Collection)this.orderPage.getDataList());
        if (this.reBuildCcsPagiCount.booleanValue()) {
            this.pagination.setPageCount(this.orderPage.getTotalCount() % this.orderPage.getPageSize() == 0 ? (this.orderPage.getTotalCount() / this.orderPage.getPageSize() == 0 ? 1 : this.orderPage.getTotalCount() / this.orderPage.getPageSize()) : this.orderPage.getTotalCount() / this.orderPage.getPageSize() + 1);
        }
        this.reBuildCcsPagiCount = true;
        this.totalCount.setText(String.valueOf(this.orderPage.totalCountProperty().get()));
        this.tableCross.scrollTo(0);
        if (this.beginDateText.getValue() != null) {
            this.refreshMng.setStartDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        }
        if (this.endDateText.getValue() != null) {
            this.refreshMng.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        }
        if (this.tableCross.getItems() != null && this.tableCross.getItems().size() == 0) {
            this.tableCross.scrollToColumnIndex(0);
        }
    }

    private Boolean checkDate() {
        if (this.beginDateText.getValue() == null) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f");
            return false;
        }
        if (this.endDateText.getValue() == null) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f");
            return false;
        }
        if (((LocalDate)this.beginDateText.getValue()).isAfter((ChronoLocalDate)this.endDateText.getValue())) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            return false;
        }
        return true;
    }

    private void rebuildPagi(HisQueryPage orderPage, Pagination pagination, ComboBox<MxNode> pageSize, String marketGrp) {
        orderPage.setCurrentPage(Integer.valueOf(pagination.getCurrentPageIndex()));
        orderPage.setPageSize(Integer.valueOf(((MxNode)pageSize.getValue()).getRaw()));
        orderPage.setMarketGrp(marketGrp);
        if (this.beginDateText.getValue() != null) {
            LocalDate beginDate = (LocalDate)this.beginDateText.getValue();
            StringBuilder bDateSb = new StringBuilder();
            bDateSb.append(beginDate.getYear()).append(beginDate.getMonthValue() < 10 ? "0" + beginDate.getMonthValue() : Integer.valueOf(beginDate.getMonthValue())).append(beginDate.getDayOfMonth() < 10 ? "0" + beginDate.getDayOfMonth() : Integer.valueOf(beginDate.getDayOfMonth()));
            orderPage.setBeginDate(bDateSb.toString());
        }
        if (this.endDateText.getValue() != null) {
            LocalDate endDate = (LocalDate)this.endDateText.getValue();
            StringBuilder eDateSb = new StringBuilder();
            eDateSb.append(endDate.getYear()).append(endDate.getMonthValue() < 10 ? "0" + endDate.getMonthValue() : Integer.valueOf(endDate.getMonthValue())).append(endDate.getDayOfMonth() < 10 ? "0" + endDate.getDayOfMonth() : Integer.valueOf(endDate.getDayOfMonth()));
            orderPage.setEndDate(eDateSb.toString());
        }
        ObservableList extAccntIdListStr = FxUtils.newList();
        this.fundAccntService.getFundAccountList().forEach(arg_0 -> this.lambda$1(marketGrp, (List)extAccntIdListStr, arg_0));
        orderPage.setExtAccntIdList((List)extAccntIdListStr);
        orderPage.setSum(((String)this.cmbDetailSum.getSelectionModel().getSelectedItem()).equals("\u6c47\u603b"));
    }

    private void initPage() {
        this.pagination.setPageCount(1);
        this.pagination.currentPageIndexProperty().addListener(e -> {
            this.reBuildCcsPagiCount = false;
            this.query();
        });
    }

    private void bind() {
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.orderPage.securityIdProperty().bind((ObservableValue)this.secIdSearch.textProperty());
        this.pageSize.valueProperty().addListener(e -> this.query());
        this.jumpPage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.tableCross.requestFocus();
            }
        });
        this.jumpPage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && !"".equals(this.jumpPage.getText())) {
                this.pagination.setCurrentPageIndex(Integer.valueOf(this.jumpPage.getText()) - 1);
            }
        });
        this.jumpPage.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        this.obList.add((Object)"\u660e\u7ec6");
        this.obList.add((Object)"\u6c47\u603b");
        this.cmbDetailSum.setItems(this.obList);
        this.cmbDetailSum.getSelectionModel().select(0);
        this.orderPage = (HisQueryPage)this.of.create(HisQueryPage.class);
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"100");
        ObservableList nodes = node.getNodes();
        Collections.sort(nodes, new Comparator<MxNode>(){

            @Override
            public int compare(MxNode c1, MxNode c2) {
                int i = Integer.valueOf(c1.getRaw()) - Integer.valueOf(c2.getRaw());
                return i;
            }
        });
        this.pageSize.setItems(nodes);
        this.pageSize.setValue((Object)node.getNode("100"));
        try {
            ObservableList accountList = FxUtils.newList();
            for (Account acc : this.accntService.getAccountListByPost(this.iba.getPostId())) {
                if (!this.accountMap.getFundAccList().contains(acc.getInvestorId())) continue;
                accountList.add((Object)acc);
            }
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.ccmbAccnt.getItems().addAll((Collection)accountList);
            this.ccmbAccnt.setConverter((StringConverter)new StringConverter<Account>(){

                public String toString(Account accnt) {
                    if (accnt.getInvestorId().isEmpty()) {
                        return accnt.getName();
                    }
                    return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
                }

                public Account fromString(String string) {
                    return null;
                }
            });
        }
        catch (MException e2) {
            this.alert.alert(Alert.AlertType.ERROR, e2.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccStr = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccStr.add(account.getInvestorId());
            }
            this.lbAccnt.setText(listAccStr.toString().substring(1, listAccStr.toString().length() - 1));
        });
        this.lbAccnt.textProperty().addListener(e -> this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText())));
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void createTable() {
        this.tableCross.setPlaceholder((Node)new Label());
        this.index.setCellFactory(p -> new IdTableCell());
        this.index.setSortable(false);
        this.id.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getId()));
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getCode()));
        this.code.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getCode()));
        this.name.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getInstName()));
        this.market.setCellValueFactory(data -> {
            SimpleObjectProperty market = new SimpleObjectProperty();
            market.set((Object)new MxNode().load("market_code", ((FutureCrossOrder)data.getValue()).getMarket()));
            return market;
        });
        this.buyPrice.setCellValueFactory(data -> new SimpleDoubleProperty(Double.valueOf(String.format("%.3f", ((FutureCrossOrder)data.getValue()).getBuyPrice())).doubleValue()));
        this.sellPrice.setCellValueFactory(data -> new SimpleDoubleProperty(Double.valueOf(String.format("%.3f", ((FutureCrossOrder)data.getValue()).getSellPrice())).doubleValue()));
        this.spread.setCellValueFactory(data -> new SimpleDoubleProperty(Double.valueOf(String.format("%.3f", ((FutureCrossOrder)data.getValue()).getSpread())).doubleValue()));
        this.buyQty.setCellValueFactory(data -> new SimpleIntegerProperty(((FutureCrossOrder)data.getValue()).getBuyQty()));
        this.sellQty.setCellValueFactory(data -> new SimpleIntegerProperty(((FutureCrossOrder)data.getValue()).getSellQty()));
        this.buyDealQty.setCellValueFactory(data -> new SimpleIntegerProperty(((FutureCrossOrder)data.getValue()).getBuyDealQty()));
        this.sellDealQty.setCellValueFactory(data -> new SimpleIntegerProperty(((FutureCrossOrder)data.getValue()).getSellDealQty()));
        this.date.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getOrdDate()));
        this.time.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getOrdTime()));
        this.accntId.setCellValueFactory(data -> new SimpleStringProperty(((FutureCrossOrder)data.getValue()).getInvestorId()));
        this.tableCross.setPlaceholder((Node)new Label());
        this.tableCross.setItems(this.list);
        this.reactMap.put(this.id.getId(), "Id");
        this.reactMap.put(this.code.getId(), "Code");
        this.reactMap.put(this.name.getId(), "InstName");
        this.reactMap.put(this.market.getId(), "MarketName");
        this.reactMap.put(this.buyPrice.getId(), "BuyPrice");
        this.reactMap.put(this.sellPrice.getId(), "SellPrice");
        this.reactMap.put(this.spread.getId(), "Spread");
        this.reactMap.put(this.buyQty.getId(), "BuyQty");
        this.reactMap.put(this.sellQty.getId(), "SellQty");
        this.reactMap.put(this.buyDealQty.getId(), "BuyDealQty");
        this.reactMap.put(this.sellDealQty.getId(), "SellDealQty");
        this.reactMap.put(this.date.getId(), "OrdDate");
        this.reactMap.put(this.time.getId(), "OrdTime");
        this.reactMap.put(this.accntId.getId(), "InvestorId");
    }

    @FXML
    public void refresh() {
        this.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCross);
    }

    @FXML
    private void etfExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u671f\u8d27\u505a\u5e02\u62a5\u544a");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<FutureCrossOrder> page = this.crossOrderHisService.getAllCrossOrderData(this.orderPage);
                    ExcelUtils.writeExcel(this.tableCross, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$1(String string, List list, FundAccount item) {
        if (this.lbAccnt.getText().contains(item.getInvestId()) && string.equals(item.getMarketGrp())) {
            list.add(item.getExtAccntId());
        }
    }

    private class IdTableCell<T>
    extends TableCell<T, String> {
        private IdTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            this.setGraphic(null);
            if (!empty) {
                int rowIndex = this.getIndex() + 1;
                this.setText(String.valueOf(rowIndex));
            }
        }
    }
}

