/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.control.cvts.NumberCvt;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.CcsDealSum;
import cms.tmx.entity.trade.CtpDealSum;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.history.ICtpDealHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DealHisSumQueryPart
extends HisQueryPart<CcsDealSum, CtpDealSum, Object> {
    private static final Logger logger = LogManager.getLogger(DealHisSumQueryPart.class);
    @FXML
    private TableView<CcsDealSum> ccsTableDeal;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColSecId;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColSecName;
    @FXML
    private TableColumn<CcsDealSum, MxNode> ccsColDir;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColVol;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColUnit;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColPrice;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColPriceNow;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColTradeAmt;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColRealFee;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColIncurredAmt;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColCommision;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColChgFee;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColStampTax;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColHandleFee;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColSecAdminFee;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColOtherFee;
    @FXML
    private TableColumn<CcsDealSum, Number> ccsColPL;
    @FXML
    private TableColumn<CcsDealSum, MxNode> ccsColMkt;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColAcc;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColPort;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColAccntGrpName;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColPortGrpName;
    @FXML
    private TableColumn<CcsDealSum, String> ccsIndex;
    @FXML
    private TableColumn<CcsDealSum, String> ccsColInterval;
    @FXML
    private TableView<CtpDealSum> ctpTableDeal;
    @FXML
    private TableColumn<CtpDealSum, String> ctpColSecId;
    @FXML
    private TableColumn<CtpDealSum, String> ctpColSecName;
    @FXML
    private TableColumn<CtpDealSum, MxNode> colCtpMarket;
    @FXML
    private TableColumn<CtpDealSum, MxNode> ctpColDir;
    @FXML
    private TableColumn<CtpDealSum, MxNode> ctpColOC;
    @FXML
    private TableColumn<CtpDealSum, MxNode> ctpColSH;
    @FXML
    private TableColumn<CtpDealSum, Number> ctpColVol;
    @FXML
    private TableColumn<CtpDealSum, Number> ctpColPrice;
    @FXML
    private TableColumn<CtpDealSum, String> ctpColAcc;
    @FXML
    private TableColumn<CtpDealSum, String> ctpIndex;
    @FXML
    private CheckBox checkDaySum;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsDealHisService ccsDealHisService;
    @Inject
    private ICtpDealHisService ctpDealHisService;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ctpExcel;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableCtp();
        this.focusRefresh(this.ccsTableDeal);
        this.focusRefresh(this.ctpTableDeal);
        this.refMng.changedProperty().addListener((ob, old, now) -> this.summarize((ObservableList<CcsDealSum>)this.pageCcs.getDataList()));
        this.query();
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio();
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.pageCcs.setInverval(this.checkDaySum.isSelected());
            this.ccsDealHisService.queryDealSum((HisQueryPage<CcsDealSum>)this.pageCcs);
        }
        catch (MException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage());
        }
        this.summarize((ObservableList<CcsDealSum>)this.pageCcs.getDataList());
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTableDeal.scrollToColumnIndex(0);
        }
        this.ccsTableDeal.scrollTo(0);
        this.ccsTableDeal.sort();
    }

    @Override
    protected void ctpQuery() {
        if (this.isPortDimension() || this.isAssetGrpDimension() || !this.rebuildPagi(this.pageCtp, this.ctpChangeExtAcc) || this.pageCtp.getExtAccntIdList().isEmpty()) {
            this.ctpReset();
            return;
        }
        try {
            this.ctpChangeExtAcc = false;
            this.ctpDealHisService.queryDealSum((HisQueryPage<CtpDealSum>)this.pageCtp);
        }
        catch (MException e) {
            logger.error("\u671f\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u671f\u8d27\u67e5\u8be2" + e.getMessage());
        }
        if (this.pageCtp.getDataList().size() == 0) {
            this.ctpTableDeal.scrollToColumnIndex(0);
        }
        this.ctpTableDeal.scrollTo(0);
        this.ctpTableDeal.sort();
    }

    private void summarize(ObservableList<CcsDealSum> oldList) {
        RefItem refItem;
        ArrayList<RefItem> refList = new ArrayList<RefItem>();
        for (CcsDealSum deal : oldList) {
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if ("SHSC".equals(deal.getInstrument().getMarket().getRaw()) || "SZSC".equals(deal.getInstrument().getMarket().getRaw())) {
                refItem = this.refMng.getItem(String.valueOf(deal.getInstrument().getSecType()) + deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            }
            if (refItem == null || this.mktMng.getInfo((IRefItem)refItem) != null) continue;
            refList.add(refItem);
        }
        this.mktMng.query(refList, new Gears());
        for (CcsDealSum deal : oldList) {
            double percent;
            deal.setLastAmount(0.0);
            refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if ("SHSC".equals(deal.getInstrument().getMarket().getRaw()) || "SZSC".equals(deal.getInstrument().getMarket().getRaw())) {
                refItem = this.refMng.getItem(String.valueOf(deal.getInstrument().getSecType()) + deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            }
            if (deal.getLastPx() == 0.0) continue;
            if (refItem == null) {
                percent = 0.0;
                percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getLastPx()) * 100.0 / deal.getLastPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getLastPx() - deal.getNowPrice()) * 100.0 / deal.getLastPx() : 0.0);
                percent = (double)Math.round(percent * 100.0) / 100.0;
                deal.setLastAmount(percent);
                continue;
            }
            if (this.mktMng.getInfo((IRefItem)refItem) == null || refItem.getType().equals("PLEDGE")) {
                deal.setLastAmount(0.0);
                deal.setInterval("\u4e0d\u663e\u793a");
                continue;
            }
            deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getNowPrice());
            if (this.mktMng.getInfo((IRefItem)refItem).getNowPrice() == 0.0) {
                deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getClosePrice());
            }
            percent = 0.0;
            percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getLastPx()) * 100.0 / deal.getLastPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getLastPx() - deal.getNowPrice()) * 100.0 / deal.getLastPx() : 0.0);
            percent = (double)Math.round(percent * 100.0) / 100.0;
            deal.setLastAmount(percent);
        }
    }

    protected void checkPortfolio() {
        String dimension = this.pageCcs.getDimension();
        if (dimension.equals("1")) {
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPort)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPort);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAccntGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAccntGrpName);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPortGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPortGrpName);
            }
            if (!this.ccsTableDeal.getColumns().contains(this.ccsColAcc)) {
                this.ccsTableDeal.getColumns().add(this.ccsColAcc);
            }
        } else if ("6".equals(dimension)) {
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPort)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPort);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAcc)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAcc);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPortGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPortGrpName);
            }
            if (!this.ccsTableDeal.getColumns().contains(this.ccsColAccntGrpName)) {
                this.ccsTableDeal.getColumns().add(this.ccsColAccntGrpName);
            }
        } else if ("7".equals(dimension)) {
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPort)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPort);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAcc)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAcc);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAccntGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAccntGrpName);
            }
            if (!this.ccsTableDeal.getColumns().contains(this.ccsColPortGrpName)) {
                this.ccsTableDeal.getColumns().add(this.ccsColPortGrpName);
            }
        } else {
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAcc)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAcc);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColAccntGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColAccntGrpName);
            }
            if (this.ccsTableDeal.getColumns().contains(this.ccsColPortGrpName)) {
                this.ccsTableDeal.getColumns().remove(this.ccsColPortGrpName);
            }
            if (!this.ccsTableDeal.getColumns().contains(this.ccsColPort)) {
                this.ccsTableDeal.getColumns().add(this.ccsColPort);
            }
        }
    }

    private void creatTableCcs() {
        this.ccsTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> ((CcsDealSum)data.getValue()).getInstrument().secIdProperty());
        this.reactMap.put(this.ccsColSecId.getId(), "SecId");
        this.ccsColSecName.setCellValueFactory(data -> ((CcsDealSum)data.getValue()).getInstrument().symbolProperty());
        this.reactMap.put(this.ccsColSecName.getId(), "SecName");
        this.ccsColDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDealSum)data.getValue()).getSide()));
        this.reactMap.put(this.ccsColDir.getId(), "ExSide");
        this.ccsColDir.setCellFactory(cell -> new SideCell());
        this.ccsColVol.setCellFactory(column -> new NumberTableCell());
        this.ccsColVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getLastQty()));
        this.reactMap.put(this.ccsColVol.getId(), "LastQty");
        this.ccsColUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getUnit()));
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.ccsColPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getLastPx()));
        this.reactMap.put(this.ccsColPrice.getId(), "LastPx");
        this.ccsColPrice.setCellFactory(data -> new PriceAvgCell());
        this.ccsColPriceNow.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getNowPrice()));
        this.reactMap.put(this.ccsColPriceNow.getId(), "NowPrice");
        this.ccsColPriceNow.setCellFactory(data -> new PriceNowCell());
        this.ccsColTradeAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getTradeAmt()));
        this.reactMap.put(this.ccsColTradeAmt.getId(), "TradeAmt");
        this.ccsColTradeAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColRealFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getRealFee()));
        this.reactMap.put(this.ccsColRealFee.getId(), "RealFee");
        this.ccsColRealFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColIncurredAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getIncurredAmt()));
        this.reactMap.put(this.ccsColIncurredAmt.getId(), "IncurredAmt");
        this.ccsColIncurredAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCommision.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getCommision()));
        this.reactMap.put(this.ccsColCommision.getId(), "Commision");
        this.ccsColCommision.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColChgFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getChgOwnerFee()));
        this.reactMap.put(this.ccsColChgFee.getId(), "ChgOwnerFee");
        this.ccsColChgFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColStampTax.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getStampTax()));
        this.reactMap.put(this.ccsColStampTax.getId(), "StampTax");
        this.ccsColStampTax.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColHandleFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getHandleFee()));
        this.reactMap.put(this.ccsColHandleFee.getId(), "HandleFee");
        this.ccsColHandleFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColSecAdminFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getSecAdminFee()));
        this.reactMap.put(this.ccsColSecAdminFee.getId(), "SecAdminFee");
        this.ccsColSecAdminFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColOtherFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getOtherFee()));
        this.reactMap.put(this.ccsColOtherFee.getId(), "OtherFee");
        this.ccsColOtherFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColPL.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDealSum)data.getValue()).getLastAmount()));
        this.reactMap.put(this.ccsColPL.getId(), "LastAmount");
        this.ccsColPL.setCellFactory(cell -> new ItemFloatCell(2, true));
        this.ccsColMkt.setCellValueFactory(data -> ((CcsDealSum)data.getValue()).getInstrument().marketProperty());
        this.reactMap.put(this.ccsColMkt.getId(), "ExMarket");
        this.ccsColAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getInvestorId()));
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.ccsColPort.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getPortfolioName()));
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
        this.ccsColInterval.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getSumDate()));
        this.reactMap.put(this.ccsColInterval.getId(), "SumDate");
        this.ccsColAccntGrpName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getAccntGrpName()));
        this.reactMap.put(this.ccsColAccntGrpName.getId(), "AccntGrpName");
        this.ccsColPortGrpName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDealSum)data.getValue()).getAccntGrpName()));
        this.reactMap.put(this.ccsColPortGrpName.getId(), "PortGrpName");
        this.ccsTableDeal.setItems(this.pageCcs.getDataList());
    }

    private void creatTableCtp() {
        this.ctpTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ctpIndex);
        this.ctpColSecId.setCellValueFactory(data -> ((CtpDealSum)data.getValue()).getInstrument().secIdProperty());
        this.ctpColSecName.setCellValueFactory(data -> ((CtpDealSum)data.getValue()).getInstrument().symbolProperty());
        this.colCtpMarket.setCellValueFactory(data -> ((CtpDealSum)data.getValue()).getInstrument().marketProperty());
        this.ctpColDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDealSum)data.getValue()).getSide()));
        this.ctpColDir.setCellFactory(cell -> new SideCell());
        this.ctpColOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDealSum)data.getValue()).getOcFlag()));
        this.ctpColSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDealSum)data.getValue()).getShFlag()));
        this.ctpColVol.setCellFactory(column -> new NumberTableCell());
        this.ctpColVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDealSum)data.getValue()).getLastQty()));
        this.ctpColPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDealSum)data.getValue()).getLastPx()));
        this.ctpColPrice.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.ctpColAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpDealSum)data.getValue()).getInvestorId()));
        this.ctpTableDeal.setItems(this.pageCtp.getDataList());
        this.reactMap.put(this.ctpColSecId.getId(), "SecId");
        this.reactMap.put(this.ctpColSecName.getId(), "SecName");
        this.reactMap.put(this.colCtpMarket.getId(), "ExMarket");
        this.reactMap.put(this.ctpColDir.getId(), "ExSide");
        this.reactMap.put(this.ctpColVol.getId(), "LastQty");
        this.reactMap.put(this.ctpColOC.getId(), "ExOcFlag");
        this.reactMap.put(this.ctpColSH.getId(), "ExShFlag");
        this.reactMap.put(this.ctpColPrice.getId(), "LastPx");
        this.reactMap.put(this.ctpColAcc.getId(), "InvestorId");
    }

    @Override
    protected boolean rebuildPagi(HisQueryPage<?> orderPage, boolean queryAll) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        if (queryAll) {
            ObservableList listAcc = FxUtils.newList();
            LinkedList<String> list = new LinkedList<String>();
            List checkItems = this.accountModel.getCheckItems();
            List checkIds = checkItems.stream().map(Account::getId).collect(Collectors.toList());
            String dimension = orderPage.getDimension();
            if (dimension.equals("1")) {
                this.fundAccntService.getFundAccountList().forEach(arg_0 -> DealHisSumQueryPart.lambda$50(orderPage, checkIds, (List)listAcc, arg_0));
                orderPage.setExtAccntIdList((List)listAcc);
                if (listAcc.isEmpty()) {
                    return false;
                }
            } else if ("2".equals(dimension)) {
                for (Portfolio portfolio : this.portfolioModel.getCheckItems()) {
                    list.add(portfolio.getId());
                }
                orderPage.setPortfolioIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            } else if ("6".equals(dimension)) {
                for (AssetGrp asset : this.assetGrpModel.getCheckItems()) {
                    if (asset.getId().isEmpty()) continue;
                    list.add(asset.getId());
                }
                orderPage.setAssetGrpIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            } else if ("7".equals(dimension)) {
                for (AssetGrp asset : this.assetGrpPortModel.getCheckItems()) {
                    if (asset.getId().isEmpty()) continue;
                    list.add(asset.getId());
                }
                orderPage.setAssetsGrpIdList(list);
                if (list.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void setDate() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)"yyyy-MM-dd");
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)"yyyy-MM-dd");
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
    }

    @FXML
    private void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableDeal);
    }

    @FXML
    private void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u6c47\u603b\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CcsDealSum> page = this.ccsDealHisService.getAllCcsSumData((HisQueryPage<CcsDealSum>)this.pageCcs);
                    this.summarize((ObservableList<CcsDealSum>)page.getDataList());
                    ExcelUtils.writeExcel(this.ccsTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    public void ctpCopy() {
        TableUtils.copyContentWithHead(this.ctpTableDeal);
    }

    @FXML
    private void ctpRefresh() {
        this.ctpQuery();
    }

    @FXML
    private void ctpExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u6c47\u603b\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ctpExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CtpDealSum> page = this.ctpDealHisService.getAllCtpSumData((HisQueryPage<CtpDealSum>)this.pageCtp);
                    ExcelUtils.writeExcel(this.ctpTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ctpExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ctpExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$50(HisQueryPage hisQueryPage, List list, List list2, FundAccount item) {
        String marketGrp = hisQueryPage.getMarketGrp();
        if (list.contains(item.getParentId()) && marketGrp.equals(item.getMarketGrp())) {
            list2.add(item.getExtAccntId());
        }
    }

    protected class ItemFloatCell
    extends TableCell<CcsDealSum, Number> {
        protected int scale = 0;
        protected boolean isPercent = false;
        protected Label label = new Label();

        ItemFloatCell(int i, boolean isPercent) {
            this.scale = i;
            this.isPercent = isPercent;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number value, boolean empty) {
            CcsDealSum sum = (CcsDealSum)this.getTableRow().getItem();
            if (empty || sum.getInterval() == null || "\u4e0d\u663e\u793a".equals(sum.getInterval())) {
                this.setGraphic(null);
                return;
            }
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
            this.label.setText(this.isPercent ? String.valueOf(text) + "%" : text);
            CssUtils.checkPct((Control)this.label, (double)value.doubleValue());
            this.setGraphic((Node)this.label);
        }
    }

    private class NumberConvert
    extends NumberCvt {
        private Integer scale;

        public String toString(Number num) {
            if (num == null || this.scale == null) {
                return "";
            }
            return StringUtils.toStr((double)num.doubleValue(), (int)this.scale);
        }

        public void setScale(int scale) {
            this.scale = scale;
        }
    }

    private class PriceAvgCell
    extends TextFieldTableCell<CcsDealSum, Number> {
        private NumberConvert cvt;
        private DoubleFilter df;

        public PriceAvgCell() {
            this.cvt = new NumberConvert();
            this.df = new DoubleFilter(true, 3, 3);
            this.setConverter((StringConverter)this.cvt);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsDealSum deal = (CcsDealSum)CcsDealSum.class.cast(this.getTableRow().getItem());
                RefItem refItem = DealHisSumQueryPart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if ("SHSC".equals(deal.getInstrument().getMarket().getRaw()) || "SZSC".equals(deal.getInstrument().getMarket().getRaw())) {
                    refItem = DealHisSumQueryPart.this.refMng.getItem(String.valueOf(deal.getInstrument().getSecType()) + deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                }
                int scale = 4;
                if (refItem != null) {
                    scale = refItem.getScale() + 1;
                }
                this.cvt.setScale(scale);
                this.df.setScale(scale);
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)scale));
            }
        }
    }

    private class PriceNowCell
    extends TextFieldTableCell<CcsDealSum, Number> {
        private NumberConvert cvt;
        private DoubleFilter df;

        public PriceNowCell() {
            this.cvt = new NumberConvert();
            this.df = new DoubleFilter(true, 3, 3);
            this.setConverter((StringConverter)this.cvt);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsDealSum deal = (CcsDealSum)CcsDealSum.class.cast(this.getTableRow().getItem());
                RefItem refItem = DealHisSumQueryPart.this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                if ("SHSC".equals(deal.getInstrument().getMarket().getRaw()) || "SZSC".equals(deal.getInstrument().getMarket().getRaw())) {
                    refItem = DealHisSumQueryPart.this.refMng.getItem(String.valueOf(deal.getInstrument().getSecType()) + deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
                }
                int scale = 3;
                if (refItem != null) {
                    scale = refItem.getScale();
                }
                this.cvt.setScale(scale);
                this.df.setScale(scale);
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)scale));
            }
        }
    }
}

