/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.cvts.NumberCvt;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.HkwolunPriceUnit;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.ObSummarizedOrder;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IDealSumNewHisService;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class DealHisSumNewQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    protected CheckComboBox<AssetGrp> ccmbPorts;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label lbPort;
    @FXML
    protected Label lbAccnts;
    @FXML
    private GridPane gridDimen;
    @FXML
    private GridPane gridAcct;
    @FXML
    private GridPane gridPort;
    @FXML
    private GridPane gridPorts;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private ComboBox<MxNode> ccsPageSizeOtc;
    @FXML
    private Pagination ccsPaginationOtc;
    @FXML
    private Label ccsTotalCountOtc;
    @FXML
    private TextField ccsJumpPageOtc;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @Inject
    private MObjFactory of;
    @Inject
    private IAccountService accntService;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private IBaseApi iba;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    protected OtcPortfolioAccountModel otcAccMng;
    @Inject
    private MxAlert alert;
    @Inject
    private DialogFactory df;
    private HisQueryPage<ObSummarizedOrder> pageCcs = new HisQueryPage();
    @FXML
    private TableView<ObSummarizedOrder> ccsTableDeal;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColSecId;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColSecName;
    @FXML
    private TableColumn<ObSummarizedOrder, MxNode> ccsColDir;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColVol;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColUnit;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColPrice;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColPriceNow;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColTradeAmt;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColRealFee;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColIncurredAmt;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColCommision;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColChgFee;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColStampTax;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColHandleFee;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColSecAdminFee;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColOtherFee;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> ccsColPL;
    @FXML
    private TableColumn<ObSummarizedOrder, MxNode> ccsColMkt;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColAcc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColPort;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColPortGrpName;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsIndex;
    @FXML
    private TableColumn<ObSummarizedOrder, String> ccsColInterval;
    private HisQueryPage<ObSummarizedOrder> pageOtc = new HisQueryPage();
    @FXML
    private TableView<ObSummarizedOrder> tableDealOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> secIdOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> secNameOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, MxNode> dirOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, SecSubType> secSubType;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> volOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> unitOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> tradeAmtOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, Number> fee;
    @FXML
    private TableColumn<ObSummarizedOrder, MxNode> mktOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> portOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> indexOtc;
    @FXML
    private TableColumn<ObSummarizedOrder, String> intervalOtc;
    @FXML
    private CheckBox checkDaySum;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng mktMng;
    private static final Logger logger = LogManager.getLogger(DealHisSumNewQueryPart.class);
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private boolean changeExtAcc = false;
    private boolean changeExtAccOtc = false;
    private List<AssetGrp> listAssets;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    protected StringConverter<Account> converter = new StringConverter<Account>(){

        public String toString(Account accnt) {
            if (accnt.getInvestorId().isEmpty()) {
                return accnt.getName();
            }
            return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
        }

        public Account fromString(String string) {
            return null;
        }
    };
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem ccsExcelOtc;
    @Inject
    private IDealSumNewHisService ccsDealHisService;
    private Map<String, String> reactMap = new HashMap<String, String>();

    @FXML
    private void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.pageOtc.setMarketGrp("OTC");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.pageOtc.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.createTableOtc();
        this.query();
        this.focusRefresh(this.ccsTableDeal);
        this.refMng.changedProperty().addListener((ob, old, now) -> {
            this.summarize((ObservableList<ObSummarizedOrder>)this.pageCcs.getDataList());
            this.summarize((ObservableList<ObSummarizedOrder>)this.pageOtc.getDataList());
        });
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now();
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        MxNode node = MxNodeFactory.createNew((String)"query_dimension_assetgrp", (String)"1");
        node.removeNode("6");
        this.btnDimension.setItems(node.getNodes());
        this.gridDimen.getChildren().clear();
        this.btnDimension.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now.getRaw().equals("1")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridAcct});
            } else if (now.getRaw().equals("2")) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPort});
            } else if ("7".equals(now.getRaw())) {
                this.gridDimen.getChildren().setAll((Object[])new Node[]{this.gridPorts});
            }
        });
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxAcc();
        this.initCheckBoxPort();
        this.initCheckBoxPorts();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
        this.initPage(this.ccsPaginationOtc, this.ccsTotalCountOtc, this.ccsJumpPageOtc, this.ccsPageSizeOtc, this.pageOtc);
    }

    private void initCheckBoxAcc() {
        try {
            ObservableList listAcc = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)listAcc);
            this.ccmbAccnt.getItems().addAll((Collection)listAcc);
            this.ccmbAccnt.setConverter(this.converter);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccId = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccId.add(account.getInvestorId());
            }
            String accStr = listAccId.toString();
            this.lbAccnt.setText(accStr.substring(1, accStr.length() - 1));
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void initCheckBoxPort() {
        List<Portfolio> listPort = this.subAccMng.getPortfoliosAll();
        Portfolio portfolio = new Portfolio();
        portfolio.setId("");
        portfolio.setName("\u5168\u9009");
        this.ccmbPort.getItems().add((Object)portfolio);
        this.ccmbPort.getItems().addAll(listPort);
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPort);
        checkComboBoxModel.init();
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
            ObservableList listAcc = FxUtils.newList();
            for (Portfolio account : checkedItems) {
                if (account.getId().isEmpty()) continue;
                listAcc.add(account.getName());
            }
            String accStr = listAcc.toString();
            this.lbPort.setText(accStr.substring(1, accStr.length() - 1));
            this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
        });
        this.ccmbPort.getCheckModel().checkAll();
    }

    private void initCheckBoxPorts() {
        try {
            AssetGrp asset = new AssetGrp();
            asset.setId("");
            asset.setName("\u5168\u9009");
            this.ccmbPorts.getItems().add((Object)asset);
            List listAssetQuery = this.assetGrpMng.getAssetGrpsByPartyId(this.iba.getPartyId(), Boolean.valueOf(true));
            List listAssetId = this.assetGrpApi.getAssetGrpIdsByPost(this.iba.getPostId());
            this.listAssets = new ArrayList<AssetGrp>();
            listAssetQuery.forEach(item -> {
                if (listAssetId.contains(item.getId()) && "3".equals(item.getType().getRaw())) {
                    this.listAssets.add((AssetGrp)item);
                }
            });
            this.ccmbPorts.getItems().addAll(this.listAssets);
        }
        catch (MException | Exception e) {
            logger.error((Object)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbPorts);
        checkComboBoxModel.init();
        this.ccmbPorts.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbPorts.getCheckModel().getCheckedItems();
            ObservableList listAssetId = FxUtils.newList();
            for (AssetGrp item : checkedItems) {
                if (item.getId().isEmpty()) continue;
                listAssetId.add(item.getName());
            }
            String assetStr = listAssetId.toString();
            this.lbAccnts.setText(assetStr.substring(1, assetStr.length() - 1));
            this.lbAccnts.setTooltip(new Tooltip(this.lbAccnts.getText()));
        });
        this.ccmbPorts.getCheckModel().checkAll();
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        this.pageOtc.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.pageOtc.setDimension(raw);
        this.changeExtAcc = true;
        this.changeExtAccOtc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.pageOtc.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
        this.otcQuery();
    }

    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
        }
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage, boolean queryAll) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (queryAll) {
            LinkedList<String> listPort = new LinkedList<String>();
            HashSet<String> setExtAcc = new HashSet<String>();
            HashSet<String> portfolioIdSet = new HashSet<String>();
            LinkedList<String> listAssetGrp = new LinkedList<String>();
            if (dimension.equals("1")) {
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    this.fundAccntService.getExtAssetFundAccs().forEach(item -> {
                        String marketGrp = orderPage.getMarketGrp();
                        if (this.lbAccnt.getText().contains(item.getInvestId()) && marketGrp.equals(item.getMarketGrp()) && !StringUtils.isEmpty((String)item.getNewCashAccntId())) {
                            setExtAcc.add(item.getNewCashAccntId());
                        }
                    });
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (CcsFundAccount ccsFundAccount : this.otcAccMng.getFundAccounts()) {
                        if (!(ccsFundAccount instanceof CcsSubFundAccount) || !this.lbAccnt.getText().contains(ccsFundAccount.getInvestId()) || StringUtils.isEmpty((String)ccsFundAccount.getNewCashAccntId())) continue;
                        CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                        setExtAcc.add(subFundAccnt.getNewCashAccntId());
                    }
                }
                orderPage.setAccountIdList(new LinkedList(setExtAcc));
                if (setExtAcc.isEmpty()) {
                    return false;
                }
            } else if ("2".equals(dimension)) {
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                        if (portfolio.getId().isEmpty() || this.subAccMng.getMap(portfolio) == null) continue;
                        for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPort.add(portfolio.getId());
                    }
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (Portfolio portfolio : this.ccmbPort.getCheckModel().getCheckedItems()) {
                        if (portfolio.getId().isEmpty() || this.otcAccMng.getMap(portfolio) == null) continue;
                        for (CcsFundAccount fundAccnt : this.otcAccMng.getMap(portfolio).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPort.add(portfolio.getId());
                    }
                }
                orderPage.setPortfolioIdList(listPort);
                orderPage.setAccountIdList(new LinkedList(setExtAcc));
                if (listPort.isEmpty()) {
                    return false;
                }
            } else if ("7".equals(dimension)) {
                for (AssetGrp assetGrp : this.ccmbPorts.getCheckModel().getCheckedItems()) {
                    if (assetGrp.getId().isEmpty()) continue;
                    listAssetGrp.add(assetGrp.getId());
                    String[] ids = assetGrp.getAssetUnitId().split(",");
                    portfolioIdSet.addAll(Arrays.asList(ids));
                }
                if ("CCS".equals(orderPage.getMarketGrp())) {
                    for (String string : portfolioIdSet) {
                        if (this.subAccMng.getMap(string) == null) continue;
                        for (CcsFundAccount fundAccnt : this.subAccMng.getMap(string).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPort.add(string);
                    }
                } else if ("OTC".equals(orderPage.getMarketGrp())) {
                    for (String string : portfolioIdSet) {
                        if (this.otcAccMng.getMap(string) == null) continue;
                        for (CcsFundAccount fundAccnt : this.otcAccMng.getMap(string).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount) || StringUtils.isEmpty((String)fundAccnt.getNewCashAccntId())) continue;
                            CcsSubFundAccount subFundAccnt = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAccnt);
                            setExtAcc.add(subFundAccnt.getNewCashAccntId());
                        }
                        listPort.add(string);
                    }
                }
                orderPage.setAccountIdList(new LinkedList(setExtAcc));
                orderPage.setPortfolioIdList(listPort);
                orderPage.setAssetsGrpIdList(listAssetGrp);
                if (listAssetGrp.isEmpty()) {
                    return false;
                }
            }
        }
        return !("1".equals(dimension) ? orderPage.getAccountIdList().isEmpty() : ("2".equals(dimension) ? orderPage.getAccountIdList().isEmpty() : "7".equals(dimension) && orderPage.getAccountIdList().isEmpty()));
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void otcReset() {
        this.ccsPaginationOtc.setPageCount(1);
        this.ccsTotalCountOtc.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> tableOrder) {
        tableOrder.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> tableOrder.refresh());
            }
        });
    }

    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTableDeal, this.ccsColAcc, this.ccsColPort, this.ccsColPortGrpName);
        if (!this.rebuildPagi(this.pageCcs, this.changeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.changeExtAcc = false;
            this.pageCcs.setInverval(this.checkDaySum.isSelected());
            this.ccsDealHisService.queryDealSum(this.pageCcs);
        }
        catch (MException | IOException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.summarize((ObservableList<ObSummarizedOrder>)this.pageCcs.getDataList());
        if (this.pageCcs.getDataList().size() == 0) {
            this.ccsTableDeal.scrollToColumnIndex(0);
        }
        this.ccsTableDeal.scrollTo(0);
        this.ccsTableDeal.sort();
    }

    protected void otcQuery() {
        this.checkPortfolio(this.tableDealOtc, null, this.portOtc, null);
        if (!this.rebuildPagi(this.pageOtc, this.changeExtAccOtc)) {
            this.otcReset();
            return;
        }
        try {
            this.changeExtAccOtc = false;
            this.pageOtc.setInverval(this.checkDaySum.isSelected());
            this.ccsDealHisService.queryDealSum(this.pageOtc);
        }
        catch (MException | IOException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.summarize((ObservableList<ObSummarizedOrder>)this.pageOtc.getDataList());
        if (this.pageOtc.getDataList().size() == 0) {
            this.tableDealOtc.scrollToColumnIndex(0);
        }
        this.tableDealOtc.scrollTo(0);
        this.tableDealOtc.sort();
    }

    protected void checkPortfolio(TableView<ObSummarizedOrder> ccsTableDeal, TableColumn<ObSummarizedOrder, String> ccsColAcc, TableColumn<ObSummarizedOrder, String> colPort, TableColumn<ObSummarizedOrder, String> ccsColPortGrpName) {
        String dimension = this.pageCcs.getDimension();
        if (dimension.equals("1")) {
            if (ccsTableDeal.getColumns().contains(colPort)) {
                ccsTableDeal.getColumns().remove(colPort);
            }
            if (ccsTableDeal.getColumns().contains(ccsColPortGrpName)) {
                ccsTableDeal.getColumns().remove(ccsColPortGrpName);
            }
            if (ccsTableDeal == this.ccsTableDeal && !ccsTableDeal.getColumns().contains(ccsColAcc)) {
                ccsTableDeal.getColumns().add(ccsColAcc);
            }
        } else if ("7".equals(dimension)) {
            if (ccsTableDeal.getColumns().contains(colPort)) {
                ccsTableDeal.getColumns().remove(colPort);
            }
            if (ccsTableDeal.getColumns().contains(ccsColAcc)) {
                ccsTableDeal.getColumns().remove(ccsColAcc);
            }
            if (ccsTableDeal == this.ccsTableDeal && !ccsTableDeal.getColumns().contains(ccsColPortGrpName)) {
                ccsTableDeal.getColumns().add(ccsColPortGrpName);
            }
        } else {
            if (ccsTableDeal.getColumns().contains(ccsColAcc)) {
                ccsTableDeal.getColumns().remove(ccsColAcc);
            }
            if (ccsTableDeal.getColumns().contains(ccsColPortGrpName)) {
                ccsTableDeal.getColumns().remove(ccsColPortGrpName);
            }
            if (!ccsTableDeal.getColumns().contains(colPort)) {
                ccsTableDeal.getColumns().add(colPort);
            }
        }
    }

    private void createTable() {
        this.ccsTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).securityIdProperty());
        this.reactMap.put(this.ccsColSecId.getId(), "SecurityId");
        this.ccsColSecName.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).securityNameProperty());
        this.reactMap.put(this.ccsColSecName.getId(), "SecurityName");
        this.ccsColDir.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).sideProperty());
        this.reactMap.put(this.ccsColDir.getId(), "ExSide");
        this.ccsColDir.setCellFactory(cell -> new SideCell());
        this.ccsColVol.setCellFactory(column -> new NumberTableCell());
        this.ccsColVol.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).cumQtyProperty());
        this.reactMap.put(this.ccsColVol.getId(), "CumQty");
        this.ccsColUnit.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).unitProperty());
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.ccsColPrice.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).avgPxProperty());
        this.reactMap.put(this.ccsColPrice.getId(), "AvgPx");
        this.ccsColPrice.setCellFactory(data -> new PriceAvgCell());
        this.ccsColPriceNow.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).nowPriceProperty());
        this.reactMap.put(this.ccsColPriceNow.getId(), "NowPrice");
        this.ccsColPriceNow.setCellFactory(data -> new PriceNowCell());
        this.ccsColTradeAmt.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).tradeAmountProperty());
        this.reactMap.put(this.ccsColTradeAmt.getId(), "TradeAmount");
        this.ccsColTradeAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColRealFee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).realFeeProperty());
        this.reactMap.put(this.ccsColRealFee.getId(), "RealFee");
        this.ccsColRealFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColIncurredAmt.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).incurredAmtProperty());
        this.reactMap.put(this.ccsColIncurredAmt.getId(), "IncurredAmt");
        this.ccsColIncurredAmt.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColCommision.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).commissionProperty());
        this.reactMap.put(this.ccsColCommision.getId(), "Commission");
        this.ccsColCommision.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColChgFee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).chgOwnerFeeProperty());
        this.reactMap.put(this.ccsColChgFee.getId(), "ChgOwnerFee");
        this.ccsColChgFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColStampTax.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).stampTaxProperty());
        this.reactMap.put(this.ccsColStampTax.getId(), "StampTax");
        this.ccsColStampTax.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColHandleFee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).handleFeeProperty());
        this.reactMap.put(this.ccsColHandleFee.getId(), "HandleFee");
        this.ccsColHandleFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColSecAdminFee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).secAdminFeeProperty());
        this.reactMap.put(this.ccsColSecAdminFee.getId(), "SecAdminFee");
        this.ccsColSecAdminFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColOtherFee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).otherFeeProperty());
        this.reactMap.put(this.ccsColOtherFee.getId(), "OtherFee");
        this.ccsColOtherFee.setCellFactory(cell -> new DoubleTableCell());
        this.ccsColPL.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).percentProperty());
        this.reactMap.put(this.ccsColPL.getId(), "Percent");
        this.ccsColPL.setCellFactory(cell -> new ItemFloatCell(2));
        this.ccsColMkt.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).marketProperty());
        this.reactMap.put(this.ccsColMkt.getId(), "ExMarket");
        this.ccsColAcc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).investorIdProperty());
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.ccsColPort.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).portfolioNameProperty());
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
        this.ccsColInterval.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).sumDateProperty());
        this.reactMap.put(this.ccsColInterval.getId(), "SumDate");
        this.ccsColPortGrpName.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).portGrpNameProperty());
        this.reactMap.put(this.ccsColPortGrpName.getId(), "PortGrpName");
        this.ccsTableDeal.setItems(this.pageCcs.getDataList());
    }

    private void createTableOtc() {
        this.tableDealOtc.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.indexOtc);
        this.indexOtc.setSortable(false);
        this.secIdOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).securityIdProperty());
        this.reactMap.put(this.secIdOtc.getId(), "SecurityId");
        this.secNameOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).securityNameProperty());
        this.reactMap.put(this.secNameOtc.getId(), "SecurityName");
        this.dirOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).sideProperty());
        this.reactMap.put(this.dirOtc.getId(), "ExSide");
        this.dirOtc.setCellFactory(cell -> new SideCell());
        this.mktOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).marketProperty());
        this.reactMap.put(this.mktOtc.getId(), "ExMarket");
        this.volOtc.setCellFactory(column -> new DoubleTableCell());
        this.volOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).cumQtyProperty());
        this.reactMap.put(this.volOtc.getId(), "CumQty");
        this.unitOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).unitProperty());
        this.reactMap.put(this.unitOtc.getId(), "Unit");
        this.secSubType.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).secSubTypeProperty());
        this.reactMap.put(this.secSubType.getId(), "SecSubType");
        this.tradeAmtOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).tradeAmountProperty());
        this.reactMap.put(this.tradeAmtOtc.getId(), "TradeAmount");
        this.tradeAmtOtc.setCellFactory(cell -> new PriceNowCell());
        this.fee.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).realFeeProperty());
        this.reactMap.put(this.fee.getId(), "RealFee");
        this.fee.setCellFactory(cell -> new ItemFloatCell(2));
        this.portOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).portfolioNameProperty());
        this.reactMap.put(this.portOtc.getId(), "PortfolioName");
        this.intervalOtc.setCellValueFactory(data -> ((ObSummarizedOrder)data.getValue()).sumDateProperty());
        this.reactMap.put(this.intervalOtc.getId(), "SumDate");
        this.tableDealOtc.setItems(this.pageOtc.getDataList());
    }

    private void summarize(ObservableList<ObSummarizedOrder> oldList) {
        RefItem refItem;
        ArrayList<RefItem> refList = new ArrayList<RefItem>();
        for (ObSummarizedOrder deal : oldList) {
            refItem = this.refMng.getItem(deal.getSecType(), deal.getMarket().getRaw(), deal.getSecurityId());
            if ("SHSC".equals(deal.getMarket().getRaw()) || "SZSC".equals(deal.getMarket().getRaw())) {
                refItem = this.refMng.getItem(String.valueOf(deal.getSecType()) + deal.getMarket().getRaw(), deal.getMarket().getRaw(), deal.getSecurityId());
            }
            if (refItem == null || this.mktMng.getInfo((IRefItem)refItem) != null) continue;
            refList.add(refItem);
        }
        this.mktMng.query(refList, new Gears());
        for (ObSummarizedOrder deal : oldList) {
            double percent;
            refItem = this.refMng.getItem(deal.getSecType(), deal.getMarket().getRaw(), deal.getSecurityId());
            if ("SHSC".equals(deal.getMarket().getRaw()) || "SZSC".equals(deal.getMarket().getRaw())) {
                refItem = this.refMng.getItem(String.valueOf(deal.getSecType()) + deal.getMarket().getRaw(), deal.getMarket().getRaw(), deal.getSecurityId());
            }
            if (deal.getAvgPx() == 0.0) continue;
            if (refItem == null) {
                percent = 0.0;
                percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getAvgPx()) * 100.0 / deal.getAvgPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getAvgPx() - deal.getNowPrice()) * 100.0 / deal.getAvgPx() : 0.0);
                percent = (double)Math.round(percent * 100.0) / 100.0;
                deal.setPercent(percent);
                continue;
            }
            if (this.mktMng.getInfo((IRefItem)refItem) == null || refItem.getType().equals("PLEDGE")) {
                deal.setPercent(0.0);
                deal.setInterval("\u4e0d\u663e\u793a");
                continue;
            }
            deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getNowPrice());
            if (this.mktMng.getInfo((IRefItem)refItem).getNowPrice() == 0.0) {
                deal.setNowPrice(this.mktMng.getInfo((IRefItem)refItem).getClosePrice());
            }
            percent = 0.0;
            percent = deal.getSide().getRaw().equals(String.valueOf(49)) || deal.getSide().getRaw().equals(String.valueOf(71)) ? (deal.getNowPrice() - deal.getAvgPx()) * 100.0 / deal.getAvgPx() : (deal.getSide().getRaw().equals(String.valueOf(50)) || deal.getSide().getRaw().equals(String.valueOf(70)) ? (deal.getAvgPx() - deal.getNowPrice()) * 100.0 / deal.getAvgPx() : 0.0);
            percent = (double)Math.round(percent * 100.0) / 100.0;
            deal.setPercent(percent);
        }
    }

    @FXML
    private void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableDeal);
    }

    @FXML
    private void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    private void ccsCopyOtc() {
        TableUtils.copyContentWithHead(this.tableDealOtc);
    }

    @FXML
    private void ccsRefreshOtc() {
        this.otcQuery();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u6c47\u603b\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObSummarizedOrder> page = this.ccsDealHisService.getAllCcsSumData(this.pageCcs);
                    this.summarize((ObservableList<ObSummarizedOrder>)page.getDataList());
                    ExcelUtils.writeExcel(this.ccsTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, "\u5bfc\u51faEXCEL\u5f02\u5e38," + e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ccsExportExcelOtc() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u6c47\u603b\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcelOtc.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ObSummarizedOrder> page = this.ccsDealHisService.getAllCcsSumData(this.pageOtc);
                    this.summarize((ObservableList<ObSummarizedOrder>)page.getDataList());
                    ExcelUtils.writeExcel(this.tableDealOtc, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcelOtc.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcelOtc.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, "\u5bfc\u51faEXCEL\u5f02\u5e38," + e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    protected class ItemFloatCell
    extends TableCell<ObSummarizedOrder, Number> {
        protected int scale = 0;
        protected Label label = new Label();

        ItemFloatCell(int i) {
            this.scale = i;
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number value, boolean empty) {
            ObSummarizedOrder sum = (ObSummarizedOrder)this.getTableRow().getItem();
            if (this.getTableRow() == null || this.getTableRow().getItem() == null || empty || "\u4e0d\u663e\u793a".equals(sum.getInterval())) {
                this.setGraphic(null);
                return;
            }
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
            this.label.setText(text);
            CssUtils.checkPct((Control)this.label, (double)value.doubleValue());
            this.setGraphic((Node)this.label);
        }
    }

    private class NumberConvert
    extends NumberCvt {
        private Integer scale;

        public String toString(Number num) {
            if (num == null || this.scale == null) {
                return "";
            }
            return StringUtils.toStr((double)num.doubleValue(), (int)this.scale);
        }

        public void setScale(int scale) {
            this.scale = scale;
        }
    }

    private class PriceAvgCell
    extends TextFieldTableCell<ObSummarizedOrder, Number> {
        private NumberConvert cvt;
        private DoubleFilter df;

        public PriceAvgCell() {
            this.cvt = new NumberConvert();
            this.df = new DoubleFilter(true, 3, 3);
            this.setConverter((StringConverter)this.cvt);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSummarizedOrder deal = (ObSummarizedOrder)ObSummarizedOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = DealHisSumNewQueryPart.this.refMng.getItem(deal.getSecType(), deal.getMarket().getRaw(), deal.getSecurityId());
                int scale = 4;
                if (refItem != null) {
                    scale = refItem.getScale() + 1;
                }
                if ("SHSC".equals(deal.getMarket().getRaw()) || "SZSC".equals(deal.getMarket().getRaw())) {
                    scale = HkwolunPriceUnit.getScale((double)deal.getAvgPx()) + 1;
                }
                this.cvt.setScale(scale);
                this.df.setScale(scale);
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)scale));
            }
        }
    }

    private class PriceNowCell
    extends TextFieldTableCell<ObSummarizedOrder, Number> {
        private NumberConvert cvt;
        private DoubleFilter df;

        public PriceNowCell() {
            this.cvt = new NumberConvert();
            this.df = new DoubleFilter(true, 3, 3);
            this.setConverter((StringConverter)this.cvt);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSummarizedOrder deal = (ObSummarizedOrder)ObSummarizedOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = DealHisSumNewQueryPart.this.refMng.getItem(deal.getSecType(), deal.getMarket().getRaw(), deal.getSecurityId());
                int scale = 3;
                if (refItem != null) {
                    scale = refItem.getScale();
                }
                if ("SHSC".equals(deal.getMarket().getRaw()) || "SZSC".equals(deal.getMarket().getRaw())) {
                    scale = HkwolunPriceUnit.getScale((double)deal.getAvgPx());
                }
                this.cvt.setScale(scale);
                this.df.setScale(scale);
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)scale));
            }
        }
    }
}

