/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.block.BlockDealModel;
import cms.tmx.query.history.ICcsDealHisService;
import cms.tmx.query.history.ICtpDealHisService;
import cms.tmx.query.history.views.HisQueryPart;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DealHisCreaterQueryPart
extends HisQueryPart<CcsDeal, CtpDeal, BlockDeal> {
    private static final Logger logger = LogManager.getLogger(DealHisCreaterQueryPart.class);
    @FXML
    private TableView<CcsDeal> ccsTableDeal;
    @FXML
    private TableColumn<CcsDeal, String> ccsColSecId;
    @FXML
    private TableColumn<CcsDeal, String> ccsColSecName;
    @FXML
    private TableColumn<CcsDeal, MxNode> ccsColDir;
    @FXML
    private TableColumn<CcsDeal, Number> ccsColVol;
    @FXML
    private TableColumn<CcsDeal, String> ccsColUnit;
    @FXML
    private TableColumn<CcsDeal, Number> ccsColPrice;
    @FXML
    private TableColumn<CcsDeal, String> ccsColTime;
    @FXML
    private TableColumn<CcsDeal, String> ccsColDate;
    @FXML
    private TableColumn<CcsDeal, MxNode> ccsColMkt;
    @FXML
    private TableColumn<CcsDeal, String> ccsColENo;
    @FXML
    private TableColumn<CcsDeal, String> ccsColDealNo;
    @FXML
    private TableColumn<CcsDeal, String> ccsColAcc;
    @FXML
    private TableColumn<CcsDeal, String> ccsColAccName;
    @FXML
    private TableColumn<CcsDeal, String> ccsColSecAcc;
    @FXML
    private TableColumn<CcsDeal, Number> ccsColAmt;
    @FXML
    private TableColumn<CcsDeal, String> ccsColReference;
    @FXML
    private TableColumn<CcsDeal, String> ccsColPort;
    @FXML
    private TableColumn<CcsDeal, String> ccsIndex;
    @FXML
    private TableColumn<CtpDeal, String> ctpIndex;
    @FXML
    private TableView<CtpDeal> ctpTableDeal;
    @FXML
    private TableColumn<CtpDeal, String> ctpColSecId;
    @FXML
    private TableColumn<CtpDeal, String> ctpColSecName;
    @FXML
    private TableColumn<CtpDeal, MxNode> colCtpMarket;
    @FXML
    private TableColumn<CtpDeal, MxNode> ctpColDir;
    @FXML
    private TableColumn<CtpDeal, MxNode> ctpColOC;
    @FXML
    private TableColumn<CtpDeal, MxNode> ctpColSH;
    @FXML
    private TableColumn<CtpDeal, Number> ctpColVol;
    @FXML
    private TableColumn<CtpDeal, Number> ctpColPrice;
    @FXML
    private TableColumn<CtpDeal, Number> ctpColExecFee;
    @FXML
    private TableColumn<CtpDeal, String> ctpColTime;
    @FXML
    private TableColumn<CtpDeal, String> ctpColOrdTime;
    @FXML
    private TableColumn<CtpDeal, MxNode> ctpColDealType;
    @FXML
    private TableColumn<CtpDeal, String> ctpColDate;
    @FXML
    private TableColumn<CtpDeal, String> ctpColENo;
    @FXML
    private TableColumn<CtpDeal, String> ctpColAcc;
    @FXML
    private TableColumn<CtpDeal, String> ctpColAccName;
    @FXML
    private TableColumn<CtpDeal, String> ctpColSecAcc;
    @FXML
    private TableColumn<CtpDeal, String> ctpColReference;
    @FXML
    private TableColumn<CtpDeal, String> ctpColDealNo;
    @FXML
    private TableView<BlockDeal> blockTableDeal;
    @FXML
    private TableColumn<BlockDeal, String> colSecId;
    @FXML
    private TableColumn<BlockDeal, String> colSecName;
    @FXML
    private TableColumn<BlockDeal, MxNode> colDir;
    @FXML
    private TableColumn<BlockDeal, Number> colVol;
    @FXML
    private TableColumn<BlockDeal, String> colUnit;
    @FXML
    private TableColumn<BlockDeal, Number> colPrice;
    @FXML
    private TableColumn<BlockDeal, String> colTime;
    @FXML
    private TableColumn<BlockDeal, MxNode> colMkt;
    @FXML
    private TableColumn<BlockDeal, String> colENo;
    @FXML
    private TableColumn<BlockDeal, String> colDealNo;
    @FXML
    private TableColumn<BlockDeal, String> colAcc;
    @FXML
    private TableColumn<BlockDeal, String> colAccName;
    @FXML
    private TableColumn<BlockDeal, String> colSecAcc;
    @FXML
    private TableColumn<BlockDeal, Number> colAmt;
    @FXML
    private TableColumn<BlockDeal, String> colReference;
    @FXML
    private TableColumn<BlockDeal, String> colExecDate;
    @FXML
    private TableColumn<BlockDeal, String> blockIndex;
    @Inject
    private MxAlert alert;
    @Inject
    private ICcsDealHisService ccsDealHisService;
    @Inject
    private ICtpDealHisService ctpDealHisService;
    @Inject
    protected BlockDealModel blockModel;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @FXML
    private Tab blockTab;
    @FXML
    private ComboBox<MxNode> blockPageSize;
    @FXML
    private Pagination blockPagination;
    @FXML
    private Label blockTotalCount;
    @FXML
    private TextField blockJumpPage;
    @FXML
    protected CheckBox cbSH;
    @FXML
    protected CheckBox cbSZ;
    @FXML
    protected CheckBox cbBuy;
    @FXML
    protected CheckBox cbSell;
    @FXML
    protected Label lbBuyCumAmt;
    @FXML
    protected Label lbSellCumAmt;
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;
    @FXML
    private MenuItem blockExcel;
    @FXML
    private MenuItem ctpExcel;

    @Override
    @FXML
    protected void initialize() {
        this.assetGrp = true;
        super.initialize();
        this.creatTableCcs();
        this.creatTableCtp();
        this.createTableBlock();
        this.query();
        this.focusRefresh(this.ccsTableDeal);
        this.focusRefresh(this.ctpTableDeal);
        this.focusRefresh(this.blockTableDeal);
    }

    @Override
    protected void initValue() {
        super.initValue();
        this.initPage(this.blockPagination, this.blockTotalCount, this.blockJumpPage, this.blockPageSize, this.pageBlock);
    }

    @Override
    protected void tabHide(ObservableList<Account> listAcc) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : listAcc) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.ccsTab);
            this.tabPane.getTabs().remove((Object)this.blockTab);
        }
        if (!marketGrpList.contains("FUTURES")) {
            this.tabPane.getTabs().remove((Object)this.ctpTab);
        }
    }

    protected void blockReset() {
        this.blockPagination.setPageCount(1);
        this.blockTotalCount.setText("0");
    }

    @Override
    protected void ctpQuery() {
        if (this.isPortDimension() || this.isAssetGrpDimension() || !this.rebuildPagi(this.pageCtp, this.ctpChangeExtAcc) || this.pageCtp.getExtAccntIdList().isEmpty()) {
            this.ctpReset();
            return;
        }
        try {
            this.ctpChangeExtAcc = false;
            this.ctpDealHisService.query((HisQueryPage<CtpDeal>)this.pageCtp);
            this.cbCtpFiltrate((HisQueryPage<CtpDeal>)this.pageCtp);
            this.sumCtpNum((ObservableList<CtpDeal>)this.pageCtp.getDataList());
        }
        catch (MException e) {
            logger.error("\u671f\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u671f\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.ctpTableDeal.scrollTo(0);
        this.ctpTableDeal.sort();
    }

    @Override
    protected void ccsQuery() {
        this.checkPortfolio(this.ccsTableDeal, this.ccsColPort);
        if (!this.rebuildPagi(this.pageCcs, this.ccsChangeExtAcc)) {
            this.ccsReset();
            return;
        }
        try {
            this.ccsChangeExtAcc = false;
            this.ccsDealHisService.query((HisQueryPage<CcsDeal>)this.pageCcs);
            this.cbFiltrate((HisQueryPage<CcsDeal>)this.pageCcs);
            this.sumNum((ObservableList<CcsDeal>)this.pageCcs.getDataList());
        }
        catch (MException e) {
            logger.error("\u73b0\u8d27\u67e5\u8be2" + e.getMessage(), (Throwable)e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u73b0\u8d27\u67e5\u8be2" + e.getMessage()));
        }
        this.ccsTableDeal.scrollTo(0);
        this.ccsTableDeal.sort();
    }

    private void cbCtpFiltrate(HisQueryPage<CtpDeal> pageCtpDeal) {
        MxList dataList = new MxList();
        dataList.addAll((List)pageCtpDeal.getDataList());
        this.pageCtp.getDataList().clear();
        for (CtpDeal deal : dataList.getList()) {
            if (!"XSHG".equals(deal.getMarket().getRaw()) ? "XSHE".equals(deal.getMarket().getRaw()) && !this.cbSZ.isSelected() : !this.cbSH.isSelected()) continue;
            if ("49".equals(deal.getSide().getRaw()) ? !this.cbBuy.isSelected() : "50".equals(deal.getSide().getRaw()) && !this.cbSell.isSelected()) continue;
            this.pageCtp.getDataList().add((Object)deal);
        }
        this.sumCtpNum((ObservableList<CtpDeal>)this.pageCtp.getDataList());
    }

    private void cbFiltrate(HisQueryPage<CcsDeal> pageCcsDeal) {
        MxList dataList = new MxList();
        dataList.addAll((List)pageCcsDeal.getDataList());
        this.pageCcs.getDataList().clear();
        for (CcsDeal deal : dataList.getList()) {
            if (!"XSHG".equals(deal.getMarket().getRaw()) ? "XSHE".equals(deal.getMarket().getRaw()) && !this.cbSZ.isSelected() : !this.cbSH.isSelected()) continue;
            if ("49".equals(deal.getSide().getRaw()) ? !this.cbBuy.isSelected() : "50".equals(deal.getSide().getRaw()) && !this.cbSell.isSelected()) continue;
            this.pageCcs.getDataList().add((Object)deal);
        }
        this.sumNum((ObservableList<CcsDeal>)this.pageCcs.getDataList());
    }

    @Override
    @FXML
    protected void queryAll() {
        super.queryAll();
        this.blockQuery();
        this.blockChangeExtAcc = false;
        this.sumCtpNum((ObservableList<CtpDeal>)this.pageCtp.getDataList());
        this.sumNum((ObservableList<CcsDeal>)this.pageCcs.getDataList());
    }

    protected void blockQuery() {
        if (!this.rebuildPagi(this.pageBlock, this.blockChangeExtAcc)) {
            this.blockReset();
            return;
        }
        try {
            this.blockChangeExtAcc = false;
            this.blockModel.query((HisQueryPage<BlockDeal>)this.pageBlock);
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u5927\u5b97\u6210\u4ea4\u5931\u8d25" + e.getMessage(), e);
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u5927\u5b97\u6210\u4ea4\u5931\u8d25" + e.getMessage()));
        }
        this.blockTableDeal.scrollTo(0);
        this.blockTableDeal.sort();
    }

    private void creatTableCtp() {
        this.ctpTableDeal.setPlaceholder((Node)new Label());
        this.ctpIndex.setSortable(false);
        TableUtils.isAuto(this.ctpIndex);
        this.ctpColSecId.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().secIdProperty());
        this.ctpColSecName.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().symbolProperty());
        this.colCtpMarket.setCellValueFactory(data -> ((CtpDeal)data.getValue()).getInstrument().marketProperty());
        this.ctpColDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getSide()));
        this.ctpColVol.setCellFactory(column -> new NumberTableCell());
        this.ctpColVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastQty()));
        this.ctpColOC.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getOcFlag()));
        this.ctpColSH.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getShFlag()));
        this.ctpColPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getLastPx()));
        this.ctpColPrice.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.ctpColExecFee.setCellValueFactory(data -> new SimpleDoubleProperty(((CtpDeal)data.getValue()).getExecFee()));
        this.ctpColExecFee.setCellFactory(data -> new FeeCell());
        this.ctpColTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getExecTime()));
        this.ctpColOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getOrdTime()));
        this.ctpColDealType.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CtpDeal)data.getValue()).getDealType()));
        this.ctpColDate.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getExecDate()));
        this.ctpColENo.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getOrderId()));
        this.ctpColDealNo.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getExecId()));
        this.ctpColAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInvestorId()));
        this.ctpColAccName.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInvestorName()));
        this.ctpColSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getInverstorSecId()));
        this.ctpColReference.setCellValueFactory(data -> new SimpleStringProperty(((CtpDeal)data.getValue()).getReference()));
        this.ctpTableDeal.setItems(this.pageCtp.getDataList());
        this.reactMap.put(this.ctpColSecId.getId(), "SecId");
        this.reactMap.put(this.ctpColSecName.getId(), "SecName");
        this.reactMap.put(this.colCtpMarket.getId(), "ExMarket");
        this.reactMap.put(this.ctpColDir.getId(), "ExSide");
        this.reactMap.put(this.ctpColVol.getId(), "LastQty");
        this.reactMap.put(this.ctpColOC.getId(), "ExOcFlag");
        this.reactMap.put(this.ctpColSH.getId(), "ExShFlag");
        this.reactMap.put(this.ctpColPrice.getId(), "LastPx");
        this.reactMap.put(this.ctpColExecFee.getId(), "ExecFee");
        this.reactMap.put(this.ctpColTime.getId(), "ExecTime");
        this.reactMap.put(this.ctpColOrdTime.getId(), "OrdTime");
        this.reactMap.put(this.ctpColDealType.getId(), "DealType");
        this.reactMap.put(this.ctpColDate.getId(), "ExecDate");
        this.reactMap.put(this.ctpColENo.getId(), "OrderId");
        this.reactMap.put(this.ctpColDealNo.getId(), "ExecId");
        this.reactMap.put(this.ctpColAcc.getId(), "InvestorId");
        this.reactMap.put(this.ctpColAccName.getId(), "InvestorName");
        this.reactMap.put(this.ctpColSecAcc.getId(), "InverstorSecId");
        this.reactMap.put(this.ctpColReference.getId(), "Reference");
    }

    private void creatTableCcs() {
        this.ccsTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.ccsIndex);
        this.ccsIndex.setSortable(false);
        this.ccsColSecId.setCellValueFactory(data -> ((CcsDeal)data.getValue()).getInstrument().secIdProperty());
        this.ccsColSecName.setCellValueFactory(data -> ((CcsDeal)data.getValue()).getInstrument().symbolProperty());
        this.ccsColDir.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getSide()));
        this.ccsColDir.setCellFactory(cell -> new SideCell());
        this.ccsColVol.setCellFactory(column -> new NumberTableCell());
        this.ccsColVol.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastQty()));
        this.ccsColUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getUnit()));
        this.ccsColPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastPx()));
        this.ccsColPrice.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.ccsColAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsDeal)data.getValue()).getLastAmount()));
        this.ccsColAmt.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.ccsColMkt.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsDeal)data.getValue()).getMarket()));
        this.ccsColPort.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getPortfolioName()));
        this.ccsColTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getExecTime()));
        this.ccsColDate.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getExecDate()));
        this.ccsColENo.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getOrderId()));
        this.ccsColDealNo.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getExecId()));
        this.ccsColAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorId()));
        this.ccsColAccName.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInvestorName()));
        this.ccsColSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getInverstorSecId()));
        this.ccsColReference.setCellValueFactory(data -> new SimpleStringProperty(((CcsDeal)data.getValue()).getReference()));
        this.ccsTableDeal.setItems(this.pageCcs.getDataList());
        this.reactMap.put(this.ccsColSecId.getId(), "SecId");
        this.reactMap.put(this.ccsColSecName.getId(), "SecName");
        this.reactMap.put(this.ccsColDir.getId(), "ExSide");
        this.reactMap.put(this.ccsColVol.getId(), "LastQty");
        this.reactMap.put(this.ccsColUnit.getId(), "Unit");
        this.reactMap.put(this.ccsColPrice.getId(), "LastPx");
        this.reactMap.put(this.ccsColAmt.getId(), "LastAmount");
        this.reactMap.put(this.ccsColTime.getId(), "ExecTime");
        this.reactMap.put(this.ccsColDate.getId(), "ExecDate");
        this.reactMap.put(this.ccsColMkt.getId(), "ExMarket");
        this.reactMap.put(this.ccsColENo.getId(), "OrderId");
        this.reactMap.put(this.ccsColDealNo.getId(), "ExecId");
        this.reactMap.put(this.ccsColAcc.getId(), "InvestorId");
        this.reactMap.put(this.ccsColAccName.getId(), "InvestorName");
        this.reactMap.put(this.ccsColSecAcc.getId(), "InverstorSecId");
        this.reactMap.put(this.ccsColReference.getId(), "Reference");
        this.reactMap.put(this.ccsColPort.getId(), "PortfolioName");
    }

    private void createTableBlock() {
        this.blockTableDeal.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.blockIndex);
        this.blockIndex.setSortable(false);
        this.colSecId.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().symbolProperty());
        this.colDir.setCellValueFactory(data -> ((BlockDeal)data.getValue()).sideProperty());
        this.colDir.setCellFactory(cell -> new SideCell());
        this.colVol.setCellFactory(column -> new NumberTableCell());
        this.colVol.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealQtyProperty());
        this.colUnit.setCellValueFactory(data -> ((BlockDeal)data.getValue()).unitProperty());
        this.colPrice.setCellValueFactory(data -> ((BlockDeal)data.getValue()).priceProperty());
        this.colPrice.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.colTime.setCellValueFactory(data -> ((BlockDeal)data.getValue()).execTimeProperty());
        this.colMkt.setCellValueFactory(data -> ((BlockDeal)data.getValue()).getInstrument().marketProperty());
        this.colENo.setCellValueFactory(data -> ((BlockDeal)data.getValue()).orderIdProperty());
        this.colDealNo.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealIdProperty());
        this.colAcc.setCellValueFactory(data -> ((BlockDeal)data.getValue()).investorIdProperty());
        this.colAccName.setCellValueFactory(data -> ((BlockDeal)data.getValue()).investorNameProperty());
        this.colSecAcc.setCellValueFactory(data -> ((BlockDeal)data.getValue()).inverstorSecIdProperty());
        this.colAmt.setCellValueFactory(data -> ((BlockDeal)data.getValue()).dealAmountProperty());
        this.colAmt.setCellFactory(data -> new HisQueryPart.PriceCell(this));
        this.colReference.setCellValueFactory(data -> ((BlockDeal)data.getValue()).referenceProperty());
        this.colExecDate.setCellValueFactory(date -> ((BlockDeal)date.getValue()).execDateProperty());
        this.blockTableDeal.setItems(this.pageBlock.getDataList());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.reactMap.put(this.colDir.getId(), "ExSide");
        this.reactMap.put(this.colMkt.getId(), "ExMarket");
        this.reactMap.put(this.colVol.getId(), "DealQty");
        this.reactMap.put(this.colUnit.getId(), "Unit");
        this.reactMap.put(this.colPrice.getId(), "Price");
        this.reactMap.put(this.colTime.getId(), "ExecTime");
        this.reactMap.put(this.colENo.getId(), "OrderId");
        this.reactMap.put(this.colDealNo.getId(), "DealId");
        this.reactMap.put(this.colAcc.getId(), "InvestorId");
        this.reactMap.put(this.colAccName.getId(), "InvestorName");
        this.reactMap.put(this.colSecAcc.getId(), "InverstorSecId");
        this.reactMap.put(this.colAmt.getId(), "DealAmount");
        this.reactMap.put(this.colReference.getId(), "Reference");
        this.reactMap.put(this.colExecDate.getId(), "ExecDate");
    }

    @FXML
    private void ccsCopy() {
        TableUtils.copyContentWithHead(this.ccsTableDeal);
    }

    @FXML
    private void ccsRefresh() {
        this.ccsQuery();
    }

    @FXML
    private void blockCopy() {
        TableUtils.copyContentWithHead(this.blockTableDeal);
    }

    @FXML
    private void blockRefresh() {
        this.blockQuery();
    }

    @FXML
    private void ctpCopy() {
        TableUtils.copyContentWithHead(this.ctpTableDeal);
    }

    @FXML
    private void ctpRefresh() {
        this.ctpQuery();
    }

    @FXML
    private void ccsExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CcsDeal> page = this.ccsDealHisService.getAllCcsData((HisQueryPage<CcsDeal>)this.pageCcs);
                    ExcelUtils.writeExcel(this.ccsTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void blockExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u5927\u5b97\u6210\u4ea4\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.blockExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<BlockDeal> page = this.blockModel.getAllBlockData((HisQueryPage<BlockDeal>)this.pageBlock);
                    ExcelUtils.writeExcel(this.blockTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.blockExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.blockExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void ctpExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u6210\u4ea4\u67e5\u8be22");
            if (file == null) {
                return;
            }
            this.ctpExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CtpDeal> page = this.ctpDealHisService.getAllCtpData((HisQueryPage<CtpDeal>)this.pageCtp);
                    ExcelUtils.writeExcel(this.ctpTableDeal, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ctpExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ctpExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    private void sumNum(ObservableList<CcsDeal> dataList) {
        Platform.runLater(() -> {
            double cumSellAmt = 0.0;
            double cumBuyAmt = 0.0;
            for (CcsDeal order : dataList) {
                if ("49".equals(order.getSide().getRaw()) || "71".equals(order.getSide().getRaw())) {
                    cumBuyAmt += order.getLastAmount();
                }
                if (!"50".equals(order.getSide().getRaw())) continue;
                cumSellAmt += order.getLastAmount();
            }
            this.lbBuyCumAmt.setText(StringUtils.toThousands((Number)cumBuyAmt, (int)2));
            this.lbSellCumAmt.setText(StringUtils.toThousands((Number)cumSellAmt, (int)2));
        });
    }

    private void sumCtpNum(ObservableList<CtpDeal> dataList) {
        Platform.runLater(() -> {
            double cumSellAmt = 0.0;
            double cumBuyAmt = 0.0;
            for (CtpDeal order : dataList) {
                if ("49".equals(order.getSide().getRaw()) || "71".equals(order.getSide().getRaw())) {
                    cumBuyAmt += order.getLastAmount();
                }
                if (!"50".equals(order.getSide().getRaw())) continue;
                cumSellAmt += order.getLastAmount();
            }
            this.lbBuyCumAmt.setText(StringUtils.toThousands((Number)cumBuyAmt, (int)2));
            this.lbSellCumAmt.setText(StringUtils.toThousands((Number)cumSellAmt, (int)2));
        });
    }

    private class FeeCell
    extends DoubleTableCell<CtpDeal> {
        int scale = 3;

        private FeeCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

