/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.checkComboBox.CheckComboBoxModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.EtfRefreshModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ICcsOrderHisService;
import cms.tmx.query.history.models.CrossOrderHisServiceImpl;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class CrossOrderHisQueryPart
extends MxPart {
    @FXML
    private TableView<CrossOrder> tableView;
    @FXML
    private TableColumn<CrossOrder, String> id;
    @FXML
    private TableColumn<CrossOrder, String> source;
    @FXML
    private TableColumn<CrossOrder, String> ordTime;
    @FXML
    private TableColumn<CrossOrder, String> ordDate;
    @FXML
    private TableColumn<CrossOrder, String> code;
    @FXML
    private TableColumn<CrossOrder, String> instName;
    @FXML
    private TableColumn<CrossOrder, String> user;
    @FXML
    private TableColumn<CrossOrder, String> ordStatus;
    @FXML
    private TableColumn<CrossOrder, String> secAccntId;
    @FXML
    private TableColumn<CrossOrder, String> legStatus;
    @FXML
    private TableColumn<CrossOrder, String> accntId;
    @FXML
    private TableColumn<CrossOrder, String> index;
    @FXML
    private CheckComboBox<Account> ccmbAccnt;
    @FXML
    private TextField secIdSearch;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> pageSize;
    @FXML
    private ComboBox<MxNode> comType;
    @FXML
    private Pagination pagination;
    @Inject
    private PortfolioAccountModel subAccMng;
    @FXML
    private Label lbAccnt;
    @FXML
    private Label totalCount;
    @FXML
    private TextField jumpPage;
    @FXML
    private Button btnSearch;
    @FXML
    private Tab etfTab;
    @FXML
    private TabPane tabPane;
    @Inject
    private MxAlert alert;
    @Inject
    private IFundAccountService fundAccntService;
    @Inject
    private IAccountService accntService;
    @Inject
    private MObjFactory of;
    @Inject
    private IBaseApi iba;
    @Inject
    private ExecutorService exe;
    private MxNode nodeStatus;
    private String TYPE_ETF = "etf";
    private String ordStatusGroup;
    @Inject
    private CrossOrderHisServiceImpl crossOrderHisService;
    private HisQueryPage<CrossOrder> orderPage;
    protected ObservableList<CrossOrder> etfList = FxUtils.newList();
    private Boolean reBuildCcsPagiCount = true;
    @Inject
    private EtfRefreshModel refreshMng;
    @FXML
    protected TableView<CcsOrder> tableDetailView;
    @FXML
    private TableColumn<CcsOrder, String> colSecId;
    @FXML
    private TableColumn<CcsOrder, String> colSecName;
    @FXML
    private TableColumn<CcsOrder, MxNode> colSecSide;
    @FXML
    private TableColumn<CcsOrder, String> colOrdTime;
    @FXML
    private TableColumn<CcsOrder, String> colOrdStatus;
    @FXML
    private TableColumn<CcsOrder, String> colUnit;
    @FXML
    private TableColumn<CcsOrder, MxNode> colMarket;
    @FXML
    private TableColumn<CcsOrder, String> colOrderId;
    @FXML
    private TableColumn<CcsOrder, String> colAccId;
    @FXML
    private TableColumn<CcsOrder, String> colSecAcc;
    @FXML
    private TableColumn<CcsOrder, Number> colPrice;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderQty;
    @FXML
    private TableColumn<CcsOrder, Number> colOrderAmt;
    @FXML
    private TableColumn<CcsOrder, Number> colDoneVol;
    @FXML
    private TableColumn<CcsOrder, Number> colPercent;
    @FXML
    private TableColumn<CcsOrder, Number> colAvgPrice;
    @FXML
    private TableColumn<CcsOrder, String> colInfo;
    @FXML
    private TableColumn<CcsOrder, String> colUser;
    @Inject
    private IRefDataMng refMng;
    private Map<String, String> reactMap = new HashMap<String, String>();
    @Inject
    private ICcsOrderHisService ccsOrderHisService;
    private static final Logger logger = LogManager.getLogger(CrossOrderHisQueryPart.class);
    protected static final String FORMAT = "yyyy-MM-dd";
    protected ObservableList<CcsOrder> orderList = FxUtils.newList();
    private MxNode node;
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.nodeStatus = MxNodeFactory.create((String)"etf_order_status", (String)"");
        this.initValue();
        this.initPage();
        this.bind();
        this.createTable();
        this.createDetailTable();
        this.query();
        this.node = ((MxNode)this.of.create(MxNode.class)).load("ord_status", "");
    }

    @FXML
    private void query() {
        if (!this.checkDate().booleanValue()) {
            return;
        }
        this.etfQuery();
    }

    private void queryDetail(CrossOrder crossOrder) {
        try {
            this.orderList.clear();
            HisQueryPage orderDetailPage = new HisQueryPage();
            ArrayList<String> list = new ArrayList<String>();
            list.add(crossOrder.getAccntId());
            orderDetailPage.setMarketGrp("CCS");
            orderDetailPage.setBeginDate(crossOrder.getOrdDate());
            orderDetailPage.setEndDate(crossOrder.getOrdDate());
            orderDetailPage.setExtAccntIdList(list);
            this.ccsOrderHisService.queryOneCcsOrder((HisQueryPage<CcsOrder>)orderDetailPage, crossOrder.getId());
            this.orderList.addAll((Collection)orderDetailPage.getDetailList());
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createDetailTable() {
        this.colSecId.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((CcsOrder)data.getValue()).getInstrument().symbolProperty());
        this.colSecSide.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getSide()));
        this.colSecSide.setCellFactory(cell -> new SideCell());
        this.colPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getPrice()));
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colOrderQty.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getOrderQty()));
        this.colOrderQty.setCellFactory(cell -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUnit()));
        this.colOrderAmt.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getOrderAmt()));
        this.colOrderAmt.setCellFactory(p -> new PriceCell());
        this.colDoneVol.setCellValueFactory(data -> new SimpleIntegerProperty(((CcsOrder)data.getValue()).getCumQty()));
        this.colDoneVol.setCellFactory(cell -> new NumberTableCell());
        this.colPercent.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getDonePercent()));
        this.colPercent.setCellFactory(column -> new DoubleTableCell());
        this.colAvgPrice.setCellValueFactory(data -> new SimpleDoubleProperty(((CcsOrder)data.getValue()).getAvgPx()));
        this.colAvgPrice.setCellFactory(p -> new PriceCell());
        this.colOrdTime.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrdTime()));
        this.colOrdStatus.setCellValueFactory(data -> {
            String ordStatus = ((CcsOrder)data.getValue()).getOrdStatus().getRaw();
            SimpleStringProperty flag = new SimpleStringProperty(this.getOrderText(Integer.valueOf(ordStatus)));
            return flag;
        });
        this.colMarket.setCellValueFactory(data -> new SimpleObjectProperty((Object)((CcsOrder)data.getValue()).getInstrument().getMarket()));
        this.colOrderId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getOrderId()));
        this.colAccId.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInvestorId()));
        this.colSecAcc.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getInverstorSecId()));
        this.colInfo.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getErrInfo()));
        this.colUser.setCellValueFactory(data -> new SimpleStringProperty(((CcsOrder)data.getValue()).getUserId()));
        this.tableDetailView.setItems(this.orderList);
        this.tableDetailView.setPlaceholder((Node)new Label());
        this.colOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableDetailView.getSortOrder().add(this.colOrdTime);
        TableUtils.orgnizeClmWidth(this.tableDetailView);
    }

    private void etfReset() {
        this.etfList.clear();
        this.pagination.setPageCount(1);
        this.totalCount.setText("0");
    }

    private void etfQuery() {
        if (!this.checkDate().booleanValue()) {
            return;
        }
        this.etfList.clear();
        this.rebuildPagi(this.orderPage, this.pagination, this.pageSize, "CCS");
        if (this.orderPage.getExtAccntIdList().isEmpty()) {
            this.etfReset();
            return;
        }
        try {
            this.crossOrderHisService.query(this.orderPage);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.etfList.addAll((Collection)this.orderPage.getDataList());
        if (this.reBuildCcsPagiCount.booleanValue()) {
            this.pagination.setPageCount(this.orderPage.getTotalCount() % this.orderPage.getPageSize() == 0 ? (this.orderPage.getTotalCount() / this.orderPage.getPageSize() == 0 ? 1 : this.orderPage.getTotalCount() / this.orderPage.getPageSize()) : this.orderPage.getTotalCount() / this.orderPage.getPageSize() + 1);
        }
        this.reBuildCcsPagiCount = true;
        this.totalCount.setText(String.valueOf(this.orderPage.totalCountProperty().get()));
        this.tableView.scrollTo(0);
        if (this.beginDateText.getValue() != null) {
            this.refreshMng.setStartDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        }
        if (this.endDateText.getValue() != null) {
            this.refreshMng.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        }
        if (this.orderPage.getDataList().size() == 0) {
            this.tableView.scrollToColumnIndex(0);
        }
    }

    private Boolean checkDate() {
        if (this.beginDateText.getValue() == null) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f");
            return false;
        }
        if (this.endDateText.getValue() == null) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f");
            return false;
        }
        if (((LocalDate)this.beginDateText.getValue()).isAfter((ChronoLocalDate)this.endDateText.getValue())) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            return false;
        }
        return true;
    }

    private void rebuildPagi(HisQueryPage orderPage, Pagination pagination, ComboBox<MxNode> pageSize, String marketGrp) {
        orderPage.setCurrentPage(Integer.valueOf(pagination.getCurrentPageIndex()));
        orderPage.setPageSize(Integer.valueOf(((MxNode)pageSize.getValue()).getRaw()));
        orderPage.setMarketGrp(marketGrp);
        if (this.beginDateText.getValue() != null) {
            LocalDate beginDate = (LocalDate)this.beginDateText.getValue();
            StringBuilder bDateSb = new StringBuilder();
            bDateSb.append(beginDate.getYear()).append(beginDate.getMonthValue() < 10 ? "0" + beginDate.getMonthValue() : Integer.valueOf(beginDate.getMonthValue())).append(beginDate.getDayOfMonth() < 10 ? "0" + beginDate.getDayOfMonth() : Integer.valueOf(beginDate.getDayOfMonth()));
            orderPage.setBeginDate(bDateSb.toString());
        }
        if (this.endDateText.getValue() != null) {
            LocalDate endDate = (LocalDate)this.endDateText.getValue();
            StringBuilder eDateSb = new StringBuilder();
            eDateSb.append(endDate.getYear()).append(endDate.getMonthValue() < 10 ? "0" + endDate.getMonthValue() : Integer.valueOf(endDate.getMonthValue())).append(endDate.getDayOfMonth() < 10 ? "0" + endDate.getDayOfMonth() : Integer.valueOf(endDate.getDayOfMonth()));
            orderPage.setEndDate(eDateSb.toString());
        }
        ObservableList extAccntIdListStr = FxUtils.newList();
        this.fundAccntService.getFundAccountList().forEach(arg_0 -> this.lambda$25(marketGrp, (List)extAccntIdListStr, arg_0));
        orderPage.setExtAccntIdList((List)extAccntIdListStr);
    }

    private void initPage() {
        this.pagination.setPageCount(1);
        this.pagination.currentPageIndexProperty().addListener(e -> {
            this.reBuildCcsPagiCount = false;
            this.etfQuery();
        });
    }

    private void bind() {
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.orderPage.securityIdProperty().bind((ObservableValue)this.secIdSearch.textProperty());
        this.pageSize.valueProperty().addListener(e -> this.etfQuery());
        this.jumpPage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.tableView.requestFocus();
            }
        });
        this.jumpPage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && !"".equals(this.jumpPage.getText())) {
                this.pagination.setCurrentPageIndex(Integer.valueOf(this.jumpPage.getText()) - 1);
            }
        });
        this.jumpPage.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
    }

    private void initValue() {
        MxNode nodeType = MxNodeFactory.create((String)"crossOrder_type", (String)this.TYPE_ETF);
        this.comType.setItems(nodeType.getNodes());
        this.comType.getSelectionModel().select(0);
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        LocalDate ldBegin = LocalDate.now().minusDays(7L);
        this.beginDateText.setValue((Object)ldBegin);
        LocalDate ldEnd = LocalDate.now();
        this.endDateText.setValue((Object)ldEnd);
        this.orderPage = (HisQueryPage)this.of.create(HisQueryPage.class);
        MxNode node = MxNodeFactory.create((String)"page_size", (String)"100");
        ObservableList nodes = node.getNodes();
        Collections.sort(nodes, new Comparator<MxNode>(){

            @Override
            public int compare(MxNode c1, MxNode c2) {
                int i = Integer.valueOf(c1.getRaw()) - Integer.valueOf(c2.getRaw());
                return i;
            }
        });
        this.pageSize.setItems(nodes);
        this.pageSize.setValue((Object)node.getNode("100"));
        try {
            ObservableList accountList = this.accntService.getAccountListByPost(this.iba.getPostId());
            Account account = new Account();
            account.setInvestorId("");
            account.setName("\u5168\u9009");
            this.ccmbAccnt.getItems().add((Object)account);
            this.tabHide((ObservableList<Account>)accountList);
            this.ccmbAccnt.getItems().addAll((Collection)accountList);
            this.ccmbAccnt.setConverter((StringConverter)new StringConverter<Account>(){

                public String toString(Account accnt) {
                    if (accnt.getInvestorId().isEmpty()) {
                        return accnt.getName();
                    }
                    return String.valueOf(accnt.getInvestorId()) + "-" + accnt.getName();
                }

                public Account fromString(String string) {
                    return null;
                }
            });
        }
        catch (MException e2) {
            this.alert.alert(Alert.AlertType.ERROR, e2.getMessage());
        }
        CheckComboBoxModel checkComboBoxModel = new CheckComboBoxModel(this.ccmbAccnt);
        checkComboBoxModel.init();
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList checkedItems = this.ccmbAccnt.getCheckModel().getCheckedItems();
            ObservableList listAccStr = FxUtils.newList();
            for (Account account : checkedItems) {
                if (account.getInvestorId().isEmpty()) continue;
                listAccStr.add(account.getInvestorId());
            }
            this.lbAccnt.setText(listAccStr.toString().substring(1, listAccStr.toString().length() - 1));
        });
        this.lbAccnt.textProperty().addListener(e -> this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText())));
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    private void tabHide(ObservableList<Account> accountList) {
        ObservableList marketGrpList = FxUtils.newList();
        for (Account acct : accountList) {
            marketGrpList.add(MarketUtils.findMarketGrp((List)acct.getSecExc()));
        }
        for (Account acct : this.subAccMng.getSubFundSecMap().keySet()) {
            marketGrpList.add(acct.getMarketGrp());
        }
        if (!marketGrpList.contains("CCS")) {
            this.tabPane.getTabs().remove((Object)this.etfTab);
        }
    }

    private void createTable() {
        this.tableView.setPlaceholder((Node)new Label());
        this.index.setCellFactory(p -> new IdTableCell());
        this.index.setSortable(false);
        this.id.setCellValueFactory(data -> ((CrossOrder)data.getValue()).idProperty());
        this.source.setCellValueFactory(data -> ((CrossOrder)data.getValue()).sourceProperty());
        this.ordDate.setCellValueFactory(data -> ((CrossOrder)data.getValue()).ordDateProperty());
        this.ordTime.setCellValueFactory(data -> ((CrossOrder)data.getValue()).ordTimeProperty());
        this.code.setCellValueFactory(data -> ((CrossOrder)data.getValue()).codeProperty());
        this.instName.setCellValueFactory(data -> ((CrossOrder)data.getValue()).instNameProperty());
        this.user.setCellValueFactory(data -> ((CrossOrder)data.getValue()).userProperty());
        this.legStatus.setCellValueFactory(data -> {
            String legStr = ((CrossOrder)data.getValue()).getLegStatus();
            if (legStr.equals("leg_pending")) {
                legStr = "\u6709\u6548\u72b6\u6001";
            } else if (legStr.equals("leg_over")) {
                legStr = "\u5b8c\u7ed3\u72b6\u6001";
            }
            SimpleStringProperty leg = new SimpleStringProperty(legStr);
            return leg;
        });
        this.secAccntId.setCellValueFactory(data -> ((CrossOrder)data.getValue()).inverstorSecIdProperty());
        this.ordStatus.setCellFactory(data -> new AutoTableCell());
        this.ordStatus.setCellValueFactory(data -> {
            int ordStatus = ((CrossOrder)data.getValue()).getOrdStatus();
            SimpleStringProperty flag = new SimpleStringProperty(this.getOrderText(ordStatus));
            return flag;
        });
        this.accntId.setCellValueFactory(data -> ((CrossOrder)data.getValue()).investorIdProperty());
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.etfList);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.queryDetail((CrossOrder)now);
            }
        });
        this.reactMap.put(this.id.getId(), "Id");
        this.reactMap.put(this.source.getId(), "Source");
        this.reactMap.put(this.ordDate.getId(), "OrdDate");
        this.reactMap.put(this.ordTime.getId(), "OrdTime");
        this.reactMap.put(this.code.getId(), "Code");
        this.reactMap.put(this.instName.getId(), "InstName");
        this.reactMap.put(this.user.getId(), "User");
        this.reactMap.put(this.legStatus.getId(), "ExLegStatus");
        this.reactMap.put(this.secAccntId.getId(), "InverstorSecId");
        this.reactMap.put(this.ordStatus.getId(), "ExOrdStatus");
        this.reactMap.put(this.accntId.getId(), "InvestorId");
    }

    private String getOrderText(int ordStatus) {
        this.node.setRaw(Integer.toString(ordStatus / 100));
        String groupStatus = "\u4e70\u5355" + this.node.getValue();
        this.node.setRaw(Integer.toString(ordStatus % 100));
        groupStatus = String.valueOf(groupStatus) + ",\u5356\u5355" + this.node.getValue();
        return groupStatus;
    }

    private String getOrdStatusGroup() {
        return this.ordStatusGroup;
    }

    private void setOrdStatusGroup(String ordStatusGroup) {
        this.ordStatusGroup = ordStatusGroup;
    }

    @FXML
    public void refresh() {
        this.etfQuery();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView, (int)1, (int)0);
    }

    @FXML
    private void etfExportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u505a\u5e02\u5355\u67e5\u8be2");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<CrossOrder> page = this.crossOrderHisService.getAllCrossOrderData(this.orderPage);
                    ExcelUtils.writeExcel(this.tableView, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    private void detailExportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableDetailView, (String)"\u505a\u5e02\u5355\u8be6\u60c5\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private /* synthetic */ void lambda$25(String string, List list, FundAccount item) {
        if (this.lbAccnt.getText().contains(item.getInvestId()) && string.equals(item.getMarketGrp())) {
            list.add(item.getExtAccntId());
        }
    }

    public class AutoTableCell<S, T>
    extends TableCell<CrossOrder, T> {
        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                CrossOrder orderExtra = (CrossOrder)this.getTableRow().getItem();
                if (orderExtra == null) {
                    return;
                }
                int ordStatus = orderExtra.getOrdStatus();
                this.setText(CrossOrderHisQueryPart.this.getOrderText(ordStatus));
                CrossOrderHisQueryPart.this.setOrdStatusGroup(CrossOrderHisQueryPart.this.getOrderText(ordStatus));
            }
            CrossOrderHisQueryPart.this.tableView.refresh();
        }
    }

    private class IdTableCell<T>
    extends TableCell<T, String> {
        private IdTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            this.setGraphic(null);
            if (!empty) {
                int rowIndex = this.getIndex() + 1;
                this.setText(String.valueOf(rowIndex));
            }
        }
    }

    private class PriceCell
    extends EditTableCell<CcsOrder> {
        double unit = 0.001;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CcsOrder order = (CcsOrder)CcsOrder.class.cast(this.getTableRow().getItem());
                RefItem refItem = CrossOrderHisQueryPart.this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
                if (refItem != null) {
                    this.unit = refItem.getPriceUnit();
                }
                this.setText(StringUtils.toPriceStr((double)item.doubleValue(), (double)this.unit));
            }
        }
    }
}

