/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.history.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.ImportExcel;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.Product;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.ClearRecordFactory;
import cms.tmx.entity.trade.BusinessRef;
import cms.tmx.entity.trade.ClearRecord;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.IBusinessRefService;
import cms.tmx.query.history.IClearRecordHisService;
import cms.tmx.query.history.views.BusinessRefDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Pagination;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class ClearRecordHisQueryPart
extends MxPart {
    private static final String FORMAT = "yyyy-MM-dd";
    @FXML
    private Tab ccsTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private DatePicker beginDateText;
    @FXML
    private DatePicker endDateText;
    @FXML
    private ComboBox<MxNode> btnDimension;
    @FXML
    private ComboBox<MxNode> ccsPageSize;
    @FXML
    private Pagination ccsPagination;
    @FXML
    private Label ccsTotalCount;
    @FXML
    private TextField ccsJumpPage;
    @FXML
    private TextField secIdSearch;
    @FXML
    private Button btnSearch;
    @FXML
    private ComboBox<String> listTemp;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private IBaseApi iba;
    @Inject
    private MxAlert alert;
    private HisQueryPage<ClearRecord> pageCcs = new HisQueryPage();
    @FXML
    private TableView<ClearRecord> tableClearRecord;
    @FXML
    private TableColumn<ClearRecord, String> colRecordId;
    @FXML
    private TableColumn<ClearRecord, String> colRecordDate;
    @FXML
    private TableColumn<ClearRecord, String> colExtAccntId;
    @FXML
    private TableColumn<ClearRecord, String> colAccName;
    @FXML
    private TableColumn<ClearRecord, String> colExtSecAccntId;
    @FXML
    private TableColumn<ClearRecord, String> colTradeType;
    @FXML
    private TableColumn<ClearRecord, String> colSecId;
    @FXML
    private TableColumn<ClearRecord, String> colSecName;
    @FXML
    private TableColumn<ClearRecord, MxNode> colMarket;
    @FXML
    private TableColumn<ClearRecord, String> colPortfolio;
    @FXML
    private TableColumn<ClearRecord, String> colUserName;
    @FXML
    private TableColumn<ClearRecord, String> colOperateTime;
    @FXML
    private TableColumn<ClearRecord, Number> colBeginSecQty;
    @FXML
    private TableColumn<ClearRecord, Number> colSecOccurQty;
    @FXML
    private TableColumn<ClearRecord, Number> colSecBalance;
    @FXML
    private TableColumn<ClearRecord, Number> colBeginAmt;
    @FXML
    private TableColumn<ClearRecord, Number> colOccurAmt;
    @FXML
    private TableColumn<ClearRecord, Number> colBalance;
    @FXML
    private TableColumn<ClearRecord, Number> colOrderPrice;
    @FXML
    private TableColumn<ClearRecord, Number> colOrderVol;
    @FXML
    private TableColumn<ClearRecord, String> colOrderTime;
    @FXML
    private TableColumn<ClearRecord, Number> colPrice;
    @FXML
    private TableColumn<ClearRecord, Number> colQty;
    @FXML
    private TableColumn<ClearRecord, Number> colAmount;
    @FXML
    private TableColumn<ClearRecord, String> colTradeTime;
    @FXML
    private TableColumn<ClearRecord, Number> colCommision;
    @FXML
    private TableColumn<ClearRecord, Number> colChgFee;
    @FXML
    private TableColumn<ClearRecord, Number> colStampTax;
    @FXML
    private TableColumn<ClearRecord, Number> colHandleFee;
    @FXML
    private TableColumn<ClearRecord, Number> colSecAdminFee;
    @FXML
    private TableColumn<ClearRecord, Number> colOtherFee;
    @FXML
    private TableColumn<ClearRecord, Number> colRealFee;
    @FXML
    private TableColumn<ClearRecord, String> colIndex;
    @FXML
    private TableColumn<ClearRecord, String> colProductName;
    @FXML
    private TableColumn<ClearRecord, String> colWriteoff;
    @FXML
    private TableColumn<ClearRecord, String> colInfo;
    @FXML
    private TableColumn<ClearRecord, Number> colDerivationAmt;
    @FXML
    private TableColumn<ClearRecord, Number> colDerivationQty;
    @FXML
    private TableColumn<ClearRecord, Number> colDerivationBalance;
    @FXML
    private TableColumn<ClearRecord, Number> colDealCount;
    @FXML
    private TableColumn<ClearRecord, Number> colSettlementFee;
    @FXML
    private TableColumn<ClearRecord, Number> colTransactionFee;
    @FXML
    private TableColumn<ClearRecord, Number> colRiskFee;
    @FXML
    private TableColumn<ClearRecord, Number> colStampTaxSub;
    @FXML
    private TableColumn<ClearRecord, Number> colChgFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colSettlementFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colTransactionFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colHandleFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colSecAdminFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colOtherFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colRiskFeeSub;
    @FXML
    private TableColumn<ClearRecord, Number> colNetFee;
    @FXML
    private TableColumn<ClearRecord, Number> colOrderFee;
    @Inject
    protected MObjFactory of;
    @Inject
    protected DialogFactory df;
    @Inject
    private IClearRecordHisService clearRecordService;
    private static final Logger logger = LogManager.getLogger(ClearRecordHisQueryPart.class);
    private boolean changeExtAcc = false;
    private Map<String, String> reactMap = new HashMap<String, String>();
    ObservableList<String> templist = FxUtils.newList();
    @Inject
    private ProductMngServiceImpl productMng;
    private List<Product> productList;
    private List<Portfolio> portfList;
    private final String XLSX = ".XLSX";
    private final String xlsx = ".xlsx";
    private final String XLS = ".XLS";
    private final String xls = ".xls";
    private final String ZX = "\u4e2d\u4fe1";
    private final String JT = "\u5efa\u6295";
    private final String ZXTP = "\u4e2d\u4fe1\u6a21\u677f";
    private final String JTTP = "\u5efa\u6295\u6a21\u677f";
    private String fileUrl = "";
    private String fileName = "";
    @Inject
    private ClearRecordFactory factory;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IBusinessRefService busiService;
    private List<BusinessRef> busiList = new LinkedList<BusinessRef>();
    @Inject
    private ExecutorService exe;
    @FXML
    private MenuItem ccsExcel;

    @FXML
    private void initialize() {
        this.pageCcs.setMarketGrp("CCS");
        this.initValue();
        this.pageCcs.changedProperty().addListener(ob -> this.queryAll());
        this.createTable();
        this.query();
        this.focusRefresh(this.tableClearRecord);
        this.listTemp.setOnMouseEntered(event -> this.listTemp.show());
    }

    private void initValue() {
        DatePickerUtils.setDateLimit((DatePicker)this.beginDateText, (DatePicker)this.endDateText, (boolean)true, (boolean)true, (boolean)true);
        LocalDate ldEnd = LocalDate.now().minusDays(1L);
        LocalDate ldBegin = ldEnd.minusDays(7L);
        DatePickerUtils.setFormat((DatePicker)this.beginDateText, (String)FORMAT);
        DatePickerUtils.setFormat((DatePicker)this.endDateText, (String)FORMAT);
        this.beginDateText.setValue((Object)ldBegin);
        this.endDateText.setValue((Object)ldEnd);
        MxNode node = MxNodeFactory.create((String)"query_dimension_clearrecord", (String)"3");
        this.btnDimension.setItems(node.getNodes());
        this.btnDimension.setValue((Object)node);
        this.secIdSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]*", 12));
        this.secIdSearch.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.query();
                this.btnSearch.requestFocus();
            }
        });
        this.initCheckBoxProduct();
        this.initCheckBoxPort();
        this.initPage(this.ccsPagination, this.ccsTotalCount, this.ccsJumpPage, this.ccsPageSize, this.pageCcs);
        this.templist.add((Object)"\u4e2d\u4fe1\u6a21\u677f");
        this.templist.add((Object)"\u5efa\u6295\u6a21\u677f");
        this.listTemp.setItems(this.templist);
        this.listTemp.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.fileUrl = "\u5efa\u6295\u6a21\u677f".equals(now) ? "/res/\u5efa\u6295\u8bc1\u5238\u6d41\u6c34\u6a21\u677f.xls" : "/res/\u4e2d\u4fe1\u8bc1\u5238\u6d41\u6c34\u6a21\u677f.XLS";
                this.fileName = this.fileUrl.substring(5, 13);
                InputStream fis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.fileUrl);
                try {
                    ExcelUtils.saveFile((InputStream)fis, (String)(String.valueOf(this.fileName) + ".xls"));
                    this.alert.alert(Alert.AlertType.INFORMATION, String.valueOf(now) + "\u4e0b\u8f7d\u6210\u529f");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (e.getMessage() != null) {
                        this.alert.alert(Alert.AlertType.ERROR, "\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
                catch (MException mException) {}
                Platform.runLater(() -> this.listTemp.getSelectionModel().clearSelection());
            }
        });
    }

    private void initCheckBoxProduct() {
        try {
            this.productList = this.productMng.getProducts(this.iba.getPartyId());
        }
        catch (MException e) {
            Platform.runLater(() -> {
                logger.error("\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u4ea7\u54c1", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
    }

    private void initCheckBoxPort() {
        this.portfList = new ArrayList<Portfolio>();
        try {
            List listPortfolio = this.portfolioMng.getPortfoliosByParty(this.iba.getPartyId());
            for (Portfolio port : listPortfolio) {
                if (port.isExternalAsset()) continue;
                this.portfList.add(port);
            }
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u673a\u6784ID\u67e5\u8be2\u6295\u7ec4", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void query() {
        this.pageCcs.clear();
        String raw = ((MxNode)this.btnDimension.getValue()).getRaw();
        this.pageCcs.setDimension(raw);
        this.changeExtAcc = true;
        this.pageCcs.setSecurityId(this.secIdSearch.getText());
        this.queryAll();
    }

    private void queryAll() {
        this.ccsQuery();
    }

    private void initPage(Pagination pagination, Label total, TextField txtJump, ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        MxNode node = MxNodeFactory.createNew((String)"page_size", (String)"20");
        Platform.runLater(() -> node.getNodes().sort((o1, o2) -> Integer.parseInt(o1.getRaw()) - Integer.parseInt(o2.getRaw())));
        cmbSize.setItems(node.getNodes());
        cmbSize.setValue((Object)node.getNode("100"));
        cmbSize.valueProperty().addListener(ob -> this.setPageSize(cmbSize, pageModel));
        txtJump.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        txtJump.setOnAction(event -> txtJump.selectAll());
        txtJump.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        txtJump.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !"".equals(txtJump.getText())) {
                pageModel.setCurrentPage(Integer.valueOf(Integer.valueOf(txtJump.getText()) - 1));
            }
        });
        pagination.setPageCount(1);
        pagination.currentPageIndexProperty().bindBidirectional((Property)pageModel.currentPageProperty());
        pagination.pageCountProperty().bindBidirectional((Property)pageModel.pageCountProperty());
        MxBindings.bindSI((Property)total.textProperty(), (Property)pageModel.totalCountProperty());
    }

    private void setPageSize(ComboBox<MxNode> cmbSize, HisQueryPage<?> pageModel) {
        if (cmbSize.getValue() != null) {
            int pageSize = Integer.valueOf(((MxNode)cmbSize.getValue()).getRaw());
            pageModel.setPageSize(Integer.valueOf(pageSize));
        }
    }

    private boolean rebuildPagi(HisQueryPage<?> orderPage) {
        orderPage.setBeginDate(((LocalDate)this.beginDateText.getValue()).toString().replaceAll("-", ""));
        orderPage.setEndDate(((LocalDate)this.endDateText.getValue()).toString().replaceAll("-", ""));
        String dimension = orderPage.getDimension();
        if (this.changeExtAcc) {
            this.changeExtAcc = false;
            if ("3".equals(dimension)) {
                ObservableList productIdList = FxUtils.newList();
                for (Product product : this.productList) {
                    if (product.getId().isEmpty()) continue;
                    productIdList.add(product.getId());
                }
                orderPage.setProductIdList((List)productIdList);
                if (productIdList.isEmpty()) {
                    return false;
                }
            } else {
                ObservableList portfolioIdList = FxUtils.newList();
                for (Portfolio portfolio : this.portfList) {
                    if (portfolio.getId().isEmpty()) continue;
                    if (this.subAccMng.getMap(portfolio) != null) {
                        for (CcsFundAccount fundAccnt : this.subAccMng.getMap(portfolio).keySet()) {
                            if (!(fundAccnt instanceof CcsSubFundAccount)) continue;
                            if (!portfolioIdList.contains(portfolio.getId())) {
                                portfolioIdList.add(portfolio.getId());
                            }
                            if (portfolioIdList.contains(fundAccnt.getExtAccntId())) continue;
                            portfolioIdList.add(fundAccnt.getExtAccntId());
                        }
                        continue;
                    }
                    if (portfolioIdList.contains(portfolio.getId())) continue;
                    portfolioIdList.add(portfolio.getId());
                }
                orderPage.setPortfolioIdList((List)portfolioIdList);
                if (portfolioIdList.isEmpty()) {
                    return false;
                }
            }
        }
        return !("3".equals(dimension) ? orderPage.getProductIdList().isEmpty() : orderPage.getPortfolioIdList().isEmpty());
    }

    private void ccsReset() {
        this.ccsPagination.setPageCount(1);
        this.ccsTotalCount.setText("0");
    }

    private void focusRefresh(TableView<? extends Object> table) {
        table.focusedProperty().addListener((ob, old, newV) -> {
            if (newV.booleanValue()) {
                Platform.runLater(() -> table.refresh());
            }
        });
    }

    private void ccsQuery() {
        if (!this.rebuildPagi(this.pageCcs)) {
            this.ccsReset();
            return;
        }
        try {
            this.clearRecordService.query(this.pageCcs);
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u67e5\u8be2\u65e5\u7ec8\u5bf9\u8d26\u6d41\u6c34", e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        if (this.pageCcs.getDataList().size() == 0) {
            this.tableClearRecord.scrollToColumnIndex(0);
        }
        this.tableClearRecord.scrollTo(0);
    }

    private void createTable() {
        this.colRecordId.setCellValueFactory(data -> ((ClearRecord)data.getValue()).recordIdProperty());
        this.reactMap.put(this.colRecordId.getId(), "RecordId");
        this.colProductName.setCellValueFactory(data -> ((ClearRecord)data.getValue()).productNameProperty());
        this.colRecordDate.setCellValueFactory(data -> ((ClearRecord)data.getValue()).recordDateProperty());
        this.reactMap.put(this.colRecordDate.getId(), "RecordDate");
        this.colExtAccntId.setCellValueFactory(data -> ((ClearRecord)data.getValue()).investorIdProperty());
        this.reactMap.put(this.colExtAccntId.getId(), "InvestorId");
        this.colAccName.setCellValueFactory(data -> ((ClearRecord)data.getValue()).accNameProperty());
        this.reactMap.put(this.colAccName.getId(), "AccName");
        this.colExtSecAccntId.setCellValueFactory(data -> ((ClearRecord)data.getValue()).inverstorSecIdProperty());
        this.reactMap.put(this.colExtSecAccntId.getId(), "InverstorSecId");
        this.colTradeType.setCellValueFactory(data -> ((ClearRecord)data.getValue()).getInstrument().applIdProperty());
        this.reactMap.put(this.colTradeType.getId(), "AppId");
        this.colSecId.setCellValueFactory(data -> ((ClearRecord)data.getValue()).getInstrument().secIdProperty());
        this.reactMap.put(this.colSecId.getId(), "SecId");
        this.colSecName.setCellValueFactory(data -> ((ClearRecord)data.getValue()).getInstrument().symbolProperty());
        this.reactMap.put(this.colSecName.getId(), "SecName");
        this.colMarket.setCellValueFactory(data -> ((ClearRecord)data.getValue()).getInstrument().marketProperty());
        this.reactMap.put(this.colMarket.getId(), "Market");
        this.colPortfolio.setCellValueFactory(data -> ((ClearRecord)data.getValue()).portfolioNameProperty());
        this.reactMap.put(this.colPortfolio.getId(), "PortfolioName");
        this.colUserName.setCellValueFactory(data -> ((ClearRecord)data.getValue()).userNameProperty());
        this.reactMap.put(this.colUserName.getId(), "UserName");
        this.colOperateTime.setCellValueFactory(data -> ((ClearRecord)data.getValue()).operateTimeProperty());
        this.reactMap.put(this.colOperateTime.getId(), "OperateTime");
        this.colBeginSecQty.setCellValueFactory(data -> ((ClearRecord)data.getValue()).beginSecQtyProperty());
        this.reactMap.put(this.colBeginSecQty.getId(), "BeginSecQty");
        this.colBeginSecQty.setCellFactory(p -> new DoubleTableCell());
        this.colSecOccurQty.setCellValueFactory(data -> ((ClearRecord)data.getValue()).secOccurQtyProperty());
        this.reactMap.put(this.colSecOccurQty.getId(), "SecOccurQty");
        this.colSecOccurQty.setCellFactory(p -> new DoubleTableCell());
        this.colSecBalance.setCellValueFactory(data -> ((ClearRecord)data.getValue()).secBalanceProperty());
        this.reactMap.put(this.colSecBalance.getId(), "SecBalance");
        this.colSecBalance.setCellFactory(p -> new DoubleTableCell());
        this.colBeginAmt.setCellValueFactory(data -> ((ClearRecord)data.getValue()).beginAmtProperty());
        this.reactMap.put(this.colBeginAmt.getId(), "BeginAmt");
        this.colBeginAmt.setCellFactory(p -> new DoubleTableCell());
        this.colOccurAmt.setCellValueFactory(data -> ((ClearRecord)data.getValue()).occurAmtProperty());
        this.reactMap.put(this.colOccurAmt.getId(), "OccurAmt");
        this.colOccurAmt.setCellFactory(p -> new DoubleTableCell());
        this.colBalance.setCellValueFactory(data -> ((ClearRecord)data.getValue()).balanceProperty());
        this.reactMap.put(this.colBalance.getId(), "Balance");
        this.colBalance.setCellFactory(p -> new DoubleTableCell());
        this.colPrice.setCellValueFactory(data -> ((ClearRecord)data.getValue()).priceProperty());
        this.reactMap.put(this.colPrice.getId(), "Price");
        this.colPrice.setCellFactory(p -> new PriceCell());
        this.colQty.setCellValueFactory(data -> ((ClearRecord)data.getValue()).qtyProperty());
        this.reactMap.put(this.colQty.getId(), "Qty");
        this.colQty.setCellFactory(p -> new DoubleTableCell());
        this.colAmount.setCellValueFactory(data -> ((ClearRecord)data.getValue()).amountProperty());
        this.reactMap.put(this.colAmount.getId(), "Amount");
        this.colAmount.setCellFactory(p -> new DoubleTableCell());
        this.colTradeTime.setCellValueFactory(data -> ((ClearRecord)data.getValue()).tradeTimeProperty());
        this.reactMap.put(this.colTradeTime.getId(), "TradeTime");
        this.colOrderPrice.setCellValueFactory(data -> ((ClearRecord)data.getValue()).orderPriceProperty());
        this.reactMap.put(this.colOrderPrice.getId(), "OrderPrice");
        this.colOrderPrice.setCellFactory(p -> new PriceCell());
        this.colOrderVol.setCellValueFactory(data -> ((ClearRecord)data.getValue()).orderVolProperty());
        this.reactMap.put(this.colOrderVol.getId(), "OrderVol");
        this.colOrderVol.setCellFactory(p -> new DoubleTableCell());
        this.colOrderTime.setCellValueFactory(data -> ((ClearRecord)data.getValue()).orderTimeProperty());
        this.reactMap.put(this.colOrderTime.getId(), "OrderTime");
        this.colRealFee.setCellValueFactory(data -> ((ClearRecord)data.getValue()).realFeeProperty());
        this.reactMap.put(this.colRealFee.getId(), "RealFee");
        this.colRealFee.setCellFactory(p -> new DoubleTableCell());
        this.colCommision.setCellValueFactory(data -> ((ClearRecord)data.getValue()).commisionProperty());
        this.reactMap.put(this.colCommision.getId(), "Commision");
        this.colCommision.setCellFactory(p -> new DoubleTableCell());
        this.colChgFee.setCellValueFactory(data -> ((ClearRecord)data.getValue()).chgFeeProperty());
        this.reactMap.put(this.colChgFee.getId(), "ChgFee");
        this.colChgFee.setCellFactory(p -> new DoubleTableCell());
        this.colStampTax.setCellValueFactory(data -> ((ClearRecord)data.getValue()).stampTaxProperty());
        this.reactMap.put(this.colStampTax.getId(), "StampTax");
        this.colStampTax.setCellFactory(p -> new DoubleTableCell());
        this.colHandleFee.setCellValueFactory(data -> ((ClearRecord)data.getValue()).handleFeeProperty());
        this.reactMap.put(this.colHandleFee.getId(), "HandleFee");
        this.colHandleFee.setCellFactory(p -> new DoubleTableCell());
        this.colSecAdminFee.setCellValueFactory(data -> ((ClearRecord)data.getValue()).secAdminFeeProperty());
        this.reactMap.put(this.colSecAdminFee.getId(), "SecAdminFee");
        this.colSecAdminFee.setCellFactory(p -> new DoubleTableCell());
        this.colOtherFee.setCellValueFactory(data -> ((ClearRecord)data.getValue()).otherFeeProperty());
        this.reactMap.put(this.colOtherFee.getId(), "OtherFee");
        this.colOtherFee.setCellFactory(p -> new DoubleTableCell());
        TableUtils.isAuto(this.colIndex);
        this.colIndex.setSortable(false);
        this.tableClearRecord.setItems(this.pageCcs.getDataList());
        this.tableClearRecord.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableClearRecord);
        this.reactMap.put(this.colProductName.getId(), "ProductName");
        this.reactMap.put(this.colWriteoff.getId(), "");
        this.reactMap.put(this.colInfo.getId(), "");
        this.reactMap.put(this.colDerivationAmt.getId(), "");
        this.reactMap.put(this.colDerivationQty.getId(), "");
        this.reactMap.put(this.colDerivationBalance.getId(), "");
        this.reactMap.put(this.colDealCount.getId(), "");
        this.reactMap.put(this.colSettlementFee.getId(), "");
        this.reactMap.put(this.colTransactionFee.getId(), "");
        this.reactMap.put(this.colRiskFee.getId(), "");
        this.reactMap.put(this.colStampTaxSub.getId(), "");
        this.reactMap.put(this.colChgFeeSub.getId(), "");
        this.reactMap.put(this.colSettlementFeeSub.getId(), "");
        this.reactMap.put(this.colTransactionFeeSub.getId(), "");
        this.reactMap.put(this.colHandleFeeSub.getId(), "");
        this.reactMap.put(this.colSecAdminFeeSub.getId(), "");
        this.reactMap.put(this.colOtherFeeSub.getId(), "");
        this.reactMap.put(this.colRiskFeeSub.getId(), "");
        this.reactMap.put(this.colNetFee.getId(), "");
        this.reactMap.put(this.colOrderFee.getId(), "");
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithTwoHead(this.tableClearRecord, (int)0, (int)0);
    }

    @FXML
    private void refresh() {
        this.ccsQuery();
    }

    @FXML
    private void businessRef() {
        BusinessRefDialog obj = (BusinessRefDialog)((Object)this.of.create(BusinessRefDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e1a\u52a1\u914d\u7f6e");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.getButton(ButtonType.OK).setVisible(false);
        dialog.launch();
    }

    @FXML
    private void exportExcel() {
        try {
            File file = ExcelUtils.saveFile((String)"\u65e5\u7ec8\u6d41\u6c34\u5bf9\u8d26");
            if (file == null) {
                return;
            }
            this.ccsExcel.setDisable(true);
            this.exe.execute(() -> {
                try {
                    HisQueryPage<ClearRecord> page = this.clearRecordService.getAllCcsData(this.pageCcs);
                    ExcelUtils.writeHisTwoHeadExcel(this.tableClearRecord, (List)page.getDataList(), this.reactMap, (File)file);
                    Platform.runLater(() -> this.ccsExcel.setDisable(false));
                }
                catch (MException | Exception e) {
                    logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", e);
                    Platform.runLater(() -> {
                        this.ccsExcel.setDisable(false);
                        this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
        }
    }

    @FXML
    public void importFlow() {
        try {
            FileChooser chooser;
            File file;
            String productId = "";
            String portfolioId = "";
            String dimension = ((MxNode)this.btnDimension.getValue()).getRaw();
            if ("3".equals(dimension) && this.productList.isEmpty()) {
                throw new Exception("\u65e0\u5bfc\u5165\u4ea7\u54c1\u6d41\u6c34\u6743\u9650");
            }
            if ("2".equals(dimension) && this.portfList.isEmpty()) {
                throw new Exception("\u65e0\u5bfc\u5165\u6295\u7ec4\u6d41\u6c34\u6743\u9650");
            }
            if (!this.productList.isEmpty()) {
                productId = this.productList.get(0).getId();
            }
            if (!this.portfList.isEmpty()) {
                portfolioId = this.portfList.get(0).getId();
            }
            if ((file = (chooser = new FileChooser()).showOpenDialog(null)) == null) {
                return;
            }
            boolean importStatus = this.checkAndImport(file, productId, portfolioId);
            if (!importStatus) {
                throw new Exception("\u6d41\u6c34\u5bfc\u5165\u5931\u8d25\uff0c\u683c\u5f0f\u9519\u8bef");
            }
            this.alert.alert(Alert.AlertType.INFORMATION, "\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage().isEmpty() ? "\u5bfc\u5165\u5931\u8d25" : e.getMessage());
            return;
        }
        try {
            this.query();
            this.focusRefresh(this.tableClearRecord);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage().isEmpty() ? "\u67e5\u8be2\u5931\u8d25" : e.getMessage());
        }
    }

    private boolean checkAndImport(File file, String productId, String portfolioId) throws Exception {
        String recordTime;
        String value;
        ClearRecord item;
        int nullRow;
        int j;
        int nullRows;
        int i;
        try {
            this.busiList = this.busiService.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> {
                logger.error("\u67e5\u8be2\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        if (!(file.getPath().endsWith(".XLSX") || file.getPath().endsWith(".XLS") || file.getPath().endsWith(".xlsx") || file.getPath().endsWith(".xls"))) {
            throw new Exception("\u6d41\u6c34\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List recordItemList = ImportExcel.read((String)file.getPath());
        if (recordItemList == null) {
            throw new Exception("\u6d41\u6c34\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
        }
        ArrayList<ClearRecord> recordList = new ArrayList<ClearRecord>();
        String businessCode = "";
        String side = "";
        boolean importStatus = false;
        String recordNum = "";
        HashSet<String> recordCodeSet = new HashSet<String>();
        if (file.getPath().contains("\u4e2d\u4fe1")) {
            if (!recordItemList.isEmpty()) {
                String columnName;
                if (((List)recordItemList.get(0)).isEmpty()) {
                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884c\u4e3a\u7a7a");
                }
                i = 0;
                while (i < ((List)recordItemList.get(0)).size()) {
                    columnName = ((String)((List)recordItemList.get(0)).get(i)).trim();
                    switch (i) {
                        case 0: {
                            if ("\u53d1\u751f\u65e5\u671f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cA\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 1: {
                            if ("\u4ea7\u54c1\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cB\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 2: {
                            if ("\u8d44\u4ea7\u5355\u5143\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cC\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 3: {
                            if ("\u7ec4\u5408\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cD\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 4: {
                            if ("\u4e1a\u52a1\u6807\u8bc6".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cE\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 5: {
                            if ("\u5e02\u573a".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cF\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 6: {
                            if ("\u8bc1\u5238\u4ee3\u7801".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cG\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 7: {
                            if ("\u8bc1\u5238\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cH\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 9: {
                            if ("\u6d41\u6c34\u4fe1\u606f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cJ\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 18: {
                            if ("\u64cd\u4f5c\u5458".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cS\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 19: {
                            if ("\u64cd\u4f5c\u65f6\u95f4".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cT\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 20: {
                            if ("\u5907\u6ce8".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cU\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 21: {
                            if ("\u59d4\u6258\u4fe1\u606f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cV\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 24: {
                            if ("\u6210\u4ea4\u4fe1\u606f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cY\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 29: {
                            if ("\u8d39\u7528\u4fe1\u606f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cAD\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 48: {
                            if ("\u5e2d\u4f4d\u4f63\u91d1".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cAW\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 49: {
                            if ("\u6d41\u6c34\u53f7".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cAX\u5217\u5217\u540d\u9519\u8bef");
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < ((List)recordItemList.get(1)).size()) {
                    columnName = ((String)((List)recordItemList.get(1)).get(i)).trim();
                    switch (i) {
                        case 9: {
                            if ("\u671f\u521d\u8bc1\u5238\u6570\u91cf".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cJ\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 10: {
                            if ("\u8bc1\u5238\u53d1\u751f\u6570".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cK\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 11: {
                            if ("\u8bc1\u5238\u672c\u6b21\u4f59\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cL\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 12: {
                            if ("\u671f\u521d\u73b0\u8d27\u8d44\u91d1\u4f59\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cM\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 13: {
                            if ("\u73b0\u8d27\u8d44\u91d1\u53d1\u751f\u6570".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cN\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 14: {
                            if ("\u73b0\u8d27\u8d44\u91d1\u672c\u6b21\u4f59\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cO\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 21: {
                            if ("\u59d4\u6258\u6570\u91cf".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cV\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 22: {
                            if ("\u59d4\u6258\u4ef7\u683c".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cW\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 23: {
                            if ("\u59d4\u6258\u65f6\u95f4".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cX\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 24: {
                            if ("\u6210\u4ea4\u6570\u91cf".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cY\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 25: {
                            if ("\u6210\u4ea4\u4ef7\u683c".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cZ\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 26: {
                            if ("\u6210\u4ea4\u91d1\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAA\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 27: {
                            if ("\u6210\u4ea4\u7b14\u6570".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAB\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 28: {
                            if ("\u6210\u4ea4\u65f6\u95f4".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAC\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 29: {
                            if ("\u5370\u82b1\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAD\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 30: {
                            if ("\u8fc7\u6237\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAE\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 31: {
                            if ("\u7ed3\u7b97\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAF\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 33: {
                            if ("\u7ecf\u624b\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAH\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 34: {
                            if ("\u8bc1\u7ba1\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAI\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 35: {
                            if ("\u5176\u4ed6\u8d39\u7528".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAJ\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 45: {
                            if ("\u624b\u7eed\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c2\u884cAT\u5217\u5217\u540d\u9519\u8bef");
                        }
                    }
                    ++i;
                }
                recordItemList.remove(0);
                recordItemList.remove(0);
                if (recordItemList.isEmpty()) {
                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u6d41\u6c34\u8bb0\u5f55\u4e3a\u7a7a");
                }
            }
            nullRows = 0;
            j = 0;
            while (j < recordItemList.size()) {
                nullRow = 0;
                for (String str : (List)recordItemList.get(j)) {
                    if (str != null && !"".equals(str.trim())) continue;
                    ++nullRow;
                }
                if (nullRow == ((List)recordItemList.get(j)).size()) {
                    ++nullRows;
                } else {
                    item = this.factory.create();
                    item.setProductId(productId);
                    item.setPortfolioId(portfolioId);
                    item.setSourceFlag(2);
                    int i2 = 0;
                    while (i2 < ((List)recordItemList.get(j)).size()) {
                        value = ((String)((List)recordItemList.get(j)).get(i2)).trim();
                        switch (i2) {
                            case 0: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u53d1\u751f\u65e5\u671f\u4e3a\u7a7a");
                                }
                                if (value.contains("\u5e74") || value.contains("\u6708") || value.contains("\u65e5")) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u53d1\u751f\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                                }
                                recordTime = ClearRecordHisQueryPart.textDateConversion(value);
                                if (!ClearRecordHisQueryPart.isIntDate(ClearRecordHisQueryPart.cellValueToString(recordTime))) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u53d1\u751f\u65e5\u671f\u6570\u636e\u683c\u5f0f\u9519\u8bef");
                                }
                                item.setRecordDate(recordTime);
                                break;
                            }
                            case 1: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
                                }
                                item.setProductName(value);
                                break;
                            }
                            case 3: {
                                item.setPortfolioName(value);
                                break;
                            }
                            case 4: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u4e1a\u52a1\u6807\u8bc6\u4e3a\u7a7a");
                                }
                                businessCode = "";
                                side = "";
                                for (BusinessRef ref : this.busiList) {
                                    if (!value.equals(ref.getBusinessName())) continue;
                                    businessCode = ref.getBusinessCode();
                                    side = ref.getSide().getRaw();
                                    break;
                                }
                                item.setBusinessCode(businessCode);
                                item.setSide(side);
                                item.getInstrument().setApplId(value);
                                break;
                            }
                            case 5: {
                                if (value == null) break;
                                if (value.contains("\u6caa") || value.contains("\u4e0a\u4ea4")) {
                                    value = "XSHG";
                                } else if (value.contains("\u6df1") || value.contains("\u6df1\u4ea4")) {
                                    value = "XSHE";
                                }
                                item.getInstrument().getMarket().setRaw(value);
                                break;
                            }
                            case 6: {
                                item.getInstrument().setSecId(value);
                                break;
                            }
                            case 7: {
                                item.getInstrument().setSymbol(value);
                                break;
                            }
                            case 9: {
                                item.setBeginSecQty(Double.parseDouble(value));
                                break;
                            }
                            case 10: {
                                if ("".equals(value)) break;
                                item.setSecOccurQty(Double.parseDouble(value));
                                break;
                            }
                            case 11: {
                                item.setSecBalance(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 12: {
                                item.setBeginAmt(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 13: {
                                item.setOccurAmt(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 14: {
                                item.setBalance(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 18: {
                                item.setUserName(value);
                                break;
                            }
                            case 19: {
                                if ("".equals(value)) break;
                                item.setOperateTime(this.excelTime(value));
                                item.setRecordTime(this.excelTime(value));
                                break;
                            }
                            case 21: {
                                item.setOrderVol(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 22: {
                                if ("".equals(value)) break;
                                item.setOrderPrice(Double.parseDouble(value));
                                break;
                            }
                            case 23: {
                                item.setOrderTime(value);
                                break;
                            }
                            case 24: {
                                item.setQty(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 25: {
                                item.setPrice(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 26: {
                                item.setAmount(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 28: {
                                if ("".equals(value)) break;
                                item.setTradeTime(this.excelTime(value));
                                break;
                            }
                            case 29: {
                                item.setStampTax(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 30: {
                                item.setChgFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 33: {
                                item.setHandleFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 34: {
                                item.setSecAdminFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 35: {
                                item.setOtherFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 45: {
                                item.setRealFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 48: {
                                item.setCommision(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 49: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u6d41\u6c34\u53f7\u4e3a\u7a7a");
                                }
                                recordNum = ClearRecordHisQueryPart.cellValueToString(value);
                                if (recordNum.indexOf(".") > 0) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 3) + "\u884c\u6d41\u6c34\u53f7\u6709\u5c0f\u6570");
                                }
                                item.setRecordId(recordNum);
                                recordCodeSet.add(recordNum);
                                break;
                            }
                        }
                        ++i2;
                    }
                    if (!item.getInstrument().getSecId().isEmpty()) {
                        RefItem ref = this.refMng.getItem(item.getInstrument().getMarket().getRaw(), item.getInstrument().getSecId());
                        if (ref != null) {
                            item.getInstrument().setSecType(ref.getType());
                        } else {
                            throw new Exception("\u6d41\u6c34\u53f7\uff1a" + item.getRecordId() + " \u8bc1\u5238\u4ee3\u7801\u3001\u5e02\u573a\u6216\u9759\u6001\u884c\u60c5\u9519\u8bef");
                        }
                    }
                    if (recordCodeSet.contains(String.valueOf(item.getRecordDate()) + item.getRecordId())) {
                        throw new Exception("\u5b58\u5728\u76f8\u540c\u65e5\u671f\u6d41\u6c34\u53f7\u91cd\u590d\uff0c\u65e5\u671f\uff1a" + item.getRecordDate() + "\uff0c\u6d41\u6c34\u53f7\uff1a" + item.getRecordId());
                    }
                    recordCodeSet.add(String.valueOf(item.getRecordDate()) + item.getRecordId());
                    recordList.add(item);
                }
                ++j;
            }
            if (recordCodeSet.size() < recordList.size() - nullRows) {
                throw new Exception("\u6d41\u6c34\u5bfc\u5165\u5931\u8d25\uff0c\u76f8\u540c\u65e5\u671f\u6d41\u6c34\u53f7\u91cd\u590d");
            }
        }
        if (file.getPath().contains("\u5efa\u6295")) {
            if (!recordItemList.isEmpty()) {
                if (((List)recordItemList.get(0)).isEmpty()) {
                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884c\u4e3a\u7a7a");
                }
                i = 0;
                while (i < ((List)recordItemList.get(0)).size()) {
                    String columnName = ((String)((List)recordItemList.get(0)).get(i)).trim();
                    switch (i) {
                        case 0: {
                            if ("\u4e1a\u52a1\u65e5\u671f".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cA\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 1: {
                            if ("\u6d41\u6c34\u5e8f\u53f7".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cB\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 2: {
                            if ("\u53d1\u751f\u4e1a\u52a1".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cC\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 3: {
                            if ("\u8bc1\u5238\u4ee3\u7801".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cD\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 4: {
                            if ("\u8bc1\u5238\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cE\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 5: {
                            if ("\u4ea7\u54c1\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cF\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 7: {
                            if ("\u5355\u5143\u540d\u79f0".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cH\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 8: {
                            if ("\u4ea4\u6613\u5e02\u573a".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cI\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 9: {
                            if ("\u4e1a\u52a1\u5206\u7c7b".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cJ\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 10: {
                            if ("\u53d1\u751f\u91d1\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cK\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 11: {
                            if ("\u53d1\u751f\u540e\u4f59\u989d".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cL\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 13: {
                            if ("\u59d4\u6258\u4ef7\u683c".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cN\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 14: {
                            if ("\u59d4\u6258\u6570\u91cf".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cO\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 15: {
                            if ("\u53d1\u751f\u6570\u91cf".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cP\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 17: {
                            if ("\u5370\u82b1\u7a0e".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cR\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 18: {
                            if ("\u8fc7\u6237\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cS\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 19: {
                            if ("\u4f63\u91d1".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cT\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 20: {
                            if ("\u7ecf\u624b\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cU\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 21: {
                            if ("\u8bc1\u7ba1\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cV\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 22: {
                            if ("\u5176\u4ed6\u8d39".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cW\u5217\u5217\u540d\u9519\u8bef");
                        }
                        case 26: {
                            if ("\u603b\u8d39\u7528".equals(columnName)) break;
                            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c1\u884cAA\u5217\u5217\u540d\u9519\u8bef");
                        }
                    }
                    ++i;
                }
                recordItemList.remove(0);
                if (!recordItemList.isEmpty()) {
                    int k = recordItemList.size() - 1;
                    while (k >= 0) {
                        if (((List)recordItemList.get(k)).size() == 0) {
                            recordItemList.remove(k);
                        } else if ("".equals(((String)((List)recordItemList.get(k)).get(0)).trim())) {
                            recordItemList.remove(k);
                        }
                        --k;
                    }
                    recordItemList.remove(recordItemList.size() - 1);
                    if (recordItemList.isEmpty()) {
                        throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u6d41\u6c34\u8bb0\u5f55\u4e3a\u7a7a");
                    }
                } else {
                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u5408\u8ba1\u884c\u4e3a\u7a7a");
                }
            }
            nullRows = 0;
            j = 0;
            while (j < recordItemList.size()) {
                nullRow = 0;
                for (String str : (List)recordItemList.get(j)) {
                    if (str != null && !"".equals(str.trim())) continue;
                    ++nullRow;
                }
                if (nullRow == ((List)recordItemList.get(j)).size()) {
                    ++nullRows;
                } else {
                    item = this.factory.create();
                    item.setProductId(productId);
                    item.setPortfolioId(portfolioId);
                    item.setSourceFlag(3);
                    int i3 = 0;
                    while (i3 < ((List)recordItemList.get(j)).size()) {
                        value = ((String)((List)recordItemList.get(j)).get(i3)).trim();
                        switch (i3) {
                            case 0: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a");
                                }
                                if (value.contains("\u5e74") || value.contains("\u6708") || value.contains("\u65e5")) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u4e1a\u52a1\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                                }
                                recordTime = ClearRecordHisQueryPart.textDateConversion(value);
                                if (!ClearRecordHisQueryPart.isIntDate(ClearRecordHisQueryPart.cellValueToString(recordTime))) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u4e1a\u52a1\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                                }
                                item.setRecordDate(recordTime);
                                break;
                            }
                            case 1: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u6d41\u6c34\u5e8f\u53f7\u4e3a\u7a7a");
                                }
                                recordNum = ClearRecordHisQueryPart.cellValueToString(value);
                                if (recordNum.indexOf(".") > 0) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u6d41\u6c34\u5e8f\u53f7\u6709\u5c0f\u6570");
                                }
                                item.setRecordId(recordNum);
                                recordCodeSet.add(recordNum);
                                break;
                            }
                            case 2: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u53d1\u751f\u4e1a\u52a1\u4e3a\u7a7a");
                                }
                                businessCode = "";
                                side = "";
                                for (BusinessRef ref : this.busiList) {
                                    if (!value.equals(ref.getBusinessName())) continue;
                                    businessCode = ref.getBusinessCode();
                                    side = ref.getSide().getRaw();
                                    break;
                                }
                                item.setBusinessCode(businessCode);
                                item.setSide(side);
                                item.setBusinessCode(businessCode);
                                item.getInstrument().setApplId(value);
                                break;
                            }
                            case 3: {
                                item.getInstrument().setSecId(value);
                                break;
                            }
                            case 4: {
                                item.getInstrument().setSymbol(value);
                                break;
                            }
                            case 5: {
                                if ("".equals(value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
                                }
                                item.setProductName(value);
                                break;
                            }
                            case 7: {
                                item.setPortfolioName(value);
                                break;
                            }
                            case 8: {
                                if (value == null) break;
                                if (value.contains("\u6caa") || value.contains("\u4e0a\u4ea4")) {
                                    value = "XSHG";
                                } else if (value.contains("\u6df1") || value.contains("\u6df1\u4ea4")) {
                                    value = "XSHE";
                                }
                                item.getInstrument().getMarket().setRaw(value);
                                break;
                            }
                            case 10: {
                                item.setOccurAmt(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 11: {
                                item.setBalance(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 13: {
                                item.setOrderPrice(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 14: {
                                item.setOrderVol(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 15: {
                                item.setSecOccurQty(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 17: {
                                item.setStampTax(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 18: {
                                item.setChgFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 19: {
                                item.setCommision(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 20: {
                                item.setHandleFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 21: {
                                item.setSecAdminFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 22: {
                                item.setOtherFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                            case 26: {
                                item.setRealFee(ClearRecordHisQueryPart.cellValueToDouble(value).doubleValue());
                                break;
                            }
                        }
                        ++i3;
                    }
                    if (!item.getInstrument().getSecId().isEmpty()) {
                        RefItem ref = this.refMng.getItem(item.getInstrument().getMarket().getRaw(), item.getInstrument().getSecId());
                        if (ref != null) {
                            item.getInstrument().setSecType(ref.getType());
                        } else {
                            throw new Exception("\u6d41\u6c34\u53f7\uff1a" + item.getRecordId() + " \u8bc1\u5238\u4ee3\u7801\u3001\u5e02\u573a\u6216\u9759\u6001\u884c\u60c5\u9519\u8bef");
                        }
                    }
                    recordList.add(item);
                }
                ++j;
            }
            if (recordCodeSet.size() < recordList.size() - nullRows) {
                throw new Exception("\u6d41\u6c34\u5bfc\u5165\u5931\u8d25\uff0c\u6d41\u6c34\u5e8f\u53f7\u91cd\u590d");
            }
        }
        boolean updateStatus = true;
        logger.info("\u5bfc\u5165\u5916\u90e8\u6d41\u6c34\uff1a" + recordList.size() + "\u6761");
        if (recordList != null && !recordList.isEmpty()) {
            try {
                this.clearRecordService.updateClearRecord(recordList);
            }
            catch (MException e) {
                updateStatus = false;
                logger.error("\u5bfc\u5165\u4ea7\u54c1\u6d41\u6c34", (Throwable)e);
                if (999997 == e.getCode()) {
                    throw new Exception("\u5bfc\u5165\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165");
                }
                throw new Exception(e.getMessage());
            }
            try {
                if (updateStatus) {
                    this.clearRecordService.updateSubClearRecord(recordList);
                }
            }
            catch (MException | Exception e) {
                Platform.runLater(() -> {
                    logger.error("\u5bfc\u5165\u6295\u7ec4\u6d41\u6c34", e);
                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
            if (updateStatus) {
                importStatus = true;
            }
        }
        return importStatus;
    }

    private static String cellValueToString(String value) {
        value = StringUtils.formatDouble((Double)Double.parseDouble(value));
        return value;
    }

    private static Double cellValueToDouble(String value) {
        return StringUtils.parseString((String)value);
    }

    public String excelTime(String excelTime) {
        SimpleDateFormat df = new SimpleDateFormat("hhmmss");
        SimpleDateFormat mf = new SimpleDateFormat("HH:mm:ss");
        if (!ClearRecordHisQueryPart.checkTime(excelTime)) {
            if (excelTime.contains(".")) {
                int i = excelTime.indexOf(".");
                excelTime = excelTime.substring(0, i);
                String str = String.format("%06d", Integer.parseInt(excelTime));
                try {
                    Date date = df.parse(str);
                    excelTime = mf.format(date.getTime());
                }
                catch (Exception ex) {
                    logger.info(ex.getMessage(), (Throwable)ex);
                }
            } else {
                try {
                    String str = String.format("%06d", Integer.parseInt(excelTime));
                    Date date = df.parse(str);
                    excelTime = mf.format(date.getTime());
                }
                catch (Exception ex) {
                    logger.info(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return excelTime;
    }

    public static boolean isIntDate(String sDate) {
        int legalLen = 8;
        if (sDate == null || sDate.length() != legalLen) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = formatter.parse(sDate);
            return sDate.equals(formatter.format(date));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isLegalDate(String sDate) {
        int legalLen = 10;
        if (sDate == null || sDate.length() != legalLen) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT);
        try {
            Date date = formatter.parse(sDate);
            return sDate.equals(formatter.format(date));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        try {
            ClearRecordHisQueryPart.cellValueToString(str);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean checkTime(String time) {
        SimpleDateFormat mf = new SimpleDateFormat("HH:mm:ss");
        try {
            mf.parse(time);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static String textDateConversion(String time) {
        String timeValue = "";
        if (time.indexOf("E") > 0) {
            BigDecimal db = new BigDecimal(time);
            timeValue = db.toPlainString();
        } else if (time.indexOf("-") > 0) {
            String[] sa = new String[]{FORMAT};
            timeValue = ClearRecordHisQueryPart.getDate(time, sa).replaceAll("-", "");
        } else if (time.indexOf("/") > 0) {
            String[] sa = new String[]{"yyyy/MM/dd"};
            timeValue = ClearRecordHisQueryPart.getDate(time, sa).replaceAll("/", "");
        } else {
            double t = ClearRecordHisQueryPart.cellValueToDouble(time);
            Date date = HSSFDateUtil.getJavaDate((double)t);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            timeValue = formatter.format(date);
            String k = String.valueOf(t);
            if (k.indexOf("E") > 0) {
                BigDecimal db = new BigDecimal(time);
                timeValue = db.toPlainString();
            }
        }
        return timeValue;
    }

    private static String getDate(String sDate, String[] sa) {
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Date d = ClearRecordHisQueryPart.getDate(s, sDate);
            if (d != null) {
                return new SimpleDateFormat(sa[0]).format(d);
            }
            ++n2;
        }
        return "";
    }

    private static Date getDate(String sFormat, String sDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        Date d = null;
        try {
            sdf.setLenient(false);
            d = sdf.parse(sDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    private class PriceCell
    extends DoubleTableCell<ClearRecord> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

